/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.communicationstools;

import CASUAL.Log;
import CASUAL.Shell;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractDeviceCommunicationsProtocol {
    String binaryLocation = "";
    String[] windowsLocation = new String[]{"The Windows platform is not yet supported. Please override this with an appropriate binary."};
    String[] linux32Location = new String[]{"The Linux32 platform is not yet supported. Please override this with an appropriate binary."};
    String[] linux64Location = new String[]{"The Linux64 platform is not yet supported. Please override this with an appropriate binary."};
    String[] linuxArmv6Location = new String[]{"The Linux ARMv6 platform is not yet supported. Please override this with an appropriate binary."};
    String[] macLocation = new String[]{"The Mac platform is not yet supported. Please override this with an appropriate binary."};

    public abstract int numberOfDevicesConnected();

    public abstract boolean checkErrorMessage(String[] var1, String var2);

    public abstract boolean installDriver();

    public abstract String deployBinary(String var1);

    public abstract void restartConnection();

    public abstract void reset();

    public abstract void shutdown();

    public abstract String getBinaryLocation();

    public boolean isConnected() {
        return this.numberOfDevicesConnected() == 1;
    }

    public void waitForDevice() {
        while (!this.isConnected()) {
            this.sleep200ms();
        }
    }

    private void sleep200ms() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(AbstractDeviceCommunicationsProtocol.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String run(String[] parameters, int timeout, boolean silent) {
        Shell shell = new Shell();
        String[] runcmd = new String[parameters.length + 1];
        runcmd[0] = this.getBinaryLocation();
        String runstring = runcmd[0];
        for (int i = 1; i < runcmd.length; ++i) {
            runcmd[i] = parameters[i - 1];
            runstring = runstring + " " + runcmd[i];
        }
        Log.level4Debug("Run " + this.getConnectionMethodName() + " from DeviceCommunicationProtocol:" + runstring);
        if (silent) {
            String retval = shell.silentTimeoutShellCommand(runcmd, timeout);
            this.checkErrorMessage(runcmd, retval);
            return retval;
        }
        return shell.liveShellCommand(runcmd, true);
    }

    public boolean fileIsDeployedProperly(String binaryLocation) {
        File f = new File(binaryLocation);
        return binaryLocation != null && !binaryLocation.isEmpty() && f.exists() && f.isFile() && f.canExecute();
    }

    public abstract String getConnectionMethodName();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String n = "\n";
        sb.append("mode:").append(this.getConnectionMethodName()).append(n);
        sb.append("Connected:").append(this.isConnected()).append(n);
        return sb.toString();
    }
}

