/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.caspac;

import CASUAL.CASUALMessageObject;
import CASUAL.CASUALStartupTasks;
import CASUAL.CASUALTools;
import CASUAL.FileOperations;
import CASUAL.Log;
import CASUAL.Statics;
import CASUAL.archiving.Unzip;
import CASUAL.archiving.Zip;
import CASUAL.caspac.Caspac;
import CASUAL.crypto.MD5sum;
import CASUAL.misc.StringOperations;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipException;

public class Script {
    final int CASPAC = 0;
    final int CASUAL = 1;
    final int FILE = 2;
    public final int extractionMethod;
    public Object scriptZipFile;
    public Unzip zipfile;
    public final String name;
    public final String tempDir;
    public String scriptContents = "";
    public List<File> individualFiles = new ArrayList<File>();
    public meta metaData = new meta();
    public String discription = "";
    public boolean scriptContinue = false;
    private static String slash = System.getProperty("file.separator");
    public String deviceArch = "";
    Map<? extends String, ? extends InputStream> getAllAsStringAndInputStream;
    public List<String> actualMD5s = new ArrayList<String>();

    public Script(Script s) {
        Log.level4Debug("Setting up script " + s.name + " from preexisting script");
        this.name = s.name;
        this.tempDir = s.tempDir;
        this.extractionMethod = 2;
        this.metaData = s.metaData;
        this.individualFiles = s.individualFiles;
        this.zipfile = s.zipfile;
        this.discription = s.discription;
        this.scriptContinue = s.scriptContinue;
        this.getAllAsStringAndInputStream = s.getAllAsStringAndInputStream;
        this.deviceArch = s.deviceArch;
    }

    public Script(String name, String tempDir) {
        Log.level4Debug("Setting up script " + name + " with name and tempdir");
        this.name = name;
        this.tempDir = tempDir;
        this.extractionMethod = 0;
    }

    public Script(String name, String tempDir, int type) {
        Log.level4Debug("Setting up script " + name + " with name, tempdir and type");
        this.name = name;
        this.tempDir = tempDir;
        this.extractionMethod = type;
    }

    public Script(String name, String script, String discription, List<File> includeFiles, String tempDir) {
        Log.level4Debug("Setting up script " + name + " with name, script, description, included files and tempdir");
        this.discription = discription;
        this.name = name;
        this.scriptContents = script;
        this.individualFiles = includeFiles;
        this.tempDir = tempDir;
        this.extractionMethod = 0;
    }

    public Script(String name, String script, String discription, List<File> includeFiles, Properties prop, String tempDir, int type) {
        Log.level4Debug("Setting up script " + name + " with name, script, description, included files, propeties, type and tempdir");
        this.discription = discription;
        this.name = name;
        this.scriptContents = script;
        this.individualFiles = includeFiles;
        this.metaData = new meta(prop);
        this.tempDir = tempDir;
        this.extractionMethod = type;
    }

    public Script(String name, String script, String discription, List<File> includeFiles, Properties prop, String tempDir) {
        Log.level4Debug("Setting up script " + name + " with name, script, description includedFiles, properties, and tempdir");
        this.discription = discription;
        this.name = name;
        this.scriptContents = script;
        this.individualFiles = includeFiles;
        this.metaData = new meta(prop);
        this.tempDir = tempDir;
        this.extractionMethod = 0;
    }

    public Script(String name, String script, String discription, String tempDir) {
        Log.level4Debug("Setting up script " + name + " with name, script, description and tempdir");
        this.name = name;
        this.scriptContents = script;
        this.discription = discription;
        this.tempDir = tempDir;
        this.extractionMethod = 0;
    }

    public Script copyOf(String newScriptName, String newTempDir) {
        Log.level4Debug("Setting up script " + newScriptName + " from preexisting script");
        Script s = new Script(newScriptName, this.tempDir);
        s.metaData = this.metaData;
        s.individualFiles = this.individualFiles;
        s.zipfile = this.zipfile;
        s.discription = this.discription;
        s.scriptContinue = this.scriptContinue;
        s.getAllAsStringAndInputStream = this.getAllAsStringAndInputStream;
        return s;
    }

    public boolean verifyScript() {
        boolean testingBool = true;
        testingBool = !this.name.isEmpty() && testingBool;
        testingBool = !this.scriptContents.isEmpty() && testingBool;
        testingBool = !this.individualFiles.isEmpty() && testingBool;
        testingBool = !this.discription.isEmpty() && testingBool;
        testingBool = this.metaData.verifyMeta() && testingBool;
        return testingBool;
    }

    public DataInputStream getScriptContents() {
        InputStream is = StringOperations.convertStringToStream(this.scriptContents);
        return new DataInputStream(is);
    }

    public String toString() {
        return this.name;
    }

    private void addMD5ToMeta(String linuxMD5, int md5Position) {
        Log.level3Verbose("evaluated MD5 to " + linuxMD5);
        this.metaData.metaProp.setProperty("Script.MD5[" + md5Position + "]", linuxMD5);
    }

    private void addMD5ToMeta(MD5sum md5sum, String filePath, int md5Position) {
        String linuxMD5 = md5sum.getLinuxMD5Sum(new File(filePath));
        Log.level3Verbose("evaluated MD5 to " + linuxMD5);
        this.metaData.metaProp.setProperty("Script.MD5[" + md5Position + "]", linuxMD5);
    }

    public Runnable getExtractionRunnable() {
        if (this.extractionMethod == 0) {
            final Unzip myCASPAC = this.zipfile;
            final Object entry = this.scriptZipFile;
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Log.level4Debug("Examining CASPAC mode package contents");
                    BufferedInputStream bis = null;
                    try {
                        Log.level4Debug("Unzipping CASPAC member " + Script.this.name);
                        bis = myCASPAC.streamFileFromZip(entry);
                        Script.this.actualMD5s.add(new MD5sum().getLinuxMD5Sum(bis, entry.toString()));
                        bis = myCASPAC.streamFileFromZip(entry);
                        Unzip.unZipInputStream(bis, Script.this.tempDir);
                        bis.close();
                        Log.level4Debug("Extracted entry " + myCASPAC.getEntryName(entry) + "to " + Script.this.tempDir);
                    }
                    catch (ZipException ex) {
                        Log.errorHandler(ex);
                    }
                    catch (IOException ex) {
                        Log.errorHandler(ex);
                    }
                    finally {
                        try {
                            if (bis != null) {
                                bis.close();
                            }
                        }
                        catch (IOException ex) {
                            Log.errorHandler(ex);
                        }
                    }
                    File[] files = new File(Script.this.tempDir).listFiles();
                    if (files != null) {
                        Script.this.individualFiles.addAll(Arrays.asList(files));
                        for (String md5 : Script.this.metaData.md5s) {
                            if (Arrays.asList(Script.this.actualMD5s.toArray(new String[0])).contains(md5)) continue;
                            Log.level4Debug("Could not find " + md5 + " in list " + StringOperations.arrayToString(Script.this.actualMD5s.toArray(new String[0])));
                            new CASUALMessageObject("@interactionPackageCorrupt").showErrorDialog();
                            if (Caspac.debug) continue;
                            Script.this.scriptContents = "";
                        }
                    }
                }
            };
            CASUALStartupTasks.caspacScriptPrepLock = false;
            return r;
        }
        if (this.extractionMethod == 1) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (Script.this.scriptZipFile != null && !Script.this.scriptZipFile.toString().isEmpty()) {
                        if (CASUALTools.IDEMode) {
                            try {
                                Log.level4Debug("Examining IDE mode script contents" + Script.this.scriptZipFile.toString());
                                Script.this.actualMD5s.add(new MD5sum().getLinuxMD5Sum(new File((String)Script.this.scriptZipFile)));
                                Unzip unzip = new Unzip(new File((String)Script.this.scriptZipFile));
                                unzip.unzipFile(Script.this.tempDir);
                            }
                            catch (ZipException ex) {
                                Log.errorHandler(ex);
                            }
                            catch (IOException ex) {
                                Log.errorHandler(ex);
                            }
                        } else {
                            try {
                                Log.level4Debug("Examining CASUAL mode script contents:" + Script.this.scriptZipFile.toString());
                                Script.this.actualMD5s.add(new MD5sum().getLinuxMD5Sum(this.getClass().getResourceAsStream("/" + Script.this.scriptZipFile.toString()), Script.this.scriptZipFile.toString()));
                                Log.level4Debug("unzip of " + Script.this.scriptZipFile.toString() + " is beginning.");
                                Unzip.unZipResource("/" + Script.this.scriptZipFile.toString(), Script.this.tempDir);
                            }
                            catch (FileNotFoundException ex) {
                                Log.errorHandler(ex);
                            }
                            catch (IOException ex) {
                                Log.errorHandler(ex);
                            }
                            Log.level4Debug("unzip of " + Script.this.name + " is complete.");
                        }
                    } else {
                        Log.level3Verbose("script Zipfile was null");
                    }
                }
            };
            CASUALStartupTasks.caspacScriptPrepLock = false;
            return r;
        }
        if (this.extractionMethod == 2) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Log.level4Debug("Examining updated script contents on filesystem");
                    Script.this.actualMD5s.add(new MD5sum().getLinuxMD5Sum(new File(Script.this.scriptZipFile.toString())));
                    String ziplocation = Script.this.scriptZipFile.toString();
                    try {
                        Unzip unzip = new Unzip(ziplocation);
                        Log.level4Debug("Unzipping from " + ziplocation + " to " + Script.this.tempDir);
                        unzip.unzipFile(Script.this.tempDir);
                    }
                    catch (ZipException ex) {
                        Log.errorHandler(ex);
                    }
                    catch (IOException ex) {
                        Log.errorHandler(ex);
                    }
                    Log.level4Debug("examining MD5s");
                    for (String md5 : Script.this.metaData.md5s) {
                        if (Arrays.asList(Script.this.actualMD5s.toArray()).contains(md5)) continue;
                        Log.level4Debug("Md5 mismatch!!  Expected:" + md5);
                        if (Caspac.debug) continue;
                        Script.this.scriptContents = "";
                    }
                    if (!Script.this.scriptContents.equals("")) {
                        Log.level4Debug("Update sucessful.  MD5s matched server.");
                    } else {
                        new CASUALMessageObject("@interactionPackageCorrupt").showErrorDialog();
                    }
                }
            };
            CASUALStartupTasks.caspacScriptPrepLock = false;
            return r;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
            }
        };
        CASUALStartupTasks.caspacScriptPrepLock = false;
        return r;
    }

    Map<String, InputStream> getScriptAsMapForCASPAC() {
        Log log = new Log();
        MD5sum md5sum = new MD5sum();
        HashMap<String, InputStream> scriptEntries = new HashMap<String, InputStream>();
        ArrayList<String> tempMD5s = new ArrayList<String>();
        tempMD5s.add(md5sum.getLinuxMD5Sum(StringOperations.convertStringToStream(this.scriptContents), this.name + ".scr"));
        scriptEntries.put(this.name + ".scr", StringOperations.convertStringToStream(this.scriptContents));
        tempMD5s.add(md5sum.getLinuxMD5Sum(StringOperations.convertStringToStream(this.discription), this.name + ".txt"));
        scriptEntries.put(this.name + ".txt", StringOperations.convertStringToStream(this.discription));
        File masterTempDir = new File(this.tempDir).getParentFile();
        File instanceZip = new File(masterTempDir + Statics.slash + this.name + ".zip");
        if (!instanceZip.exists()) {
            try {
                instanceZip.createNewFile();
            }
            catch (IOException ex) {
                Log.errorHandler(ex);
            }
        }
        Log.level3Verbose("set script $ZIPFILE to " + instanceZip.getAbsolutePath());
        try {
            Zip zip = new Zip(instanceZip);
            zip.addFilesToExistingZip(this.individualFiles.toArray(new File[this.individualFiles.size()]));
            Log.level3Verbose("Adding zip:" + instanceZip.getAbsolutePath());
            tempMD5s.add(new MD5sum().getLinuxMD5Sum(instanceZip));
            scriptEntries.put(this.name + ".zip", new FileInputStream(instanceZip.getAbsoluteFile()));
        }
        catch (IOException ex) {
            Log.errorHandler(ex);
        }
        for (int i = 0; i < tempMD5s.size(); ++i) {
            this.addMD5ToMeta(tempMD5s.get(i), i);
        }
        this.actualMD5s = tempMD5s;
        scriptEntries.put(this.name + ".meta", this.metaData.getMetaInputStream());
        return scriptEntries;
    }

    public void performUnzipAfterScriptZipfileUpdate() throws ZipException, IOException {
        this.getExtractionRunnable().run();
    }

    public class meta {
        public String minSVNversion = "";
        public String scriptRevision = "";
        public String uniqueIdentifier = "";
        public String supportURL = "";
        public String updateMessage = "";
        public String killSwitchMessage = "";
        public Properties metaProp;
        public List<String> md5s = new ArrayList<String>();

        public meta() {
            this.metaProp = new Properties();
        }

        public meta(Properties prop) {
            this.metaProp = prop;
            this.setVariablesFromProperties(prop);
        }

        public meta(InputStream prop) throws IOException {
            this.metaProp.load(prop);
            this.setVariablesFromProperties(this.metaProp);
        }

        public boolean verifyMeta() {
            boolean testingBool = true;
            testingBool = !this.minSVNversion.isEmpty() && testingBool;
            testingBool = !this.scriptRevision.isEmpty() && testingBool;
            testingBool = !this.uniqueIdentifier.isEmpty() && testingBool;
            testingBool = !this.supportURL.isEmpty() && testingBool;
            testingBool = !this.updateMessage.isEmpty() && testingBool;
            testingBool = !this.killSwitchMessage.isEmpty() && testingBool;
            return testingBool;
        }

        public InputStream getMetaInputStream() {
            this.setPropsFromVariables();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                this.metaProp.store(output, "This properties file was generated by CASUAL");
            }
            catch (IOException ex) {
                Log.errorHandler(ex);
            }
            return new ByteArrayInputStream(output.toByteArray());
        }

        public boolean write(String output) throws FileNotFoundException, IOException {
            File f = new File(output);
            return this.write(f);
        }

        public boolean write(File output) throws FileNotFoundException, IOException {
            this.setPropsFromVariables();
            FileOutputStream fos = new FileOutputStream(output);
            this.metaProp.store(fos, "This properties file was generated by CASUAL");
            return new FileOperations().verifyExists(output.toString());
        }

        public void setPropsFromVariables() {
            this.metaProp.setProperty("CASUAL.minSVN", this.minSVNversion);
            this.metaProp.setProperty("Script.Revision", this.scriptRevision);
            this.metaProp.setProperty("Script.ID", this.uniqueIdentifier);
            this.metaProp.setProperty("Script.SupportURL", this.supportURL);
            this.metaProp.setProperty("Script.UpdateMessage", this.updateMessage);
            this.metaProp.setProperty("Script.KillSwitchMessage", this.killSwitchMessage);
        }

        private void setVariablesFromProperties(Properties prop) {
            this.minSVNversion = prop.getProperty("CASUAL.minSVN", "");
            this.scriptRevision = prop.getProperty("Script.Revision", "");
            this.uniqueIdentifier = prop.getProperty("Script.ID", "");
            this.supportURL = prop.getProperty("Script.SupportURL", "");
            this.updateMessage = prop.getProperty("Script.UpdateMessage", "");
            this.killSwitchMessage = prop.getProperty("Script.KillSwitchMessage", "");
            this.md5s = new ArrayList<String>();
            int i = 0;
            while (!prop.getProperty("Script.MD5[" + i + "]", "").equals("")) {
                this.md5s.add(prop.getProperty("Script.MD5[" + i + "]"));
                ++i;
            }
        }

        public void load(Properties prop) {
            this.metaProp = prop;
            this.setVariablesFromProperties(this.metaProp);
        }

        void load(BufferedInputStream streamFileFromZip) {
            try {
                this.metaProp.load(streamFileFromZip);
            }
            catch (IOException ex) {
                Log.errorHandler(ex);
            }
            this.setVariablesFromProperties(this.metaProp);
        }

        public int minSVNversion() {
            return Integer.parseInt(this.minSVNversion);
        }
    }
}

