/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.caspac;

import CASUAL.AudioHandler;
import CASUAL.CASUALStartupTasks;
import CASUAL.CASUALTools;
import CASUAL.FileOperations;
import CASUAL.Log;
import CASUAL.Statics;
import CASUAL.archiving.Unzip;
import CASUAL.archiving.Zip;
import CASUAL.caspac.Script;
import CASUAL.crypto.AES128Handler;
import CASUAL.crypto.MD5sum;
import CASUAL.misc.MandatoryThread;
import CASUAL.misc.StringOperations;
import CASUAL.network.CASUALDevIntegration.CasualDevCounter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;

public final class Caspac {
    public final int type;
    public BufferedImage logo;
    public final File CASPAC;
    public final CodeSource CASPACsrc;
    public String overview = "";
    public Build build;
    public ArrayList<Script> scripts = new ArrayList();
    public final String TempFolder;
    private ArrayList<MandatoryThread> unzipThreads = new ArrayList();
    private Script activeScript;
    public boolean caspacShouldBeDeletedAfterExtraction = false;
    public static boolean debug = false;
    private String tempbannerpic;
    private String[] controlFiles = new String[]{"-Overview.txt", "-build.properties", "-logo.png"};

    public Caspac(File caspac, String tempDir, int type) throws IOException {
        this.CASPAC = caspac;
        this.CASPACsrc = null;
        this.TempFolder = tempDir;
        this.type = type;
        this.loadCASPACcontrolFilesFromCASPAC();
    }

    public Caspac(File caspac, String tempDir, int type, char[] securityKey) throws IOException, Exception {
        AES128Handler ch = new AES128Handler(caspac);
        ch.decrypt(tempDir + caspac.getName(), securityKey);
        this.CASPAC = new File(tempDir + caspac.getName());
        this.CASPACsrc = null;
        this.TempFolder = tempDir;
        this.type = type;
        this.caspacShouldBeDeletedAfterExtraction = true;
        this.loadCASPACcontrolFilesFromCASPAC();
        if (this.tempbannerpic != null) {
            this.build.bannerPic = this.tempbannerpic;
        }
    }

    public Caspac(CodeSource src, String tempDir, int type) throws IOException {
        this.CASPACsrc = src;
        URL jar = src.getLocation();
        this.CASPAC = new File(tempDir + jar.getFile().toString());
        this.TempFolder = tempDir;
        this.type = type;
        if (CASUALTools.IDEMode) {
            this.updateMD5s();
            this.setupIDEModeScriptForCASUAL("TestScript");
        } else {
            ZipEntry ZEntry;
            Log.level4Debug("Opening self as stream for scan");
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            Log.level4Debug("Picking Jar File:" + src.toString() + " ..scanning.");
            while ((ZEntry = zip.getNextEntry()) != null) {
                String entry = ZEntry.getName();
                if (!entry.startsWith("SCRIPTS/") && !entry.startsWith("SCRIPTS\\")) continue;
                this.handleCASPACJarFiles(entry);
            }
        }
    }

    public static final Caspac makeGenericCaspac() throws IOException {
        File f = new File(Statics.getTempFolder() + "newfile");
        Caspac c = new Caspac(f, Statics.getTempFolder(), 2);
        Script s = new Script("oneshot", Statics.getTempFolder());
        return c;
    }

    public void setActiveScript(Script s) {
        CasualDevCounter.doIncrementCounter(s.name + s.metaData.uniqueIdentifier);
        CASUALStartupTasks.caspacScriptPrepLock = true;
        if (this.type == 1) {
            try {
                Log.level3Verbose("Setting script " + s.name + " as active and loading");
                this.activeScript = s;
                this.loadActiveScript();
            }
            catch (MalformedURLException ex) {
            }
            catch (IOException iOException) {}
        } else {
            this.activeScript = s;
        }
    }

    public Script getActiveScript() {
        return this.activeScript;
    }

    public void removeScript(Script script) {
        if (this.scripts.contains(script)) {
            this.scripts.remove(script);
            Log.level4Debug("Removing Script: " + script.name);
        }
    }

    public void write() throws IOException {
        HashMap<String, InputStream> nameStream = new HashMap<String, InputStream>();
        if (!this.CASPAC.exists()) {
            this.CASPAC.createNewFile();
        }
        Zip zip = new Zip(this.CASPAC);
        nameStream.put("-build.properties", this.build.getBuildPropInputStream());
        nameStream.put("-Overview.txt", StringOperations.convertStringToStream(this.overview));
        if (this.logo != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.logo, "png", baos);
            ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
            nameStream.put("-logo.png", is);
        }
        for (Script s : this.scripts) {
            File[] list = new File(s.tempDir).listFiles();
            if (list != null) {
                for (File test : list) {
                    boolean delete = true;
                    for (File f : s.individualFiles) {
                        if (!test.getCanonicalFile().equals(f.getCanonicalFile())) continue;
                        delete = false;
                    }
                    if (!delete || !test.toString().contains(s.tempDir)) continue;
                    test.delete();
                }
            }
            nameStream.putAll(s.getScriptAsMapForCASPAC());
        }
        Log.level4Debug("Placeing the following files in the caspac Zip");
        zip.streamEntryToExistingZip(nameStream);
    }

    public void setBuild(Properties prop) {
        this.build = new Build(prop);
        this.build.loadPropsToVariables();
    }

    public void loadFirstScriptFromCASPAC() throws ZipException, IOException {
        Log.level4Debug("Starting loadFirstScriptFromCASPAC unzip on " + this.CASPAC.getAbsolutePath());
        String scriptName = "";
        Unzip unzip = new Unzip(this.CASPAC);
        while (unzip.zipFileEntries.hasMoreElements()) {
            boolean isScript;
            ZipEntry entry = unzip.zipFileEntries.nextElement();
            String filename = unzip.getEntryName(entry);
            boolean bl = isScript = !Arrays.asList(this.controlFiles).contains(((Object)entry).toString());
            if ((!isScript || !scriptName.isEmpty()) && (!isScript || !scriptName.equals(this.activeScript.name))) continue;
            this.handleCASPACScriptFiles(filename, unzip, entry);
            scriptName = ((Object)entry).toString().substring(0, ((Object)entry).toString().lastIndexOf("."));
            this.activeScript = this.getScriptByFilename(filename);
        }
        Log.level4Debug("loading CASPAC script");
        this.performUnzipOnQueue();
    }

    public void loadActiveScript() throws IOException {
        Log.level4Debug("Starting loadActiveScript CASPAC unzip.");
        String scriptName = this.activeScript.name;
        if (this.type == 0) {
            Unzip unzip = new Unzip(this.CASPAC);
            while (unzip.zipFileEntries.hasMoreElements()) {
                ZipEntry entry = unzip.zipFileEntries.nextElement();
                String filename = unzip.getEntryName(entry);
                if (!((Object)entry).toString().startsWith(scriptName)) continue;
                this.handleCASPACScriptFiles(filename, unzip, entry);
            }
        } else if (this.type == 1) {
            Log.level3Verbose("This is a CASUAL jar with resources");
            try {
                this.activeScript = this.updateIfRequired(this.activeScript);
            }
            catch (URISyntaxException ex) {
                Log.errorHandler(ex);
            }
            Log.level4Debug("returned from checking updates.");
            this.replaceScriptByName(this.activeScript);
            this.unzipThreads = new ArrayList();
            MandatoryThread t = new MandatoryThread(this.activeScript.getExtractionRunnable());
            t.setName("Active Script Preparation");
            this.unzipThreads.add(t);
            this.performUnzipOnQueue();
        }
    }

    public void load() throws ZipException, IOException {
        if (this.type == 1) {
            Script s = this.scripts.get(0);
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(s.scriptZipFile.toString());
            Unzip.unZipInputStream(in, s.tempDir);
            in.close();
            this.activeScript = s;
            return;
        }
        Log.level4Debug("Starting commanded Load CASPAC unzip.");
        Unzip unzip = new Unzip(this.CASPAC);
        while (unzip.zipFileEntries.hasMoreElements()) {
            ZipEntry entry = unzip.zipFileEntries.nextElement();
            this.handleCASPACFiles(entry, unzip);
        }
        Log.level4Debug("Starting to unzip script zips");
        this.performUnzipOnQueue();
        Log.level4Debug("CASPAC load completed.");
    }

    public void waitForUnzipAndRun(Runnable action) {
        this.waitForUnzipAndRun(action, false, null);
    }

    public void waitForUnzipAndRun(Runnable action, boolean onASeparateThread, String ThreadName) {
        this.startAndWaitForUnzip();
        if (onASeparateThread) {
            MandatoryThread t = new MandatoryThread(action);
            t.setName(ThreadName);
            t.start();
        } else {
            action.run();
        }
    }

    public void startAndWaitForUnzip() {
        boolean[] isUnzipping = new boolean[this.unzipThreads.size()];
        Log.level4Debug("Currently waiting for Threads:" + Integer.toString(isUnzipping.length));
        for (MandatoryThread t : this.unzipThreads) {
            if (t != null && !t.isComplete()) {
                t.start();
                t.waitFor();
            }
            Log.level4Debug("Unzip completed!");
        }
        if (this.caspacShouldBeDeletedAfterExtraction) {
            this.CASPAC.delete();
        }
        Log.level4Debug("Unzipping complete.");
    }

    public void waitForUnzip() {
        for (MandatoryThread t : this.unzipThreads) {
            if (t == null) continue;
            if (!t.isAlive() && !t.isComplete()) {
                t.start();
            }
            if (!t.isComplete()) {
                t.waitFor();
            }
            Log.level4Debug("Unzip completed!");
        }
    }

    private void handleCASPACFiles(Object entry, Unzip pack) throws IOException {
        boolean isScript;
        String filename = pack.getEntryName(entry);
        boolean bl = isScript = !this.handleCASPACInformationFiles(filename, pack, entry);
        if (isScript) {
            this.handleCASPACScriptFiles(filename, pack, entry);
        }
    }

    private Script getScriptInstanceByFilename(String fileName) {
        for (Script s : this.scripts) {
            if (!s.name.equals(fileName.substring(0, fileName.lastIndexOf(".")))) continue;
            return s;
        }
        Script script = new Script(fileName.substring(0, fileName.lastIndexOf(".")), this.TempFolder + fileName + Statics.slash, this.type);
        this.scripts.add(script);
        return this.scripts.get(this.scripts.indexOf(script));
    }

    public Script getScriptByFilename(String fileName) {
        Log.level4Debug("Looking up " + fileName);
        String scriptName = "";
        try {
            scriptName = fileName.substring(0, fileName.lastIndexOf("."));
            for (Script s : this.scripts) {
                if (!s.name.equals(scriptName)) continue;
                return s;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!scriptName.isEmpty()) {
            Script s = new Script(scriptName, this.TempFolder + scriptName + Statics.slash, this.type);
            this.scripts.add(s);
            return this.scripts.get(this.scripts.size() - 1);
        }
        return null;
    }

    public String[] getScriptNames() {
        ArrayList<String> scriptNames = new ArrayList<String>();
        for (Script s : this.scripts) {
            scriptNames.add(s.name);
        }
        return StringOperations.convertArrayListToStringArray(scriptNames);
    }

    public Script getScriptByName(String name) {
        for (Script s : this.scripts) {
            if (!s.name.equals(name)) continue;
            return s;
        }
        Script s = new Script(name, this.TempFolder + Statics.slash + name + Statics.slash, this.type);
        this.scripts.add(s);
        return this.scripts.get(this.scripts.size() - 1);
    }

    private void performUnzipOnQueue() {
        Log.level3Verbose("Performing unzip of resources.");
        for (MandatoryThread t : this.unzipThreads) {
            t.start();
        }
    }

    private void setBuildPropInformation(Unzip pack, Object entry) throws IOException {
        Log.level4Debug("Found -build.properties adding information to CASPAC");
        this.build = new Build(pack.streamFileFromZip(entry));
        this.build.loadPropsToVariables();
    }

    private void extractCASPACBanner(Unzip pack, Object entry, String filename) throws IOException {
        Log.level4Debug("Found logo adding information to CASPAC");
        this.logo = ImageIO.read(ImageIO.createImageInputStream(pack.streamFileFromZip(entry)));
        if (filename.isEmpty()) {
            filename = this.TempFolder + "-logo.png";
        }
        if (this.build != null) {
            this.build.bannerPic = filename;
        } else {
            this.tempbannerpic = filename;
        }
    }

    private boolean handleCASPACInformationFiles(String filename, Unzip pack, Object entry) throws IOException {
        boolean isAControlFile = false;
        if (filename.equals("-build.properties")) {
            this.setBuildPropInformation(pack, entry);
            isAControlFile = true;
        } else if (filename.endsWith(".png")) {
            if (filename.equals("")) {
                filename = this.TempFolder + "-logo.png";
            }
            this.extractCASPACBanner(pack, entry, filename);
            isAControlFile = true;
        } else if (filename.toString().equals("-Overview.txt")) {
            this.overview = StringOperations.convertStreamToString(pack.streamFileFromZip(entry));
            isAControlFile = true;
        }
        return isAControlFile;
    }

    private void handleCASPACScriptFiles(String filename, Unzip pack, Object entry) throws IOException {
        FileOperations fo = new FileOperations();
        MD5sum md5sum = new MD5sum();
        if (filename.toString().endsWith(".meta")) {
            Script script = this.getScriptInstanceByFilename(filename.toString());
            Log.level4Debug("Found METADATA for " + script.name + ".");
            if (!this.scripts.contains(script)) {
                Log.level4Debug(script.name + " not found in CASPAC adding" + " script to CASPAC.");
                this.scripts.add(script);
            }
            int i = this.scripts.indexOf(script);
            script.metaData.load(pack.streamFileFromZip(entry));
            Log.level4Debug("Added METADATA to " + script.name + ".");
            boolean md5ArrayPosition = false;
            this.scripts.set(i, script);
        } else if (filename.toString().endsWith(".scr")) {
            Script script = this.getScriptInstanceByFilename(filename.toString());
            script.scriptContents = fo.readTextFromStream(pack.streamFileFromZip(entry));
            Log.level4Debug("Added Script for " + script.name + ".");
            script.actualMD5s.add(md5sum.getLinuxMD5Sum(StringOperations.convertStringToStream(script.scriptContents), filename));
        } else if (filename.toString().endsWith(".zip")) {
            Script script = this.getScriptInstanceByFilename(filename.toString());
            script.scriptZipFile = entry;
            script.zipfile = pack;
            MandatoryThread t = new MandatoryThread(script.getExtractionRunnable());
            t.setName("zip File Preparation " + this.unzipThreads.size());
            this.unzipThreads.add(t);
            Log.level4Debug("Added .zip to " + script.name + ". It will be unziped at end of unpacking.");
        } else if (filename.toString().endsWith(".txt")) {
            String description;
            Script script = this.getScriptInstanceByFilename(filename.toString());
            script.discription = description = fo.readTextFromStream(pack.streamFileFromZip(entry));
            Log.level4Debug("Added Description to " + script.name + ".");
            script.actualMD5s.add(md5sum.getLinuxMD5Sum(StringOperations.convertStringToStream(script.discription), filename));
        }
    }

    private void setBuild(InputStream in) throws IOException {
        Properties prop = new Properties();
        prop.load(in);
        this.setBuild(prop);
        Log.level4Debug(StringOperations.convertStreamToString(this.build.getBuildPropInputStream()));
    }

    private void handleCASPACJarFiles(String entry) throws IOException {
        FileOperations fo = new FileOperations();
        if (entry.startsWith("/")) {
            entry = entry.replaceFirst("/", "");
        }
        if (entry.equals("SCRIPTS/-Overview.txt") || entry.equals("SCRIPTS\\-Overview.txt")) {
            Log.level4Debug("processing:" + entry);
            this.overview = fo.readTextFromResource(entry);
            System.out.println("overview " + this.overview);
        } else if (entry.equals("SCRIPTS/-build.properties") || entry.equals("SCRIPTS\\-build.properties")) {
            Log.level4Debug("processing:" + entry);
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(entry);
            this.setBuild(in);
        } else if (entry.equals("SCRIPTS/-logo.png") || entry.equals("SCRIPTS\\-logo.png")) {
            Log.level4Debug("processing:" + entry);
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(entry);
            this.logo = ImageIO.read(ImageIO.createImageInputStream(in));
        } else if (entry.endsWith(".txt")) {
            Log.level4Debug("processing:" + entry);
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(entry);
            this.getScriptByFilename((String)entry).discription = fo.readTextFromResource(entry);
        } else if (entry.endsWith(".scr")) {
            Log.level4Debug("processing:" + entry);
            System.out.println("SCRIPT CONTENTS:" + fo.readTextFromResource(entry));
            this.getScriptByFilename((String)entry).scriptContents = fo.readTextFromResource(entry);
        } else if (entry.endsWith(".meta")) {
            Log.level4Debug("processing:" + entry);
            System.out.println("loading meta " + entry);
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(entry);
            Properties prop = new Properties();
            prop.load(in);
            this.getScriptByFilename((String)entry).metaData.load(prop);
        } else if (entry.endsWith(".zip")) {
            Log.level4Debug("processing:" + entry);
            Log.level3Verbose("found zip at " + entry);
            this.getScriptByFilename((String)entry).scriptZipFile = entry;
        }
        Log.level4Debug("getting MD5 for:" + entry);
        new MD5sum().getLinuxMD5Sum(Caspac.class.getClassLoader().getResourceAsStream(entry), entry);
    }

    private void setupIDEModeScriptForCASUAL(String defaultPackage) {
        FileOperations fo = new FileOperations();
        Script script = this.getScriptByName(defaultPackage);
        String caspacPath = "SCRIPTS/";
        try {
            File f = new File(".");
            caspacPath = f.getCanonicalPath() + "/SCRIPTS/";
        }
        catch (IOException ex) {
            Log.errorHandler(ex);
        }
        String scriptPath = caspacPath + defaultPackage;
        try {
            this.setBuild(new BufferedInputStream(new FileInputStream(caspacPath + "-build.properties")));
        }
        catch (FileNotFoundException ex) {
            Log.errorHandler(ex);
        }
        catch (IOException ex) {
            Log.errorHandler(ex);
        }
        this.overview = fo.readFile(caspacPath + "-Overview.txt");
        String logof = caspacPath + "-logo.png";
        try {
            FileInputStream in = new FileInputStream(logof);
            this.logo = ImageIO.read(ImageIO.createImageInputStream(in));
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.build.bannerPic = logof;
        Log.level4Debug("IDE MODE PATH=" + scriptPath);
        this.getScriptByName((String)defaultPackage).scriptContents = fo.readFile(scriptPath + ".scr");
        this.getScriptByName((String)defaultPackage).discription = fo.readFile(scriptPath + ".txt");
        try {
            this.getScriptByName((String)defaultPackage).metaData.load(new BufferedInputStream(new FileInputStream(new File(scriptPath + ".meta"))));
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        this.getScriptByName((String)defaultPackage).scriptZipFile = scriptPath + ".zip";
    }

    private void loadCASPACcontrolFilesFromCASPAC() throws IOException {
        FileOperations fo = new FileOperations();
        if (fo.verifyExists(this.CASPAC.getAbsolutePath()) && this.CASPAC.canRead()) {
            try {
                Unzip unzip = new Unzip(this.CASPAC);
                Enumeration<? extends ZipEntry> cpEnumeration = unzip.zipFileEntries;
                if (cpEnumeration.hasMoreElements()) {
                    while (cpEnumeration.hasMoreElements()) {
                        ZipEntry o = cpEnumeration.nextElement();
                        if (unzip.getEntryName(o).contains("-Overview.txt")) {
                            this.overview = fo.readTextFromStream(unzip.streamFileFromZip(o));
                        }
                        if (unzip.getEntryName(o).contains("-build.properties")) {
                            this.build = new Build(unzip.streamFileFromZip(o));
                        }
                        if (!unzip.getEntryName(o).contains("-logo.png")) continue;
                        this.extractCASPACBanner(unzip, o, this.overview);
                    }
                }
            }
            catch (ZipException zipException) {
                // empty catch block
            }
        }
    }

    private void updateMD5s() {
        MandatoryThread update = new MandatoryThread(CASUALTools.updateMD5s);
        update.setName("Updating MD5s");
        update.start();
        Log.level3Verbose("IDE Mode: Using TestScript.scr ONLY!");
    }

    public Script updateIfRequired(Script s) throws MalformedURLException, URISyntaxException, IOException {
        return s;
    }

    public int replaceScriptByName(Script s) {
        String name = s.name;
        for (int i = 0; i < this.scripts.size(); ++i) {
            if (!this.scripts.get((int)i).name.equals(name)) continue;
            this.scripts.set(i, s);
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String n = System.getProperty("line.separator");
        sb.append("Scripts:").append(this.scripts.size()).append(n);
        sb.append("Working Dir: ").append(this.TempFolder).append(n);
        sb.append(this.build.buildProp.toString());
        return sb.toString();
    }

    public class Build {
        public String developerName = "";
        public String developerDonateButtonText = "";
        public String donateLink = "";
        public String windowTitle = "";
        public boolean usePictureForBanner = false;
        public String bannerPic = "";
        public String bannerText = "";
        public String executeButtonText = "Do It";
        public boolean audioEnabled = AudioHandler.useSound;
        public boolean alwaysEnableControls = false;
        public Properties buildProp = new Properties();

        public Build(InputStream prop) throws IOException {
            Log.level4Debug("Loading build information from inputstream");
            this.buildProp.load(prop);
            this.loadPropsToVariables();
            Log.level4Debug(this.windowTitle + " - " + this.bannerText + " - " + this.developerName);
        }

        public Build(Properties prop) {
            Log.level4Debug("Loading build information from prop information");
            this.buildProp = prop;
            this.loadPropsToVariables();
        }

        public boolean write(String output) throws FileNotFoundException, IOException {
            File f = new File(output);
            return this.write(f);
        }

        public boolean write(File output) throws FileNotFoundException, IOException {
            FileOperations fo = new FileOperations();
            this.setPropsFromVariables();
            FileOutputStream fos = new FileOutputStream(output);
            this.buildProp.store(fos, "This properties file was generated by CASUAL");
            return fo.verifyExists(output.toString());
        }

        public InputStream getBuildPropInputStream() throws IOException {
            this.setPropsFromVariables();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.buildProp.store(output, "This properties file was generated by CASUAL");
            return new ByteArrayInputStream(output.toByteArray());
        }

        private void setPropsFromVariables() {
            this.buildProp.setProperty("Window.UsePictureForBanner", this.usePictureForBanner ? "True" : "False");
            this.buildProp.setProperty("Audio.Enabled", this.audioEnabled ? "True" : "False");
            this.buildProp.setProperty("Application.AlwaysEnableControls", this.alwaysEnableControls ? "True" : "False");
            this.buildProp.setProperty("Developer.DonateLink", this.donateLink);
            this.buildProp.setProperty("Developer.DonateToButtonText", this.developerDonateButtonText);
            this.buildProp.setProperty("Developer.Name", this.developerName);
            this.buildProp.setProperty("Window.ExecuteButtonText", this.executeButtonText);
            this.buildProp.setProperty("Window.BannerText", this.bannerText);
            this.buildProp.setProperty("Window.BannerPic", this.bannerPic);
            this.buildProp.setProperty("Window.Title", this.windowTitle);
        }

        private void loadPropsToVariables() {
            if (this.buildProp.containsKey("Audio.Enabled")) {
                AudioHandler.useSound = this.audioEnabled = this.buildProp.getProperty("Audio.Enabled", "").contains("rue");
            }
            this.usePictureForBanner = this.buildProp.getProperty("Window.UsePictureForBanner", "").contains("rue");
            this.developerDonateButtonText = this.buildProp.getProperty("Developer.DonateToButtonText", "");
            this.developerName = this.buildProp.getProperty("Developer.Name", "");
            this.donateLink = this.buildProp.getProperty("Developer.DonateLink", "");
            this.donateLink = this.buildProp.getProperty("Developer.DonateLink", "");
            this.executeButtonText = this.buildProp.getProperty("Window.ExecuteButtonText", "");
            this.bannerText = this.buildProp.getProperty("Window.BannerText", "");
            this.alwaysEnableControls = this.buildProp.getProperty("Application.AlwaysEnableControls", "").contains("rue");
            this.windowTitle = this.buildProp.getProperty("Window.Title", "");
        }
    }
}

