/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.archiving.libpit;

import java.io.IOException;
import java.io.OutputStream;

public class PitOutputStream {
    private final OutputStream outputStream;
    private final byte[] writeBuffer = new byte[4];

    public PitOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void writeInt(int value) throws IOException {
        this.writeBuffer[0] = (byte)(value & 0xFF);
        this.writeBuffer[1] = (byte)(value >> 8 & 0xFF);
        this.writeBuffer[2] = (byte)(value >> 16 & 0xFF);
        this.writeBuffer[3] = (byte)(value >> 24);
        this.outputStream.write(this.writeBuffer);
    }

    public void writeShort(short value) throws IOException {
        this.writeBuffer[0] = (byte)(value & 0xFF);
        this.writeBuffer[1] = (byte)(value >> 8);
        this.outputStream.write(this.writeBuffer, 0, 2);
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.outputStream.write(buffer, offset, length);
    }
}

