/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.archiving.libpit;

import java.util.Arrays;

public class PitEntry {
    public static final int PARTITION_NAME_MAX_LENGTH = 32;
    public static final int FILENAME_MAX_LENGTH = 32;
    public static final int FOTA_NAME_MAX_LENGTH = 32;
    private int bin_type = 0;
    private int device_type = 0;
    private int part_id = 0;
    private int part_type = 0;
    private int filesystem = 0;
    private int block_start = 0;
    private int block_count = 0;
    private int file_offset = 0;
    private int file_size = 0;
    public char[] part_name = new char[32];
    public char[] file_name = new char[32];
    public char[] fota_name = new char[32];

    public boolean matches(PitEntry otherPitEntry) {
        return this.toString().equals(otherPitEntry.toString());
    }

    public int getBinType() {
        return this.bin_type;
    }

    public String getBinFriendlyType() {
        if (this.bin_type == 0) {
            return "AP";
        }
        return "CP";
    }

    public void setBinType(int binType) {
        this.bin_type = binType;
    }

    public int getDevType() {
        return this.device_type;
    }

    public void setDeviceType(int devType) {
        this.device_type = devType;
    }

    public int getPartID() {
        return this.part_id;
    }

    public void setPartID(int partitionIdentifier) {
        this.part_id = partitionIdentifier;
    }

    public int getPartitionType() {
        return this.part_type;
    }

    public void setPartitionType(int partitionFlags) {
        this.part_type = partitionFlags;
    }

    public int getFilesystem() {
        return this.filesystem;
    }

    public void setFilesystem(int filesystem) {
        this.filesystem = filesystem;
    }

    public int getBlockStart() {
        return this.block_start;
    }

    public void setBlockStart(int blockStart) {
        this.block_start = blockStart;
    }

    public int getBlockCount() {
        return this.block_count;
    }

    public void setBlockCount(int partitionBlockCount) {
        this.block_count = partitionBlockCount;
    }

    public int getFileOffset() {
        return this.file_offset;
    }

    public void setFileOffset(int fileOffset) {
        this.file_offset = fileOffset;
    }

    public int getFileSize() {
        return this.file_size;
    }

    public void setFileSize(int partitionBlockSize) {
        this.file_size = partitionBlockSize;
    }

    public byte[] getPartitionNameBytes() {
        return this.convertCharArrayToByteArray(this.part_name);
    }

    public String getPartitionName() {
        String partitionName = "";
        return new String(this.part_name).trim();
    }

    public String getOdinFlashablePartitionName() {
        String partitionName = "";
        for (int i = 0; i < this.part_name.length && this.part_name[i] != '\u0000'; ++i) {
            partitionName = partitionName + this.part_name[i];
        }
        return new String(partitionName);
    }

    public String getPartitionFriendlyName() {
        String filename = "";
        block0: for (int i = 0; i < this.part_name.length; ++i) {
            if (this.part_name[i] != '\u0000') {
                filename = filename + this.part_name[i];
                continue;
            }
            while (this.part_name[i] == '\u0000' && i < this.part_name.length - 1) {
                if (this.part_name[++i] == '\u0000') continue;
                filename = filename + "   param: " + this.part_name[i];
                continue block0;
            }
        }
        return filename;
    }

    public void setPartitionName(byte[] partitionName) {
        this.part_name = this.convertByteArrayToCharArray(partitionName);
    }

    public void setPartitionName(String partitionName) {
        if (partitionName.length() < this.part_name.length) {
            this.part_name = Arrays.copyOf(partitionName.toCharArray(), this.part_name.length);
        } else {
            partitionName = partitionName.substring(0, this.part_name.length - 1);
            this.part_name = Arrays.copyOf(partitionName.toCharArray(), this.part_name.length);
        }
    }

    public byte[] getFileNameBytes() {
        return this.convertCharArrayToByteArray(this.file_name);
    }

    public String getFilenameString() {
        String filename = "";
        for (int i = 0; i < this.file_name.length; ++i) {
            if (this.file_name[i] == '\u0000') continue;
            filename = filename + this.file_name[i];
        }
        return filename;
    }

    public String getFriendlyFileName() {
        String filename = "";
        block0: for (int i = 0; i < this.file_name.length; ++i) {
            if (this.file_name[i] != '\u0000') {
                filename = filename + this.file_name[i];
                continue;
            }
            while (this.file_name[i] == '\u0000' && i < this.file_name.length - 1) {
                if (this.file_name[++i] == '\u0000') continue;
                filename = filename + "   param: " + this.file_name[i];
                continue block0;
            }
        }
        return filename;
    }

    public void setFilename(byte[] filename) {
        this.file_name = this.convertByteArrayToCharArray(filename);
    }

    public void setFilename(String filename) {
        if (filename.length() < this.file_name.length) {
            this.file_name = Arrays.copyOf(filename.toCharArray(), this.file_name.length);
        } else {
            filename = filename.substring(0, this.file_name.length - 1);
            this.file_name = Arrays.copyOf(filename.toCharArray(), this.file_name.length);
        }
    }

    public byte[] getFotaNameBytes() {
        return this.convertCharArrayToByteArray(this.fota_name);
    }

    public String getFotaName() {
        String fotaname = "";
        for (int i = 0; i < this.fota_name.length; ++i) {
            if (this.fota_name[i] == '\u0000') continue;
            fotaname = fotaname + this.fota_name[i];
        }
        return fotaname;
    }

    public String getFOTAFriendlyName() {
        String fotaname = "";
        block0: for (int i = 0; i < this.fota_name.length; ++i) {
            if (this.fota_name[i] != '\u0000') {
                fotaname = fotaname + this.fota_name[i];
                continue;
            }
            while (this.fota_name[i] == '\u0000' && i < this.fota_name.length - 1) {
                if (this.fota_name[++i] == '\u0000') continue;
                fotaname = fotaname + "   param: " + this.fota_name[i];
                continue block0;
            }
        }
        return fotaname;
    }

    public void setFotaName(byte[] fotaName) {
        this.fota_name = this.convertByteArrayToCharArray(fotaName);
    }

    public void setFotaName(String fotaName) {
        if (fotaName.length() < this.file_name.length) {
            this.fota_name = Arrays.copyOf(fotaName.toCharArray(), this.fota_name.length);
        } else {
            fotaName = fotaName.substring(0, this.file_name.length - 1);
            this.fota_name = Arrays.copyOf(fotaName.toCharArray(), this.fota_name.length);
        }
    }

    public String getPartitionTypeFriendlyName() {
        switch (this.part_type) {
            case 0: {
                return "Raw";
            }
            case 1: {
                return "Bct";
            }
            case 2: {
                return "Bootloader";
            }
            case 4: {
                return "Data";
            }
            case 5: {
                return "Data";
            }
            case 6: {
                return "MBR";
            }
            case 7: {
                return "EBR";
            }
            case 8: {
                return "GP1";
            }
            case 9: {
                return "GPT";
            }
        }
        return "undocumented";
    }

    public String getFilesystemTypeFriendlyName() {
        switch (this.filesystem) {
            case 0: {
                return "raw";
            }
            case 1: {
                return "Basic";
            }
            case 2: {
                return "Enhanced";
            }
            case 3: {
                return "EXT2";
            }
            case 4: {
                return "YAFFS2";
            }
            case 5: {
                return "EXT4";
            }
        }
        return "undocumented";
    }

    public String getDeviceTypeFriendlyName() {
        switch (this.device_type) {
            case 1: {
                return "NAND";
            }
            case 2: {
                return "EMMC";
            }
            case 3: {
                return "SPI";
            }
            case 4: {
                return "IDE";
            }
            case 5: {
                return "NAND_X16";
            }
        }
        return "undocumented";
    }

    public String getBlockCountFriendly(boolean si) {
        int unit;
        long bytes = (long)this.block_count * 512L;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + "B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f%sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public String getPartitionDescritpion() {
        String n = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("The ").append(this.getPartitionFriendlyName());
        sb.append(" partition, ");
        if (this.getPartID() < 0) {
            sb.append(" is invalid");
            return sb.toString();
        }
        sb.append("identified as partition number ").append(this.getPartID());
        sb.append(", is ").append(this.getBlockCountFriendly(true)).append(" in size and carries a ").append(this.getFilesystemTypeFriendlyName()).append(" format. This partition resides on the ").append(this.getPartitionTypeFriendlyName()).append(" section of the ").append(this.getBinFriendlyType()).append(" ").append(this.getDeviceTypeFriendlyName()).append(".");
        if (!this.getFriendlyFileName().equals("") && !this.getFriendlyFileName().startsWith("-")) {
            sb.append(" It identifies itself to Odin as ").append(this.getFriendlyFileName()).append(".");
        }
        if (this.file_offset != 0 && this.file_size != 0) {
            sb.append("The partition carries a filesize of ").append(this.file_size).append(" and an offset of ").append(this.file_offset).append(".");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String n = System.getProperty("line.separator");
        sb.append("ID: ").append(this.part_id);
        sb.append("   Partition Name: ").append(this.getPartitionFriendlyName()).append(n);
        sb.append("Filename: ").append(this.getFriendlyFileName()).append(n);
        sb.append("Block Size: ").append(this.block_count).append(" (").append(this.getBlockCountFriendly(true)).append(")").append(n);
        sb.append("Block range: ").append(this.block_start).append(" - ").append(this.getPartitionEndBlock());
        sb.append(" (hex 0x").append(Integer.toHexString(this.block_start)).append(" - 0x").append(Integer.toHexString(this.getPartitionEndBlock())).append(")").append(n);
        sb.append("FilesystemType: ").append(this.filesystem);
        sb.append("   PartType: ").append(this.part_type);
        sb.append("   DevType: ").append(this.device_type);
        sb.append("   BinType: ").append(this.bin_type).append(n);
        sb.append("Offset:").append(this.file_offset);
        sb.append("   Size: ").append(this.file_size);
        sb.append("   FOTA: ").append(this.getFOTAFriendlyName()).append(n);
        sb.append(this.getPartitionDescritpion());
        if (this.getFotaName().contains("remained")) {
            sb.append(" The partition will expand to fill the remainder of the ").append(this.getDeviceTypeFriendlyName()).append(".");
        }
        sb.append(n).append(n).append(n);
        return sb.toString();
    }

    private int getPartitionEndBlock() {
        return this.block_start + this.block_count - 1;
    }

    public char[] convertByteArrayToCharArray(byte[] byteArray) {
        char[] retval = new char[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            retval[i] = (char)byteArray[i];
        }
        return retval;
    }

    public byte[] convertCharArrayToByteArray(char[] charArray) {
        byte[] retval = new byte[charArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            retval[i] = (byte)charArray[i];
        }
        return retval;
    }
}

