/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.archiving.libpit;

import CASUAL.archiving.libpit.PitEntry;
import CASUAL.archiving.libpit.PitInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;

public class PitData {
    public static final int FILE_IDENTIFIER = 305436790;
    public int entryCount;
    char[] fileType = new char[8];
    char[] pitName = new char[12];
    private final ArrayList<PitEntry> entries = new ArrayList();
    ByteArrayOutputStream signature = new ByteArrayOutputStream();

    public PitData() {
    }

    public PitData(PitInputStream PitStream) {
        this.unpack(PitStream);
    }

    public PitData(File pit) throws FileNotFoundException {
        this(new PitInputStream(new FileInputStream(pit)));
    }

    public final boolean unpack(PitInputStream pitInputStream) {
        try {
            int byteRead;
            int i;
            int pitID = pitInputStream.readInt();
            if (pitID != 305436790) {
                return false;
            }
            this.entries.clear();
            this.entryCount = pitInputStream.readInt();
            this.entries.ensureCapacity(this.entryCount);
            for (i = 0; i < 8; ++i) {
                this.fileType[i] = (char)pitInputStream.read();
            }
            for (i = 0; i < 12; ++i) {
                this.pitName[i] = (char)pitInputStream.read();
            }
            byte[] buffer = new byte[32];
            for (int i2 = 0; i2 < this.entryCount; ++i2) {
                PitEntry entry = new PitEntry();
                this.entries.add(entry);
                entry.setBinType(pitInputStream.readInt());
                entry.setDeviceType(pitInputStream.readInt());
                entry.setPartID(pitInputStream.readInt());
                entry.setPartitionType(pitInputStream.readInt());
                entry.setFilesystem(pitInputStream.readInt());
                entry.setBlockStart(pitInputStream.readInt());
                entry.setBlockCount(pitInputStream.readInt());
                entry.setFileOffset(pitInputStream.readInt());
                entry.setFileSize(pitInputStream.readInt());
                pitInputStream.read(buffer, 0, 32);
                entry.setPartitionName(buffer);
                pitInputStream.read(buffer, 0, 32);
                entry.setFilename(buffer);
                pitInputStream.read(buffer, 0, 32);
                entry.setFotaName(buffer);
            }
            while ((byteRead = pitInputStream.read()) != -1) {
                this.signature.write(byteRead);
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean pack(DataOutputStream dataOutputStream) {
        try {
            int i;
            dataOutputStream.writeInt(Integer.reverseBytes(305436790));
            dataOutputStream.writeInt(Integer.reverseBytes(this.entryCount));
            for (i = 0; i < this.fileType.length; ++i) {
                dataOutputStream.write(this.fileType[i]);
            }
            for (i = 0; i < this.pitName.length; ++i) {
                dataOutputStream.write(this.pitName[i]);
            }
            for (i = 0; i < this.entryCount; ++i) {
                PitEntry entry = this.entries.get(i);
                dataOutputStream.writeInt(Integer.reverseBytes(entry.getBinType()));
                dataOutputStream.writeInt(Integer.reverseBytes(entry.getDevType()));
                dataOutputStream.writeInt(Integer.reverseBytes(entry.getPartID()));
                dataOutputStream.writeInt(Integer.reverseBytes(entry.getPartitionType()));
                dataOutputStream.writeInt(Integer.reverseBytes(entry.getFilesystem()));
                dataOutputStream.writeInt(Integer.reverseBytes(entry.getBlockStart()));
                dataOutputStream.writeInt(Integer.reverseBytes(entry.getBlockCount()));
                dataOutputStream.writeInt(Integer.reverseBytes(entry.getFileOffset()));
                dataOutputStream.writeInt(Integer.reverseBytes(entry.getFileSize()));
                dataOutputStream.write(entry.getPartitionNameBytes());
                dataOutputStream.write(entry.getFileNameBytes());
                dataOutputStream.write(entry.getFotaNameBytes());
            }
            dataOutputStream.write(this.signature.toByteArray());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean matches(PitData otherPitData) {
        return this.toString().equals(otherPitData.toString());
    }

    public void clear() {
        this.entryCount = 0;
        this.fileType = new char[8];
        this.pitName = new char[12];
        this.entries.clear();
    }

    public PitEntry getEntry(int index) {
        return this.entries.get(index);
    }

    public PitEntry findEntry(String partitionName) {
        for (int i = 0; i < this.entries.size(); ++i) {
            PitEntry entry = this.entries.get(i);
            String s = entry.getPartitionName().trim();
            if (!entry.getPartitionName().equals(partitionName)) continue;
            return entry;
        }
        return null;
    }

    public PitEntry findEntryByFilename(String filename) {
        for (int i = 0; i < this.entries.size(); ++i) {
            PitEntry entry = this.entries.get(i);
            String nameCheck = "";
            for (char c : entry.file_name) {
                if (c == '\u0000') break;
                nameCheck = nameCheck + c;
            }
            if (!filename.equals(nameCheck)) continue;
            return entry;
        }
        return null;
    }

    public PitEntry findEntry(int partitionIdentifier) {
        for (int i = 0; i < this.entries.size(); ++i) {
            PitEntry entry = this.entries.get(i);
            if (entry.getPartID() != partitionIdentifier) continue;
            return entry;
        }
        return null;
    }

    public void removeEntry(PitEntry entry) {
        this.entries.remove(entry);
    }

    public void addEntry(PitEntry entry) {
        this.entries.add(this.entryCount++, entry);
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public char[] getFileType() {
        return this.fileType;
    }

    public char[] getPhone() {
        return this.pitName;
    }

    public String getPITFriendlyName() {
        String pitFriendlyName = "";
        block0: for (int i = 0; i < this.pitName.length; ++i) {
            if (this.pitName[i] != '\u0000') {
                pitFriendlyName = pitFriendlyName + this.pitName[i];
                continue;
            }
            while (this.pitName[i] == '\u0000' && i < this.pitName.length - 1) {
                if (this.pitName[++i] == '\u0000') continue;
                pitFriendlyName = pitFriendlyName + "\nPIT Parameter: " + this.pitName[i];
                continue block0;
            }
        }
        return pitFriendlyName;
    }

    public String getFileTypeFriendlyName() {
        String filetypeFriendlyName = "";
        block0: for (int i = 0; i < this.fileType.length; ++i) {
            if (this.fileType[i] != '\u0000') {
                filetypeFriendlyName = filetypeFriendlyName + this.fileType[i];
                continue;
            }
            while (this.fileType[i] == '\u0000' && i < this.fileType.length - 1) {
                if (this.fileType[++i] == '\u0000') continue;
                filetypeFriendlyName = filetypeFriendlyName + "\nPIT Parameter: " + this.fileType[i];
                continue block0;
            }
        }
        return filetypeFriendlyName;
    }

    public String toString() {
        String n = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append(n);
        sb.append("PIT Name: ").append(this.getPITFriendlyName()).append(n);
        sb.append("Entry Count: ").append(this.entryCount).append(n);
        sb.append("File Type: ").append(this.getFileTypeFriendlyName()).append(n);
        sb.append(n);
        sb.append(n);
        for (int i = 0; i < this.entries.size(); ++i) {
            sb.append("--- Entry #").append(i).append(" ---").append(n);
            sb.append(this.entries.get(i).toString());
        }
        sb.append(n).append(n);
        return sb.toString();
    }

    public void resizePartition(String partName, int changeToSize) throws ClassNotFoundException {
        this.resizePartition(this.findEntry(partName), changeToSize);
    }

    public void resizePartition(PitEntry entry, int changeToSize) throws ClassNotFoundException {
        int i;
        PitEntry[] sorted = this.sortEntriesByBlockLocation();
        int entryLocation = -1;
        String type = entry.getPartitionTypeFriendlyName();
        for (i = 0; i < sorted.length; ++i) {
            if (entry != sorted[i]) continue;
            entryLocation = i;
            break;
        }
        if (entryLocation == -1) {
            throw new ClassNotFoundException("The PitEntry Specified was not found:" + entry);
        }
        sorted[entryLocation].setBlockCount(sorted[entryLocation].getBlockCount() + changeToSize);
        for (i = entryLocation + 1; i < sorted.length; ++i) {
            if (!sorted[i].getPartitionTypeFriendlyName().equals(type)) continue;
            sorted[i].setBlockStart(sorted[i].getBlockStart() + changeToSize);
        }
        for (PitEntry finalEntry : sorted) {
            for (int i2 = 0; i2 < this.entries.size(); ++i2) {
                if (this.entries.get(i2).getPartID() != finalEntry.getPartID()) continue;
                this.entries.set(i2, finalEntry);
            }
        }
    }

    public PitEntry[] sortEntriesByBlockLocation() {
        boolean enumerated = false;
        LinkedList<PitEntry> ll = new LinkedList<PitEntry>();
        ll.addAll(this.entries);
        while (!enumerated) {
            enumerated = true;
            int lastBlock = 0;
            for (int i = 0; i < ll.size(); ++i) {
                if (lastBlock < ((PitEntry)ll.get(i)).getBlockStart()) {
                    lastBlock = ((PitEntry)ll.get(i)).getBlockStart();
                    continue;
                }
                if (i == 0) continue;
                enumerated = false;
                ll.add(i - 2, (PitEntry)ll.get(i));
                ll.remove(i + 1);
            }
        }
        PitEntry[] retval = ll.toArray(new PitEntry[ll.size()]);
        return retval;
    }
}

