/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.archiving;

import CASUAL.Log;
import CASUAL.Statics;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.LinkedList;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Zip {
    private final File outputZip;
    private Log log = new Log();
    private String TempFolder = Statics.getTempFolder();
    byte[] BUFFER = new byte[4096];

    public Zip(File zip) throws IOException {
        this.outputZip = zip;
    }

    public String getTempFolder() {
        return this.TempFolder;
    }

    public void addToTempFolderLoc(String TempFolder) {
        this.TempFolder = this.TempFolder + Statics.slash + TempFolder;
        if (!new File(this.TempFolder).exists()) {
            new File(this.TempFolder).mkdirs();
        }
    }

    public void addFilesToExistingZip(String fileToAdd) throws IOException {
        File file = new File(fileToAdd);
        this.addFilesToExistingZip(new File[]{file});
    }

    public void addFilesToExistingZip(String[] filesToBeZipped) throws IOException {
        File[] fileList = new File[filesToBeZipped.length];
        int i = 0;
        for (String file : filesToBeZipped) {
            fileList[i] = new File(file);
        }
        this.addFilesToExistingZip(fileList);
    }

    public void addFilesToExistingZip(File fileToAdd) throws IOException {
        this.addFilesToExistingZip(new File[]{fileToAdd});
    }

    public void addFilesToExistingZip(File[] files) throws IOException {
        if (!this.outputZip.exists()) {
            this.outputZip.createNewFile();
        }
        File tempFile = File.createTempFile(this.outputZip.getName(), null);
        tempFile.delete();
        this.getTemporaryOutputZip(tempFile, this.BUFFER);
        ZipInputStream zin = new ZipInputStream(new FileInputStream(tempFile));
        ZipOutputStream out = this.prepareZipFileForMoreEntries(zin, files);
        for (int i = 0; i < files.length; ++i) {
            FileInputStream in = new FileInputStream(files[i]);
            this.writeEntryToZipFile(out, files[i].getName(), in);
        }
        out.close();
        tempFile.delete();
    }

    public void streamEntryToExistingZip(InputStream in, String name) throws IOException {
        File tempFile = File.createTempFile(this.outputZip.getName(), null);
        tempFile.delete();
        this.getTemporaryOutputZip(tempFile, this.BUFFER);
        ZipInputStream zin = new ZipInputStream(new FileInputStream(tempFile));
        ZipOutputStream out = this.prepareZipFileForMoreEntries(zin, name);
        this.writeEntryToZipFile(out, name, in);
        out.close();
        tempFile.delete();
    }

    public void injectZip(String injectionZip) {
        this.injectZip(new File(injectionZip), "");
    }

    public void injectZip(File injectionZip) {
        this.injectZip(injectionZip, "");
    }

    public void injectZip(File injectionZip, String injectionPath) {
        try {
            if (!injectionPath.equals("")) {
                if (injectionPath.startsWith(Statics.slash)) {
                    injectionPath = injectionPath.replaceFirst(Statics.slash, "");
                }
                if (!injectionPath.endsWith(Statics.slash)) {
                    injectionPath = injectionPath.concat(Statics.slash);
                }
            }
            byte[] buf = new byte[1024];
            ZipInputStream zin = new ZipInputStream(new FileInputStream(injectionZip));
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(this.outputZip));
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                int len;
                out.putNextEntry(entry);
                while ((len = zin.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                entry = zin.getNextEntry();
            }
            zin.close();
            if (!injectionZip.exists()) {
                Log.level0Error("The file " + injectionZip.getAbsolutePath() + " doesn't exist please make sure it is the right location.");
                return;
            }
            zin = new ZipInputStream(new FileInputStream(injectionZip));
            entry = zin.getNextEntry();
            while (entry != null) {
                int len;
                String name = entry.getName();
                if (injectionPath.equals("")) {
                    out.putNextEntry(entry);
                } else {
                    out.putNextEntry(new ZipEntry(injectionPath + name));
                }
                while ((len = zin.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                entry = zin.getNextEntry();
            }
            out.close();
        }
        catch (FileNotFoundException ex) {
            Log.errorHandler(ex);
        }
        catch (IOException ex) {
            Log.errorHandler(ex);
        }
    }

    public void streamEntryToExistingZip(Map<String, InputStream> nameStream) throws IOException {
        File tempFile = File.createTempFile(this.outputZip.getName(), null);
        tempFile.delete();
        this.getTemporaryOutputZip(tempFile, this.BUFFER);
        ZipInputStream zin = new ZipInputStream(new FileInputStream(tempFile));
        ZipOutputStream out = this.prepareZipFileForMoreEntries(zin, nameStream);
        for (Map.Entry<String, InputStream> entry : nameStream.entrySet()) {
            this.writeEntryToZipFile(out, entry.getKey(), entry.getValue());
            entry.getValue().close();
        }
        out.close();
        tempFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFolderFilesToNewZip(String newZip, String toBeZipped) throws Exception {
        File directory = new File(toBeZipped);
        URI base = directory.toURI();
        LinkedList<File> queue = new LinkedList<File>();
        queue.push(directory);
        FileOutputStream out = new FileOutputStream(newZip);
        OutputStream res = out;
        try {
            ZipOutputStream zout = new ZipOutputStream(out);
            res = zout;
            while (!queue.isEmpty()) {
                directory = (File)queue.pop();
                for (File kid : directory.listFiles()) {
                    String name = base.relativize(kid.toURI()).getPath();
                    if (kid.isDirectory()) {
                        queue.push(kid);
                        name = name.endsWith("/") ? name : name + "/";
                        zout.putNextEntry(new ZipEntry(name));
                        continue;
                    }
                    zout.putNextEntry(new ZipEntry(name));
                    Zip.copy(kid, (OutputStream)zout);
                    zout.closeEntry();
                }
            }
        }
        finally {
            res.close();
        }
    }

    private static void copy(File in, File out) throws FileNotFoundException, IOException {
        Zip.copy(in, (OutputStream)new FileOutputStream(out));
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int readCount;
        byte[] buffer = new byte[1024];
        while ((readCount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, readCount);
        }
    }

    private static void copy(File file, OutputStream out) throws IOException {
        FileInputStream in = new FileInputStream(file);
        Zip.copy(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileToZipDir(File file) throws IOException {
        if (!file.exists()) {
            Log.level0Error("File: " + file.toString() + " not found while adding to zip");
            return;
        }
        File fileToAdd = new File(this.TempFolder + Statics.slash + file.getName());
        if (!fileToAdd.exists()) {
            fileToAdd.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel dest = null;
        try {
            source = new FileInputStream(file).getChannel();
            dest = new FileOutputStream(fileToAdd).getChannel();
            ((FileChannel)dest).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (dest != null) {
                dest.close();
            }
        }
    }

    private void addFileToZipDir(File file, File destFolder) throws IOException {
        if (!file.exists()) {
            Log.level0Error("File: " + file.toString() + " not found while adding to zip.");
            return;
        }
        File fileToAdd = new File(destFolder.toString() + Statics.slash + file.getName());
        if (!fileToAdd.exists()) {
            fileToAdd.createNewFile();
        }
        Zip.copy(fileToAdd, destFolder);
    }

    public void addFileToZipDIr(File file) throws IOException {
        if (!file.exists()) {
            Log.level0Error("File: " + file.toString() + " not found while adding to zip.");
            return;
        }
        if (file.isFile()) {
            this.addFileToZipDir(file);
        }
        if (file.isDirectory()) {
            this.addDirectoryToZipDir(file, null);
        }
    }

    private void addDirectoryToZipDir(File folder, File parent) throws IOException {
        File dirToAdd = parent == null ? new File(this.TempFolder + Statics.slash + folder.getName()) : new File(parent.toString() + Statics.slash + folder.getName());
        if (!dirToAdd.exists()) {
            dirToAdd.mkdir();
        }
        for (File c : folder.listFiles()) {
            if (c.isDirectory()) {
                this.addDirectoryToZipDir(c, dirToAdd);
                continue;
            }
            this.addFileToZipDir(c, dirToAdd);
        }
    }

    public void compressZipDir(String file) throws FileNotFoundException, IOException {
        this.zipDir(file, "");
    }

    public void compressZipDir() throws FileNotFoundException, IOException {
        this.zipDir(this.TempFolder, "");
    }

    private void zipDir(String directory, String path) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(this.outputZip));
        this.zipDir(directory, zos, path);
    }

    public void zipDir(String directory, ZipOutputStream zos, String path) throws IOException {
        File zipDir = new File(directory);
        String[] dirList = zipDir.list();
        byte[] readBuffer = new byte[2156];
        for (int i = 0; i < dirList.length; ++i) {
            File f = new File(zipDir, dirList[i]);
            if (f.isDirectory()) {
                String filePath = f.getPath();
                this.zipDir(filePath, zos, path + f.getName() + "/");
                continue;
            }
            FileInputStream fis = new FileInputStream(f);
            ZipEntry anEntry = new ZipEntry(path + f.getName());
            zos.putNextEntry(anEntry);
            int bytesIn = fis.read(readBuffer);
            while (bytesIn != -1) {
                zos.write(readBuffer, 0, bytesIn);
                bytesIn = fis.read(readBuffer);
            }
        }
    }

    private void getTemporaryOutputZip(File tempFile, byte[] buf) throws IOException, RuntimeException {
        boolean renameOk = this.outputZip.renameTo(tempFile);
        boolean copyOk = false;
        if (!renameOk) {
            int len;
            if (tempFile.exists()) {
                tempFile.delete();
            }
            tempFile.createNewFile();
            FileInputStream in = new FileInputStream(this.outputZip);
            FileOutputStream out = new FileOutputStream(tempFile);
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
            copyOk = true;
        }
        if (!renameOk && !copyOk) {
            throw new IOException("could not rename or copy the file " + this.outputZip.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
        }
    }

    private ZipOutputStream prepareZipFileForMoreEntries(ZipInputStream zin, File[] files) throws FileNotFoundException, IOException {
        String[] namesToCheck = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            namesToCheck[i] = files[i].getName();
        }
        return this.prepareZipFileForMoreEntries(zin, namesToCheck);
    }

    private ZipOutputStream prepareZipFileForMoreEntries(ZipInputStream zin, String name) throws FileNotFoundException, IOException {
        String[] namesToCheck = new String[]{name};
        return this.prepareZipFileForMoreEntries(zin, namesToCheck);
    }

    private ZipOutputStream prepareZipFileForMoreEntries(ZipInputStream zin, Map<String, InputStream> nameStream) throws FileNotFoundException, IOException {
        String[] namesToCheck = nameStream.keySet().toArray(new String[nameStream.size()]);
        return this.prepareZipFileForMoreEntries(zin, namesToCheck);
    }

    private ZipOutputStream prepareZipFileForMoreEntries(ZipInputStream zin, String[] namesToCheck) throws FileNotFoundException, IOException {
        ZipEntry entry;
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(this.outputZip));
        while ((entry = zin.getNextEntry()) != null) {
            int len;
            boolean skipEntryInFavorOfNewEntry = false;
            for (String newEntryName : namesToCheck) {
                if (!newEntryName.equals(entry.getName())) continue;
                skipEntryInFavorOfNewEntry = true;
            }
            if (skipEntryInFavorOfNewEntry) continue;
            String name = entry.getName();
            out.putNextEntry(new ZipEntry(name));
            while ((len = zin.read(this.BUFFER)) > 0) {
                out.write(this.BUFFER, 0, len);
            }
        }
        return out;
    }

    private void writeEntryToZipFile(ZipOutputStream out, String file, InputStream in) throws IOException {
        int len;
        out.putNextEntry(new ZipEntry(file));
        while ((len = in.read(this.BUFFER)) > 0) {
            out.write(this.BUFFER, 0, len);
        }
        out.closeEntry();
    }
}

