/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.archiving;

import CASUAL.CASUALMain;
import CASUAL.Log;
import CASUAL.Statics;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class Unzip {
    static int BUFFER = 4096;
    final ZipFile zip;
    public Enumeration<? extends ZipEntry> zipFileEntries;

    public Unzip(File f) throws ZipException, IOException {
        this.zip = new ZipFile(f);
        try {
            this.zipFileEntries = this.zip.entries();
        }
        catch (Exception e) {
            Log.errorHandler(e);
        }
    }

    public Unzip(String f) throws ZipException, IOException {
        this.zip = new ZipFile(new File(f));
        try {
            this.zipFileEntries = this.zip.entries();
        }
        catch (Exception e) {
            Log.errorHandler(e);
        }
    }

    public void unzipFile(String outputFolder) throws ZipException, IOException {
        this.unzipFileToFolder(outputFolder);
    }

    private void unzipFileToFolder(String outputFolder) throws ZipException, IOException {
        Log.level4Debug("Unzipping " + this.zip.toString());
        String newPath = outputFolder + System.getProperty("file.separator");
        new File(newPath).mkdir();
        this.zipFileEntries = this.zip.entries();
        while (this.zipFileEntries.hasMoreElements()) {
            ZipEntry entry = this.zipFileEntries.nextElement();
            String currentEntry = entry.getName();
            File destFile = new File(newPath, currentEntry);
            File destinationParent = destFile.getParentFile();
            destinationParent.mkdirs();
            if (!entry.isDirectory()) {
                Log.level3Verbose("unzipping " + entry.toString());
                this.writeFromZipToFile(this.zip, entry, newPath);
                continue;
            }
            if (!entry.isDirectory()) continue;
            Log.level4Debug(newPath + entry.getName());
            new File(newPath + entry.getName()).mkdirs();
        }
    }

    public static void unZipResource(String zipResource, String outputFolder) throws FileNotFoundException, IOException {
        InputStream zStream = new CASUALMain().getClass().getResourceAsStream(zipResource);
        Unzip.unZipInputStream(zStream, outputFolder);
        zStream.close();
    }

    public static void unZipInputStream(InputStream zStream, String outputFolder) throws FileNotFoundException, IOException {
        ZipEntry zipEntry;
        zStream.mark(0);
        ZipInputStream zipInputStream = new ZipInputStream(zStream);
        zipInputStream = new ZipInputStream(zStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int currentByte;
            Log.level3Verbose("Unzipping " + zipEntry.getName());
            File EntryFile = new File(outputFolder + System.getProperty("file.separator") + zipEntry.getName());
            if (zipEntry.isDirectory()) {
                EntryFile.mkdirs();
                continue;
            }
            File EntryFolder = new File(EntryFile.getParent());
            if (!EntryFolder.exists()) {
                EntryFolder.mkdirs();
            }
            byte[] data = new byte[BUFFER];
            String currentEntry = zipEntry.getName();
            File DestFile = new File(outputFolder + System.getProperty("file.separator"), currentEntry);
            FileOutputStream FileOut = new FileOutputStream(DestFile);
            BufferedInputStream BufferedInputStream2 = new BufferedInputStream(zipInputStream);
            BufferedOutputStream Destination = new BufferedOutputStream(FileOut);
            int numberOfCycles = (int)(zipEntry.getSize() / (long)BUFFER);
            boolean updatePercent = false;
            if (numberOfCycles > 0) {
                updatePercent = true;
            }
            int currentCycle = 0;
            while ((currentByte = BufferedInputStream2.read(data, 0, BUFFER)) != -1) {
                Destination.write(data, 0, currentByte);
                if (updatePercent) {
                    Statics.GUI.setProgressBar(++currentCycle);
                    continue;
                }
                Statics.GUI.setBlocksUnzipped(++currentCycle);
            }
            Destination.flush();
            Destination.close();
        }
        Log.level3Verbose("Unzip Complete");
    }

    public void close() {
        try {
            this.zip.close();
        }
        catch (IOException ex) {
            Log.errorHandler(ex);
        }
    }

    public String deployFileFromZip(Object entry, String outputFolder) throws ZipException, IOException {
        ZipEntry zipEntry = new ZipEntry((ZipEntry)entry);
        this.writeFromZipToFile(this.zip, zipEntry, outputFolder);
        this.zip.close();
        return outputFolder + entry.toString();
    }

    public static BufferedInputStream streamFileFromZip(File zipFile, Object entry) throws ZipException, IOException {
        ZipFile zip = new ZipFile(zipFile);
        return new BufferedInputStream(zip.getInputStream((ZipEntry)entry));
    }

    private void writeFromZipToFile(ZipFile zip, ZipEntry entry, String filePathToWrite) throws IOException, FileNotFoundException {
        int currentByte;
        BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
        byte[] data = new byte[BUFFER];
        FileOutputStream fos = new FileOutputStream(new File(filePathToWrite + entry));
        BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
        while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
            dest.write(data, 0, currentByte);
        }
        dest.flush();
        dest.close();
        is.close();
    }

    public BufferedInputStream streamFileFromZip(Object entry) throws ZipException, IOException {
        return new BufferedInputStream(this.zip.getInputStream((ZipEntry)entry));
    }

    public String getEntryName(Object entry) {
        ZipEntry zipEntry = (ZipEntry)entry;
        String name = zipEntry.getName();
        return name;
    }

    public ZipEntry getEntry(Object entry) {
        return (ZipEntry)entry;
    }
}

