/*
 * Decompiled with CFR 0.152.
 */
package CASUAL;

import CASUAL.Log;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Translations {
    static ResourceBundle translation;

    public static String get(String line) {
        if (translation == null) {
            Translations.setDefaultLanguage();
        }
        Log.level4Debug("[TRANSLATION]" + line);
        String[] splitRef = line.split("( )|(\n)");
        String retVal = "";
        for (String ref : splitRef) {
            if (translation == null || ref.isEmpty() || !ref.startsWith("@")) continue;
            try {
                retVal = line.replace(ref, translation.getString(ref));
            }
            catch (MissingResourceException ex) {
                Log.level3Verbose("*****MISSING TRANSLATION VALUE***** for " + ref + " ");
            }
        }
        return retVal;
    }

    private static void setDefaultLanguage() {
        String lang = Locale.getDefault().getDisplayLanguage();
        try {
            translation = ResourceBundle.getBundle("CASUAL/resources/Translations/English", Locale.getDefault());
        }
        catch (Exception e) {
            translation = ResourceBundle.getBundle("CASUAL/resources/Translations/English");
            Log.level3Verbose("Language " + lang + " was not found in CASUAL/resources/Translations/" + lang + ".properties.  CASUAL will accept translations.  Defaulting to english. ");
        }
    }

    public void setLanguage(String lang) {
        try {
            translation = ResourceBundle.getBundle("CASUAL/resources/Translations/" + lang);
        }
        catch (Exception e) {
            translation = ResourceBundle.getBundle("CASUAL/resources/Translations/English");
            Log.level3Verbose("Language " + lang + " was not found in CASUAL/resources/Translations/" + lang + ".properties.  CASUAL will accept translations.  Defaulting to english. ");
        }
    }
}

