/*
 * Decompiled with CFR 0.152.
 */
package CASUAL;

import CASUAL.CASUALLanguage;
import CASUAL.CASUALStartupTasks;
import CASUAL.FileOperations;
import CASUAL.Log;
import CASUAL.caspac.Caspac;
import CASUAL.communicationstools.adb.ADBTools;
import CASUAL.communicationstools.adb.busybox.CASUALDataBridge;
import CASUAL.communicationstools.fastboot.FastbootTools;
import CASUAL.communicationstools.heimdall.HeimdallTools;
import CASUAL.iCASUALUI;
import CASUAL.instrumentation.Instrumentation;
import CASUAL.misc.MandatoryThread;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class Statics {
    private static String currentStatus = "working";
    public static boolean debugMode = false;
    public static Caspac CASPAC;
    public static int outputGUIVerbosity;
    public static int outputLogVerbosity;
    public static BufferedReader in;
    public static iCASUALUI GUI;
    public static final String slash;
    public static String PreProgress;
    public static String ScriptLocation;
    public static String CASUALHome;
    private static File TempFolder;
    public static String SelectedScriptFolder;
    public static String WinElevatorInTempFolder;
    public static final String WinPermissionElevatorResource = "/CASUAL/resources/ADB/Elevate.exe";
    public static final String WinVCRedis32tInRepo = "https://android-casual.googlecode.com/svn/trunk/repo/vcredist_x86.exe";
    public static ArrayList<String> ActionEvents;
    public static ArrayList<String> ReactionEvents;

    public static boolean isGUIIsAvailable() {
        if (GUI != null) {
            return GUI.isReady() && !GraphicsEnvironment.isHeadless();
        }
        return false;
    }

    public static String getTempFolder() {
        FileOperations fo = new FileOperations();
        if (TempFolder == null) {
            String user = System.getProperty("user.name");
            String tf = System.getProperty("java.io.tmpdir");
            tf = tf.endsWith(slash) ? tf : tf + slash;
            SimpleDateFormat sdf = new SimpleDateFormat("-yyyy-MM-dd-HH.mm.ss");
            TempFolder = new File(tf + "CASUAL" + user + sdf.format(new Date()).toString() + slash);
            Statics.setTempFolder(TempFolder.toString());
            fo.makeFolder(TempFolder.toString());
        }
        if (!TempFolder.exists()) {
            TempFolder.mkdirs();
        }
        return TempFolder.toString() + slash;
    }

    public String getTempFolderInstance() {
        return TempFolder.toString() + slash;
    }

    public static void initializeStatics() {
        CASUALDataBridge.commandedShutdown = true;
        Statics.setStatus("working");
        outputGUIVerbosity = 2;
        outputLogVerbosity = 4;
        PreProgress = "";
        SelectedScriptFolder = "";
        WinElevatorInTempFolder = TempFolder + "Elevate.exe";
        CASUALStartupTasks.scriptRunLock = new MandatoryThread();
        CASUALStartupTasks.lockGUIunzip = false;
        ActionEvents = new ArrayList();
        ReactionEvents = new ArrayList();
        new ADBTools().reset();
        new HeimdallTools().reset();
        new FastbootTools().reset();
        CASUALLanguage.GOTO = "";
        try {
            Statics.CASPAC.getActiveScript().scriptContinue = false;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void setStatus(final String status) {
        Log.level4Debug(status);
        currentStatus = status;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                if (GUI != null) {
                    GUI.setInformationScrollBorderText(status);
                }
                Instrumentation.updateStatus(status);
            }
        });
        t.setName("Updating GUI");
        t.start();
    }

    public static String getStatus() {
        return currentStatus;
    }

    public static String setTempFolder(String folder) {
        TempFolder = new File(folder);
        WinElevatorInTempFolder = TempFolder + "Elevate.exe";
        new FastbootTools().reset();
        new ADBTools().reset();
        return TempFolder.toString() + slash;
    }

    static {
        outputGUIVerbosity = 2;
        outputLogVerbosity = 4;
        in = new BufferedReader(new InputStreamReader(System.in));
        slash = System.getProperty("file.separator");
        PreProgress = "";
        ScriptLocation = "/SCRIPTS/";
        CASUALHome = System.getProperty("user.home") + System.getProperty("file.separator") + ".CASUAL" + System.getProperty("file.separator");
        WinElevatorInTempFolder = Statics.getTempFolder() + "Elevate.exe";
        ActionEvents = new ArrayList();
        ReactionEvents = new ArrayList();
    }
}

