/*
 * Decompiled with CFR 0.152.
 */
package CASUAL;

import CASUAL.CASUALMessageObject;
import CASUAL.CASUALScriptParser;
import CASUAL.FileOperations;
import CASUAL.Log;
import CASUAL.OSTools;
import CASUAL.Statics;
import CASUAL.misc.StringOperations;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;

public class Shell {
    public String elevateSimpleCommandWithMessage(String[] cmd, String message) {
        return this.elevateSimpleCommands(cmd, message);
    }

    public String elevateSimpleCommand(String[] cmd) {
        return this.elevateSimpleCommands(cmd, null);
    }

    private String elevateSimpleCommands(String[] cmd, String message) {
        FileOperations FileOperations2 = new FileOperations();
        Shell Shell2 = new Shell();
        String Result = "";
        String Command = "";
        for (String cmd1 : cmd) {
            Command = Command + "\"" + cmd1 + "\" ";
        }
        if (OSTools.isLinux()) {
            boolean useGKSU = true;
            String[] testGKSudo = new String[]{"which", "gksudo"};
            String testReturn = Shell2.silentShellCommand(testGKSudo);
            if (testReturn.contains("CritERROR!!!") || testReturn.equals("\n") || testReturn.isEmpty()) {
                useGKSU = false;
                String[] testPKexec = new String[]{"which", "pkexec"};
                testReturn = Shell2.silentShellCommand(testPKexec);
                if (testReturn.contains("CritERROR!!!") || testReturn.equals("\n") || testReturn.isEmpty()) {
                    new CASUALMessageObject("@interactionPermissionNotFound").showTimeoutDialog(60, null, 0, 0, null, null);
                }
            }
            String ScriptFile = Statics.getTempFolder() + "ElevateScript.sh";
            FileOperations2.deleteFile(ScriptFile);
            try {
                FileOperations2.writeToFile("#!/bin/sh\n" + Command, ScriptFile);
            }
            catch (IOException ex) {
                Log.errorHandler(ex);
            }
            FileOperations2.setExecutableBit(ScriptFile);
            Log.level4Debug("###Elevating Command: " + Command + " ###");
            Result = "";
            if (useGKSU) {
                Result = message == null ? Shell2.liveShellCommand(new String[]{"gksudo", "-k", "-D", "CASUAL", ScriptFile}, true) : Shell2.liveShellCommand(new String[]{"gksudo", "--message", message, "-k", "-D", "CASUAL", ScriptFile}, true);
            } else {
                int i = 0;
                while (Result.equals("") || Result.contains("Error executing command as another user")) {
                    Result = Shell2.liveShellCommand(new String[]{"pkexec", ScriptFile}, true);
                    if (!Result.contains("Error executing command as another user:") || ++i < 3) continue;
                    Log.level2Information("@permissionsElevationProblem");
                    Result = Shell2.liveShellCommand(new String[]{ScriptFile}, true);
                    break;
                }
            }
        } else if (OSTools.isMac()) {
            String ScriptFile = Statics.getTempFolder() + "ElevateScript.sh";
            try {
                FileOperations2.writeToFile("#!/bin/sh \nexport bar=" + Command + " ;\n" + "for i in \"$@\"; do export bar=\"$bar '${i}'\";done;\n" + "osascript -e 'do shell script \"$bar\" with administrator privileges'", ScriptFile);
                Log.level3Verbose(ScriptFile);
            }
            catch (IOException ex) {
                Log.errorHandler(ex);
            }
            FileOperations2.setExecutableBit(ScriptFile);
            String[] MacCommand = new String[]{ScriptFile};
            Result = this.liveShellCommand(MacCommand, true);
        } else if (!OSTools.OSName().equals("Windows XP")) {
            Result = this.liveShellCommand(cmd, true);
        }
        return Result;
    }

    public String sendShellCommand(String[] cmd) {
        Log.level4Debug("###executing: " + cmd[0] + "###");
        String AllText = "";
        try {
            String line;
            Process process = new ProcessBuilder(cmd).start();
            BufferedReader STDOUT = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader STDERR = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            try {
                process.waitFor();
            }
            catch (InterruptedException ex) {
                Log.errorHandler(ex);
            }
            int y = 0;
            while ((line = STDOUT.readLine()) != null) {
                AllText = y == 0 ? AllText + "\n" + line + "\n" : AllText + line + "\n";
                ++y;
            }
            y = 0;
            while ((line = STDERR.readLine()) != null && !line.equals("")) {
                AllText = y == 0 ? AllText + "\n" + line + "\n" : AllText + line + "\n";
                ++y;
            }
            return AllText + "\n";
        }
        catch (IOException ex) {
            Log.level0Error("@problemWhileExecutingCommand " + StringOperations.arrayToString(cmd) + "\nreturnval:" + AllText);
            return "CritERROR!!!";
        }
    }

    public String sendShellCommandIgnoreError(String[] cmd) {
        Log.level4Debug("\n###executing: " + cmd[0] + "###");
        String AllText = "";
        try {
            String line;
            Process process = new ProcessBuilder(cmd).start();
            BufferedReader STDOUT = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = STDOUT.readLine()) != null) {
                AllText = AllText + line + "\n";
            }
            return AllText + "\n";
        }
        catch (IOException ex) {
            Log.level0Error("@problemWhileExecutingCommand " + StringOperations.arrayToString(cmd) + "returnval:" + AllText);
            return "CritERROR!!!";
        }
    }

    public String silentShellCommand(String[] cmd) {
        String AllText = "";
        try {
            String line;
            Process process = new ProcessBuilder(cmd).start();
            BufferedReader STDOUT = new BufferedReader(new InputStreamReader(process.getInputStream()));
            try {
                process.waitFor();
            }
            catch (InterruptedException ex) {
                Log.errorHandler(ex);
            }
            while ((line = STDOUT.readLine()) != null) {
                AllText = AllText + "\n" + line;
            }
            return AllText;
        }
        catch (IOException ex) {
            return "CritERROR!!!";
        }
    }

    public String liveShellCommand(String[] params, boolean display) {
        String LogRead = "";
        try {
            int c;
            ProcessBuilder p = new ProcessBuilder(params);
            p.redirectErrorStream(true);
            Process process = p.start();
            Log.level4Debug("###executing real-time command: " + params[0] + "###");
            BufferedReader STDOUT = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String LineRead = "";
            while ((c = STDOUT.read()) > -1) {
                String CharRead = Character.toString((char)c);
                LineRead = LineRead + CharRead;
                LogRead = LogRead + CharRead;
                if (display) {
                    Log.progress(CharRead);
                }
                if ((Statics.ActionEvents.isEmpty() || !LineRead.contains("\n")) && !LineRead.contains("\r")) continue;
                for (int i = 0; i <= Statics.ActionEvents.size() - 1; ++i) {
                    if (Statics.ActionEvents == null || !LineRead.contains(Statics.ActionEvents.get(i))) continue;
                    new CASUALScriptParser().executeOneShotCommand(Statics.ReactionEvents.get(i));
                }
                LineRead = "";
            }
        }
        catch (RuntimeException ex) {
            Log.errorHandler(ex);
            return LogRead;
        }
        catch (IOException ex) {
            Log.errorHandler(ex);
        }
        return LogRead;
    }

    public String timeoutShellCommand(final String[] cmd, int timeout) {
        class TimeoutString {
            public String AllText = "";

            TimeoutString() {
            }
        }
        final TimeoutString tos = new TimeoutString();
        Runnable runCommand = new Runnable(){
            {
            }

            @Override
            public void run() {
                Log.level4Debug("###executing timeout command: " + cmd[0] + "###");
                try {
                    String line;
                    ProcessBuilder p = new ProcessBuilder(cmd);
                    p.redirectErrorStream(true);
                    Process process = p.start();
                    BufferedReader STDOUT = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((line = STDOUT.readLine()) != null) {
                        tos.AllText = tos.AllText + line + "\n";
                    }
                }
                catch (IOException ex) {
                    Log.level0Error("@problemWhileExecutingCommand " + StringOperations.arrayToString(cmd) + " " + tos.AllText);
                }
            }
        };
        Thread t = new Thread(runCommand);
        t.setDaemon(true);
        t.setName("TimeOutShell " + cmd[0] + timeout + "ms abandon time");
        t.start();
        Calendar endTime = Calendar.getInstance();
        endTime.add(14, timeout);
        while (Calendar.getInstance().getTimeInMillis() < endTime.getTimeInMillis() && t.isAlive()) {
        }
        if (Calendar.getInstance().getTimeInMillis() >= endTime.getTimeInMillis()) {
            Log.level3Verbose("TimeOut on " + cmd[0] + " after " + timeout + "ms. Returning what was received.");
            return "Timeout!!! " + tos.AllText;
        }
        return tos.AllText;
    }

    public String silentTimeoutShellCommand(final String[] cmd, int timeout) {
        class TimeoutString {
            public String AllText = "";

            TimeoutString() {
            }
        }
        final TimeoutString tos = new TimeoutString();
        Runnable runCommand = new Runnable(){
            {
            }

            @Override
            public void run() {
                try {
                    String line;
                    ProcessBuilder p = new ProcessBuilder(cmd);
                    p.redirectErrorStream(true);
                    Process process = p.start();
                    BufferedReader STDOUT = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while ((line = STDOUT.readLine()) != null) {
                        tos.AllText = tos.AllText.concat(line).concat("\n");
                    }
                }
                catch (IOException ex) {
                    Log.level0Error("@problemWhileExecutingCommand " + StringOperations.arrayToString(cmd) + " " + tos.AllText);
                }
            }
        };
        Thread t = new Thread(runCommand);
        t.setDaemon(true);
        t.setName("SilentTimeOutShell " + cmd[0] + timeout + "ms abandon time");
        t.start();
        Calendar endTime = Calendar.getInstance();
        endTime.add(14, timeout);
        while (Calendar.getInstance().getTimeInMillis() < endTime.getTimeInMillis() && t.isAlive()) {
        }
        if (Calendar.getInstance().getTimeInMillis() >= endTime.getTimeInMillis()) {
            Log.level3Verbose("TimeOut on " + cmd[0] + " after " + timeout + "ms. Returning what was received.");
            return "Timeout!!! " + tos.AllText;
        }
        return tos.AllText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String timeoutValueCheckingShellCommand(String[] cmd, final String[] restartTimerKeywords, final int timeout, boolean logLevel2) {
        StringBuilder sb = new StringBuilder();
        try {
            ProcessBuilder p = new ProcessBuilder(cmd);
            p = p.redirectErrorStream(true);
            Process process = p.start();
            class TimeoutLogger {
                boolean realtime;
                private final StringBuilder log = new StringBuilder();
                AtomicBoolean timedOut = new AtomicBoolean(false);
                AtomicBoolean isRunning = new AtomicBoolean(true);
                final Object isRunningLock = new Object();
                AtomicBoolean isLogging = new AtomicBoolean(true);
                final Object isLoggingLock = new Object();
                final Process processRunning;
                final Timer watchDogTimer = new Timer(timeout, new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        Log.level4Debug("Watchdog Triggered!  Command timed out.");
                        timedOut.set(true);
                        Process process = processRunning;
                        synchronized (process) {
                            processRunning.notifyAll();
                        }
                    }
                });

                TimeoutLogger(boolean realtime, Process p) {
                    this.realtime = realtime;
                    this.processRunning = p;
                }

                synchronized void log(char c) {
                    this.log.append(c);
                    if (this.realtime) {
                        Log.progress(Character.toString(c));
                        String logstring = this.log.toString();
                        for (String check : restartTimerKeywords) {
                            if (!logstring.endsWith(check) || !this.isRunning.get()) continue;
                            Log.level4Debug("Timer Reset on keyword " + check);
                            this.watchDogTimer.restart();
                        }
                    }
                }

                synchronized String get() {
                    return this.log.toString();
                }
            }
            final TimeoutLogger tl = new TimeoutLogger(logLevel2, process);
            Thread processMonitor = new Thread(new Runnable(){
                {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        tl.processRunning.waitFor();
                        tl.watchDogTimer.stop();
                        tl.isRunning.set(false);
                        Log.level4Debug("Process Monitor done.");
                        Process process = tl.processRunning;
                        synchronized (process) {
                            tl.processRunning.notifyAll();
                        }
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Shell.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
            processMonitor.setName("Monitoring Process Exit Status from " + cmd[0]);
            Thread reader = new Thread(new Runnable(){
                {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    BufferedInputStream STDOUT = new BufferedInputStream(tl.processRunning.getInputStream());
                    Log.level4Debug("Instantiating reader process");
                    try {
                        char read;
                        while (tl.isRunning.get() && !tl.timedOut.get()) {
                            if (STDOUT.available() <= 0) continue;
                            read = (char)STDOUT.read();
                            tl.log(read);
                        }
                        tl.watchDogTimer.stop();
                        Thread.sleep(100L);
                        while (STDOUT.available() > 0) {
                            read = (char)STDOUT.read();
                            tl.log(read);
                        }
                        tl.isLogging.set(false);
                        Process read2 = tl.processRunning;
                        synchronized (read2) {
                            tl.processRunning.notifyAll();
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Shell.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Shell.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
            reader.setName("Reading and monitoring output from " + cmd[0]);
            reader.start();
            tl.watchDogTimer.start();
            processMonitor.start();
            Process process2 = tl.processRunning;
            synchronized (process2) {
                tl.processRunning.wait();
            }
            if (tl.isLogging.get()) {
                process2 = tl.processRunning;
                synchronized (process2) {
                    tl.processRunning.wait();
                }
            }
            String retvalue = tl.get();
            if (tl.timedOut.get()) {
                retvalue = "Timeout!!! " + retvalue;
                process.destroy();
            }
            return retvalue;
        }
        catch (IOException ex) {
            Logger.getLogger(Shell.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Shell.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "";
    }
}

