/*
 * Decompiled with CFR 0.152.
 */
package CASUAL;

import CASUAL.Log;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class ResourceDeployer {
    public String deployResourceTo(String resourceLocation, String tempFolder) {
        return this.deployResourceTo(new String[]{resourceLocation}, tempFolder)[0];
    }

    public String[] deployResourceTo(String[] resourceLocation, String tempFolder) {
        ArrayList<String> deployed = new ArrayList<String>();
        for (String res : resourceLocation) {
            String name = tempFolder + new File(res).getName();
            if (!this.copyFromResourceToFile(res, name)) {
                return new String[0];
            }
            deployed.add(name);
        }
        return deployed.toArray(new String[deployed.size()]);
    }

    public boolean copyFromResourceToFile(String Resource, String toFile) {
        boolean retval = false;
        try {
            File destination = new File(toFile);
            this.makeParentFolder(destination);
            InputStream resourceAsStream = this.getClass().getResourceAsStream(Resource);
            if (resourceAsStream.available() < 1) {
                resourceAsStream.close();
                Log.level0Error("@criticalErrorWhileCopying " + Resource);
                return false;
            }
            this.writeInputStreamToFile(resourceAsStream, destination);
            if (destination.length() < 1L) {
                resourceAsStream.close();
                Log.level0Error("@failedToWriteFile");
                retval = false;
            } else {
                resourceAsStream.close();
                retval = true;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (IOException ex) {
            Log.errorHandler(ex);
            Log.level0Error("@criticalErrorWhileCopying " + Resource);
            return false;
        }
        return retval;
    }

    private void makeParentFolder(File destination) {
        if (!destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
    }

    private boolean writeInputStreamToFile(InputStream is, File file) {
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            byte[] data = new byte[4096];
            if (is.available() > 0) {
                while (is.read(data, 0, data.length) != -1) {
                    out.write(data, 0, data.length);
                }
            } else {
                return false;
            }
            is.close();
            out.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

