/*
 * Decompiled with CFR 0.152.
 */
package CASUAL;

import CASUAL.Statics;
import CASUAL.Translations;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Log {
    public static PrintStream out = new PrintStream(System.out);
    private static String progressBuffer = "";
    static int lastNewLine = 100;

    private static void sendToGUI(String data) {
        if (Statics.GUI == null) {
            Statics.PreProgress = Statics.PreProgress + "\n" + data;
        } else if (!data.equals("\n") || !data.isEmpty()) {
            Statics.GUI.sendString(data + "\n");
        }
    }

    public static void level0Error(String data) {
        if (data.startsWith("@")) {
            data = Translations.get(data);
        }
        Log.writeOutToLog("[ERROR]" + data);
        if (Statics.outputGUIVerbosity >= 0) {
            Log.sendToGUI(data);
        }
        if (Statics.outputLogVerbosity >= 0) {
            out.println("[ERROR]" + data);
        }
    }

    public static void Level1Interaction(String data) {
        if (data.startsWith("@")) {
            data = Translations.get(data);
        }
        Log.writeOutToLog("[INTERACTION]" + data);
        if (Statics.outputGUIVerbosity >= 1) {
            Log.sendToGUI(data);
        }
        if (Statics.outputLogVerbosity >= 1) {
            out.println("[INTERACTION]" + data);
        }
    }

    public static void level2Information(String data) {
        if (data.startsWith("@")) {
            data = Translations.get(data);
        }
        Log.writeOutToLog("[INFO]" + data);
        if (Statics.outputGUIVerbosity >= 2) {
            Log.sendToGUI(data);
        }
        if (Statics.outputLogVerbosity >= 2) {
            out.println("[INFO]" + data);
        }
    }

    public static void level3Verbose(String data) {
        Log.writeOutToLog("[VERBOSE]" + data);
        if (Statics.outputGUIVerbosity >= 3) {
            Log.sendToGUI(data);
        }
        if (Statics.outputLogVerbosity >= 3) {
            out.println("[VERBOSE]" + data);
        }
    }

    public static void level4Debug(String data) {
        Log.writeOutToLog("[DEBUG]" + data);
        if (Statics.outputGUIVerbosity >= 4) {
            Log.sendToGUI(data);
        }
        if (Statics.outputLogVerbosity >= 4) {
            out.println("[DEBUG]" + data);
        }
    }

    public static void writeToLogFile(String data) {
        Log.writeOutToLog(data);
    }

    private static synchronized void writeOutToLog(String data) {
        try {
            FileWriter WriteFile = new FileWriter(Statics.getTempFolder() + "Log.txt", true);
            PrintWriter output = new PrintWriter(WriteFile);
            output.write(data + "\n");
            WriteFile.close();
            output.close();
        }
        catch (IOException ex) {
            out.println("Attempted to write to log but could not.");
        }
    }

    public static void progress(String data) {
        if (Statics.GUI == null) {
            System.out.print(data);
        } else {
            Statics.GUI.sendProgress(data);
        }
    }

    public static void LiveUpdate(String data) {
        out.print(data);
        if (Statics.GUI != null) {
            Statics.GUI.sendProgress(data);
        }
    }

    public static void beginLine() {
        out.println();
        if (Statics.isGUIIsAvailable()) {
            Log.progress("\n");
        }
    }

    public static void errorHandler(Exception e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        Log.level0Error("[CRITICAL]" + e.getLocalizedMessage() + "\n" + e.getMessage() + "\n" + e.toString() + "\n" + "\n" + writer.toString());
        Log.level0Error("@criticalError");
    }

    static void initialize() {
        out = new PrintStream(System.out);
    }
}

