/*
 * Decompiled with CFR 0.152.
 */
package CASUAL;

import CASUAL.Log;
import CASUAL.misc.StringOperations;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

public class FileOperations {
    public void recursiveDelete(String path) {
        this.recursiveDelete(new File(path));
    }

    public void recursiveDelete(File path) {
        File[] c = path.listFiles();
        if (path.exists()) {
            Log.level4Debug("Removing folder and contents:" + path.toString());
            if (c != null && c.length > 0) {
                for (File file : c) {
                    if (file.isDirectory()) {
                        this.recursiveDelete(file);
                        file.delete();
                        continue;
                    }
                    file.delete();
                }
            }
            path.delete();
        }
    }

    public boolean verifyWritePermissionsRecursive(String path) {
        File Check = new File(path);
        File[] c = Check.listFiles();
        if (Check.exists()) {
            Log.level4Debug("Verifying permissions in folder:" + path.toString());
            for (File file : c) {
                if (file.canWrite()) continue;
                return false;
            }
        }
        return true;
    }

    public String findRecursive(String PathToSearch, String FileName) {
        File Check = new File(PathToSearch);
        File[] c = Check.listFiles();
        String s = "";
        if (Check.exists()) {
            Log.level3Verbose("Searching for file in folder:" + PathToSearch.toString());
            for (File file : c) {
                if (file.isDirectory()) {
                    return this.findRecursive(file.getAbsolutePath(), FileName);
                }
                if (!file.getName().equals(FileName)) continue;
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException ex) {
                    Log.errorHandler(ex);
                }
            }
        }
        return s;
    }

    public boolean verifyExists(String file) {
        if (file != null && !file.isEmpty()) {
            File f = new File(file);
            return f.exists() || f.isDirectory() || f.isFile();
        }
        return false;
    }

    public boolean makeFolder(String Folder) {
        if (Folder == null) {
            return false;
        }
        File folder = new File(Folder);
        if (folder.exists()) {
            return true;
        }
        folder.mkdirs();
        if (folder.exists()) {
            return true;
        }
        Log.level0Error("@couldNotCreateFolder " + Folder);
        return false;
    }

    public void writeStreamToFile(BufferedInputStream stream, String destination) throws FileNotFoundException, IOException {
        int currentByte;
        int buffer = 4096;
        byte[] data = new byte[buffer];
        File f = new File(destination);
        if (!this.verifyExists(f.getParent())) {
            this.makeFolder(f.getParent());
        }
        FileOutputStream fos = new FileOutputStream(f);
        BufferedOutputStream dest = new BufferedOutputStream(fos, buffer);
        while ((currentByte = stream.read(data, 0, buffer)) != -1) {
            dest.write(data, 0, currentByte);
        }
        dest.flush();
        dest.close();
    }

    public void writeToFile(String Text, String File2) throws IOException {
        FileWriter fw = new FileWriter(File2, true);
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(Text);
        bw.flush();
        fw.close();
        Log.level4Debug("Write Finished");
    }

    public void overwriteFile(String Text, String File2) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(File2, false));
        bw.write(Text);
        bw.close();
        Log.level4Debug("File overwrite Finished");
    }

    private boolean writeInputStreamToFile(InputStream is, File file) {
        Log.level4Debug("Attempting to write " + file.getPath());
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            int BUFFER = 4096;
            byte[] data = new byte[BUFFER];
            if (is.available() > 0) {
                int currentByte;
                while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
                    out.write(data, 0, currentByte);
                }
            } else {
                return false;
            }
            is.close();
            out.flush();
            out.close();
        }
        catch (IOException e) {
            return false;
        }
        if (file.exists() && file.length() >= 4L) {
            Log.level4Debug("File verified.");
            return true;
        }
        Log.level0Error("@failedToWriteFile");
        return false;
    }

    public Boolean deleteFile(String FileName) {
        Boolean Deleted;
        File file = new File(FileName);
        if (file.exists()) {
            if (file.delete()) {
                Deleted = true;
                Log.level4Debug("Deleted " + FileName);
            } else {
                Deleted = false;
                Log.level0Error("@couldNotDeleteFile" + FileName);
            }
        } else {
            Deleted = true;
        }
        return Deleted;
    }

    public boolean deleteStringArrayOfFiles(String[] cleanUp) {
        for (String s : cleanUp) {
            if (s == null) continue;
            new File(s).delete();
            if (!this.verifyExists(s)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(File sourceFile, File destFile) throws IOException {
        Log.level4Debug("Copying " + sourceFile.getCanonicalPath() + " to " + destFile.getCanonicalPath());
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        FileChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            destination.transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
        }
        if (destination != null) {
            destination.close();
        }
    }

    public String currentDir() {
        String CurrentDir = new File(".").getAbsolutePath();
        Log.level4Debug("Detected current folder: " + CurrentDir);
        if (CurrentDir.endsWith(".")) {
            CurrentDir = CurrentDir.substring(0, CurrentDir.length() - 1);
        }
        return CurrentDir;
    }

    public boolean copyFile(String FromFile, String ToFile) {
        File OriginalFile = new File(FromFile);
        File DestinationFile = new File(ToFile);
        try {
            this.copyFile(OriginalFile, DestinationFile);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean setExecutableBit(String Executable2) {
        File Exe = new File(Executable2);
        boolean Result = Exe.setExecutable(true);
        Log.level4Debug("Setting executable " + Exe + ". Result=" + Result);
        return Result;
    }

    public boolean verifyResource(String res) {
        return this.getClass().getResource(res) != null;
    }

    public String readTextFromResource(String Resource) {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(Resource);
        StringBuilder text = new StringBuilder();
        try {
            int read;
            InputStreamReader in = new InputStreamReader(resourceAsStream, "UTF-8");
            while ((read = in.read()) != -1) {
                char C = Character.valueOf((char)read).charValue();
                text.append(C);
            }
            in.close();
        }
        catch (NullPointerException ex) {
            Log.level0Error("@resourceNotFound:" + Resource);
        }
        catch (IOException ex) {
            Log.level0Error("@resourceNotFound:" + Resource);
        }
        return text.toString();
    }

    public String readTextFromStream(BufferedInputStream in) {
        StringBuilder text = new StringBuilder();
        try {
            int read;
            while ((read = in.read()) != -1) {
                char C = Character.valueOf((char)read).charValue();
                text.append(C);
            }
            in.close();
        }
        catch (IOException ex) {
            Log.errorHandler(ex);
        }
        return text.toString();
    }

    public String readFile(String FileOnDisk) {
        String EntireFile = "";
        try {
            String Line2;
            BufferedReader br = new BufferedReader(new FileReader(FileOnDisk));
            while ((Line2 = br.readLine()) != null) {
                EntireFile = EntireFile + "\n" + Line2;
            }
            br.close();
        }
        catch (IOException ex) {
            Log.level2Information("@fileNotFound " + FileOnDisk);
        }
        EntireFile = EntireFile.replaceFirst("\n", "");
        return EntireFile;
    }

    public String[] listFolderFiles(String folder) {
        File dir = new File(folder);
        if (!dir.isDirectory()) {
            Log.level0Error("@fileNotAFolder");
            return null;
        }
        ArrayList<String> files = new ArrayList<String>();
        File[] list = dir.listFiles();
        for (int x = 0; list.length > x; ++x) {
            files.add(list[x].getName());
        }
        return StringOperations.convertArrayListToStringArray(files);
    }

    public String[] listFolderFilesCannonically(String folder) {
        File dir = new File(folder);
        if (!dir.isDirectory()) {
            Log.level0Error("\"@fileNotAFolder");
            return null;
        }
        String[] childOf = new String[1024];
        File[] list = dir.listFiles();
        for (int x = 0; list.length > x; ++x) {
            try {
                childOf[x] = list[x].getCanonicalFile().toString();
                continue;
            }
            catch (IOException ex) {
                Log.errorHandler(ex);
            }
        }
        return childOf;
    }

    public boolean moveFile(File sourceFile, File destFile) throws IOException {
        FileOperations fO = new FileOperations();
        if (!destFile.getParentFile().exists()) {
            File folder = destFile.getParentFile();
            folder.mkdirs();
        }
        if (destFile.exists()) {
            Log.level3Verbose("Cannot move file.  Destination file is in the way");
            return false;
        }
        Log.level4Debug("moving " + sourceFile.getAbsolutePath() + " to " + destFile.getAbsolutePath());
        return sourceFile.renameTo(destFile);
    }

    public boolean moveFile(String sourceFile, String destFile) throws IOException {
        FileOperations fo = new FileOperations();
        if (!fo.verifyExists(sourceFile)) {
            Log.level4Debug("[moveFile()] Source doesn't exist");
            return false;
        }
        if (fo.verifyExists(destFile)) {
            fo.deleteFile(destFile);
        }
        if (fo.copyFile(sourceFile, destFile)) {
            if (fo.deleteFile(sourceFile).booleanValue()) {
                Log.level4Debug("[moveFile()]File moved successfully");
                return true;
            }
            Log.level4Debug("[moveFile()]File copied, unable to remove source");
            return false;
        }
        Log.level4Debug("[moveFile()]Unable to copy source to destination");
        return false;
    }
}

