/*
 * Decompiled with CFR 0.152.
 */
package CASUAL;

import CASUAL.CASUALMessageObject;
import CASUAL.Log;
import CASUAL.Shell;
import CASUAL.Statics;
import CASUAL.caspac.Caspac;
import CASUAL.communicationstools.adb.ADBTools;
import CASUAL.crypto.MD5sum;
import CASUAL.iCASUALUI;
import CASUAL.misc.LinkedProperties;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CASUALTools {
    public static final boolean IDEMode = new CASUALTools().getIDEMode();
    public static Thread zipPrep;
    public Runnable GUI = new Runnable(){

        @Override
        public void run() {
            try {
                CASUALTools.setGUIAPI();
                Statics.GUI.setVisible(true);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(CASUALTools.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(CASUALTools.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(CASUALTools.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    };
    public static Runnable updateMD5s;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void md5sumTestScripts() {
        String scriptsPath;
        File folder;
        Statics.setStatus("Setting MD5s");
        Log.level4Debug("\nIDE Mode: Scanning and updating MD5s.\nWe are in " + System.getProperty("user.dir"));
        this.incrementBuildNumber();
        if (this.getIDEMode() && (folder = new File(scriptsPath = System.getProperty("user.dir") + Statics.slash + "SCRIPTS" + Statics.slash)).isDirectory()) {
            for (File fileEntry : folder.listFiles()) {
                if (!fileEntry.toString().endsWith(".meta")) continue;
                InputStream in = null;
                try {
                    String md5;
                    Log.level3Verbose("Verifying meta: " + fileEntry.toString());
                    LinkedProperties prop = new LinkedProperties();
                    in = new FileInputStream(fileEntry);
                    prop.load(in);
                    in.close();
                    int pos = 0;
                    boolean md5Changed = false;
                    while ((md5 = prop.getProperty("Script.MD5[" + pos + "]")) != null) {
                        String entry = "Script.MD5[" + pos + "]";
                        String[] md5File = md5.split("  ");
                        String newMD5 = new MD5sum().md5sum(scriptsPath + md5File[1]);
                        if (!md5.contains(newMD5)) {
                            md5Changed = true;
                            Log.level4Debug("Old MD5: " + md5);
                            Log.level4Debug("New MD5: " + prop.getProperty(entry));
                        }
                        prop.setProperty(entry, newMD5 + "  " + md5File[1]);
                        ++pos;
                    }
                    if (!md5Changed) continue;
                    Log.level4Debug("MD5s for " + fileEntry + " changed. Updating...");
                    FileOutputStream fos = new FileOutputStream(fileEntry);
                    prop.store(fos, null);
                    fos.close();
                }
                catch (FileNotFoundException ex) {
                    Log.errorHandler(ex);
                }
                catch (IOException ex) {
                    Log.errorHandler(ex);
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ex) {
                        Log.errorHandler(ex);
                    }
                }
            }
        }
    }

    private boolean getIDEMode() {
        String className = this.getClass().getName().replace('.', '/');
        String classJar = this.getClass().getResource("/" + className + ".class").toString();
        String path = new File(".").getAbsolutePath();
        boolean isSource = path.contains("src") && path.contains("CASUALcore");
        return classJar.startsWith("file:") && isSource;
    }

    public static void rewriteMD5OnCASPAC(File CASPAC) {
        try {
            Caspac caspac = new Caspac(CASPAC, Statics.getTempFolder(), 0);
            caspac.load();
            caspac.write();
            System.exit(0);
        }
        catch (IOException ex) {
            Log.errorHandler(ex);
        }
    }

    private void incrementBuildNumber() throws NumberFormatException {
        Properties prop = new Properties();
        try {
            if (new File(System.getProperty("user.dir") + "/CASUAL/resources/CASUALApp.properties").exists()) {
                prop.load(new FileInputStream(System.getProperty("user.dir") + "/CASUAL/resources/CASUALApp.properties"));
                int x = Integer.parseInt(prop.getProperty("Application.buildnumber").replace(",", ""));
                prop.setProperty("Application.buildnumber", Integer.toString(++x));
                prop.setProperty("Application.buildnumber", Integer.toString(x));
                prop.store(new FileOutputStream(System.getProperty("user.dir") + "/CASUAL/resources/CASUALApp.properties"), "Application.buildnumber=" + x);
            }
        }
        catch (IOException ex) {
            Log.errorHandler(ex);
        }
    }

    public static void sleepForOneSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            Log.errorHandler(ex);
        }
    }

    public static void sleepForOneTenthOfASecond() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            Log.errorHandler(ex);
        }
    }

    public static int getSVNVersion() {
        return Integer.parseInt(ResourceBundle.getBundle("CASUAL/resources/CASUALApp").getString("Application.revision"));
    }

    private static void setiCASUALinteraction(Class<?> cls) throws InstantiationException, IllegalAccessException {
        if (!GraphicsEnvironment.isHeadless()) {
            iCASUALUI clsInstance;
            Statics.GUI = clsInstance = (iCASUALUI)cls.newInstance();
        }
    }

    public static void setGUIAPI() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String messageAPI = ResourceBundle.getBundle("CASUAL/resources/CASUALApp").getString("Application.GUI");
        try {
            Class<?> cls = Class.forName(messageAPI);
            CASUALTools.setiCASUALGUI(cls);
        }
        catch (ClassNotFoundException ex) {
            Class<?> cls = Class.forName("GUI.development.CASUALGUIMain");
            CASUALTools.setiCASUALGUI(cls);
        }
        catch (InstantiationException ex) {
            Class<?> cls = Class.forName("GUI.development.CASUALGUIMain");
            CASUALTools.setiCASUALGUI(cls);
        }
        catch (IllegalAccessException ex) {
            Class<?> cls = Class.forName("GUI.development.CASUALGUIMain");
            CASUALTools.setiCASUALGUI(cls);
        }
    }

    private static void setiCASUALGUI(Class<?> cls) throws InstantiationException, IllegalAccessException {
        iCASUALUI clsInstance;
        Statics.GUI = clsInstance = (iCASUALUI)cls.newInstance();
    }

    public static boolean uidMatches(String expectedUID) {
        String[] cmd = new String[]{new ADBTools().getBinaryLocation(), "shell", "id -u"};
        String retval = new Shell().silentShellCommand(cmd);
        return retval.contains(expectedUID);
    }

    public static String rootAccessCommand() {
        if (CASUALTools.uidMatches("uid=0(")) {
            return "";
        }
        if (CASUALTools.uidMatches("2000")) {
            String retval = new Shell().silentShellCommand(new String[]{new ADBTools().getBinaryLocation(), "shell", "su -c 'id -u'"});
            if (retval.contains("uid=0(")) {
                return "su -c ";
            }
            return "";
        }
        new CASUALMessageObject("@couldNotObtainRootOnDevice").showErrorDialog();
        return "";
    }

    static {
        updateMD5s = new Runnable(){

            @Override
            public void run() {
                new CASUALTools().md5sumTestScripts();
            }
        };
    }
}

