/*
 * Decompiled with CFR 0.152.
 */
package CASUAL;

import CASUAL.CASUALMain;
import CASUAL.Log;
import CASUAL.Statics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Arrays;

public class CASUALTest {
    static String[] args;
    public static boolean shutdown;
    int BUFFER = 4096;
    PipedOutputStream writeToCASUAL;
    PipedInputStream toAppPipedInputStream;
    BufferedReader readFromCASUAL;
    PipedOutputStream fromAppPipedOutputStream;
    PipedInputStream fromAppPipedInputStream;
    final String[] valuesWeDontWantToSee;
    boolean[] badChecks;
    final String[] valuesWeWantToSee;
    private boolean[] goodChecks;
    StringBuilder sb = new StringBuilder();
    public Runnable readReactToCASUAL = new Runnable(){

        @Override
        public void run() {
            while (!shutdown) {
                try {
                    String line;
                    while ((line = CASUALTest.this.readFromCASUAL.readLine()) != null) {
                        CASUALTest.this.sb.append(line + "\n");
                        this.doCasualOuputHandling(line);
                        if (!line.contains("[DEBUG]Shutting Down")) continue;
                    }
                    if (line.contains("[DEBUG]Shutting Down")) break;
                    this.doQuarterSecondSleep();
                }
                catch (Exception ex) {
                    Log.level4Debug(ex.getLocalizedMessage());
                }
            }
        }

        private void doCasualOuputHandling(String line) {
            try {
                CASUALTest.this.validateLine(line);
                if (line.contains("ERROR")) {
                    Log.level4Debug(line);
                } else if (line.contains("[INPUT][ANY]")) {
                    Log.level4Debug(line);
                    CASUALTest.this.writeToCASUAL.write(13);
                } else if (line.contains("[USERTASK][Q or RETURN][CRITICAL]")) {
                    CASUALTest.this.writeToCASUAL.write(13);
                } else if (line.contains("[CANCELOPTION][Q or RETURN]")) {
                    CASUALTest.this.writeToCASUAL.write(13);
                } else if (line.contains("[INTERACTION][NOTIFICATION][RETURN]")) {
                    CASUALTest.this.writeToCASUAL.write(13);
                } else if (line.contains("[RETURN]")) {
                    CASUALTest.this.writeToCASUAL.write(13);
                } else if (line.contains("[INFOMESSAGE][RETURN]")) {
                    CASUALTest.this.writeToCASUAL.write(13);
                } else if (line.contains("[ERRORMESSAGE][RETURN]")) {
                    CASUALTest.this.writeToCASUAL.write(13);
                } else if (line.contains("[INTERACTION][CANCELOPTION][Q or RETURN]")) {
                    CASUALTest.this.writeToCASUAL.write(13);
                } else if (line.contains("[INTERACTION][ACTIONREQUIRED][Q or RETURN]")) {
                    CASUALTest.this.writeToCASUAL.write(13);
                }
            }
            catch (IOException ex) {
                Log.errorHandler(ex);
            }
        }

        private void doQuarterSecondSleep() {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };
    Runnable launchCASUAL = new Runnable(){

        @Override
        public void run() {
            CASUALMain.beginCASUAL(args);
            shutdown = true;
            CASUALMain.shutdown(0);
            shutdown = false;
        }
    };

    public CASUALTest() {
        this.valuesWeWantToSee = new String[]{""};
        this.goodChecks = new boolean[this.valuesWeWantToSee.length];
        Arrays.fill(this.goodChecks, Boolean.FALSE);
        this.valuesWeDontWantToSee = new String[0];
        this.badChecks = new boolean[this.valuesWeDontWantToSee.length];
        Arrays.fill(this.badChecks, Boolean.FALSE);
        try {
            this.fromAppPipedInputStream = new PipedInputStream(this.BUFFER);
            this.fromAppPipedOutputStream = new PipedOutputStream(this.fromAppPipedInputStream);
            this.readFromCASUAL = new BufferedReader(new InputStreamReader(this.fromAppPipedInputStream));
            Log.out = new PrintStream(this.fromAppPipedOutputStream);
            this.toAppPipedInputStream = new PipedInputStream(this.BUFFER);
            this.writeToCASUAL = new PipedOutputStream(this.toAppPipedInputStream);
            Statics.in = new BufferedReader(new InputStreamReader(this.toAppPipedInputStream));
        }
        catch (IOException ex) {
            Log.errorHandler(ex);
        }
    }

    public CASUALTest(String[] CASUALLaunchCommand, String[] valuesToCheckDuringRun, String[] valuesWeDontWantToSee) {
        this.valuesWeWantToSee = valuesToCheckDuringRun;
        this.goodChecks = new boolean[this.valuesWeWantToSee.length];
        Arrays.fill(this.goodChecks, Boolean.FALSE);
        this.valuesWeDontWantToSee = valuesWeDontWantToSee;
        this.badChecks = new boolean[valuesWeDontWantToSee.length];
        Arrays.fill(this.badChecks, Boolean.FALSE);
        try {
            this.fromAppPipedInputStream = new PipedInputStream(this.BUFFER);
            this.fromAppPipedOutputStream = new PipedOutputStream(this.fromAppPipedInputStream);
            this.readFromCASUAL = new BufferedReader(new InputStreamReader(this.fromAppPipedInputStream));
            Log.out = new PrintStream(this.fromAppPipedOutputStream);
            this.toAppPipedInputStream = new PipedInputStream(this.BUFFER);
            this.writeToCASUAL = new PipedOutputStream(this.toAppPipedInputStream);
            Statics.in = new BufferedReader(new InputStreamReader(this.toAppPipedInputStream));
        }
        catch (IOException ex) {
            Log.errorHandler(ex);
        }
        args = CASUALLaunchCommand;
    }

    private void instantiateCASUAL() {
        Thread launch = new Thread(this.launchCASUAL);
        launch.setName("CASUALMain");
        launch.start();
        Thread read = new Thread(this.readReactToCASUAL);
        read.setName("Reading and reacting to CASUAL");
        read.start();
        try {
            launch.join();
        }
        catch (InterruptedException ex) {
            Log.errorHandler(ex);
        }
    }

    private void validateLine(String line) {
        int i;
        for (i = 0; i < this.valuesWeWantToSee.length; ++i) {
            if (!line.contains(this.valuesWeWantToSee[i])) continue;
            this.goodChecks[i] = true;
        }
        for (i = 0; i < this.valuesWeDontWantToSee.length; ++i) {
            if (!line.contains(this.valuesWeDontWantToSee[i])) continue;
            this.badChecks[i] = true;
        }
    }

    public boolean checkTestPoints() {
        this.instantiateCASUAL();
        if (this.goodChecks != null && this.goodChecks.length > 0) {
            for (boolean check : this.goodChecks) {
                if (check) continue;
                return false;
            }
        }
        if (this.badChecks != null && this.badChecks.length > 0) {
            for (boolean check : this.badChecks) {
                if (!check) continue;
                return false;
            }
        }
        return true;
    }

    static {
        shutdown = false;
    }
}

