/*
 * Decompiled with CFR 0.152.
 */
package CASUAL;

import CASUAL.AudioHandler;
import CASUAL.Log;
import CASUAL.Statics;
import java.io.File;

public class CASUALSettings {
    private CASUALMode CASPACType = CASUALMode.CASUAL;
    private File caspacLocation;
    private boolean useGUI = false;
    private boolean execute = false;
    private String executeCommand = "";
    private String password = "";
    private MonitorMode monitor = MonitorMode.ADB;

    private void reset() {
        this.CASPACType = CASUALMode.CASUAL;
        this.caspacLocation = null;
        this.useGUI = false;
        this.execute = false;
        this.executeCommand = "";
        this.password = "";
    }

    private void setDefaultCASUALOperation() {
        this.useGUI = true;
    }

    public void checkArguments(String[] args) {
        this.reset();
        if (args == null || args.length == 0) {
            this.setDefaultCASUALOperation();
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (this.CASPACType.equals((Object)CASUALMode.EXIT)) {
                return;
            }
            try {
                String check = this.lower(args[i]);
                if (check.equals("help") || check.equals("h") || check.equals("?")) {
                    this.argReaction(ArgOptions.HELP, "");
                    continue;
                }
                if (check.equals("license")) {
                    this.argReaction(ArgOptions.LICENSE, "");
                    continue;
                }
                if (check.equals("gui") || check.equals("g")) {
                    this.argReaction(ArgOptions.GUI, "");
                    continue;
                }
                if (check.equals("nosound")) {
                    this.argReaction(ArgOptions.NOSOUND, "");
                    continue;
                }
                if (check.equals("adb")) {
                    this.monitor = MonitorMode.ADB;
                    continue;
                }
                if (check.equals("heimdall")) {
                    this.monitor = MonitorMode.HEIMDALL;
                    continue;
                }
                if (check.equals("fastboot")) {
                    this.monitor = MonitorMode.FASTBOOT;
                    continue;
                }
                if (check.equals("temp") || check.equals("t")) {
                    this.argReaction(ArgOptions.TEMP, this.getNextArg(++i, args));
                    continue;
                }
                if (check.equals("password") || check.equals("p")) {
                    this.argReaction(ArgOptions.PASSWORD, this.getNextArg(++i, args));
                    continue;
                }
                if (check.equals("caspac") || check.equals("c")) {
                    this.argReaction(ArgOptions.CASPAC, this.getNextArg(++i, args));
                    continue;
                }
                if (check.equals("execute") || check.equals("e")) {
                    this.argReaction(ArgOptions.EXECUTE, this.getNextArg(++i, args));
                    continue;
                }
                this.argReaction(ArgOptions.INVALID, this.getNextArg(i++, args));
                continue;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                this.argRequiresParameterExit(args, i);
            }
        }
    }

    private String getNextArg(int i, String[] args) {
        if (args[i] == null || args[i].startsWith("-")) {
            this.argRequiresParameterExit(args, i);
        }
        return args[i];
    }

    private void argRequiresParameterExit(String[] args, int i) {
        Log.level0Error("Argument " + args[i - 1] + " requires a parameter");
        this.showHelpMessageAndExit();
    }

    private void argReaction(ArgOptions action, String arg) {
        switch (action) {
            case HELP: {
                this.showHelpMessageAndExit();
                break;
            }
            case LICENSE: {
                this.showLicenseAndExit();
                break;
            }
            case TEMP: {
                this.setTempFolder(arg);
                break;
            }
            case PASSWORD: {
                this.setPassword(arg);
                break;
            }
            case CASPAC: {
                this.setCASPACMode(arg);
                break;
            }
            case GUI: {
                this.setUseGUI(true);
                break;
            }
            case NOSOUND: {
                AudioHandler.useSound = false;
                break;
            }
            case EXECUTE: {
                this.setupExecuteMode(arg);
                break;
            }
            default: {
                Log.level0Error("Invalid Option: " + arg);
                this.showHelpMessageAndExit();
            }
        }
    }

    private void setupExecuteMode(String arg) {
        this.setCASPACType(CASUALMode.EXECUTE);
        this.setExecute(true);
        this.setExecuteCommand(arg);
    }

    private void setCASPACMode(String arg) {
        this.setCaspacLocation(new File(arg));
        if (!this.caspacLocation.isFile()) {
            Log.level0Error("ERROR: CASPAC Not Found Please spcify a valid CASPAC");
            this.setCASPACType(CASUALMode.EXIT);
        } else {
            this.setCASPACType(CASUALMode.CASPAC);
            Log.level4Debug("Setting CASPAC location to " + this.getCaspacLocation().getAbsolutePath());
        }
    }

    public MonitorMode getMonitorMode() {
        return this.monitor;
    }

    public CASUALMode getCASPACType() {
        return this.CASPACType;
    }

    public void setCASPACType(CASUALMode CASPACType) {
        this.CASPACType = CASPACType;
    }

    public File getCaspacLocation() {
        return this.caspacLocation;
    }

    public void setCaspacLocation(File caspacLocation) {
        this.caspacLocation = caspacLocation;
    }

    public boolean isUseGUI() {
        return this.useGUI;
    }

    public void setUseGUI(boolean useGUI) {
        this.useGUI = useGUI;
    }

    public boolean isExecute() {
        return this.execute;
    }

    public void setExecute(boolean execute) {
        this.execute = execute;
    }

    public String getExecuteCommand() {
        return this.executeCommand;
    }

    public void setExecuteCommand(String executeCommand) {
        this.executeCommand = executeCommand;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    void setTempFolder(String tempFolder) {
        Statics.setTempFolder(tempFolder);
    }

    private void showLicenseAndExit() {
        Log.level2Information("\n    This program is free software: you can redistribute it and/or modify\n    it under the terms of the GNU General Public License as published by\n    the Free Software Foundation, either version 3 of the License, or\n    (at your option) any later version.\n\n    This program is distributed in the hope that it will be useful,\n    but WITHOUT ANY WARRANTY; without even the implied warranty of\n    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n    GNU General Public License for more details.");
        this.setCASPACType(CASUALMode.EXIT);
    }

    private void showHelpMessageAndExit() {
        Log.level2Information("\n Usage: casual.jar [optional parameters]\n without arguments - Launch the GUI\n [--help] shows this message and exits\n [--license] -shows license and exits\n [--execute/-e \"command\"]-executes any CASUAL command and exits. Launch CASUAL GUI to read about commands [--caspac/-c path_to" + Statics.slash + "CASPACzip] -launches CASUAL with a CASPAC" + " [--gui/-g)] - performs actions with a GUI\n");
        this.setCASPACType(CASUALMode.EXIT);
    }

    private String lower(String arg) {
        return arg.toLowerCase().replace("-", "");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String n = "\n";
        sb.append("Type:").append((Object)this.CASPACType).append(n);
        sb.append("Monitor:").append((Object)this.monitor).append(n);
        sb.append("UseGUI:").append(this.useGUI).append(n);
        sb.append("executeMode:").append(this.execute).append(n);
        sb.append("executeCommand:").append(this.executeCommand).append(n);
        sb.append("password:").append(this.password).append(n);
        sb.append("CASPACLocation:").append(this.caspacLocation).append(n);
        return sb.toString();
    }

    public static enum MonitorMode {
        ADB,
        HEIMDALL,
        FASTBOOT;

    }

    public static enum CASUALMode {
        CASUAL,
        CASPAC,
        EXECUTE,
        EXIT;

    }

    public static enum ArgOptions {
        HELP,
        LICENSE,
        TEMP,
        PASSWORD,
        CASPAC,
        GUI,
        NOSOUND,
        EXECUTE,
        INVALID;

    }
}

