/*
 * Decompiled with CFR 0.152.
 */
package CASUAL;

import CASUAL.CASUALConnectionStatusMonitor;
import CASUAL.CASUALLanguage;
import CASUAL.CASUALStartupTasks;
import CASUAL.Log;
import CASUAL.Statics;
import CASUAL.caspac.Caspac;
import CASUAL.caspac.Script;
import CASUAL.misc.CountLines;
import CASUAL.misc.MandatoryThread;
import CASUAL.misc.StringOperations;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CASUALScriptParser {
    static Caspac oneShotCaspac;
    int LinesInScript = 0;
    String ScriptTempFolder = "";
    String ScriptName = "";
    DataInputStream scriptInput;

    public void loadFileAndExecute(Caspac caspac, boolean multiThreaded) {
        Statics.setStatus("Loading from file");
        this.executeSelectedScript(caspac, multiThreaded);
    }

    private DataInputStream getDataStreamFromFile(Caspac caspac) {
        try {
            Log.level4Debug("Selected file" + caspac.getActiveScript().name);
            this.ScriptName = caspac.getActiveScript().name;
            this.ScriptTempFolder = caspac.getActiveScript().tempDir;
            this.LinesInScript = new CountLines().countISLines(caspac.getActiveScript().getScriptContents());
            Log.level4Debug("Lines in Script " + this.LinesInScript);
            return new DataInputStream(caspac.getActiveScript().getScriptContents());
        }
        catch (FileNotFoundException ex) {
            Log.errorHandler(ex);
            return null;
        }
        catch (IOException ex) {
            Log.errorHandler(ex);
            return null;
        }
    }

    public String executeOneShotCommand(String Line2) {
        Statics.setStatus("Executing");
        String retvalue = "";
        if (Statics.CASPAC == null) {
            this.ScriptName = "oneShot";
            this.ScriptTempFolder = Statics.getTempFolder();
        }
        try {
            if (Line2.contains(";;;")) {
                String[] lineArray;
                for (String linesplit : lineArray = Line2.split(";;;")) {
                    retvalue = retvalue + new CASUALLanguage(this.ScriptName, this.ScriptTempFolder).commandHandler(linesplit) + "\n";
                }
            } else {
                retvalue = new CASUALLanguage(this.ScriptName, this.ScriptTempFolder).commandHandler(Line2);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CASUALScriptParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        return retvalue;
    }

    public void executeSelectedScript(final Caspac caspac, boolean startThreaded) {
        Statics.ReactionEvents = new ArrayList();
        Statics.ActionEvents = new ArrayList();
        Statics.CASPAC.getActiveScript().scriptContinue = true;
        this.scriptInput = new DataInputStream(StringOperations.convertStringToStream(caspac.getActiveScript().scriptContents));
        Log.level4Debug("Executing Scripted Datastream" + this.scriptInput.toString());
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Log.level4Debug("CASUAL has initiated a multithreaded execution environment");
                if (Statics.isGUIIsAvailable()) {
                    Statics.GUI.setProgressBarMax(CASUALScriptParser.this.LinesInScript);
                }
                Log.level4Debug("Reading datastream" + CASUALScriptParser.this.scriptInput);
                new CASUALLanguage(caspac, caspac.getActiveScript().tempDir).beginScriptingHandler(CASUALScriptParser.this.scriptInput);
                if (Statics.isGUIIsAvailable()) {
                    CASUALConnectionStatusMonitor.resumeAfterStop();
                } else {
                    CASUALConnectionStatusMonitor.stop();
                }
                try {
                    CASUALScriptParser.this.scriptInput.close();
                }
                catch (IOException ex) {
                    Log.errorHandler(ex);
                }
                Statics.CASPAC.getActiveScript().deviceArch = "";
                Statics.setStatus("done");
                Log.level2Information("@scriptComplete");
            }
        };
        if (startThreaded) {
            CASUALStartupTasks.scriptRunLock = new MandatoryThread(r);
            Statics.setStatus("Executing");
            CASUALStartupTasks.scriptRunLock.setName("CASUAL Script Executor");
            CASUALStartupTasks.scriptRunLock.start();
        } else {
            r.run();
        }
    }

    void executeActiveScript(Caspac CASPAC) {
        Log.level3Verbose("Exection of active script in CASPAC Commensing");
        Script s = CASPAC.getActiveScript();
        Statics.CASPAC.getActiveScript().scriptContinue = true;
        Log.level2Information(s.discription);
        int CASUALSVN = Integer.parseInt(ResourceBundle.getBundle("CASUAL/resources/CASUALApp").getString("Application.revision"));
        int scriptSVN = Integer.parseInt(s.metaData.minSVNversion);
        if (CASUALSVN < scriptSVN) {
            Log.level0Error("@improperCASUALversion");
            return;
        }
        try {
            ByteArrayInputStream scriptStream = new ByteArrayInputStream(s.scriptContents.getBytes("UTF-8"));
            DataInputStream dis = new DataInputStream(scriptStream);
            CASPAC.setActiveScript(s);
            new CASUALLanguage(CASPAC, s.tempDir).beginScriptingHandler(dis);
        }
        catch (UnsupportedEncodingException ex) {
            Log.errorHandler(ex);
        }
    }

    void executeFirstScriptInCASPAC(Caspac CASPAC) {
        String scriptName = CASPAC.getScriptNames()[0];
        Script s = CASPAC.getScriptByName(scriptName);
        CASPAC.setActiveScript(s);
        this.executeActiveScript(CASPAC);
    }
}

