/*
 * Decompiled with CFR 0.152.
 */
package CASUAL;

import CASUAL.Log;
import CASUAL.Statics;
import CASUAL.Translations;
import CASUAL.iCASUALUI;
import CASUAL.instrumentation.Instrumentation;
import java.awt.Component;
import java.awt.HeadlessException;
import java.util.Arrays;

public class CASUALMessageObject {
    public String originalMessage = "";
    public String expectedReturn = "";
    public String title;
    public String messageText;
    public iCASUALUI.MessageCategory category;
    public int timeoutOptionType;
    public Object timeoutInitialValue;
    public Object[] timeoutOptions;
    public int timeoutPresetTime;
    public int timeoutMessageType;

    public CASUALMessageObject(String messageInput) {
        if (messageInput.startsWith("@")) {
            String translation = Translations.get(messageInput);
            if (translation.contains(">>>")) {
                this.originalMessage = messageInput;
                String[] s = translation.split(">>>", 2);
                this.title = s[0];
                this.messageText = s[1];
            } else {
                this.title = null;
                this.messageText = translation;
            }
        } else if (messageInput.contains(">>>")) {
            this.originalMessage = messageInput;
            String[] s = messageInput.split(">>>", 2);
            this.title = s[0];
            this.messageText = s[1];
        } else {
            this.title = null;
            this.messageText = messageInput;
        }
        Instrumentation.updateStatus("-New Message:" + this.title + " " + this.messageText);
    }

    public CASUALMessageObject(String title, String messageInput) {
        this.title = title;
        this.messageText = messageInput;
    }

    public synchronized int showTimeoutDialog(int PRESET_TIME, Component parentComponent, int optionType, int timeOutMessageType, Object[] options, Object initialValue) {
        this.timeoutOptionType = optionType;
        this.timeoutMessageType = timeOutMessageType;
        this.timeoutOptions = options;
        this.timeoutInitialValue = initialValue;
        this.timeoutPresetTime = PRESET_TIME;
        this.setType(iCASUALUI.MessageCategory.TIMEOUT);
        this.expectedReturn = "(String)int from " + Arrays.asList(options).toString();
        if (Statics.GUI == null) {
            return 0;
        }
        return Integer.parseInt(Statics.GUI.displayMessage(this));
    }

    public String inputDialog() throws HeadlessException {
        this.setType(iCASUALUI.MessageCategory.TEXTINPUT);
        this.expectedReturn = "Any String";
        return Statics.GUI.displayMessage(this);
    }

    public int showActionRequiredDialog() throws HeadlessException {
        this.setType(iCASUALUI.MessageCategory.ACTIONREQUIRED);
        this.expectedReturn = "String 0-continue, 1-stop";
        return Integer.parseInt(Statics.GUI.displayMessage(this));
    }

    public int showUserCancelOption() {
        this.setType(iCASUALUI.MessageCategory.USERCANCELOPTION);
        this.expectedReturn = "String 0-continue, 1-stop";
        return Integer.parseInt(Statics.GUI.displayMessage(this));
    }

    public void showCommandNotification() throws HeadlessException {
        this.setType(iCASUALUI.MessageCategory.COMMANDNOTIFICATION);
        this.expectedReturn = "Empty";
        Statics.GUI.displayMessage(this);
    }

    public void showUserNotification() throws HeadlessException {
        this.setType(iCASUALUI.MessageCategory.USERNOTIFICATION);
        this.expectedReturn = "Empty";
        Statics.GUI.displayMessage(this);
    }

    public void showInformationMessage() throws HeadlessException {
        this.setType(iCASUALUI.MessageCategory.SHOWINFORMATION);
        this.expectedReturn = "Empty";
        Log.level3Verbose("showing information message object");
        Statics.GUI.displayMessage(this);
        Log.level3Verbose("Done with message object");
    }

    public void showErrorDialog() throws HeadlessException {
        this.setType(iCASUALUI.MessageCategory.SHOWERROR);
        this.expectedReturn = "Empty";
        Statics.GUI.displayMessage(this);
    }

    public boolean showYesNoOption() {
        this.setType(iCASUALUI.MessageCategory.SHOWYESNO);
        Boolean retval = Statics.GUI.displayMessage(this).equals("0");
        this.expectedReturn = "String 0-yes, 1-no";
        return retval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String n = "\n";
        sb.append("[").append((Object)this.category).append("] Title:").append(this.title).append(n);
        sb.append("Message:").append(this.messageText.replace("\n", "\\\\n")).append(n);
        sb.append("press: ").append(this.expectedReturn).append(n);
        return sb.toString();
    }

    private int setType(iCASUALUI.MessageCategory cat) {
        this.category = cat;
        return this.getMessageType();
    }

    public int getMessageType() {
        return this.category.compareTo(iCASUALUI.MessageCategory.TIMEOUT);
    }
}

