/*
 * Decompiled with CFR 0.152.
 */
package CASUAL;

import CASUAL.AudioHandler;
import CASUAL.CASUALConnectionStatusMonitor;
import CASUAL.CASUALScriptParser;
import CASUAL.CASUALSettings;
import CASUAL.CASUALStartupTasks;
import CASUAL.CASUALTools;
import CASUAL.FileOperations;
import CASUAL.Log;
import CASUAL.Statics;
import CASUAL.caspac.Caspac;
import CASUAL.communicationstools.adb.ADBTools;
import CASUAL.communicationstools.fastboot.FastbootTools;
import CASUAL.communicationstools.heimdall.HeimdallTools;
import CASUAL.misc.MandatoryThread;
import CASUAL.network.Pastebin;
import GUI.CommandLine.CommandLineUI;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.CodeSource;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;

public final class CASUALMain {
    boolean exitWhenDone = false;
    public static final String defaultPackage = "TestScript";
    private static final boolean useOverrideArgs = false;
    private static final String[] overrideArguments = new String[]{""};
    CASUALSettings arguments = new CASUALSettings();
    public Runnable setupCASUALCASPAC = new Runnable(){

        @Override
        public void run() {
            if (CASUALMain.this.arguments.getCaspacLocation() != null && CASUALMain.this.arguments.getCaspacLocation().exists()) {
                try {
                    Caspac cp;
                    if (!CASUALMain.this.arguments.getPassword().isEmpty()) {
                        cp = new Caspac(CASUALMain.this.arguments.getCaspacLocation(), Statics.getTempFolder(), 0, CASUALMain.this.arguments.getPassword().toCharArray());
                        CASUALMain.this.arguments.setPassword("");
                    } else {
                        cp = new Caspac(CASUALMain.this.arguments.getCaspacLocation(), Statics.getTempFolder(), 0);
                    }
                    cp.loadFirstScriptFromCASPAC();
                    Statics.CASPAC = cp;
                }
                catch (IOException ex) {
                    Log.errorHandler(ex);
                }
                catch (Exception ex) {
                    Log.errorHandler(ex);
                }
            } else if (!CASUALMain.this.arguments.isExecute()) {
                CodeSource src = this.getClass().getProtectionDomain().getCodeSource();
                try {
                    Caspac cp;
                    Statics.CASPAC = cp = new Caspac(src, Statics.getTempFolder(), 1);
                }
                catch (ZipException ex) {
                    Log.errorHandler(ex);
                }
                catch (IOException ex) {
                    Log.errorHandler(ex);
                }
            }
        }
    };

    public static void main(String[] args) {
        Statics.initializeStatics();
        CASUALMain.beginCASUAL(args);
    }

    public static void beginCASUAL(String[] args) {
        CASUALMain main = new CASUALMain();
        String CASUALFileName = new File(main.getClass().getProtectionDomain().getCodeSource().getLocation().getPath()).toString();
        String CASUALSVNRevision = ResourceBundle.getBundle("CASUAL/resources/CASUALApp").getString("Application.revision");
        String CASUALBuildNumber = ResourceBundle.getBundle("CASUAL/resources/CASUALApp").getString("Application.buildnumber");
        System.out.println("CASUAL Cross-platform Android Scripting and Unified Auxiliary Loader\nRevision:" + CASUALSVNRevision + " build:" + CASUALBuildNumber + "\n" + "    CASUAL  Copyright (C) 2013  Adam Outler\n" + "    This program comes with ABSOLUTELY NO WARRANTY.  This is free software,\n" + "    and you are welcome to redistribute it, under certain conditions; run\n" + "    '" + CASUALFileName + " --license'\n" + "    for details. http://android-casual.googlecode.com for source.\n" + "Logging:" + Statics.getTempFolder() + "\nSystem: " + System.getProperty("os.name"));
        main.arguments.checkArguments(args);
        main.startup();
        System.gc();
    }

    public void startup() {
        CASUALStartupTasks.scriptRunLock.start();
        new FileOperations().makeFolder(Statics.getTempFolder());
        switch (this.arguments.getCASPACType()) {
            case CASUAL: {
                this.startGUI();
                this.commonCASUALCASPACStartupTasks();
                this.waitForGUI();
                Statics.CASPAC.setActiveScript(Statics.CASPAC.getScriptByName(Statics.CASPAC.getScriptNames()[0]));
                try {
                    Statics.CASPAC.loadActiveScript();
                }
                catch (IOException ex) {
                    Logger.getLogger(CASUALMain.class.getName()).log(Level.SEVERE, null, ex);
                }
                Statics.GUI.setCASPAC(Statics.CASPAC);
                CASUALStartupTasks.startADB.waitFor();
                this.startConnectionStatusMonitor();
                return;
            }
            case CASPAC: {
                if (Statics.GUI == null) {
                    Statics.GUI = new CommandLineUI();
                }
                this.commonCASUALCASPACStartupTasks();
                Statics.CASPAC.setActiveScript(Statics.CASPAC.getScriptByName(Statics.CASPAC.getScriptNames()[0]));
                try {
                    Statics.CASPAC.loadActiveScript();
                }
                catch (IOException ex) {
                    Logger.getLogger(CASUALMain.class.getName()).log(Level.SEVERE, null, ex);
                }
                CASUALStartupTasks.caspacPrepLock.waitFor();
                Statics.CASPAC.waitForUnzip();
                CASUALStartupTasks.startADB.waitFor();
                new CASUALScriptParser().executeActiveScript(Statics.CASPAC);
                break;
            }
            case EXECUTE: {
                this.doConsoleStartup(this.arguments.getExecuteCommand());
                break;
            }
            case EXIT: {
                CASUALMain.shutdown(1);
                break;
            }
            default: {
                CASUALMain.shutdown(1);
            }
        }
        CASUALMain.shutdown(0);
    }

    private void waitForGUI() {
        try {
            CASUALStartupTasks.startGUI.join();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(CASUALMain.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void commonCASUALCASPACStartupTasks() {
        CASUALStartupTasks.startADB.start();
        this.prepareCaspac();
        this.setDefaultCASPACScript();
        Statics.setStatus("waiting for CASPAC");
        CASUALStartupTasks.caspacPrepLock.waitFor();
    }

    private void caspacExecute() {
        CASUALConnectionStatusMonitor.stop();
        Statics.CASPAC.startAndWaitForUnzip();
        new CASUALScriptParser().executeActiveScript(Statics.CASPAC);
    }

    private void setDefaultCASPACScript() {
        if (Statics.CASPAC != null && Statics.CASPAC.scripts != null && Statics.CASPAC.scripts.size() >= 1) {
            Log.level4Debug("Finalizing active script up to be run");
            Statics.CASPAC.setActiveScript(Statics.CASPAC.scripts.get(0));
            Statics.CASPAC.getActiveScript().scriptContinue = true;
        }
    }

    private void startGUI() {
        CASUALStartupTasks.startGUI = new MandatoryThread(new CASUALTools().GUI);
        CASUALStartupTasks.startGUI.setName("CASUAL GUI");
        CASUALStartupTasks.startGUI.start();
    }

    public static void shutdown(int i) {
        Log.level4Debug("Shutting Down");
        AudioHandler.useSound = false;
        Log.out.flush();
        if (Statics.CASPAC != null && Statics.CASPAC.getActiveScript() != null) {
            Statics.CASPAC.getActiveScript().scriptContinue = false;
        }
        CASUALConnectionStatusMonitor.stop();
        new ADBTools().shutdown();
        if (!CASUALTools.IDEMode && !Statics.isGUIIsAvailable() && Statics.CASPAC.type != 0) {
            try {
                new Pastebin().pasteAnonymousLog();
            }
            catch (MalformedURLException ex) {
                Log.errorHandler(ex);
            }
        }
        if (Statics.GUI != null) {
            Statics.GUI.dispose();
        }
        CASUALConnectionStatusMonitor.stop();
        Statics.initializeStatics();
    }

    private static void doSleep() {
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(CASUALMain.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void doConsoleStartup(String cmd) {
        CASUALConnectionStatusMonitor.stop();
        CASUALScriptParser csp = new CASUALScriptParser();
        csp.executeOneShotCommand(cmd);
        Log.level2Information("@scriptComplete");
    }

    private void startConnectionStatusMonitor() {
        switch (this.arguments.getMonitorMode()) {
            case ADB: {
                new CASUALConnectionStatusMonitor().start(new ADBTools());
                break;
            }
            case FASTBOOT: {
                new CASUALConnectionStatusMonitor().start(new FastbootTools());
                break;
            }
            case HEIMDALL: {
                new CASUALConnectionStatusMonitor().start(new HeimdallTools());
                break;
            }
            default: {
                new CASUALConnectionStatusMonitor().start(new ADBTools());
            }
        }
    }

    public void prepareCaspac() {
        CASUALStartupTasks.caspacPrepLock = new MandatoryThread(this.setupCASUALCASPAC);
        CASUALStartupTasks.caspacPrepLock.setName("Preparing Scripts");
        CASUALStartupTasks.caspacPrepLock.start();
    }
}

