/*
 * Decompiled with CFR 0.152.
 */
package CASUAL;

import CASUAL.CASUALMessageObject;
import CASUAL.CASUALScriptParser;
import CASUAL.FileOperations;
import CASUAL.Log;
import CASUAL.OSTools;
import CASUAL.Shell;
import CASUAL.ShellTools;
import CASUAL.Statics;
import CASUAL.caspac.Caspac;
import CASUAL.communicationstools.adb.ADBTools;
import CASUAL.communicationstools.adb.busybox.BusyboxTools;
import CASUAL.communicationstools.adb.busybox.CASUALDataBridge;
import CASUAL.communicationstools.fastboot.FastbootTools;
import CASUAL.communicationstools.heimdall.HeimdallTools;
import CASUAL.communicationstools.heimdall.drivers.DriverInstall;
import CASUAL.communicationstools.heimdall.drivers.DriverRemove;
import CASUAL.crypto.MD5sum;
import CASUAL.misc.StringOperations;
import CASUAL.network.CASUALUpdates;
import CASUAL.network.Pastebin;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CASUALLanguage {
    private final String ScriptTempFolder;
    final String CASUALHOME = System.getProperty("user.home") + System.getProperty("file.separator") + ".CASUAL" + System.getProperty("file.separator");
    final Caspac CASPAC;
    private String deviceBuildPropStorage;
    static String GOTO = "";
    int CurrentLine = 1;

    public CASUALLanguage(Caspac caspac, String ScriptTempFolder) {
        this.ScriptTempFolder = ScriptTempFolder;
        this.CASPAC = caspac;
    }

    public CASUALLanguage(String ScriptName, String ScriptTempFolder) {
        this.ScriptTempFolder = ScriptTempFolder;
        this.CASPAC = null;
    }

    public void beginScriptingHandler(DataInputStream dataIn) {
        String strLine = "";
        try {
            BufferedReader bReader = new BufferedReader(new InputStreamReader(dataIn));
            bReader.mark(1);
            while ((strLine = bReader.readLine()) != null) {
                if (!Statics.CASPAC.getActiveScript().scriptContinue) {
                    return;
                }
                ++this.CurrentLine;
                if (Statics.isGUIIsAvailable()) {
                    Statics.GUI.setProgressBar(this.CurrentLine);
                }
                if (!GOTO.equals("")) {
                    bReader.reset();
                    while (!strLine.startsWith(GOTO)) {
                        strLine = bReader.readLine();
                    }
                    GOTO = "";
                }
                if (strLine.contains(";;;")) {
                    String[] lineArray;
                    for (String line : lineArray = strLine.split(";;;")) {
                        this.commandHandler(line);
                    }
                    continue;
                }
                this.commandHandler(strLine);
            }
            dataIn.close();
            if (DriverInstall.removeDriverOnCompletion == 2) {
                Log.level2Information("Removing generic USB driver as requested");
                new DriverRemove().deleteOemInf();
            }
            Log.level2Information("@done");
        }
        catch (Exception e) {
            Log.level0Error("@problemParsingScript");
            Log.level0Error(strLine);
            Log.errorHandler(new RuntimeException("CASUAL scripting error\n   " + strLine, e));
            Log.level0Error("@problemParsingScript");
            Log.level0Error(strLine);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String commandHandler(String line) throws IOException {
        String[] split;
        String removeCommand;
        if ((line = StringOperations.removeLeadingSpaces(line)).equals("")) {
            return "";
        }
        if (line.startsWith("$LINUXMAC")) {
            if (!OSTools.isLinux() && !OSTools.isMac()) return "";
            removeCommand = "$LINUXMAC";
            line = this.processIdentifiedCommand(removeCommand, line);
            Log.progress("Linux Or Mac Detected: ");
            Log.level4Debug("OS IS LINUX or MAC! remaining commands:" + line);
        }
        if (line.startsWith("$LINUXWINDOWS")) {
            if (!OSTools.isLinux() && !OSTools.isWindows()) return "";
            removeCommand = "$LINUXWINDOWS";
            line = this.processIdentifiedCommand(removeCommand, line);
            Log.progress("Windows or Linux Detected: ");
            Log.level4Debug("OS IS WINDOWS OR LINUX! remaining commands:" + line);
        }
        if (line.startsWith("$WINDOWSMAC")) {
            if (!OSTools.isWindows() && !OSTools.isMac()) return "";
            removeCommand = "$WINDOWSMAC";
            line = this.processIdentifiedCommand(removeCommand, line);
            Log.progress("Mac or Windows Detected: ");
            Log.level4Debug("OS IS Windows or Mac! remaining commands:" + line);
        }
        if (line.startsWith("$LINUX")) {
            if (!OSTools.isLinux()) return "";
            removeCommand = "$LINUX";
            line = this.processIdentifiedCommand(removeCommand, line);
            Log.progress("Linux Detected: ");
            Log.level4Debug("OS IS LINUX! remaining commands:" + line);
        }
        if (line.startsWith("$WINDOWS")) {
            if (!OSTools.isWindows()) return "";
            Log.progress("Windows Detected: ");
            removeCommand = "$WINDOWS";
            line = this.processIdentifiedCommand(removeCommand, line);
            Log.level4Debug("OS IS WINDOWS! remaining commands:" + line);
        }
        if (line.startsWith("$MAC")) {
            if (!OSTools.isMac()) return "";
            Log.progress("Mac Detected: ");
            removeCommand = "$MAC";
            line = this.processIdentifiedCommand(removeCommand, line);
            Log.level4Debug("OS IS MAC! remaining commands:" + line);
        }
        if (line.startsWith("$HALT")) {
            if (Statics.CASPAC != null) {
                Statics.CASPAC.getActiveScript().scriptContinue = false;
            }
            line = line.replace("$HALT", "");
            Log.level4Debug("HALT RECEIVED");
            line = StringOperations.removeLeadingSpaces(line);
            Log.level4Debug("Finishing remaining commands:" + line);
        }
        if (line.startsWith("$SENDLOG")) {
            line = line.replace("$SENDLOG", "");
            if (StringOperations.removeLeadingAndTrailingSpaces(line = StringOperations.removeLeadingSpaces(line)).equals("")) {
                Log.level4Debug("Sendlog Command Issued!\nNo remaining commands");
            } else {
                Log.level4Debug("Sendlog Command Issued!\nFinishing remaining commands:" + line);
            }
            try {
                new Pastebin().doPosting();
                return "";
            }
            catch (IOException ex) {
                Log.errorHandler(ex);
                return "";
            }
            catch (URISyntaxException ex) {
                Log.errorHandler(ex);
            }
            return "";
        }
        if (line.startsWith("$GOTO")) {
            line = line.replace("$GOTO", "");
            GOTO = StringOperations.removeLeadingAndTrailingSpaces(line);
            return "";
        }
        if (line.startsWith("$ON")) {
            line = line.replace("$ON", "");
            line = StringOperations.removeLeadingSpaces(line);
            String[] Event = line.split(",");
            try {
                Statics.ActionEvents.add(Event[0]);
                Log.level4Debug("***NEW EVENT ADDED***");
                Log.level4Debug("ON EVENT: " + Event[0]);
                Statics.ReactionEvents.add(Event[1]);
                Log.level4Debug("PERFORM ACTION: " + Event[1]);
                return "";
            }
            catch (Exception e) {
                Log.errorHandler(e);
            }
            return "";
        }
        if (line.startsWith("$CLEARON")) {
            Statics.ActionEvents = new ArrayList();
            Statics.ReactionEvents = new ArrayList();
            Log.level4Debug("***$CLEARON RECEIVED. CLEARING ALL LOGGING EVENTS.***");
            return "";
        }
        if (line.startsWith("#")) {
            Log.level4Debug("Ignoring commented line" + line);
            return "";
        }
        if (line.equals("")) {
            return "";
        }
        Log.level4Debug("SCRIPT COMMAND:" + line);
        if (line.startsWith("$IFCONTAINS ")) {
            line = StringOperations.removeLeadingSpaces(line.replaceFirst("$IFCONTAINS ", ""));
            return this.doIfContainsReturnResults(line, true);
        }
        if (line.startsWith("$IFNOTCONTAINS ")) {
            line = StringOperations.removeLeadingSpaces(line.replaceFirst("$IFCONTAINS ", ""));
            return this.doIfContainsReturnResults(line, false);
        }
        if (line.startsWith("$SLEEP")) {
            int sleeptime;
            Log.level3Verbose("detected sleep command: " + line);
            line = line.replace("$SLEEP", "").trim();
            if (line.startsWith("MILLIS")) {
                line = line.replace("MILLIS", "").trim();
                sleeptime = Integer.parseInt(line);
            } else {
                sleeptime = Integer.parseInt(line) * 1000;
            }
            if (Integer.parseInt(line) < 0) {
                throw new RuntimeException();
            }
            try {
                Log.level2Information("sleeping for " + sleeptime / 1000 + " seconds");
                Thread.sleep(sleeptime);
                return line;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            return line;
        }
        if (line.contains("$BUSYBOX")) {
            line = line.replace("$BUSYBOX", BusyboxTools.getBusyboxLocation());
            Log.level4Debug("Expanded $BUSYBOX: " + line);
        }
        if (line.contains("$SLASH")) {
            line = line.replace("$SLASH", Statics.slash);
            Log.level4Debug("Expanded $SLASH: " + line);
        }
        if (line.contains("$ZIPFILE")) {
            if (!this.verifyZIPFILEReferencesExist(line)) {
                return "";
            }
            line = line.replace("$ZIPFILE", this.ScriptTempFolder);
            Log.level4Debug("Expanded $ZIPFILE: " + line);
        }
        if (line.contains("\\n") && (line.startsWith("$USERNOTIFICATION") || line.startsWith("$USERNOTIFICATION") || line.startsWith("$USERCANCELOPTION"))) {
            line = line.replace("\\n", "\n");
        }
        if (line.contains("$HOMEFOLDER")) {
            if (!new FileOperations().verifyExists(this.CASUALHOME)) {
                new FileOperations().makeFolder(this.CASUALHOME);
            }
            line = line.replace("$HOMEFOLDER", this.CASUALHOME);
            Log.level4Debug("Expanded $HOMEFOLDER" + line);
        }
        if (line.startsWith("$ECHO")) {
            Log.level4Debug("Received ECHO command" + line);
            line = line.replace("$ECHO", "");
            line = StringOperations.removeLeadingSpaces(line);
            Log.level2Information(line);
            return line;
        }
        if (line.startsWith("$LISTDIR")) {
            line = line.replace("$LISTDIR", "");
            line = StringOperations.removeLeadingSpaces(line);
            if (!OSTools.isLinux() && !OSTools.isMac()) {
                line = line.replace("/", Statics.slash);
            }
            File[] files = new File(line).listFiles();
            String retval = "";
            if (files == null || files.length <= 0) return retval;
            for (File file : files) {
                retval = retval + file.getAbsolutePath() + "\n";
                try {
                    this.commandHandler("shell \"echo " + file.getCanonicalPath() + "\"");
                }
                catch (IOException ex) {
                    Log.errorHandler(ex);
                }
            }
            return retval;
        }
        if (line.startsWith("$MAKEDIR")) {
            line = line.replace("$MAKEDIR", "");
            line = StringOperations.removeLeadingSpaces(line);
            Log.level4Debug("Creating Folder: " + line);
            new File(line).mkdirs();
            return line;
        }
        if (line.startsWith("$REMOVEDIR")) {
            line = line.replace("$REMOVEDIR", "");
            line = StringOperations.removeLeadingSpaces(line);
            Log.level4Debug("Creating Folder: " + line);
            new FileOperations().recursiveDelete(line);
            return line;
        }
        if (line.startsWith("$COMMANDNOTIFICATION")) {
            line = line.replace("$COMMANDNOTIFICATION", "").trim();
            String title = "Return Value";
            String retval = this.commandHandler(line);
            new CASUALMessageObject(title + ">>>" + retval).showCommandNotification();
            return retval;
        }
        if (line.startsWith("$USERNOTIFICATION")) {
            line = line.replace("$USERNOTIFICATION", "");
            new CASUALMessageObject(line.replaceFirst(",", ">>>")).showUserNotification();
            return "";
        }
        if (line.startsWith("$USERCANCELOPTION")) {
            int n = new CASUALMessageObject((line = StringOperations.removeLeadingSpaces(line.replace("$USERCANCELOPTION", ""))).replaceFirst(",", ">>>")).showUserCancelOption();
            if (n != 1) return "";
            Log.level0Error(this.CASPAC.getActiveScript().name);
            Log.level0Error("@canceledAtUserRequest");
            Statics.CASPAC.getActiveScript().scriptContinue = false;
            return "";
        }
        if (line.startsWith("$ACTIONREQUIRED")) {
            int n = new CASUALMessageObject((line = StringOperations.removeLeadingSpaces(line.replace("$ACTIONREQUIRED", ""))).replaceFirst(",", ">>>")).showActionRequiredDialog();
            if (n != 1) return "";
            Log.level0Error(this.CASPAC.getActiveScript().name);
            Log.level0Error("@haltedPerformActions");
            Statics.CASPAC.getActiveScript().scriptContinue = false;
            return "";
        }
        if (line.startsWith("$USERINPUTBOX")) {
            String[] Message = line.replace("$USERINPUTBOX", "").split(",", 3);
            String inputBoxText = new CASUALMessageObject(Message[0] + ">>>" + Message[1]).inputDialog();
            if (inputBoxText == null) {
                inputBoxText = "";
            }
            inputBoxText = this.returnSafeCharacters(inputBoxText);
            Log.level4Debug(inputBoxText);
            String command = Message[2].replace("$USERINPUT", inputBoxText);
            this.commandHandler(command);
            return "";
        }
        if (line.startsWith("$DOWNLOAD")) {
            line = line.replace("$DOWNLOAD", "");
            line = StringOperations.removeLeadingSpaces(line);
            String[] downloadCommand = line.split(",");
            for (int i = 0; i < downloadCommand.length; ++i) {
                downloadCommand[i] = downloadCommand[i].trim();
            }
            FileOperations fo = new FileOperations();
            Log.level4Debug("Downloading " + downloadCommand[2]);
            Log.level4Debug("From " + downloadCommand[0]);
            Log.level4Debug("to " + downloadCommand[1]);
            if (!new File(downloadCommand[1]).getParentFile().exists()) {
                new File(downloadCommand[1]).getParentFile().mkdirs();
            }
            if (downloadCommand.length == 3) {
                new CASUALUpdates().downloadFileFromInternet(downloadCommand[0], downloadCommand[1], downloadCommand[2]);
                return downloadCommand[1];
            }
            if (downloadCommand.length == 4) {
                new CASUALUpdates().downloadFileFromInternet(downloadCommand[0], downloadCommand[1], downloadCommand[2]);
                if (new MD5sum().compareMD5StringsFromLinuxFormatToFilenames(new String[]{downloadCommand[3]}, new String[]{downloadCommand[1]})) return "";
                new CASUALScriptParser().executeOneShotCommand("$HALT HALTING Downloaded md5sum did not check out");
                return "";
            }
            Log.level0Error("Invalid download command");
            return "Invalid Download Command";
        }
        if (line.startsWith("$EXECUTE")) {
            line = StringOperations.removeLeadingSpaces(line.replace("$EXECUTE", ""));
            ArrayList<String> command = new ShellTools().parseCommandLine(line);
            String[] commandArray = (String[])Arrays.copyOf(command.toArray(), command.size(), String[].class);
            return new Shell().sendShellCommand(commandArray);
        }
        if (line.startsWith("$BUILDPROP")) {
            if (this.deviceBuildPropStorage != null && this.deviceBuildPropStorage.contains("ro.")) {
                return this.deviceBuildPropStorage;
            }
            String[] cmd = new String[]{new ADBTools().getBinaryLocation(), "shell", "cat /system/build.prop"};
            this.deviceBuildPropStorage = new Shell().timeoutShellCommand(cmd, 5000);
            return this.deviceBuildPropStorage;
        }
        if (line.startsWith("$FLASH")) {
            if (!(line = line.replace("$FLASH", "").trim()).contains(",")) {
                Log.level0Error("Missing Comma in $FLASH command");
                throw new RuntimeException("no comma to split and specify destination");
            }
            split = line.split(",");
            File f = new File(split[0].replace("\"", "").trim());
            try {
                f.createNewFile();
            }
            catch (IOException ex) {
                Logger.getLogger(CASUALLanguage.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                long x = new CASUALDataBridge().sendFile(f, split[1].trim());
                if (x == f.length()) return "Pushed " + x + " bytes";
                new CASUALMessageObject("@interactionUltimateFlashFailure").showErrorDialog();
                return "Pushed " + x + " bytes";
            }
            catch (FileNotFoundException ex) {
                Log.level0Error("@fileNotFound");
                throw new RuntimeException("File not found");
            }
            catch (Exception ex) {
                Log.level0Error("@failedToWriteFile");
                throw new RuntimeException("Failed to write file");
            }
        }
        if (line.startsWith("$PULL")) {
            if (!(line = line.replace("$PULL", "").trim()).contains(",")) {
                Log.level0Error("Missing Comma in $PULL command");
                throw new RuntimeException("no comma to split and specify destination");
            }
            split = line.split(",");
            File f = new File(split[1].replace("\"", "").trim());
            new File(f.getParent()).mkdirs();
            try {
                f.createNewFile();
                return new CASUALDataBridge().integralGetFile(split[0].trim(), f);
            }
            catch (IOException ex) {
                // empty catch block
            }
            return new CASUALDataBridge().integralGetFile(split[0].trim(), f);
        }
        if (line.startsWith("$HEIMDALL")) {
            line = line.replace("$HEIMDALL", "");
            line = StringOperations.removeLeadingSpaces(line);
            Log.level4Debug("Received Command: " + line);
            Log.level4Debug("CASUALLanguage- verifying Heimdall deployment.");
            if (new HeimdallTools().run(new String[]{"detect"}, 5000, true).contains("CritERROR!!!")) return new CASUALScriptParser().executeOneShotCommand("$HALT $ECHO You must install Heimdall!");
            ArrayList<String> intermediateCommand = new ShellTools().parseCommandLine(line);
            String[] command = intermediateCommand.toArray(new String[intermediateCommand.size()]);
            new HeimdallTools().waitForDevice();
            Log.level2Information("@executingHeimdall");
            return new HeimdallTools().doHeimdallShellCommand(command);
        }
        if (line.startsWith("$FASTBOOT")) {
            line = line.replace("$FASTBOOT", "");
            line = StringOperations.removeLeadingSpaces(line);
            Log.level4Debug("received fastbot command.");
            Log.level4Debug("deploying fastboot.");
            new FastbootTools().getBinaryLocation();
            Log.level2Information("@waitingForDownloadModeDevice");
            if (!OSTools.isLinux()) return new FastbootTools().doFastbootShellCommand(line);
            Log.level2Information("@linuxPermissionsElevation");
            String returnValue = new FastbootTools().doElevatedFastbootShellCommand(line.replaceAll("\"", "\\\""));
            if (!returnValue.contentEquals("\n")) {
                return returnValue;
            }
        } else {
            String retVal;
            if (line.startsWith("$ADB")) {
                line = line.replace("$ADB", "");
                line = StringOperations.removeLeadingSpaces(line);
                retVal = this.doShellCommand(line, null, null);
                Log.level4Debug("return from ADB:" + retVal);
                return retVal;
            }
            retVal = this.doShellCommand(line, null, null);
            Log.level4Debug("return from ADB:" + retVal);
            return retVal;
        }
        Log.level4Debug("COMMAND processed - " + new ADBTools().getBinaryLocation() + " " + line);
        return "";
    }

    private String processIdentifiedCommand(String identified, String line) {
        line = line.replace(identified, "");
        Log.level4Debug("Processing " + identified);
        line = StringOperations.removeLeadingSpaces(line);
        return line;
    }

    private String returnSafeCharacters(String Str) {
        Str = Str.replace("\\", "\\\\");
        Str = Str.replace("\"", "\\\"");
        Str = Str.replace("'", "\\'");
        return Str;
    }

    private String doIfContainsReturnResults(String line, boolean ifContains) {
        if (line.startsWith("$IFCONTAINS")) {
            line = StringOperations.removeLeadingSpaces(line.replaceFirst("\\$IFCONTAINS", ""));
        } else if (line.startsWith("$IFNOTCONTAINS")) {
            line = StringOperations.removeLeadingSpaces(line.replaceFirst("\\$IFNOTCONTAINS", ""));
        }
        String[] checkValueSplit = line.split("\\$INCOMMAND", 2);
        String checkValue = StringOperations.removeLeadingAndTrailingSpaces(checkValueSplit[0].replace("\\$INCOMMAND", line));
        String[] commandSplit = checkValueSplit[1].split("\\$DO", 2);
        String command = StringOperations.removeLeadingAndTrailingSpaces(commandSplit[0]);
        String casualCommand = StringOperations.removeLeadingAndTrailingSpaces(commandSplit[1]);
        if (command.startsWith("$ADB")) {
            command = command.replaceFirst("\\$ADB", "");
        }
        Log.level4Debug("checking for results to be " + ifContains);
        Log.level4Debug("requesting " + command);
        String returnValue = new CASUALScriptParser().executeOneShotCommand(command);
        Log.level4Debug("got " + returnValue);
        String retValue = "";
        if (returnValue.contains(checkValue) == ifContains) {
            if (casualCommand.contains("&&&")) {
                String[] lineSplit;
                for (String cmd : lineSplit = casualCommand.split("&&&")) {
                    retValue = retValue + new CASUALScriptParser().executeOneShotCommand(StringOperations.removeLeadingAndTrailingSpaces(cmd));
                }
            } else {
                retValue = retValue + new CASUALScriptParser().executeOneShotCommand(StringOperations.removeLeadingAndTrailingSpaces(casualCommand));
            }
        }
        return retValue;
    }

    private String doShellCommand(String Line2, String ReplaceThis, String WithThis) {
        return this.executeADBCommand(Line2, ReplaceThis, WithThis, true);
    }

    private String executeADBCommand(String Line2, String ReplaceThis, String WithThis, boolean parseError) {
        if ((Line2 = StringOperations.removeLeadingSpaces(Line2)).startsWith("wait-for")) {
            Log.level2Information("@waitingForDeviceToBeDetected");
        }
        Shell Shell2 = new Shell();
        ArrayList<String> ShellCommand = new ArrayList<String>();
        ShellCommand.add(new ADBTools().getBinaryLocation());
        ShellCommand.addAll(new ShellTools().parseCommandLine(Line2));
        String[] StringCommand = StringOperations.convertArrayListToStringArray(ShellCommand);
        if (ReplaceThis != null) {
            for (int i = 0; i < StringCommand.length; ++i) {
                StringCommand[i] = StringCommand[i].replace(ReplaceThis, WithThis);
            }
        }
        Log.level4Debug("sending");
        if (parseError) {
            return Shell2.liveShellCommand(StringCommand, true);
        }
        return Shell2.sendShellCommandIgnoreError(StringCommand);
    }

    private boolean verifyFileExists(String testFileString) {
        if (!new FileOperations().verifyExists(testFileString)) {
            if (new FileOperations().verifyExists(testFileString = testFileString.replace(",", ""))) {
                Log.level3Verbose("verified " + testFileString + " exists");
                return true;
            }
            return false;
        }
        Log.level3Verbose("verified " + testFileString + " exists");
        return true;
    }

    private void fileNotFound() {
        int n = new CASUALMessageObject("@interactionMissingFileVirusScanner").showUserCancelOption();
        if (n == 1) {
            Log.level0Error(this.CASPAC.getActiveScript().name);
            Log.level0Error("@canceledDueToMissingFiles");
            Statics.CASPAC.getActiveScript().scriptContinue = false;
        }
    }

    private boolean verifyZIPFILEReferencesExist(String line) {
        if (!(line.startsWith("$USERINPUTBOX") || line.startsWith("$MAKEDIR") || line.startsWith("$PULL") || line.startsWith("$DOWNLOAD") || line.startsWith("$ECHO") || line.startsWith("$REMOVEDIR") || line.startsWith("$COMMANDNOTIFICATION") || line.startsWith("$MAKEDIR") || line.contains(" shell echo ") || line.startsWith("$USERNOTIFICATION") || line.contains(" pull "))) {
            String[] lineArray = line.split(" ");
            int pos = 0;
            while (pos < lineArray.length) {
                if (lineArray[pos].contains("$ZIPFILE")) {
                    String zipRef = lineArray[pos].replace("$ZIPFILE", this.ScriptTempFolder).replace("\"", "");
                    if (lineArray[pos].endsWith("$ZIPFILE\"") || lineArray[pos].equals("$ZIPFILE")) {
                        if (!this.verifyFileExists(zipRef)) {
                            this.fileNotFound();
                            return false;
                        }
                        ++pos;
                        continue;
                    }
                    if (this.verifyFileExists(zipRef)) {
                        ++pos;
                        continue;
                    }
                    boolean fileFound = false;
                    String instanceString = zipRef;
                    for (int instancePos = pos + 1; instancePos < lineArray.length && !lineArray[instancePos].contains("$ZIPFILE"); ++instancePos) {
                        if (!this.verifyFileExists(instanceString = instanceString + " " + lineArray[instancePos])) continue;
                        fileFound = true;
                        ++pos;
                        break;
                    }
                    if (!fileFound) {
                        this.fileNotFound();
                    }
                }
                ++pos;
            }
        }
        return true;
    }
}

