/*
 * Decompiled with CFR 0.152.
 */
package CASUAL;

import CASUAL.CASUALStartupTasks;
import CASUAL.Log;
import CASUAL.Statics;
import CASUAL.communicationstools.AbstractDeviceCommunicationsProtocol;

public class CASUALConnectionStatusMonitor {
    private static int LastState = 0;
    private static AbstractDeviceCommunicationsProtocol monitor;
    private static AbstractDeviceCommunicationsProtocol monitorLastState;
    static final int TIMERINTERVAL = 1000;
    static boolean paused;

    public static void stop() {
        monitorLastState = monitor;
        monitor = null;
        paused = true;
    }

    public static void resumeAfterStop() {
        paused = false;
        if (monitorLastState == null) {
            Log.level3Verbose("A call to resume monitor occurred, but monitor was not reset first.  No action is occuring");
        } else {
            new CASUALConnectionStatusMonitor().start(monitorLastState);
        }
    }

    public static String getStatus() {
        return new CASUALConnectionStatusMonitor().toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String n = "\n";
        sb.append("Status:");
        if (monitor == null) {
            sb.append("offline").append(n).append("Mode:not monitoring").append(n);
        } else {
            sb.append("online").append(n).append(monitor.toString());
        }
        return sb.toString();
    }

    public void start(AbstractDeviceCommunicationsProtocol mode) {
        CASUALConnectionStatusMonitor.stop();
        paused = false;
        this.stateSwitcher(0);
        monitor = mode;
        Log.level3Verbose("Starting: " + mode);
        if (Statics.isGUIIsAvailable() && (CASUALStartupTasks.lockGUIformPrep || CASUALStartupTasks.lockGUIunzip)) {
            Statics.GUI.setControlStatus(false);
            Statics.GUI.setStatusLabelIcon("/CASUAL/resources/icons/DeviceDisconnected.png", "Device Not Detected");
            LastState = 0;
        }
        this.doMonitoring();
    }

    private void doMonitoring() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                AbstractDeviceCommunicationsProtocol stateMonitor = monitor;
                while (monitor != null && monitor.equals(stateMonitor)) {
                    CASUALConnectionStatusMonitor.this.sleepForOneSecond();
                    if (paused) continue;
                    CASUALConnectionStatusMonitor.this.doDeviceCheck();
                }
            }
        });
        t.setName("Connection Status");
        t.start();
    }

    private void doDeviceCheck() {
        int connectedDevices;
        try {
            connectedDevices = monitor.numberOfDevicesConnected();
        }
        catch (NullPointerException ex) {
            connectedDevices = 0;
        }
        if (connectedDevices > 1) {
            this.stateSwitcher(connectedDevices);
        } else if (connectedDevices == 0) {
            this.stateSwitcher(0);
        } else if (connectedDevices == 1) {
            this.stateSwitcher(1);
        }
    }

    void stateSwitcher(int state) {
        if (LastState != state) {
            Log.level4Debug("State Change Detected, The new state is: " + state);
            switch (state) {
                case 0: {
                    Log.level4Debug("@stateDisconnected");
                    Statics.setStatus("Device Removed");
                    Statics.GUI.deviceDisconnected();
                    Statics.GUI.setControlStatus(false);
                    break;
                }
                case 1: {
                    Statics.setStatus("Device Connected");
                    Log.level4Debug("@stateConnected");
                    Statics.GUI.deviceConnected("ADB");
                    Statics.GUI.setControlStatus(true);
                    break;
                }
                default: {
                    Statics.setStatus("Multiple Devices Detected");
                    if (state == 2) {
                        Log.level0Error("@stateMultipleDevices");
                        Log.level0Error("Remove " + (state - 1) + " device to continue.");
                    }
                    Statics.GUI.setControlStatus(false);
                    Log.level4Debug("State Multiple Devices Number of devices" + state);
                    Statics.GUI.deviceMultipleConnected(state);
                }
            }
            LastState = state;
        }
    }

    private void sleepForOneSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            Log.errorHandler(ex);
        }
    }

    static {
        paused = false;
    }
}

