/*
 * Decompiled with CFR 0.152.
 */
package CASUAL;

import CASUAL.Log;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioHandler {
    public static volatile boolean useSound = false;

    public static synchronized void playSound(final String url) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                if (useSound) {
                    try {
                        byte[] buffer = new byte[4096];
                        AudioInputStream is = AudioSystem.getAudioInputStream(new BufferedInputStream(this.getClass().getResourceAsStream(url)));
                        AudioFormat Format = is.getFormat();
                        SourceDataLine line = AudioSystem.getSourceDataLine(Format);
                        line.open(Format);
                        line.start();
                        while (is.available() > 0) {
                            int Len = is.read(buffer);
                            line.write(buffer, 0, Len);
                        }
                        line.drain();
                        line.close();
                        is.close();
                    }
                    catch (IllegalArgumentException ex) {
                        useSound = false;
                    }
                    catch (UnsupportedAudioFileException ex) {
                        useSound = false;
                    }
                    catch (IOException ex) {
                        useSound = false;
                    }
                    catch (LineUnavailableException ex) {
                        useSound = false;
                    }
                }
            }
        });
        t.setName("Audio");
        t.start();
    }

    public static synchronized void playMultipleInputStreams(final String[] urls) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                if (useSound) {
                    for (String url : urls) {
                        try {
                            AudioInputStream audioIn = AudioSystem.getAudioInputStream(this.getClass().getResourceAsStream(url));
                            AudioFormat format = audioIn.getFormat();
                            DataLine.Info info = new DataLine.Info(Clip.class, format);
                            Clip clip = (Clip)AudioSystem.getLine(info);
                            clip.open(audioIn);
                            clip.start();
                            this.sleepTillEndOfClip(clip);
                            clip.drain();
                        }
                        catch (IOException error) {
                            Log.level3Verbose("File Not Found");
                        }
                        catch (UnsupportedAudioFileException ex) {
                            Logger.getLogger(AudioHandler.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (LineUnavailableException ex) {
                            Logger.getLogger(AudioHandler.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (IllegalArgumentException ex) {
                            Logger.getLogger(AudioHandler.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(AudioHandler.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }

            private void sleepTillEndOfClip(Clip clip) throws InterruptedException {
                Thread.sleep(clip.getMicrosecondLength() / 5000L);
            }
        });
        t.setName("AudioStream");
        t.start();
    }
}

