/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.UIToolkit;
import com.sun.deploy.uitoolkit.WindowFactory;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import com.sun.deploy.util.FXLoader;
import com.sun.deploy.util.ReflectionUtil;

public class ToolkitStore {
    public static final String UITOOLKIT = "jnlp.uitoolkit";
    public static final String JNLP_TK = "jnlp.tk";
    public static final String JNLP_FX = "jnlp.fx";
    public static final String JNLP_TK_AWT = "awt";
    public static final String JNLP_TK_FX = "jfx";
    public static final String JNLP_TK_TEXT = "text";
    public static final String AWT_IMPL_CLASS = "com.sun.deploy.uitoolkit.impl.awt.UIToolkitImpl";
    public static final String AWT_PLUGIN_IMPL_CLASS = "com.sun.deploy.uitoolkit.impl.awt.AWTPluginUIToolkit";
    public static final String FX_PLUGIN_IMPL_CLASS = "com.sun.deploy.uitoolkit.impl.fx.FXPluginToolkit";
    public static final String TEXT_PLUGIN_IMPL_CLASS = "com.sun.deploy.uitoolkit.impl.text.TextPluginUIToolkit";
    public static final String TEXT_IMPL_CLASS = "com.sun.deploy.uitoolkit.impl.text.TextUIToolkit";
    private static Class toolkitClass;
    private static volatile UIToolkit toolkitImpl;
    public static final int PLUGIN_MODE = 1;
    public static final int DESKTOP_MODE = 0;
    public static final int AWT_TOOLKIT = 10;
    public static final int FX_TOOLKIT = 11;
    public static final int TEXT_TOOLKIT = 12;
    private static int useTk;
    private static boolean isPlugin;
    private static boolean forceToolkitMatchForTests;
    static /* synthetic */ Class class$com$sun$deploy$uitoolkit$UIToolkit;
    static /* synthetic */ Class class$com$sun$deploy$uitoolkit$ToolkitStore;

    private static boolean isInitialized() {
        return null != toolkitImpl;
    }

    private static UIToolkit loadToolkit(String string) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (!ReflectionUtil.isClassAvailable(string, classLoader)) {
            throw new ClassNotFoundException(string + " cannot be found.");
        }
        Class<?> clazz = Class.forName(string, true, classLoader);
        UIToolkit uIToolkit = (UIToolkit)clazz.newInstance();
        uIToolkit.init();
        return uIToolkit;
    }

    private static String getToolkitClassName(int n, int n2) {
        String string;
        switch (n) {
            case 10: {
                string = n2 == 1 ? AWT_PLUGIN_IMPL_CLASS : AWT_IMPL_CLASS;
                break;
            }
            case 11: {
                string = FX_PLUGIN_IMPL_CLASS;
                break;
            }
            case 12: {
                string = n2 == 1 ? TEXT_PLUGIN_IMPL_CLASS : TEXT_IMPL_CLASS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid toolkit type.");
            }
        }
        return string;
    }

    private static void ensureJfxAvailability(String string) throws ClassNotFoundException {
        if (null == string || string.length() == 0) {
            string = "2.0+";
        }
        FXLoader.loadFX(string);
    }

    private static void ensureAWTAvailability() throws Exception {
        if (!ReflectionUtil.isClassAvailable("sun.awt.SunToolkit", null)) {
            throw new Exception("AWT is not available !!");
        }
    }

    private static synchronized UIToolkit init() throws Exception {
        String string = System.getProperty(UITOOLKIT);
        if (string != null) {
            string = string.trim();
            Trace.println("Set UIToolkit through system property: " + string, TraceLevel.UI);
            try {
                if (string.equalsIgnoreCase(FX_PLUGIN_IMPL_CLASS)) {
                    ToolkitStore.ensureJfxAvailability("2.0+");
                }
                toolkitImpl = ToolkitStore.loadToolkit(string);
                toolkitClass = toolkitImpl.getClass();
                return toolkitImpl;
            }
            catch (Exception exception) {
                Trace.println(string + " is not available, move on to next...", TraceLevel.UI);
            }
        } else {
            String string2 = System.getProperty(JNLP_TK);
            if (string2 != null) {
                if ((string2 = string2.trim()).equalsIgnoreCase(JNLP_TK_FX)) {
                    ToolkitStore.setToolkitType(11);
                    try {
                        ToolkitStore.ensureJfxAvailability("2.0+");
                        ToolkitStore.setToolkitType(11);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Trace.ignored(classNotFoundException);
                        ToolkitStore.setToolkitType(10);
                    }
                } else if (string2.equalsIgnoreCase(JNLP_TK_TEXT)) {
                    ToolkitStore.setToolkitType(12);
                } else {
                    ToolkitStore.setToolkitType(10);
                }
            } else {
                String string3 = System.getProperty(JNLP_FX);
                if (string3 != null) {
                    try {
                        ToolkitStore.ensureJfxAvailability(string3);
                        ToolkitStore.setToolkitType(11);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Trace.ignored(classNotFoundException);
                        ToolkitStore.setToolkitType(10);
                    }
                } else {
                    ToolkitStore.setToolkitType(10);
                }
            }
        }
        Trace.println("toolkit class not specified, use current settings...", TraceLevel.UI);
        if (useTk == 10) {
            ToolkitStore.ensureAWTAvailability();
        }
        try {
            string = ToolkitStore.getToolkitClassName(useTk, isPlugin ? 1 : 0);
            Trace.println("Try to load UIToolkit: " + string, TraceLevel.UI);
            toolkitImpl = ToolkitStore.loadToolkit(string);
        }
        catch (Exception exception) {
            if (useTk != 10) {
                Trace.println("Fallback to AWT toolkit...", TraceLevel.UI);
                ToolkitStore.ensureAWTAvailability();
                string = ToolkitStore.getToolkitClassName(10, isPlugin ? 1 : 0);
                toolkitImpl = ToolkitStore.loadToolkit(string);
            }
            throw exception;
        }
        toolkitImpl.init();
        toolkitClass = toolkitImpl.getClass();
        return toolkitImpl;
    }

    public static void setMode(int n) {
        if (ToolkitStore.isInitialized()) {
            if (n == 1 == isPlugin) {
                Trace.println("don't need to switch mode", TraceLevel.UI);
                return;
            }
            Trace.println("Attempt to switch toolkit mode after initialization to mode: " + n, TraceLevel.UI);
            toolkitImpl = toolkitImpl.changeMode(n);
        }
        if (n == 1) {
            isPlugin = true;
        } else if (n == 0) {
            isPlugin = false;
        } else {
            Trace.println("Error: ToolkitStore.setMode() invalid argument " + n, TraceLevel.UI);
        }
    }

    public static boolean allowTextToolkit() {
        if ("USE_TEXTUI_TOOLKIT".equals(System.getenv("DEPLOY_USE_TEXT_TOOLKIT_DEBUG"))) {
            return true;
        }
        Trace.println("WARNING TEXT UI TOOLKIT NOT ALLOWED");
        return false;
    }

    public static void setToolkitType(int n) {
        if (n == 12 && !ToolkitStore.allowTextToolkit()) {
            throw new SecurityException("Text UI toolkit not allowed");
        }
        if (ToolkitStore.isInitialized()) {
            Trace.println("Warning: ToolkitStore.setType() called after initialized, may not be effective", TraceLevel.UI);
        }
        if (n != 11 && n != 12 && n != 10) {
            Trace.println("Error: ToolkitStore.setType() invalid argument " + n, TraceLevel.UI);
        }
        useTk = n;
    }

    public static boolean isAWTToolkitRunning() {
        return useTk == 10;
    }

    static synchronized void setUIToolkit(Class clazz) {
        if (ToolkitStore.isInitialized()) {
            if (toolkitClass != clazz) {
                Trace.println("Warning: SetUIToolkit changed toolkit after initialization", TraceLevel.UI);
            } else {
                return;
            }
        }
        Trace.println("UIToolkit set to" + clazz.getName(), TraceLevel.UI);
        if ((class$com$sun$deploy$uitoolkit$UIToolkit == null ? (class$com$sun$deploy$uitoolkit$UIToolkit = ToolkitStore.class$("com.sun.deploy.uitoolkit.UIToolkit")) : class$com$sun$deploy$uitoolkit$UIToolkit).isAssignableFrom(clazz)) {
            toolkitClass = clazz;
            if (toolkitImpl != null) {
                try {
                    toolkitImpl = (UIToolkit)toolkitClass.newInstance();
                }
                catch (Exception exception) {
                    System.err.println("Exception instantiating toolkit" + exception);
                }
            }
        } else {
            System.err.println("setUIToolkit: class is not a  UIToolkit class");
        }
    }

    public static synchronized void dispose() throws Exception {
        forceToolkitMatchForTests = false;
        if (!ToolkitStore.isInitialized()) {
            return;
        }
        toolkitImpl.dispose();
        toolkitImpl = null;
        toolkitClass = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UIToolkit get() {
        if (!ToolkitStore.isInitialized()) {
            Class clazz = class$com$sun$deploy$uitoolkit$ToolkitStore == null ? (class$com$sun$deploy$uitoolkit$ToolkitStore = ToolkitStore.class$("com.sun.deploy.uitoolkit.ToolkitStore")) : class$com$sun$deploy$uitoolkit$ToolkitStore;
            synchronized (clazz) {
                if (!ToolkitStore.isInitialized()) {
                    try {
                        ToolkitStore.init();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        return toolkitImpl;
    }

    public static UIFactory getUI() {
        return ToolkitStore.get().getUIFactory();
    }

    public static WindowFactory getWindowFactory() {
        return ToolkitStore.get().getWindowFactory();
    }

    public static boolean isUsingPreferredToolkitType(int n) {
        return ToolkitStore.isUsingPreferredToolkit(n, isPlugin ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUsingPreferredToolkit(int n, int n2) {
        Object object;
        if (forceToolkitMatchForTests) {
            return true;
        }
        if (!ToolkitStore.isInitialized()) {
            object = class$com$sun$deploy$uitoolkit$ToolkitStore == null ? (class$com$sun$deploy$uitoolkit$ToolkitStore = ToolkitStore.class$("com.sun.deploy.uitoolkit.ToolkitStore")) : class$com$sun$deploy$uitoolkit$ToolkitStore;
            synchronized (object) {
                ToolkitStore.setMode(n2);
                ToolkitStore.setToolkitType(n);
                ToolkitStore.get();
            }
        }
        try {
            object = ToolkitStore.get().getClass().getCanonicalName();
            String string = System.getProperty(UITOOLKIT);
            string = null != string ? string.trim() : ToolkitStore.getToolkitClassName(n, n2);
            return ((String)object).equals(string);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return true;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        toolkitImpl = null;
        useTk = 10;
        isPlugin = false;
        forceToolkitMatchForTests = false;
    }
}

