/*
 * Decompiled with CFR 0.152.
 */
package com.casual_dev.jodin;

import CASUAL.CASUALConnectionStatusMonitor;
import CASUAL.CASUALMessageObject;
import CASUAL.Log;
import CASUAL.OSTools;
import CASUAL.Statics;
import CASUAL.caspac.Caspac;
import CASUAL.caspac.Script;
import CASUAL.communicationstools.AbstractDeviceCommunicationsProtocol;
import CASUAL.communicationstools.heimdall.HeimdallTools;
import CASUAL.communicationstools.heimdall.odin.CorruptOdinFileException;
import CASUAL.communicationstools.heimdall.odin.Odin;
import CASUAL.iCASUALUI;
import CASUAL.network.LinkLauncher;
import CASUAL.network.Pastebin;
import com.casual_dev.jodin.JOdinMain;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;

public class JOdinController
implements Initializable,
iCASUALUI {
    @FXML
    Button testButton;
    @FXML
    private AnchorPane loading;
    @FXML
    private Label passFailLabel;
    @FXML
    private AnchorPane displaySurface;
    @FXML
    private Button button1;
    @FXML
    private Button button2;
    @FXML
    private Button button3;
    @FXML
    private Label messageTitle;
    @FXML
    private TextArea messageDisplay;
    @FXML
    private AnchorPane mainSurface;
    private Stage stage;
    @FXML
    private Rectangle passFailBox;
    @FXML
    private ProgressBar progress;
    @FXML
    private TextField connectedIndicator;
    @FXML
    private CheckBox autoReboot;
    @FXML
    private CheckBox repartition;
    @FXML
    private Button pitSelection;
    @FXML
    private TextField pitLocation;
    @FXML
    private CheckBox bootloaderFlash;
    @FXML
    private Button bootloaderSelection;
    @FXML
    private TextField bootloaderLocation;
    @FXML
    private CheckBox pdaFlash;
    @FXML
    private Button pdaSelection;
    @FXML
    private TextField pdaLocation;
    @FXML
    private CheckBox phoneFlash;
    @FXML
    private Button phoneSelection;
    @FXML
    private TextField phoneLocation;
    @FXML
    private CheckBox cscFlash;
    @FXML
    private Button cscSelection;
    @FXML
    private TextField cscLocation;
    @FXML
    private TextArea messageBox;
    @FXML
    private Button start;
    @FXML
    private Button reset;
    @FXML
    private Button exit;
    @FXML
    Button reportProblem;
    @FXML
    TextField inputText;
    @FXML
    Button donate;
    boolean ready = false;
    @FXML
    Button dismissLegal;
    @FXML
    AnchorPane legal;
    @FXML
    Button showLegal;
    File initialDir = new File(System.getProperty("user.dir"));
    boolean dummyGUI = false;
    static int i;
    String returnValue;
    final Object lock = new Object();
    Caspac caspac;
    int max = 100;

    public void initialize(URL url, ResourceBundle rb) {
        Statics.GUI = this;
        this.ready = true;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                JOdinController.this.displaySurface.setVisible(false);
                JOdinController.this.resetPassFail("");
                JOdinController.this.deviceDisconnected();
                JOdinController.this.checkFilesCheckboxes();
                JOdinController.this.inputText.setPromptText("Enter Text Here");
                new CASUALConnectionStatusMonitor().start((AbstractDeviceCommunicationsProtocol)new HeimdallTools());
                JOdinController.this.loading.setVisible(false);
                JOdinController.this.hideDisplaySurface();
            }
        });
        t.start();
    }

    @FXML
    private void installDriverButton() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean x = new HeimdallTools().installDriver();
                new CASUALMessageObject("All Done>>>All done.\n\nReport: " + (x ? "Sucessful!" : "No Changes") + "\n\nIf you continue to have problems," + (OSTools.isMac() ? " ensure you have removed Samsung Kies from your computer.  You should also" : "") + " reboot the device and the computer. ").showInformationMessage();
            }
        });
        t.start();
    }

    private String showFileChooser(String title) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(title);
        fileChooser.setInitialDirectory(this.initialDir);
        File f = fileChooser.showOpenDialog((Window)JOdinMain.stage);
        if (f == null) {
            return "";
        }
        this.initialDir = f.getParentFile();
        return f.getAbsolutePath();
    }

    @FXML
    private void pitPressed() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JOdinController.this.pitLocation.setText(JOdinController.this.showFileChooser("Select PIT"));
                JOdinController.this.checkFilesCheckboxes();
            }
        });
    }

    @FXML
    private void bootloaderPressed() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JOdinController.this.bootloaderLocation.setText(JOdinController.this.showFileChooser("Select Bootloader"));
                JOdinController.this.checkFilesCheckboxes();
                if (!JOdinController.this.bootloaderLocation.getText().equals("")) {
                    JOdinController.this.bootloaderFlash.setSelected(true);
                }
            }
        });
    }

    @FXML
    private void pdaPressed() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JOdinController.this.pdaLocation.setText(JOdinController.this.showFileChooser("Select PDA"));
                JOdinController.this.checkFilesCheckboxes();
                if (!JOdinController.this.pdaLocation.getText().equals("")) {
                    JOdinController.this.pdaFlash.setSelected(true);
                }
            }
        });
    }

    @FXML
    private void phonePressed() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JOdinController.this.phoneLocation.setText(JOdinController.this.showFileChooser("Select Phone"));
                JOdinController.this.checkFilesCheckboxes();
                if (!JOdinController.this.phoneLocation.getText().equals("")) {
                    JOdinController.this.phoneFlash.setSelected(true);
                }
            }
        });
    }

    @FXML
    private void cscPressed() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JOdinController.this.cscLocation.setText(JOdinController.this.showFileChooser("Select CSC"));
                JOdinController.this.checkFilesCheckboxes();
                if (!JOdinController.this.cscLocation.getText().equals("")) {
                    JOdinController.this.cscFlash.setSelected(true);
                }
            }
        });
    }

    public void completePass() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JOdinController.this.passFailLabel.setText("PASS");
                JOdinController.this.passFailBox.setFill(Paint.valueOf((String)"green"));
                JOdinController.this.disableControls(false);
            }
        });
    }

    public void resetPassFail(final String message) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JOdinController.this.passFailLabel.setText(message);
                JOdinController.this.passFailBox.setFill(Paint.valueOf((String)"#dfdfdf"));
                JOdinController.this.disableControls(false);
            }
        });
    }

    public void completeFail() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JOdinController.this.passFailLabel.setText("FAIL");
                JOdinController.this.passFailBox.setFill(Paint.valueOf((String)"red"));
            }
        });
    }

    private void checkFilesCheckboxes() {
        if (this.bootloaderLocation.getText().equals("")) {
            this.bootloaderFlash.setSelected(false);
            this.bootloaderFlash.setDisable(true);
            this.bootloaderLocation.setDisable(true);
        } else {
            this.bootloaderFlash.setDisable(false);
            this.bootloaderLocation.setDisable(false);
        }
        if (this.pdaLocation.getText().equals("")) {
            this.pdaFlash.setSelected(false);
            this.pdaFlash.setDisable(true);
            this.pdaLocation.setDisable(true);
        } else {
            this.pdaFlash.setDisable(false);
            this.pdaLocation.setDisable(false);
        }
        if (this.phoneLocation.getText().equals("")) {
            this.phoneFlash.setSelected(false);
            this.phoneFlash.setDisable(true);
            this.phoneLocation.setDisable(true);
        } else {
            this.phoneFlash.setDisable(false);
            this.phoneLocation.setDisable(false);
        }
        if (this.cscLocation.getText().equals("")) {
            this.cscFlash.setSelected(false);
            this.cscFlash.setDisable(true);
            this.cscLocation.setDisable(true);
        } else {
            this.cscFlash.setDisable(false);
            this.cscLocation.setDisable(false);
        }
        if (this.pitLocation.getText().equals("")) {
            this.pitLocation.setDisable(true);
        } else {
            this.pitLocation.setDisable(false);
        }
    }

    private void exit() {
        System.exit(0);
    }

    @FXML
    private void reset() {
        this.pitLocation.setText("");
        this.bootloaderLocation.setText("");
        this.pdaLocation.setText("");
        this.phoneLocation.setText("");
        this.cscLocation.setText("");
        this.autoReboot.setSelected(true);
        this.repartition.setSelected(false);
        this.messageBox.setText("");
        this.checkFilesCheckboxes();
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public boolean isDummyGUI() {
        return false;
    }

    @FXML
    private void displaySurface(final String[] message, final String[] buttonText, final boolean textbox) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JOdinController.this.mainSurface.setEffect((Effect)new GaussianBlur());
                if (textbox) {
                    JOdinController.this.inputText.setVisible(true);
                } else {
                    JOdinController.this.inputText.setVisible(false);
                }
                JOdinController.this.returnValue = null;
                JOdinController.this.button1.setVisible(true);
                if (buttonText.length > 0) {
                    JOdinController.this.button1.setText(buttonText[0]);
                } else {
                    JOdinController.this.button1.setVisible(false);
                }
                if (buttonText.length >= 2) {
                    JOdinController.this.button2.setText(buttonText[1]);
                    JOdinController.this.button2.setVisible(true);
                } else {
                    JOdinController.this.button2.setVisible(false);
                }
                if (buttonText.length >= 3) {
                    JOdinController.this.button3.setText(buttonText[2]);
                    JOdinController.this.button3.setVisible(true);
                } else {
                    JOdinController.this.button3.setVisible(false);
                }
                JOdinController.this.messageTitle.setText(message[0]);
                JOdinController.this.messageDisplay.setText(message[1]);
                JOdinController.this.displaySurface.setOpacity(0.0);
                JOdinController.this.displaySurface.setVisible(true);
                FadeTransition ft = new FadeTransition(Duration.millis((double)500.0), (Node)JOdinController.this.displaySurface);
                ft.setFromValue(0.0);
                ft.setToValue(100.0);
                ft.setCycleCount(1);
                ft.setAutoReverse(true);
                ft.play();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideDisplaySurface() {
        this.mainSurface.setEffect(null);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
        this.inputText.setVisible(false);
        this.displaySurface.setVisible(false);
        this.loading.setVisible(false);
    }

    @FXML
    void button1ClickAction() {
        if (this.inputText.getText().equals("")) {
            this.returnValue = "0";
        } else {
            this.returnValue = this.inputText.getText();
            this.inputText.setText("");
        }
        this.hideDisplaySurface();
    }

    @FXML
    private void button2ClickAction() {
        this.returnValue = "1";
        this.hideDisplaySurface();
    }

    @FXML
    private void button3ClickAction() {
        this.returnValue = "2";
        this.hideDisplaySurface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String displayMessage(CASUALMessageObject messageObject) {
        Log.Level1Interaction((String)messageObject.toString());
        String[] message = new String[]{messageObject.title, messageObject.messageText};
        this.returnValue = null;
        switch (messageObject.category) {
            case ACTIONREQUIRED: {
                this.displaySurface(message, new String[]{"I did it", "I didn' do it"}, false);
                break;
            }
            case COMMANDNOTIFICATION: {
                this.displaySurface(message, new String[]{"OK"}, false);
                break;
            }
            case TEXTINPUT: {
                this.displaySurface(message, new String[]{"OK", "Cancel"}, true);
                break;
            }
            case SHOWERROR: {
                this.displaySurface(message, new String[]{"OK"}, false);
                break;
            }
            case SHOWINFORMATION: {
                this.displaySurface(message, new String[]{"OK"}, false);
                break;
            }
            case SHOWYESNO: {
                this.displaySurface(message, new String[]{"Yes", "no"}, false);
                break;
            }
            case TIMEOUT: {
                this.displaySurface(message, new String[]{"Ok"}, false);
                break;
            }
            case USERCANCELOPTION: {
                this.displaySurface(message, new String[]{"OK", "Cancel"}, false);
                break;
            }
            case USERNOTIFICATION: {
                this.displaySurface(message, new String[]{"OK"}, false);
            }
        }
        try {
            while (this.returnValue == null) {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.wait();
                }
            }
            return this.returnValue;
        }
        catch (InterruptedException ex) {
            return this.returnValue;
        }
    }

    public void dispose() {
        this.exit();
    }

    private void disableControls(final boolean b) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JOdinController.this.pitSelection.setDisable(b);
                JOdinController.this.bootloaderSelection.setDisable(b);
                JOdinController.this.pdaSelection.setDisable(b);
                JOdinController.this.phoneSelection.setDisable(b);
                JOdinController.this.cscSelection.setDisable(b);
                JOdinController.this.start.setDisable(b);
                JOdinController.this.reset.setDisable(b);
                JOdinController.this.exit.setDisable(b);
            }
        });
    }

    @FXML
    public void StartButtonActionPerformed() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                String location;
                JOdinController.this.resetPassFail("running");
                JOdinController.this.disableControls(true);
                if (JOdinController.this.pitLocation.getText().isEmpty()) {
                    String pitMessage = "Do you want me to obtain a PIT for you?>>>This application requires what is known as a` 'PIT file'.  The PIT file tells the application where to place files on your device.  If you don't have a PIT file, we can obtain one from your device";
                    boolean obtainPit = new CASUALMessageObject(pitMessage).showYesNoOption();
                    if (obtainPit) {
                        new CASUALMessageObject("You will need to restart your device in Download Mode.>>>In order to obtain a PIT file, the device will be rebooted.  Once it reboots, you will need to put it back into download mode.\n\nPro-Tip: hold the download mode combination and press OK to dismiss this dislog to reboot into download mode immediately").showInformationMessage();
                        HeimdallTools ht = new HeimdallTools();
                        String newPit = Statics.getTempFolder() + "part.pit";
                        ht.run(new String[]{"download-pit", "--output", newPit}, 10000, true);
                        File f = new File(newPit);
                        if (f.exists()) {
                            JOdinController.this.pitLocation.setText(f.getAbsolutePath());
                            JOdinController.this.disableControls(false);
                            JOdinController.this.resetPassFail("waiting");
                            new CASUALMessageObject("Got it!>>>We obtained the PIT file and everything is ready to flash\n\n Click the start button again when you're ready. ").showInformationMessage();
                            return;
                        }
                        new CASUALMessageObject("Could not obtain pit.>>>We could not obtain the pit file. We tried, but it didn't work. ").showErrorDialog();
                        JOdinController.this.disableControls(false);
                        JOdinController.this.resetPassFail("halted");
                        return;
                    }
                    new CASUALMessageObject("We can't continue without a PIT>>>We cannot continue without a PIT file.  Please select one or let CASUAL do it for you.").showInformationMessage();
                    JOdinController.this.disableControls(false);
                    JOdinController.this.resetPassFail("halted");
                    return;
                }
                ArrayList<File> list = new ArrayList<File>();
                if (JOdinController.this.bootloaderFlash.isSelected()) {
                    location = JOdinController.this.bootloaderLocation.getText();
                    list.add(new File(location));
                }
                if (JOdinController.this.pdaFlash.isSelected()) {
                    location = JOdinController.this.pdaLocation.getText();
                    list.add(new File(location));
                }
                if (JOdinController.this.phoneFlash.isSelected()) {
                    location = JOdinController.this.phoneLocation.getText();
                    list.add(new File(location));
                }
                if (JOdinController.this.cscFlash.isSelected()) {
                    location = JOdinController.this.cscLocation.getText();
                    list.add(new File(location));
                }
                try {
                    String s;
                    Odin odin = new Odin(new File(JOdinController.this.pitLocation.getText()));
                    String[] flashList = odin.getHeimdallFileParametersFromOdinFile(Statics.getTempFolder(), list.toArray(new File[list.size()]));
                    ArrayList<String> flashCommand = new ArrayList<String>();
                    flashCommand.add("flash");
                    flashCommand.add("--PIT");
                    flashCommand.add(JOdinController.this.pitLocation.getText());
                    if (JOdinController.this.repartition.isSelected()) {
                        flashCommand.add("--repartition");
                    }
                    flashCommand.addAll(Arrays.asList(flashList));
                    if (!JOdinController.this.autoReboot.isSelected()) {
                        flashCommand.add("--no-reboot");
                    }
                    JOdinController.this.messageBox.appendText(new HeimdallTools().getBinaryLocation());
                    String[] runCommand = flashCommand.toArray(new String[flashCommand.size()]);
                    System.out.println("heimdall Command:");
                    System.out.println(new HeimdallTools().getBinaryLocation());
                    CASUALConnectionStatusMonitor.stop();
                    HeimdallTools ht = new HeimdallTools();
                    if (!ht.isConnected()) {
                        JOdinController.this.messageBox.appendText("\nWaiting for device");
                    }
                    if (ht.checkErrorMessage(runCommand, s = ht.run(runCommand, 9999999, false))) {
                        JOdinController.this.completePass();
                    } else {
                        JOdinController.this.completeFail();
                    }
                    CASUALConnectionStatusMonitor.resumeAfterStop();
                }
                catch (FileNotFoundException ex) {
                    new CASUALMessageObject("We can't continue without a PIT>>>The PIT file was corrupt. We cannot continue without a PIT file.  Please select one or let CASUAL do it for you.").showInformationMessage();
                    JOdinController.this.pitLocation.setText("");
                    JOdinController.this.disableControls(false);
                    return;
                }
                catch (CorruptOdinFileException ex) {
                    new CASUALMessageObject("Corrupt File>>> A corrupted file was detected.  In order to continue, you must select a valid Odin File").showInformationMessage();
                    JOdinController.this.bootloaderLocation.setText("");
                    JOdinController.this.pdaLocation.setText("");
                    JOdinController.this.phoneLocation.setText("");
                    JOdinController.this.cscLocation.setText("");
                    JOdinController.this.disableControls(false);
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(JOdinController.class.getName()).log(Level.SEVERE, null, ex);
                }
                JOdinController.this.disableControls(false);
            }
        });
        t.start();
    }

    public boolean setControlStatus(boolean status) {
        this.start.setDisable(!status);
        return !this.start.isDisabled();
    }

    public boolean getControlStatus() {
        return !this.start.isDisabled();
    }

    public void setCASPAC(Caspac caspac) {
        this.caspac = caspac;
    }

    public void setInformationScrollBorderText(String title) {
        this.messageBox.appendText(title + "\n");
    }

    public void setProgressBar(int value) {
        this.progress.setProgress((double)(value / this.max));
    }

    public void setProgressBarMax(int value) {
        this.max = value;
    }

    public void setScript(Script s) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setStartButtonText(String text) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setStatusLabelIcon(String Icon, String Text) {
        this.messageBox.appendText(Text + "\n");
    }

    public void setStatusMessageLabel(String text) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setWindowBannerText(String text) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setVisible(boolean b) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void deviceConnected(String mode) {
        this.connectedIndicator.setText("Connected");
        this.connectedIndicator.setStyle("-fx-background-color: lime;");
    }

    public void deviceDisconnected() {
        this.connectedIndicator.setText("Disconnected");
        this.connectedIndicator.setStyle("-fx-background-color: red;");
    }

    public void deviceMultipleConnected(int numberOfDevicesConnected) {
        this.connectedIndicator.setText("Disconnected");
        this.connectedIndicator.setStyle("-fx-background-color: red;");
    }

    public void setBlocksUnzipped(int i) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @FXML
    private void sendReport() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    new Pastebin().doPosting();
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(JOdinController.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(JOdinController.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (URISyntaxException ex) {
                    Logger.getLogger(JOdinController.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        t.setName("reporting error");
        t.start();
    }

    @FXML
    private void donatePressed() {
        LinkLauncher ll = new LinkLauncher("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=WHZEN3FV6SKAA");
        ll.launch();
    }

    public void sendString(String string) {
    }

    public void sendProgress(String data) {
        this.sendProgress(data, this.messageBox);
    }

    public void sendProgress(final String data, final TextArea messageBox) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                char[] dataArray;
                block3: for (char c : dataArray = data.toCharArray()) {
                    switch (c) {
                        case '\b': {
                            String doc = messageBox.getText();
                            doc = doc.substring(0, doc.length() - 1);
                            messageBox.setText(doc);
                            continue block3;
                        }
                        default: {
                            messageBox.appendText(data);
                        }
                    }
                }
                String[] test = messageBox.getText().split("\n");
                String lastline = test[test.length - 1];
                if (lastline.startsWith("Uploading")) {
                    lastline = lastline.replace("Uploading ", "");
                    JOdinController.this.passFailLabel.setText(lastline);
                }
            }
        });
    }

    @FXML
    private void showLegal() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JOdinController.this.mainSurface.setEffect((Effect)new GaussianBlur());
                JOdinController.this.legal.setVisible(true);
            }
        });
    }

    @FXML
    private void dismissLegal() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JOdinController.this.mainSurface.setEffect(null);
                JOdinController.this.legal.setVisible(false);
            }
        });
    }
}

