/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.nio.file.spi.FileTypeDetector;
import sun.nio.fs.DynamicFileAttributeView;
import sun.nio.fs.GnomeFileTypeDetector;
import sun.nio.fs.LinuxDosFileAttributeView;
import sun.nio.fs.LinuxFileStore;
import sun.nio.fs.LinuxFileSystem;
import sun.nio.fs.LinuxUserDefinedFileAttributeView;
import sun.nio.fs.UnixFileSystemProvider;
import sun.nio.fs.UnixPath;
import sun.nio.fs.Util;

public class LinuxFileSystemProvider
extends UnixFileSystemProvider {
    @Override
    LinuxFileSystem newFileSystem(String string) {
        return new LinuxFileSystem(this, string);
    }

    @Override
    LinuxFileStore getFileStore(UnixPath unixPath) throws IOException {
        return new LinuxFileStore(unixPath);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> clazz, LinkOption ... linkOptionArray) {
        if (clazz == DosFileAttributeView.class) {
            return (V)new LinuxDosFileAttributeView(UnixPath.toUnixPath(path), Util.followLinks(linkOptionArray));
        }
        if (clazz == UserDefinedFileAttributeView.class) {
            return (V)new LinuxUserDefinedFileAttributeView(UnixPath.toUnixPath(path), Util.followLinks(linkOptionArray));
        }
        return super.getFileAttributeView(path, clazz, linkOptionArray);
    }

    @Override
    public DynamicFileAttributeView getFileAttributeView(Path path, String string, LinkOption ... linkOptionArray) {
        if (string.equals("dos")) {
            return new LinuxDosFileAttributeView(UnixPath.toUnixPath(path), Util.followLinks(linkOptionArray));
        }
        if (string.equals("user")) {
            return new LinuxUserDefinedFileAttributeView(UnixPath.toUnixPath(path), Util.followLinks(linkOptionArray));
        }
        return super.getFileAttributeView(path, string, linkOptionArray);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> clazz, LinkOption ... linkOptionArray) throws IOException {
        if (clazz == DosFileAttributes.class) {
            DosFileAttributeView dosFileAttributeView = this.getFileAttributeView(path, DosFileAttributeView.class, linkOptionArray);
            return (A)dosFileAttributeView.readAttributes();
        }
        return super.readAttributes(path, clazz, linkOptionArray);
    }

    @Override
    FileTypeDetector getFileTypeDetector() {
        return new GnomeFileTypeDetector();
    }
}

