/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaModule;
import agent.frida.manager.FridaSession;
import agent.frida.model.iface2.FridaModelTargetModule;
import agent.frida.model.impl.FridaModelTargetExportContainerImpl;
import agent.frida.model.impl.FridaModelTargetImportContainerImpl;
import agent.frida.model.impl.FridaModelTargetModuleContainerImpl;
import agent.frida.model.impl.FridaModelTargetModuleSectionContainerImpl;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import agent.frida.model.impl.FridaModelTargetSymbolContainerImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="Module", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Sections", type=FridaModelTargetModuleSectionContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Symbols", type=FridaModelTargetSymbolContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Imports", type=FridaModelTargetImportContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Exports", type=FridaModelTargetExportContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="BaseAddress", type=Address.class), @TargetAttributeType(name="ImageName", type=String.class), @TargetAttributeType(name="Len", type=String.class), @TargetAttributeType(type=Void.class)})
public class FridaModelTargetModuleImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetModule {
    protected final FridaSession session;
    protected final FridaModelTargetSymbolContainerImpl symbols;
    protected final FridaModelTargetImportContainerImpl imports;
    protected final FridaModelTargetExportContainerImpl exports;
    protected final FridaModelTargetModuleSectionContainerImpl sections;

    protected static String indexModule(FridaModule module) {
        return FridaClient.getId(module);
    }

    protected static String keyModule(FridaModule module) {
        return PathUtils.makeKey((String)FridaModelTargetModuleImpl.indexModule(module));
    }

    public FridaModelTargetModuleImpl(FridaModelTargetModuleContainerImpl modules, FridaModule module) {
        super(modules.getModel(), (TargetObject)modules, FridaModelTargetModuleImpl.keyModule(module), module, "Module");
        this.session = modules.session;
        this.symbols = new FridaModelTargetSymbolContainerImpl(this);
        this.imports = new FridaModelTargetImportContainerImpl(this);
        this.exports = new FridaModelTargetExportContainerImpl(this);
        this.sections = new FridaModelTargetModuleSectionContainerImpl(this);
        AddressSpace space = this.getModel().getAddressSpace("ram");
        this.changeAttributes(List.of(), List.of(this.sections, this.symbols, this.imports, this.exports), Map.of("_short_display", module.getName(), "_module_name", module.getPath(), "ImageName", module.getPath()), "Initialized");
        try {
            Address address = space.getAddress(module.getRangeAddress());
            AddressRangeImpl range = new AddressRangeImpl(address, module.getRangeSize().longValue());
            this.changeAttributes(List.of(), List.of(), Map.of("_range", range, "BaseAddress", address, "Len", Long.toHexString(module.getRangeSize())), "Initialized");
        }
        catch (AddressFormatException | AddressOverflowException throwable) {
            // empty catch block
        }
    }

    @Override
    public String getDescription(int level) {
        FridaModule module = (FridaModule)this.getModelObject();
        return module.getName();
    }

    protected Address doGetBase() {
        return null;
    }

    @Override
    public FridaModule getModule() {
        return (FridaModule)this.getModelObject();
    }

    public FridaSession getSession() {
        return this.session;
    }

    @Override
    public void setRange(AddressRangeImpl range) {
        if (range != null) {
            this.changeAttributes(List.of(), List.of(), Map.of("_range", range, "BaseAddress", range.getMinAddress(), "Len", Long.toHexString(range.getLength())), "Initialized");
        }
    }
}

