/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.cmd;

import agent.frida.frida.FridaClient;
import agent.frida.manager.FridaFrame;
import agent.frida.manager.FridaThread;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.cmd.FridaPendingCommand;
import agent.frida.manager.impl.FridaManagerImpl;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;

public class FridaListStackFramesCommand
extends AbstractFridaCommand<Map<String, FridaFrame>> {
    protected final FridaThread thread;
    private Map<String, FridaFrame> frames = new HashMap<String, FridaFrame>();
    private int frameCount = 0;

    public FridaListStackFramesCommand(FridaManagerImpl manager, FridaThread thread) {
        super(manager);
        this.thread = thread;
    }

    @Override
    public Map<String, FridaFrame> complete(FridaPendingCommand<?> pending) {
        return this.frames;
    }

    @Override
    public void invoke() {
        this.manager.loadScript(this, "list_stack_frames", "result = Thread.backtrace(this.context, Backtracer.ACCURATE).map(DebugSymbol.fromAddress);");
    }

    @Override
    public void parseSpecifics(JsonElement element) {
        JsonObject jobj = element.getAsJsonObject();
        HashMap<String, JsonElement> map = new HashMap<String, JsonElement>();
        for (Map.Entry l : jobj.entrySet()) {
            map.put((String)l.getKey(), (JsonElement)l.getValue());
        }
        FridaFrame frame = new FridaFrame(map, this.frameCount++);
        this.frames.put(FridaClient.getId(frame), frame);
    }
}

