/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.gadp;

import agent.frida.gadp.impl.FridaGadpServerImpl;
import ghidra.dbg.agent.AgentWindow;
import ghidra.util.Msg;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public interface FridaGadpServer
extends AutoCloseable {
    public static void main(String[] args) throws Exception {
        new FridaRunner().run(args);
    }

    public static FridaGadpServer newInstance(SocketAddress addr) throws IOException {
        return new FridaGadpServerImpl(addr);
    }

    public CompletableFuture<Void> startFrida(String[] var1);

    public SocketAddress getLocalAddress();

    public void terminate() throws IOException;

    public boolean isRunning();

    @Override
    default public void close() throws IOException {
        this.terminate();
    }

    public static class FridaRunner {
        protected InetSocketAddress bindTo;
        protected List<String> fridaArgs = new ArrayList<String>();
        protected byte busId = 1;
        protected String remote = null;

        public void run(String[] args) throws IOException, InterruptedException, ExecutionException {
            this.parseArguments(args);
            try (FridaGadpServer server = FridaGadpServer.newInstance(this.bindTo);){
                server.startFrida(this.fridaArgs.toArray(new String[0])).exceptionally(e -> {
                    Msg.error((Object)this, (Object)"Error starting Frida/GADP", (Throwable)e);
                    System.exit(-1);
                    return null;
                });
                new AgentWindow("Frida Agent for Ghidra", server.getLocalAddress());
                while (server.isRunning()) {
                    Thread.sleep(1000L);
                }
                System.exit(0);
            }
        }

        protected void parseArguments(String[] args) {
            String iface = "localhost";
            int port = 12345;
            Iterator<String> ait = Arrays.asList(args).iterator();
            while (ait.hasNext()) {
                String a = ait.next();
                if ("-h".equals(a) || "--help".equals(a)) {
                    this.printUsage();
                    System.exit(0);
                    continue;
                }
                if ("-p".equals(a) || "--port".equals(a)) {
                    if (!ait.hasNext()) {
                        System.err.println("Expected PORT");
                        this.printUsage();
                        System.exit(-1);
                    }
                    String portStr = ait.next();
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Integer required. Got " + portStr);
                        this.printUsage();
                        System.exit(-1);
                    }
                    continue;
                }
                if ("-H".equals(a) || "--host".equals(a)) {
                    if (!ait.hasNext()) {
                        System.err.println("Expected HOST/ADDR");
                        this.printUsage();
                        System.exit(-1);
                    }
                    iface = ait.next();
                    continue;
                }
                System.err.println("Unknown option: " + a);
                this.printUsage();
                System.exit(-1);
            }
            this.bindTo = new InetSocketAddress(iface, port);
        }

        protected void printUsage() {
            System.out.println("This is the GADP server for Frida.  Usage:");
            System.out.println();
            System.out.println("     [-H HOST/ADDR] [-p PORT] [-i ID] [-t TRANSPORT] [-r REMOTE]");
            System.out.println();
            System.out.println("Options:");
            System.out.println("  --host/-H          The address of the interface on which to listen.");
            System.out.println("                     Default is localhost");
            System.out.println("  --port/-p          The TCP port on which to listen for GADP. Default is 12345");
        }
    }
}

