/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.pcode.DecoderException;
import java.io.IOException;
import java.io.InputStream;

public class LinkedByteBuffer {
    public static final int BUFFER_SIZE = 1024;
    private ArrayIter initialBuffer;
    private int byteCount;
    private int maxCount;
    private ArrayIter currentBuffer;
    private int currentPos;
    private String source;

    public LinkedByteBuffer(int max, String src) {
        this.currentBuffer = this.initialBuffer = new ArrayIter();
        this.byteCount = 0;
        this.currentPos = 0;
        this.maxCount = max;
        this.initialBuffer.array = new byte[1024];
        this.initialBuffer.next = null;
        this.source = src;
    }

    public void ingestStream(InputStream stream) throws IOException {
        int tok = stream.read();
        if (tok <= 0) {
            return;
        }
        while (true) {
            if (this.byteCount > this.maxCount) {
                throw new IOException("Response buffer size exceded for: " + this.source);
            }
            while (this.currentPos != 1024) {
                this.currentBuffer.array[this.currentPos++] = (byte)tok;
                tok = stream.read();
                if (tok > 0) continue;
            }
            this.byteCount += this.currentPos;
            if (tok <= 0) {
                return;
            }
            this.currentBuffer = this.currentBuffer.next = new ArrayIter();
            this.currentBuffer.array = new byte[1024];
            this.currentPos = 0;
        }
    }

    public void pad(int val) {
        if (this.currentPos == 1024) {
            this.byteCount += this.currentPos;
            this.currentBuffer = this.currentBuffer.next = new ArrayIter();
            this.currentBuffer.array = new byte[1];
            this.currentPos = 0;
        }
        this.currentBuffer.array[this.currentPos++] = (byte)val;
    }

    public void getStartPosition(Position position) {
        position.array = this.initialBuffer.array;
        position.current = 0;
        position.seqIter = this.initialBuffer;
    }

    public static class ArrayIter {
        public ArrayIter next;
        public byte[] array;
    }

    public static class Position {
        public ArrayIter seqIter;
        public byte[] array;
        public int current;

        public void copy(Position pos) {
            this.seqIter = pos.seqIter;
            this.array = pos.array;
            this.current = pos.current;
        }

        public final byte getByte() {
            return this.array[this.current];
        }

        public final byte getBytePlus1() throws DecoderException {
            int plus1 = this.current + 1;
            if (plus1 == this.array.length) {
                ArrayIter iter = this.seqIter.next;
                if (iter == null) {
                    throw new DecoderException("Unexpected end of stream");
                }
                return iter.array[0];
            }
            return this.array[plus1];
        }

        public final byte getNextByte() throws DecoderException {
            byte res = this.array[this.current];
            ++this.current;
            if (this.current != this.array.length) {
                return res;
            }
            this.seqIter = this.seqIter.next;
            if (this.seqIter == null) {
                throw new DecoderException("Unexpected end of stream");
            }
            this.array = this.seqIter.array;
            this.current = 0;
            return res;
        }

        public final void advancePosition(int skip) throws DecoderException {
            while (this.array.length - this.current <= skip) {
                skip -= this.array.length - this.current;
                this.seqIter = this.seqIter.next;
                if (this.seqIter == null) {
                    throw new DecoderException("Unexpected end of stream");
                }
                this.array = this.seqIter.array;
                this.current = 0;
            }
            this.current += skip;
        }
    }
}

