/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.database.function.FunctionDB;
import ghidra.program.database.symbol.CodeSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Library;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.DataTypeSymbol;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.FunctionPrototype;
import ghidra.program.model.pcode.GlobalSymbolMap;
import ghidra.program.model.pcode.HighConstant;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.HighGlobal;
import ghidra.program.model.pcode.HighLocal;
import ghidra.program.model.pcode.HighOther;
import ghidra.program.model.pcode.HighParam;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.JumpTable;
import ghidra.program.model.pcode.LocalSymbolMap;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.PcodeException;
import ghidra.program.model.pcode.PcodeSyntaxTree;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeAST;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class HighFunction
extends PcodeSyntaxTree {
    public static final String DECOMPILER_TAG_MAP = "decompiler_tags";
    private Function func;
    private Language language;
    private CompilerSpec compilerSpec;
    private FunctionPrototype proto;
    private LocalSymbolMap localSymbols;
    private GlobalSymbolMap globalSymbols;
    private List<JumpTable> jumpTables;
    private List<DataTypeSymbol> protoOverrides;

    public HighFunction(Function function, Language language, CompilerSpec compilerSpec, PcodeDataTypeManager dtManager) {
        super(function.getProgram().getAddressFactory(), dtManager);
        this.func = function;
        this.language = language;
        this.compilerSpec = compilerSpec;
        AddressSpace stackSpace = function.getProgram().getAddressFactory().getStackSpace();
        this.localSymbols = new LocalSymbolMap(this, stackSpace);
        this.globalSymbols = new GlobalSymbolMap(this);
        this.proto = new FunctionPrototype(this.localSymbols, function);
        this.jumpTables = null;
        this.protoOverrides = null;
    }

    public Function getFunction() {
        return this.func;
    }

    public long getID() {
        if (this.func instanceof FunctionDB) {
            return this.func.getSymbol().getID();
        }
        return this.func.getProgram().getSymbolTable().getDynamicSymbolID(this.func.getEntryPoint());
    }

    public Language getLanguage() {
        return this.language;
    }

    public CompilerSpec getCompilerSpec() {
        return this.compilerSpec;
    }

    public FunctionPrototype getFunctionPrototype() {
        return this.proto;
    }

    public JumpTable[] getJumpTables() {
        if (this.jumpTables == null) {
            return new JumpTable[0];
        }
        JumpTable[] res = new JumpTable[this.jumpTables.size()];
        return this.jumpTables.toArray(res);
    }

    public LocalSymbolMap getLocalSymbolMap() {
        return this.localSymbols;
    }

    public GlobalSymbolMap getGlobalSymbolMap() {
        return this.globalSymbols;
    }

    public HighSymbol getMappedSymbol(Address addr, Address pcaddr) {
        return this.localSymbols.findLocal(addr, pcaddr);
    }

    @Override
    public HighSymbol getSymbol(long symbolId) {
        return this.localSymbols.getSymbol(symbolId);
    }

    public void grabFromFunction(int overrideExtrapop, boolean includeDefaultNames, boolean doOverride) {
        this.localSymbols.grabFromFunction(includeDefaultNames);
        this.proto.grabFromFunction(this.func, overrideExtrapop, doOverride);
        this.jumpTables = null;
        this.protoOverrides = null;
        this.grabOverrides();
    }

    private void grabOverrides() {
        if (!(this.func instanceof FunctionDB)) {
            return;
        }
        SymbolTable symtab = this.func.getProgram().getSymbolTable();
        Namespace space = HighFunction.findOverrideSpace(this.func);
        if (space == null) {
            return;
        }
        SymbolIterator iter = symtab.getSymbols(space);
        while (iter.hasNext()) {
            DataTypeSymbol protover;
            Symbol sym = iter.next();
            String nm = sym.getName();
            if (nm.length() < 3) continue;
            if ((nm = nm.substring(0, 3)).equals("jmp")) {
                JumpTable jumpTab;
                Object obj = sym.getObject();
                if (!(obj instanceof Namespace) || (jumpTab = JumpTable.readOverride((Namespace)obj, symtab)) == null) continue;
                if (this.jumpTables == null) {
                    this.jumpTables = new ArrayList<JumpTable>();
                }
                this.jumpTables.add(jumpTab);
                continue;
            }
            if (!nm.equals("prt") || sym.getSymbolType() != SymbolType.LABEL || (protover = HighFunctionDBUtil.readOverride(sym)) == null) continue;
            if (this.protoOverrides == null) {
                this.protoOverrides = new ArrayList<DataTypeSymbol>();
            }
            this.protoOverrides.add(protover);
        }
    }

    private void decodeHigh(Decoder decoder) throws DecoderException {
        int el = decoder.openElement(ElementId.ELEM_HIGH);
        String classstring = decoder.readString(AttributeId.ATTRIB_CLASS);
        (switch (classstring.charAt(0)) {
            case 'o' -> new HighOther(this);
            case 'g' -> new HighGlobal(this);
            case 'l' -> new HighLocal(this);
            case 'p' -> new HighParam(this);
            case 'c' -> new HighConstant(this);
            default -> throw new DecoderException("Unknown HighVariable class string: " + classstring);
        }).decode(decoder);
        decoder.closeElement(el);
    }

    private void decodeHighlist(Decoder decoder) throws DecoderException {
        int el = decoder.openElement(ElementId.ELEM_HIGHLIST);
        while (decoder.peekElement() != 0) {
            this.decodeHigh(decoder);
        }
        decoder.closeElement(el);
    }

    @Override
    public void decode(Decoder decoder) throws DecoderException {
        int subel;
        int start = decoder.openElement(ElementId.ELEM_FUNCTION);
        String name = decoder.readString(AttributeId.ATTRIB_NAME);
        if (!this.func.getName().equals(name)) {
            throw new DecoderException("Function name mismatch: " + this.func.getName() + " + " + name);
        }
        while ((subel = decoder.peekElement()) != 0) {
            if (subel == ElementId.ELEM_ADDR.id()) {
                Address addr = AddressXML.decode(decoder);
                if (this.func.getEntryPoint().equals(addr)) continue;
                throw new DecoderException("Mismatched address in function tag");
            }
            if (subel == ElementId.ELEM_PROTOTYPE.id()) {
                this.proto.decodePrototype(decoder, this);
                continue;
            }
            if (subel == ElementId.ELEM_LOCALDB.id()) {
                this.localSymbols.decodeScope(decoder);
                continue;
            }
            if (subel == ElementId.ELEM_AST.id()) {
                super.decode(decoder);
                continue;
            }
            if (subel == ElementId.ELEM_HIGHLIST.id()) {
                this.decodeHighlist(decoder);
                continue;
            }
            if (subel == ElementId.ELEM_JUMPTABLELIST.id()) {
                this.decodeJumpTableList(decoder);
                continue;
            }
            if (subel == ElementId.ELEM_OVERRIDE.id()) {
                decoder.skipElement();
                continue;
            }
            if (subel == ElementId.ELEM_SCOPE.id()) {
                decoder.skipElement();
                continue;
            }
            throw new DecoderException("Unknown element in function");
        }
        decoder.closeElement(start);
    }

    private void decodeJumpTableList(Decoder decoder) throws DecoderException {
        int el = decoder.openElement(ElementId.ELEM_JUMPTABLELIST);
        while (decoder.peekElement() != 0) {
            JumpTable table = new JumpTable(this.func.getEntryPoint().getAddressSpace());
            table.decode(decoder);
            if (table.isEmpty()) continue;
            if (this.jumpTables == null) {
                this.jumpTables = new ArrayList<JumpTable>();
            }
            this.jumpTables.add(table);
        }
        decoder.closeElement(el);
    }

    protected Address getPCAddress(Varnode rep) {
        Address pcaddr = null;
        if (!rep.isAddrTied() && (pcaddr = rep.getPCAddress()) == Address.NO_ADDRESS) {
            try {
                pcaddr = this.func.getEntryPoint().add(-1L);
            }
            catch (AddressOutOfBoundsException e) {
                pcaddr = this.func.getEntryPoint();
            }
        }
        return pcaddr;
    }

    public HighVariable splitOutMergeGroup(HighVariable high, Varnode vn) throws PcodeException {
        try {
            HighVariable resremain;
            HighLocal reslocal;
            HighSymbol sym;
            Varnode[] curinst;
            ArrayList<Varnode> newinst = new ArrayList<Varnode>();
            ArrayList<Varnode> oldinst = new ArrayList<Varnode>();
            short ourgroup = vn.getMergeGroup();
            for (Varnode curvn : curinst = high.getInstances()) {
                if (curvn.getMergeGroup() == ourgroup) {
                    newinst.add(curvn);
                    continue;
                }
                oldinst.add(curvn);
            }
            if (oldinst.size() == 0) {
                return high;
            }
            if (!(high instanceof HighLocal)) {
                throw new PcodeException("Variable " + high.getName() + " is speculatively merged but not a local");
            }
            HighLocal highloc = (HighLocal)high;
            Varnode[] newinstarray = new Varnode[newinst.size()];
            newinst.toArray(newinstarray);
            Varnode[] oldinstarray = new Varnode[oldinst.size()];
            oldinst.toArray(oldinstarray);
            Varnode oldrep = high.getRepresentative();
            if (oldrep.getMergeGroup() == ourgroup) {
                if (high instanceof HighParam) {
                    return high;
                }
                vn = oldrep;
                oldrep = oldinstarray[0];
                sym = highloc.getSymbol();
                reslocal = new HighLocal(highloc.getDataType(), highloc.getRepresentative(), null, highloc.getPCAddress(), sym);
                resremain = new HighOther(highloc.getDataType(), new Varnode(oldrep.getAddress(), highloc.getSize()), null, oldrep.getPCAddress(), this);
            } else {
                sym = this.localSymbols.newMappedSymbol(0L, highloc.getName(), highloc.getDataType(), this.buildStorage(vn), vn.getPCAddress(), -1);
                reslocal = new HighLocal(highloc.getDataType(), vn, null, vn.getPCAddress(), sym);
                resremain = highloc;
            }
            sym.setHighVariable(reslocal);
            reslocal.attachInstances(newinstarray, vn);
            for (Varnode element : newinstarray) {
                ((VarnodeAST)element).setHigh(reslocal);
            }
            resremain.attachInstances(oldinstarray, oldrep);
            for (Varnode element : oldinstarray) {
                ((VarnodeAST)element).setHigh(resremain);
            }
            return reslocal;
        }
        catch (InvalidInputException e) {
            throw new DecoderException("Bad storage node", e);
        }
    }

    public void encode(Encoder encoder, long id, Namespace namespace, Address entryPoint, int size) throws IOException {
        boolean hasOverrideTag;
        encoder.openElement(ElementId.ELEM_FUNCTION);
        if (id != 0L) {
            encoder.writeUnsignedInteger(AttributeId.ATTRIB_ID, id);
        }
        encoder.writeString(AttributeId.ATTRIB_NAME, this.func.getName());
        encoder.writeSignedInteger(AttributeId.ATTRIB_SIZE, size);
        if (this.func.isInline()) {
            encoder.writeBool(AttributeId.ATTRIB_INLINE, true);
        }
        if (this.func.hasNoReturn()) {
            encoder.writeBool(AttributeId.ATTRIB_NORETURN, true);
        }
        if (entryPoint == null) {
            AddressXML.encode(encoder, this.func.getEntryPoint());
        } else {
            AddressXML.encode(encoder, entryPoint);
        }
        this.localSymbols.encodeLocalDb(encoder, namespace);
        this.proto.encodePrototype(encoder, this.getDataTypeManager());
        if (this.jumpTables != null && this.jumpTables.size() > 0) {
            encoder.openElement(ElementId.ELEM_JUMPTABLELIST);
            for (JumpTable jumpTable : this.jumpTables) {
                jumpTable.encode(encoder);
            }
            encoder.closeElement(ElementId.ELEM_JUMPTABLELIST);
        }
        boolean bl = hasOverrideTag = this.protoOverrides != null && this.protoOverrides.size() > 0;
        if (hasOverrideTag) {
            encoder.openElement(ElementId.ELEM_OVERRIDE);
            PcodeDataTypeManager dtmanage = this.getDataTypeManager();
            for (DataTypeSymbol sym : this.protoOverrides) {
                Address addr = sym.getAddress();
                FunctionPrototype fproto = new FunctionPrototype((FunctionSignature)((Object)sym.getDataType()), this.compilerSpec, false);
                encoder.openElement(ElementId.ELEM_PROTOOVERRIDE);
                AddressXML.encode(encoder, addr);
                fproto.encodePrototype(encoder, dtmanage);
                encoder.closeElement(ElementId.ELEM_PROTOOVERRIDE);
            }
            encoder.closeElement(ElementId.ELEM_OVERRIDE);
        }
        encoder.closeElement(ElementId.ELEM_FUNCTION);
    }

    @Override
    public void setVolatile(Varnode vn, boolean val) {
        if (val) {
            this.globalSymbols.populateAnnotation(vn);
        }
    }

    public static Namespace findOverrideSpace(Function func) {
        SymbolTable symtab = func.getProgram().getSymbolTable();
        return HighFunction.findNamespace(symtab, func, "override");
    }

    public static Namespace findCreateOverrideSpace(Function func) {
        SymbolTable symtab = func.getProgram().getSymbolTable();
        return HighFunction.findCreateNamespace(symtab, func, "override");
    }

    public static Namespace findNamespace(SymbolTable symtab, Namespace parent, String name) {
        return symtab.getNamespace(name, parent);
    }

    public static void createLabelSymbol(SymbolTable symtab, Address addr, String name, Namespace namespace, SourceType source, boolean useLocalNamespace) throws InvalidInputException {
        if (namespace == null && useLocalNamespace) {
            namespace = symtab.getNamespace(addr);
        }
        symtab.createLabel(addr, name, namespace, source);
    }

    public static void deleteSymbol(SymbolTable symtab, Address addr, String name, Namespace space) throws InvalidInputException {
        Symbol s = symtab.getSymbol(name, addr, space);
        if (s == null) {
            throw new InvalidInputException("Symbol " + name + " not found!");
        }
        if (s.getSource() == SourceType.DEFAULT) {
            throw new InvalidInputException("Deleting the default symbol \"" + name + "\" @ " + addr + " is not allowed.");
        }
        boolean success = symtab.removeSymbolSpecial(s);
        if (!success) {
            throw new InvalidInputException("Couldn't delete the symbol \"" + name + "\" @ " + addr + ".");
        }
    }

    public static boolean clearNamespace(SymbolTable symtab, Namespace space) throws InvalidInputException {
        SymbolIterator iter = symtab.getSymbols(space);
        ArrayList<Address> addrlist = new ArrayList<Address>();
        ArrayList<String> namelist = new ArrayList<String>();
        while (iter.hasNext()) {
            Symbol sym = iter.next();
            if (!(sym instanceof CodeSymbol)) {
                return false;
            }
            addrlist.add(sym.getAddress());
            namelist.add(sym.getName());
        }
        for (int i = 0; i < addrlist.size(); ++i) {
            HighFunction.deleteSymbol(symtab, (Address)addrlist.get(i), (String)namelist.get(i), space);
        }
        return true;
    }

    public static Namespace findCreateNamespace(SymbolTable symtab, Namespace parentspace, String name) {
        Namespace res = HighFunction.findNamespace(symtab, parentspace, name);
        if (res == null) {
            try {
                return symtab.createNameSpace(parentspace, name, SourceType.USER_DEFINED);
            }
            catch (DuplicateNameException e) {
                return null;
            }
            catch (InvalidInputException e) {
                return null;
            }
        }
        return res;
    }

    public static final boolean collapseToGlobal(Namespace namespace) {
        return namespace instanceof Library;
    }

    public static void encodeNamespace(Encoder encoder, Namespace namespace) throws IOException {
        encoder.openElement(ElementId.ELEM_PARENT);
        if (namespace != null) {
            ArrayList<Namespace> arr = new ArrayList<Namespace>();
            for (Namespace curspc = namespace; curspc != null; curspc = curspc.getParentNamespace()) {
                arr.add(0, curspc);
                if (HighFunction.collapseToGlobal(curspc)) break;
            }
            encoder.openElement(ElementId.ELEM_VAL);
            encoder.closeElement(ElementId.ELEM_VAL);
            for (int i = 1; i < arr.size(); ++i) {
                Namespace curScope = (Namespace)arr.get(i);
                encoder.openElement(ElementId.ELEM_VAL);
                encoder.writeUnsignedInteger(AttributeId.ATTRIB_ID, curScope.getID());
                encoder.writeString(AttributeId.ATTRIB_CONTENT, curScope.getName());
                encoder.closeElement(ElementId.ELEM_VAL);
            }
        }
        encoder.closeElement(ElementId.ELEM_PARENT);
    }

    public static String tagFindExclude(String tagname, String doc) {
        if (doc == null) {
            return null;
        }
        int length = tagname.length();
        int bindex = doc.indexOf("<" + tagname);
        if (bindex == -1) {
            return null;
        }
        if (bindex + length + 3 > doc.length()) {
            return null;
        }
        if (doc.charAt(bindex + length + 1) == '/') {
            return "";
        }
        int eindex = doc.indexOf("</" + tagname + ">");
        if (eindex == -1) {
            return null;
        }
        return doc.substring(bindex + length + 2, eindex);
    }
}

