/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.LocalSymbolMap;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import java.io.IOException;

public class FunctionPrototype {
    private LocalSymbolMap localsyms;
    private String modelname;
    private GenericCallingConvention gconv;
    private String injectname;
    private DataType returntype;
    private VariableStorage returnstorage;
    private ParameterDefinition[] params;
    private boolean modellock;
    private boolean voidinputlock;
    private boolean outputlock;
    private boolean dotdotdot;
    private int extrapop;
    private boolean isinline;
    private boolean noreturn;
    private boolean custom;
    private boolean hasThis;
    private boolean isConstruct;
    private boolean isDestruct;

    public FunctionPrototype(LocalSymbolMap ls, Function func) {
        this.localsyms = ls;
        this.modelname = null;
        this.gconv = null;
        this.injectname = null;
        this.returntype = null;
        this.returnstorage = null;
        this.params = null;
        this.modellock = false;
        this.voidinputlock = false;
        this.outputlock = false;
        this.dotdotdot = func.hasVarArgs();
        this.isinline = func.isInline();
        this.noreturn = func.hasNoReturn();
        this.custom = func.hasCustomVariableStorage();
        this.hasThis = false;
        this.isConstruct = false;
        this.isDestruct = false;
        this.extrapop = 32768;
    }

    public FunctionPrototype(FunctionSignature proto, CompilerSpec cspec, boolean voidimpliesdotdotdot) {
        this.modelname = proto.getGenericCallingConvention().getDeclarationName();
        PrototypeModel model = cspec.matchConvention(proto.getGenericCallingConvention());
        this.localsyms = null;
        this.gconv = proto.getGenericCallingConvention();
        this.injectname = null;
        this.returntype = proto.getReturnType();
        this.returnstorage = null;
        this.params = proto.getArguments();
        this.modellock = true;
        this.voidinputlock = this.params == null || this.params.length == 0;
        this.outputlock = true;
        this.dotdotdot = proto.hasVarArgs();
        this.isinline = false;
        this.noreturn = false;
        this.custom = false;
        this.extrapop = model.getExtrapop();
        this.hasThis = model.hasThisPointer();
        this.isConstruct = false;
        this.isDestruct = false;
        if (voidimpliesdotdotdot && this.voidinputlock) {
            this.dotdotdot = true;
        }
    }

    void grabFromFunction(Function f, int overrideExtrapop, boolean doOverride) {
        this.modelname = f.getCallingConventionName();
        PrototypeModel protoModel = f.getCallingConvention();
        if (protoModel == null) {
            protoModel = f.getProgram().getCompilerSpec().getDefaultCallingConvention();
        }
        this.hasThis = protoModel.hasThisPointer();
        this.modellock = this.modelname != null && this.modelname != "unknown";
        this.injectname = f.getCallFixup();
        this.voidinputlock = false;
        Parameter returnparam = f.getReturn();
        this.returntype = returnparam.getDataType();
        this.returnstorage = returnparam.getVariableStorage();
        SourceType sigSource = f.getSignatureSource();
        this.outputlock = sigSource != SourceType.DEFAULT ? DataType.DEFAULT != this.returntype : false;
        if (this.returnstorage == null || !this.returnstorage.isValid()) {
            this.outputlock = false;
            this.returnstorage = VariableStorage.VOID_STORAGE;
            this.returntype = VoidDataType.dataType;
        }
        this.voidinputlock = f.getSignatureSource() != SourceType.DEFAULT && f.getParameterCount() == 0;
        this.dotdotdot = f.hasVarArgs();
        this.isinline = f.isInline();
        this.noreturn = f.hasNoReturn() | this.isNoReturnInjection(f, this.injectname);
        this.custom = f.hasCustomVariableStorage();
        int purge = f.getStackPurgeSize();
        this.extrapop = doOverride ? overrideExtrapop : (purge == 0x7FFFFFFE || purge == Integer.MAX_VALUE ? protoModel.getExtrapop() : purge + protoModel.getStackshift());
    }

    private boolean isNoReturnInjection(Function f, String fixupname) {
        if (fixupname == null) {
            return false;
        }
        Program program = f.getProgram();
        InjectPayload callFixup = program.getCompilerSpec().getPcodeInjectLibrary().getPayload(1, fixupname);
        if (callFixup == null) {
            return false;
        }
        return !callFixup.isFallThru();
    }

    public int getNumParams() {
        if (this.localsyms != null) {
            return this.localsyms.getNumParams();
        }
        return this.params.length;
    }

    public HighSymbol getParam(int i) {
        if (this.localsyms != null) {
            return this.localsyms.getParamSymbol(i);
        }
        return null;
    }

    public ParameterDefinition[] getParameterDefinitions() {
        return this.params != null ? (ParameterDefinition[])this.params.clone() : null;
    }

    public boolean isBackedByLocalSymbolMap() {
        return this.localsyms != null;
    }

    public DataType getReturnType() {
        return this.returntype;
    }

    public VariableStorage getReturnStorage() {
        return this.returnstorage;
    }

    public int getExtraPop() {
        return this.extrapop;
    }

    public boolean isVarArg() {
        return this.dotdotdot;
    }

    public boolean isInline() {
        return this.isinline;
    }

    public boolean hasNoReturn() {
        return this.noreturn;
    }

    public boolean hasThisPointer() {
        return this.hasThis;
    }

    public boolean isConstructor() {
        return this.isConstruct;
    }

    public boolean isDestructor() {
        return this.isDestruct;
    }

    public String getModelName() {
        return this.modelname;
    }

    public GenericCallingConvention getGenericCallingConvention() {
        return this.gconv;
    }

    public void encodePrototype(Encoder encoder, PcodeDataTypeManager dtmanage) throws IOException {
        int sz;
        encoder.openElement(ElementId.ELEM_PROTOTYPE);
        if (this.extrapop == 32768) {
            encoder.writeString(AttributeId.ATTRIB_EXTRAPOP, "unknown");
        } else {
            encoder.writeSignedInteger(AttributeId.ATTRIB_EXTRAPOP, this.extrapop);
        }
        encoder.writeString(AttributeId.ATTRIB_MODEL, this.modelname);
        if (this.modellock) {
            encoder.writeBool(AttributeId.ATTRIB_MODELLOCK, this.modellock);
        }
        if (this.dotdotdot) {
            encoder.writeBool(AttributeId.ATTRIB_DOTDOTDOT, this.dotdotdot);
        }
        if (this.voidinputlock) {
            encoder.writeBool(AttributeId.ATTRIB_VOIDLOCK, this.voidinputlock);
        }
        if (this.isinline) {
            encoder.writeBool(AttributeId.ATTRIB_INLINE, this.isinline);
        }
        if (this.noreturn) {
            encoder.writeBool(AttributeId.ATTRIB_NORETURN, this.noreturn);
        }
        if (this.custom) {
            encoder.writeBool(AttributeId.ATTRIB_CUSTOM, this.custom);
        }
        if (this.isConstruct) {
            encoder.writeBool(AttributeId.ATTRIB_CONSTRUCTOR, this.isConstruct);
        }
        if (this.isDestruct) {
            encoder.writeBool(AttributeId.ATTRIB_DESTRUCTOR, this.isDestruct);
        }
        encoder.openElement(ElementId.ELEM_RETURNSYM);
        if (this.outputlock) {
            encoder.writeBool(AttributeId.ATTRIB_TYPELOCK, this.outputlock);
        }
        if ((sz = this.returntype.getLength()) < 0) {
            Msg.warn((Object)this, (Object)"Bad returntype size");
            sz = 1;
        }
        if (this.returnstorage != null && this.returnstorage.isValid() && !this.returnstorage.isVoidStorage()) {
            int logicalsize = 0;
            if (sz != this.returnstorage.size()) {
                logicalsize = sz;
            }
            AddressXML.encode(encoder, this.returnstorage.getVarnodes(), (long)logicalsize);
        } else {
            encoder.openElement(ElementId.ELEM_ADDR);
            encoder.closeElement(ElementId.ELEM_ADDR);
        }
        dtmanage.encodeTypeRef(encoder, this.returntype, sz);
        encoder.closeElement(ElementId.ELEM_RETURNSYM);
        if (this.injectname != null) {
            encoder.openElement(ElementId.ELEM_INJECT);
            encoder.writeString(AttributeId.ATTRIB_CONTENT, this.injectname);
            encoder.closeElement(ElementId.ELEM_INJECT);
        }
        if (this.params != null) {
            encoder.openElement(ElementId.ELEM_INTERNALLIST);
            for (ParameterDefinition param : this.params) {
                encoder.openElement(ElementId.ELEM_PARAM);
                String name = param.getName();
                DataType dt = param.getDataType();
                boolean namelock = false;
                if (name != null && name.length() > 0) {
                    encoder.writeString(AttributeId.ATTRIB_NAME, name);
                    namelock = true;
                }
                encoder.writeBool(AttributeId.ATTRIB_TYPELOCK, true);
                encoder.writeBool(AttributeId.ATTRIB_NAMELOCK, namelock);
                encoder.openElement(ElementId.ELEM_ADDR);
                encoder.closeElement(ElementId.ELEM_ADDR);
                sz = dt.getLength();
                if (sz < 0) {
                    sz = 1;
                }
                dtmanage.encodeTypeRef(encoder, dt, sz);
                encoder.closeElement(ElementId.ELEM_PARAM);
            }
            encoder.closeElement(ElementId.ELEM_INTERNALLIST);
        }
        encoder.closeElement(ElementId.ELEM_PROTOTYPE);
    }

    public void decodePrototype(Decoder decoder, PcodeFactory pcodeFactory) throws DecoderException {
        int attribId;
        int attribId2;
        PcodeDataTypeManager dtmanage = pcodeFactory.getDataTypeManager();
        int node = decoder.openElement(ElementId.ELEM_PROTOTYPE);
        this.modelname = decoder.readString(AttributeId.ATTRIB_MODEL);
        PrototypeModel protoModel = dtmanage.getProgram().getCompilerSpec().getCallingConvention(this.modelname);
        this.hasThis = protoModel == null ? false : protoModel.hasThisPointer();
        try {
            this.extrapop = (int)decoder.readSignedInteger(AttributeId.ATTRIB_EXTRAPOP);
        }
        catch (DecoderException e) {
            this.extrapop = 32768;
        }
        this.modellock = false;
        this.dotdotdot = false;
        this.voidinputlock = false;
        this.isinline = false;
        this.noreturn = false;
        this.custom = false;
        this.isConstruct = false;
        this.isDestruct = false;
        while ((attribId2 = decoder.getNextAttributeId()) != 0) {
            if (attribId2 == AttributeId.ATTRIB_MODELLOCK.id()) {
                this.modellock = decoder.readBool();
                continue;
            }
            if (attribId2 == AttributeId.ATTRIB_DOTDOTDOT.id()) {
                this.dotdotdot = decoder.readBool();
                continue;
            }
            if (attribId2 == AttributeId.ATTRIB_VOIDLOCK.id()) {
                this.voidinputlock = decoder.readBool();
                continue;
            }
            if (attribId2 == AttributeId.ATTRIB_INLINE.id()) {
                this.isinline = decoder.readBool();
                continue;
            }
            if (attribId2 == AttributeId.ATTRIB_NORETURN.id()) {
                this.noreturn = decoder.readBool();
                continue;
            }
            if (attribId2 == AttributeId.ATTRIB_CUSTOM.id()) {
                this.custom = decoder.readBool();
                continue;
            }
            if (attribId2 == AttributeId.ATTRIB_CONSTRUCTOR.id()) {
                this.isConstruct = decoder.readBool();
                continue;
            }
            if (attribId2 != AttributeId.ATTRIB_DESTRUCTOR.id()) continue;
            this.isDestruct = decoder.readBool();
        }
        int retel = decoder.openElement(ElementId.ELEM_RETURNSYM);
        this.outputlock = false;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId != AttributeId.ATTRIB_TYPELOCK.id()) continue;
            this.outputlock = decoder.readBool();
        }
        int addrel = decoder.openElement(ElementId.ELEM_ADDR);
        this.returnstorage = AddressXML.decodeStorageFromAttributes(-1, decoder, pcodeFactory);
        decoder.closeElement(addrel);
        this.returntype = dtmanage.decodeDataType(decoder);
        decoder.closeElement(retel);
        decoder.closeElementSkipping(node);
    }
}

