/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.AddressSpaceSettingsDefinition;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.ComponentOffsetSettingsDefinition;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.GenericDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.PointerType;
import ghidra.program.model.data.PointerTypeSettingsDefinition;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.UniversalID;
import ghidra.util.UniversalIdGenerator;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PointerTypedef
extends GenericDataType
implements TypeDef {
    private boolean isAutoNamed;
    private TypedefDataType modelTypedef;
    private UniversalID universalId = UniversalIdGenerator.nextID();

    public PointerTypedef(String typeDefName, DataType referencedDataType, int pointerSize, DataTypeManager dtm, AddressSpace space) {
        this(typeDefName, referencedDataType, PointerTypedef.getPreferredPointerSize(pointerSize, dtm, space), dtm);
        AddressSpaceSettingsDefinition.DEF.setValue(this.getDefaultSettings(), space.getName());
    }

    public PointerTypedef(String typeDefName, DataType referencedDataType, int pointerSize, DataTypeManager dtm, PointerType type) {
        this(typeDefName, referencedDataType, pointerSize, dtm);
        Objects.requireNonNull(type, "Pointer type required");
        PointerTypeSettingsDefinition.DEF.setType(this.getDefaultSettings(), type);
    }

    public PointerTypedef(String typeDefName, DataType referencedDataType, int pointerSize, DataTypeManager dtm, long componentOffset) {
        this(typeDefName, referencedDataType, pointerSize, dtm);
        ComponentOffsetSettingsDefinition.DEF.setValue(this.getDefaultSettings(), componentOffset);
    }

    public PointerTypedef(String typeDefName, DataType referencedDataType, int pointerSize, DataTypeManager dtm) {
        super(PointerTypedef.getCategoryPath(referencedDataType), PointerTypedef.getTempNameIfNeeded(typeDefName), dtm);
        this.isAutoNamed = StringUtils.isBlank((CharSequence)typeDefName);
        this.modelTypedef = new TypedefDataType("TEMP", new PointerDataType(referencedDataType, pointerSize, dtm));
    }

    public PointerTypedef(String typeDefName, Pointer pointerDataType, DataTypeManager dtm) {
        super(pointerDataType.getCategoryPath(), PointerTypedef.getTempNameIfNeeded(typeDefName), dtm);
        this.isAutoNamed = StringUtils.isBlank((CharSequence)typeDefName);
        this.modelTypedef = new TypedefDataType("TEMP", pointerDataType.clone(dtm));
    }

    private static CategoryPath getCategoryPath(DataType referencedDataType) {
        return referencedDataType != null ? referencedDataType.getCategoryPath() : CategoryPath.ROOT;
    }

    private static String getTempNameIfNeeded(String baseName) {
        return StringUtils.isBlank((CharSequence)baseName) ? "TEMP" : baseName;
    }

    private static int getPreferredPointerSize(int pointerSize, DataTypeManager dtm, AddressSpace space) {
        Objects.requireNonNull(space, "Address space must be specified");
        if (pointerSize > 0) {
            return pointerSize;
        }
        pointerSize = space.getSize() / 8;
        if (dtm.getDataOrganization().getPointerSize() == pointerSize) {
            pointerSize = -1;
        }
        return pointerSize;
    }

    @Override
    public void enableAutoNaming() {
        this.isAutoNamed = true;
    }

    @Override
    public boolean isAutoNamed() {
        return this.isAutoNamed;
    }

    protected DataType getReferencedDataType() {
        Pointer ptrType = (Pointer)this.getDataType();
        return ptrType.getDataType();
    }

    @Override
    public UniversalID getUniversalID() {
        return this.universalId;
    }

    @Override
    public boolean isEquivalent(DataType obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof TypeDef)) {
            return false;
        }
        TypeDef td = (TypeDef)obj;
        if (!DataTypeUtilities.equalsIgnoreConflict(this.getName(), td.getName())) {
            return false;
        }
        if (!this.hasSameTypeDefSettings(td)) {
            return false;
        }
        return DataTypeUtilities.isSameOrEquivalentDataType(this.getDataType(), td.getDataType());
    }

    @Override
    public String getDescription() {
        return "Pointer-Typedef";
    }

    @Override
    public String getName() {
        if (this.isAutoNamed) {
            return TypedefDataType.generateTypedefName(this);
        }
        return super.getName();
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return this.modelTypedef.hasLanguageDependantLength();
    }

    @Override
    public int getLength() {
        return this.modelTypedef.getLength();
    }

    @Override
    public DataType getDataType() {
        return this.modelTypedef.getDataType();
    }

    @Override
    public DataType getBaseDataType() {
        return this.modelTypedef.getBaseDataType();
    }

    @Override
    public SettingsDefinition[] getSettingsDefinitions() {
        return this.modelTypedef.getSettingsDefinitions();
    }

    @Override
    public TypeDefSettingsDefinition[] getTypeDefSettingsDefinitions() {
        return this.modelTypedef.getTypeDefSettingsDefinitions();
    }

    @Override
    public Settings getDefaultSettings() {
        return this.modelTypedef.getDefaultSettings();
    }

    @Override
    public boolean dependsOn(DataType dt) {
        DataType myDt = this.getDataType();
        return myDt == dt || myDt.dependsOn(dt);
    }

    @Override
    public String toString() {
        if (this.isAutoNamed) {
            return this.getClass().getSimpleName() + ": " + this.getName();
        }
        return this.getClass().getSimpleName() + ": typedef " + this.getName() + " " + this.getDataType().getName();
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return this.modelTypedef.getValueClass(settings);
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return this.modelTypedef.getValue(buf, settings, length);
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return this.modelTypedef.getRepresentation(buf, settings, length);
    }

    @Override
    public PointerTypedef clone(DataTypeManager dtm) {
        if (this.dataMgr == dtm) {
            return this;
        }
        return this.copy(dtm);
    }

    @Override
    public PointerTypedef copy(DataTypeManager dtm) {
        Pointer ptrType = (Pointer)this.getDataType();
        String n = this.isAutoNamed ? null : this.getName();
        PointerTypedef td = new PointerTypedef(n, ptrType, this.getDataTypeManager());
        TypedefDataType.copyTypeDefSettings(this, td, false);
        return td;
    }
}

