/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.NumberSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import java.math.BigInteger;

public class ComponentOffsetSettingsDefinition
implements NumberSettingsDefinition,
TypeDefSettingsDefinition {
    private static final String COMPONENT_OFFSET_SETTING_NAME = "component_offset";
    private static final String DESCRIPTION = "Identifies a component offset to be applied to a pointer reference";
    private static final String DISPLAY_NAME = "Component Offset";
    private static BigInteger MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final int DEFAULT = 0;
    public static final ComponentOffsetSettingsDefinition DEF = new ComponentOffsetSettingsDefinition();

    private ComponentOffsetSettingsDefinition() {
    }

    public BigInteger getMaxValue() {
        return MAX_VALUE;
    }

    public boolean allowNegativeValue() {
        return true;
    }

    public boolean isHexModePreferred() {
        return false;
    }

    public long getValue(Settings settings) {
        if (settings == null) {
            return 0L;
        }
        Long value = settings.getLong(COMPONENT_OFFSET_SETTING_NAME);
        if (value == null) {
            return 0L;
        }
        return value;
    }

    public void setValue(Settings settings, long value) {
        if (value == 0L) {
            settings.clearSetting(COMPONENT_OFFSET_SETTING_NAME);
        } else {
            settings.setLong(COMPONENT_OFFSET_SETTING_NAME, value);
        }
    }

    public boolean hasValue(Settings settings) {
        return this.getValue(settings) != 0L;
    }

    public String getName() {
        return DISPLAY_NAME;
    }

    public String getStorageKey() {
        return COMPONENT_OFFSET_SETTING_NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public void clear(Settings settings) {
        settings.clearSetting(COMPONENT_OFFSET_SETTING_NAME);
    }

    public void copySetting(Settings srcSettings, Settings destSettings) {
        Long value = srcSettings.getLong(COMPONENT_OFFSET_SETTING_NAME);
        if (value == null) {
            destSettings.clearSetting(COMPONENT_OFFSET_SETTING_NAME);
        } else {
            destSettings.setLong(COMPONENT_OFFSET_SETTING_NAME, value.longValue());
        }
    }

    @Override
    public String getAttributeSpecification(Settings settings) {
        if (this.hasValue(settings)) {
            long offset = this.getValue(settings);
            return "offset(0x" + Long.toHexString(offset) + ")";
        }
        return null;
    }
}

