/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.StringSettingsDefinition;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class AddressSpaceSettingsDefinition
implements StringSettingsDefinition,
TypeDefSettingsDefinition {
    private static final String ADDRESS_SPACE_SETTING_NAME = "addr_space_name";
    private static final String DESCRIPTION = "Identifies the referenced address space name (case-sensitive; ignored if no match)";
    private static final String DISPLAY_NAME = "Address Space";
    private static final String DEFAULT = null;
    public static final AddressSpaceSettingsDefinition DEF = new AddressSpaceSettingsDefinition();

    private AddressSpaceSettingsDefinition() {
    }

    public String getValue(Settings settings) {
        if (settings == null) {
            return DEFAULT;
        }
        String value = settings.getString(ADDRESS_SPACE_SETTING_NAME);
        if (value == null) {
            return DEFAULT;
        }
        return value;
    }

    public void setValue(Settings settings, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            settings.clearSetting(ADDRESS_SPACE_SETTING_NAME);
        } else {
            settings.setString(ADDRESS_SPACE_SETTING_NAME, value);
        }
    }

    public boolean hasValue(Settings settings) {
        return this.getValue(settings) != DEFAULT;
    }

    public String getName() {
        return DISPLAY_NAME;
    }

    public String getStorageKey() {
        return ADDRESS_SPACE_SETTING_NAME;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public void clear(Settings settings) {
        settings.clearSetting(ADDRESS_SPACE_SETTING_NAME);
    }

    public void copySetting(Settings srcSettings, Settings destSettings) {
        String value = srcSettings.getString(ADDRESS_SPACE_SETTING_NAME);
        if (value == null) {
            destSettings.clearSetting(ADDRESS_SPACE_SETTING_NAME);
        } else {
            destSettings.setString(ADDRESS_SPACE_SETTING_NAME, value);
        }
    }

    @Override
    public String getAttributeSpecification(Settings settings) {
        String spaceName = this.getValue(settings);
        if (!StringUtils.isBlank((CharSequence)spaceName)) {
            return "space(" + spaceName + ")";
        }
        return null;
    }

    public String[] getSuggestedValues(Settings settings) {
        return settings.getSuggestedValues((StringSettingsDefinition)this);
    }

    public boolean supportsSuggestedValues() {
        return true;
    }

    public boolean addPreferredValues(Object settingsOwner, Set<String> set) {
        if (settingsOwner instanceof ProgramBasedDataTypeManager) {
            ProgramBasedDataTypeManager dtm = (ProgramBasedDataTypeManager)settingsOwner;
            AddressFactory addressFactory = dtm.getProgram().getAddressFactory();
            for (AddressSpace space : addressFactory.getAllAddressSpaces()) {
                if (!space.isLoadedMemorySpace()) continue;
                set.add(space.getName());
            }
            return true;
        }
        return false;
    }
}

