/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.pcode.floatformat.BigFloat;
import ghidra.pcode.floatformat.FloatFormat;
import ghidra.pcode.floatformat.FloatFormatFactory;
import ghidra.pcode.floatformat.UnsupportedFloatFormatException;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeEncodeException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.Float10DataType;
import ghidra.program.model.data.Float16DataType;
import ghidra.program.model.data.Float2DataType;
import ghidra.program.model.data.Float4DataType;
import ghidra.program.model.data.Float8DataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.LongDoubleDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.mem.MemBuffer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.TreeMap;

public abstract class AbstractFloatDataType
extends BuiltIn {
    private static final long serialVersionUID = 1L;
    private static SettingsDefinition[] SETTINGS_DEFS = new SettingsDefinition[0];
    private static TreeMap<Integer, AbstractFloatDataType> floatTypes;

    public AbstractFloatDataType(String name, DataTypeManager dtm) {
        super(null, name, dtm);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.name;
    }

    @Override
    public String getDescription() {
        return "IEEE-754 Float";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        try {
            int len = this.getLength();
            FloatFormat floatFormat = FloatFormatFactory.getFloatFormat(len);
            byte[] bytes = new byte[len];
            if (buf.getBytes(bytes, 0) != len) {
                return null;
            }
            if (len <= 8) {
                long value = Utils.bytesToLong(bytes, len, buf.isBigEndian());
                double doubleValue = floatFormat.getHostFloat(value);
                switch (len) {
                    case 2: {
                        return (short)doubleValue;
                    }
                    case 4: {
                        return Float.valueOf((float)doubleValue);
                    }
                }
                return doubleValue;
            }
            BigInteger value = Utils.bytesToBigInteger(bytes, len, buf.isBigEndian(), false);
            BigDecimal decValue = floatFormat.round(floatFormat.getHostFloat(value));
            return decValue;
        }
        catch (UnsupportedFloatFormatException e) {
            return null;
        }
    }

    @Override
    public boolean isEncodable() {
        int length = this.getLength();
        return length == 4 || length == 8;
    }

    @Override
    public byte[] encodeValue(Object value, MemBuffer buf, Settings settings, int length) throws DataTypeEncodeException {
        try {
            int len = this.getLength();
            if (length != -1 && length != len) {
                throw new DataTypeEncodeException("Length mismatch", value, this);
            }
            FloatFormat floatFormat = FloatFormatFactory.getFloatFormat(len);
            if (len == 8 || len == 4) {
                if (!(value instanceof Number)) {
                    throw new DataTypeEncodeException("length-" + len + " float requires Number type", value, this);
                }
                double doubleValue = ((Number)value).doubleValue();
                long encoding = floatFormat.getEncoding(doubleValue);
                return Utils.longToBytes(encoding, len, buf.isBigEndian());
            }
            if (!(value instanceof BigFloat)) {
                throw new DataTypeEncodeException("non-standard float length requires BigFloat type", value, this);
            }
            BigInteger encoding = floatFormat.getEncoding((BigFloat)value);
            return Utils.bigIntegerToBytes(encoding, len, buf.isBigEndian());
        }
        catch (DataTypeEncodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataTypeEncodeException(value, this, e);
        }
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        Object obj = this.getValue(buf, settings, length);
        if (obj == null) {
            return "??";
        }
        return obj.toString();
    }

    @Override
    public byte[] encodeRepresentation(String repr, MemBuffer buf, Settings settings, int length) throws DataTypeEncodeException {
        try {
            int len = this.getLength();
            if (length != -1 && length != len) {
                throw new DataTypeEncodeException("Length mismatch", repr, this);
            }
            if (length == 8 || length == 4) {
                double doubleValue = Double.parseDouble(repr);
                return this.encodeValue(doubleValue, buf, settings, length);
            }
            throw new DataTypeEncodeException("Cannot yet parse values of non-standard float length", repr, this);
        }
        catch (DataTypeEncodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataTypeEncodeException((Object)repr, this, e);
        }
    }

    @Override
    protected SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return SETTINGS_DEFS;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return this.name.toUpperCase();
    }

    @Override
    public String getCTypeDeclaration(DataOrganization dataOrganization) {
        return this.hasLanguageDependantLength() ? null : this.name;
    }

    private static synchronized TreeMap<Integer, AbstractFloatDataType> getFloatTypes() {
        if (floatTypes == null) {
            floatTypes = new TreeMap();
            floatTypes.put(2, Float2DataType.dataType);
            floatTypes.put(4, Float4DataType.dataType);
            floatTypes.put(8, Float8DataType.dataType);
            floatTypes.put(10, Float10DataType.dataType);
            floatTypes.put(16, Float16DataType.dataType);
        }
        return floatTypes;
    }

    public static DataType getFloatDataType(int size, DataTypeManager dtm) {
        DataType dt;
        DataOrganization dataOrganization;
        if (size < 1) {
            return DefaultDataType.dataType;
        }
        if (dtm != null && (dataOrganization = dtm.getDataOrganization()) != null) {
            if (size == dataOrganization.getFloatSize()) {
                return FloatDataType.dataType.clone(dtm);
            }
            if (size == dataOrganization.getDoubleSize()) {
                return DoubleDataType.dataType.clone(dtm);
            }
            if (size == dataOrganization.getLongDoubleSize()) {
                return LongDoubleDataType.dataType.clone(dtm);
            }
        }
        if ((dt = (DataType)AbstractFloatDataType.getFloatTypes().get(size)) == null) {
            return Undefined.getUndefinedDataType(size);
        }
        return dt;
    }

    public static AbstractFloatDataType[] getFloatDataTypes(DataTypeManager dtm) {
        DataOrganization dataOrganization;
        TreeMap<Integer, AbstractFloatDataType> floatMap = AbstractFloatDataType.getFloatTypes();
        TreeMap<Integer, AbstractFloatDataType> newFloatMap = floatMap;
        if (dtm != null && (dataOrganization = dtm.getDataOrganization()) != null) {
            newFloatMap = new TreeMap();
            newFloatMap.put(dataOrganization.getFloatSize(), (AbstractFloatDataType)FloatDataType.dataType.clone(dtm));
            if (!newFloatMap.containsKey(dataOrganization.getDoubleSize())) {
                newFloatMap.put(dataOrganization.getDoubleSize(), (AbstractFloatDataType)DoubleDataType.dataType.clone(dtm));
            }
            if (!newFloatMap.containsKey(dataOrganization.getLongDoubleSize())) {
                newFloatMap.put(dataOrganization.getLongDoubleSize(), (AbstractFloatDataType)LongDoubleDataType.dataType.clone(dtm));
            }
            for (int size : floatMap.keySet()) {
                if (newFloatMap.containsKey(size)) continue;
                newFloatMap.put(size, (AbstractFloatDataType)floatMap.get(size).clone(dtm));
            }
        }
        AbstractFloatDataType[] floatTypeArray = new AbstractFloatDataType[newFloatMap.size()];
        newFloatMap.values().toArray(floatTypeArray);
        return floatTypeArray;
    }
}

