/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.register;

import db.DBHandle;
import db.Table;
import db.util.ErrorHandler;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.code.CodeManager;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.register.DatabaseRangeMapAdapter;
import ghidra.program.database.register.OldProgramContextDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.util.AbstractStoredProgramContext;
import ghidra.program.util.LanguageTranslator;
import ghidra.program.util.RangeMapAdapter;
import ghidra.program.util.RegisterValueStore;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;

public class ProgramRegisterContextDB
extends AbstractStoredProgramContext
implements ManagerDB {
    private DBHandle dbHandle;
    private ErrorHandler errorHandler;
    private Lock lock;
    private ProgramDB program;
    private AddressMap addrMap;
    private boolean changing = false;

    public ProgramRegisterContextDB(DBHandle dbHandle, ErrorHandler errHandler, Language lang, CompilerSpec compilerSpec, AddressMap addrMap, Lock lock, int openMode, CodeManager codeMgr, TaskMonitor monitor) throws VersionException, CancelledException {
        super(lang);
        boolean upgrade;
        this.addrMap = addrMap;
        this.dbHandle = dbHandle;
        this.errorHandler = errHandler;
        this.lock = lock;
        boolean oldContextDataExists = OldProgramContextDB.oldContextDataExists(dbHandle);
        boolean bl = upgrade = oldContextDataExists && !ProgramRegisterContextDB.contextDataExists(dbHandle);
        if (openMode != 3 && upgrade) {
            throw new VersionException(true);
        }
        this.registerValueMap = new HashMap();
        this.defaultRegisterValueMap = new HashMap();
        this.initializeDefaultValues(lang, compilerSpec);
        this.initializedCurrentValues();
        if (upgrade) {
            this.upgrade(addrMap, monitor);
        }
        if (openMode == 3 && oldContextDataExists) {
            try {
                OldProgramContextDB.removeOldContextData(dbHandle);
            }
            catch (IOException e) {
                this.errorHandler.dbError(e);
            }
        }
    }

    private static boolean contextDataExists(DBHandle dbh) {
        for (Table table : dbh.getTables()) {
            if (!table.getName().startsWith("Range Map - Register_")) continue;
            return true;
        }
        return false;
    }

    private void upgrade(AddressMap addressMapExt, TaskMonitor monitor) throws CancelledException {
        OldProgramContextDB oldContext = new OldProgramContextDB(this.dbHandle, this.errorHandler, this.language, addressMapExt, this.lock);
        for (Register register : this.language.getRegisters()) {
            if (register.getBaseRegister() != register) continue;
            AddressRangeIterator it = oldContext.getRegisterValueAddressRanges(register);
            while (it.hasNext()) {
                monitor.checkCanceled();
                AddressRange range = (AddressRange)it.next();
                RegisterValue regValue = oldContext.getNonDefaultValue(register, range.getMinAddress());
                this.recoverOldRegisterValue(range.getMinAddress(), range.getMaxAddress(), regValue);
            }
        }
    }

    private void recoverOldRegisterValue(Address start, Address end, RegisterValue value) {
        Register reg = value.getRegister();
        if (reg.isProcessorContext()) {
            if (!reg.hasChildren()) {
                return;
            }
            byte[] validBitMask = reg.getBaseMask();
            Arrays.fill(validBitMask, (byte)0);
            for (Register child : reg.getChildRegisters()) {
                byte[] mask = child.getBaseMask();
                for (int i = 0; i < validBitMask.length; ++i) {
                    int n = i;
                    validBitMask[n] = (byte)(validBitMask[n] | mask[i]);
                }
            }
            byte[] maskValue = value.toBytes();
            for (int i = 0; i < validBitMask.length; ++i) {
                int n = i;
                maskValue[n] = (byte)(maskValue[n] & validBitMask[i]);
                int n2 = i + validBitMask.length;
                maskValue[n2] = (byte)(maskValue[n2] & validBitMask[i]);
            }
            value = new RegisterValue(reg, maskValue);
        }
        try {
            this.setRegisterValue(start, end, value);
        }
        catch (ContextChangeException e) {
            throw new AssertException("Unexpected context error during upgrade", (Throwable)((Object)e));
        }
    }

    private void initializedCurrentValues() {
        Table[] tables;
        String tableNamePrefix = "Range Map - Register_";
        for (Table table : tables = this.dbHandle.getTables()) {
            String registerName;
            Register register;
            if (!table.getName().startsWith(tableNamePrefix) || (register = this.getRegister(registerName = table.getName().substring(tableNamePrefix.length()))) == null) continue;
            DatabaseRangeMapAdapter adapter = new DatabaseRangeMapAdapter(register, this.dbHandle, this.addrMap, this.lock, this.errorHandler);
            this.createRegisterValueStore(register, adapter);
        }
    }

    public void initializeDefaultValues(Language lang, CompilerSpec compilerSpec) {
        this.defaultRegisterValueMap.clear();
        lang.applyContextSettings(this);
        if (compilerSpec != null) {
            compilerSpec.applyContextSettings(this);
        }
    }

    @Override
    public void invalidateCache(boolean all) throws IOException {
        this.invalidateReadCache();
        this.invalidateRegisterStores();
    }

    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        super.moveAddressRange(fromAddr, toAddr, length, monitor);
    }

    @Override
    public void programReady(int openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
    }

    @Override
    public void setProgram(ProgramDB program) {
        this.program = program;
    }

    @Override
    protected RangeMapAdapter createNewRangeMapAdapter(Register baseRegister) {
        return new DatabaseRangeMapAdapter(baseRegister, this.dbHandle, this.addrMap, this.lock, this.errorHandler);
    }

    private void checkContextWrite(Register reg, Address start, Address end) throws ContextChangeException {
        if (this.changing || !reg.getBaseRegister().equals(this.getBaseContextRegister())) {
            return;
        }
        CodeManager codeManager = this.program.getCodeManager();
        codeManager.checkContextWrite(start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAddressRange(Address start, Address end, TaskMonitor monitor) {
        this.lock.acquire();
        try {
            super.deleteAddressRange(start, end, monitor);
            if (this.program != null) {
                this.program.setRegisterValuesChanged(null, start, end);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Address start, Address end, Register register) throws ContextChangeException {
        this.lock.acquire();
        boolean restore = false;
        try {
            this.checkContextWrite(register, start, end);
            restore = !this.changing;
            this.changing = true;
            super.remove(start, end, register);
            if (this.program != null) {
                this.program.setRegisterValuesChanged(register, start, end);
            }
        }
        finally {
            if (restore) {
                this.changing = false;
            }
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Register register, Address start, Address end, BigInteger value) throws ContextChangeException {
        this.lock.acquire();
        boolean restore = false;
        try {
            this.checkContextWrite(register, start, end);
            restore = !this.changing;
            this.changing = true;
            super.setValue(register, start, end, value);
            if (this.program != null) {
                this.program.setRegisterValuesChanged(register, start, end);
            }
        }
        finally {
            if (restore) {
                this.changing = false;
            }
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRegisterValue(Address start, Address end, RegisterValue value) throws ContextChangeException {
        this.lock.acquire();
        boolean restore = false;
        try {
            this.checkContextWrite(value.getRegister(), start, end);
            restore = !this.changing;
            this.changing = true;
            super.setRegisterValue(start, end, value);
            if (this.program != null) {
                this.program.setRegisterValuesChanged(value.getRegister(), start, end);
            }
        }
        finally {
            if (restore) {
                this.changing = false;
            }
            this.lock.release();
        }
    }

    public void setLanguage(LanguageTranslator translator, CompilerSpec newCompilerSpec, AddressSetView programMemory, TaskMonitor monitor) throws CancelledException {
        if (translator == null) {
            RegisterValueStore store;
            boolean clearContext = Boolean.valueOf(this.language.getProperty("resetContextOnUpgrade"));
            if (clearContext && (store = (RegisterValueStore)this.registerValueMap.get(this.baseContextRegister)) != null) {
                store.clearAll();
            }
            this.initializeDefaultValues(this.language, newCompilerSpec);
            return;
        }
        Language newLanguage = translator.getNewLanguage();
        ArrayList<Register> registers = new ArrayList<Register>(this.language.getRegisters());
        Collections.sort(registers, (r1, r2) -> r2.getBitLength() - r1.getBitLength());
        for (Register register : registers) {
            boolean clearContext;
            RegisterValueStore store;
            monitor.checkCanceled();
            if (!register.isBaseRegister() || (store = (RegisterValueStore)this.registerValueMap.get(register)) == null) continue;
            boolean bl = clearContext = register.isProcessorContext() && Boolean.valueOf(newLanguage.getProperty("resetContextOnUpgrade")) != false;
            if (clearContext || !store.setLanguage(translator, monitor)) {
                Msg.warn((Object)this, (Object)("WARNING! Discarding all context for register " + register.getName()));
                store.clearAll();
            }
            this.registerValueMap.remove(register);
        }
        this.init(newLanguage);
        this.initializeDefaultValues(newLanguage, newCompilerSpec);
        this.registerValueMap.clear();
        this.initializedCurrentValues();
        Register ctxReg = newLanguage.getContextBaseRegister();
        if (ctxReg != Register.NO_CONTEXT && translator.isValueTranslationRequired(ctxReg)) {
            RegisterValue gapValue = new RegisterValue(ctxReg);
            if ((gapValue = translator.getNewRegisterValue(gapValue)) != null && gapValue.hasAnyValue()) {
                this.fillInContextGaps(ctxReg, gapValue, programMemory);
            }
        }
    }

    private void fillInContextGaps(Register ctxReg, RegisterValue gapValue, AddressSetView programMemory) {
        AddressSet area = new AddressSet(programMemory);
        RegisterValueStore store = (RegisterValueStore)this.registerValueMap.get(ctxReg);
        if (store != null) {
            AddressRangeIterator addressRangeIterator = store.getAddressRangeIterator();
            while (addressRangeIterator.hasNext()) {
                area.delete((AddressRange)addressRangeIterator.next());
            }
        }
        AddressRangeIterator addressRanges = area.getAddressRanges();
        while (addressRanges.hasNext()) {
            AddressRange range = (AddressRange)addressRanges.next();
            try {
                this.setRegisterValue(range.getMinAddress(), range.getMaxAddress(), gapValue);
            }
            catch (ContextChangeException e) {
                throw new AssertException("Unexpected context error during language upgrade", (Throwable)((Object)e));
            }
        }
    }

    @Override
    public void flushProcessorContextWriteCache() {
        this.lock.acquire();
        try {
            super.flushProcessorContextWriteCache();
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void invalidateProcessorContextWriteCache() {
        this.lock.acquire();
        try {
            super.invalidateProcessorContextWriteCache();
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public AddressRangeIterator getRegisterValueAddressRanges(Register register) {
        this.lock.acquire();
        try {
            AddressRangeIterator addressRangeIterator = super.getRegisterValueAddressRanges(register);
            return addressRangeIterator;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressRange getRegisterValueRangeContaining(Register register, Address addr) {
        this.lock.acquire();
        try {
            AddressRange addressRange = super.getRegisterValueRangeContaining(register, addr);
            return addressRange;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressRangeIterator getRegisterValueAddressRanges(Register register, Address start, Address end) {
        this.lock.acquire();
        try {
            AddressRangeIterator addressRangeIterator = super.getRegisterValueAddressRanges(register, start, end);
            return addressRangeIterator;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public AddressRangeIterator getDefaultRegisterValueAddressRanges(Register register) {
        this.lock.acquire();
        try {
            AddressRangeIterator addressRangeIterator = super.getDefaultRegisterValueAddressRanges(register);
            return addressRangeIterator;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressRangeIterator getDefaultRegisterValueAddressRanges(Register register, Address start, Address end) {
        this.lock.acquire();
        try {
            AddressRangeIterator addressRangeIterator = super.getDefaultRegisterValueAddressRanges(register, start, end);
            return addressRangeIterator;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Register[] getRegistersWithValues() {
        this.lock.acquire();
        try {
            Register[] registerArray = super.getRegistersWithValues();
            return registerArray;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasValueOverRange(Register reg, BigInteger value, AddressSetView addrSet) {
        this.lock.acquire();
        try {
            boolean bl = super.hasValueOverRange(reg, value, addrSet);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultValue(RegisterValue registerValue, Address start, Address end) {
        this.lock.acquire();
        try {
            super.setDefaultValue(registerValue, start, end);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterValue getDefaultValue(Register register, Address address) {
        this.lock.acquire();
        try {
            RegisterValue registerValue = super.getDefaultValue(register, address);
            return registerValue;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterValue getNonDefaultValue(Register register, Address address) {
        this.lock.acquire();
        try {
            RegisterValue registerValue = super.getNonDefaultValue(register, address);
            return registerValue;
        }
        finally {
            this.lock.release();
        }
    }

    private void invalidateRegisterStores() {
        for (RegisterValueStore store : this.registerValueMap.values()) {
            store.invalidate();
        }
        for (RegisterValueStore store : this.defaultRegisterValueMap.values()) {
            store.invalidate();
        }
    }
}

