/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBRecord;
import db.Field;
import ghidra.docking.settings.Settings;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.data.BitFieldDBDataType;
import ghidra.program.database.data.ComponentDBAdapter;
import ghidra.program.database.data.CompositeDB;
import ghidra.program.database.data.CompositeDBAdapter;
import ghidra.program.database.data.DataTypeComponentDB;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BitFieldPacking;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.CompositeAlignmentHelper;
import ghidra.program.model.data.CompositeInternal;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionDataType;
import ghidra.program.model.data.UnionInternal;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

class UnionDB
extends CompositeDB
implements UnionInternal {
    private int unionLength;
    private int unionAlignment;
    private int computedAlignment = -1;
    private List<DataTypeComponentDB> components;

    public UnionDB(DataTypeManagerDB dataMgr, DBObjectCache<DataTypeDB> cache, CompositeDBAdapter compositeAdapter, ComponentDBAdapter componentAdapter, DBRecord record) {
        super(dataMgr, cache, compositeAdapter, componentAdapter, record);
    }

    @Override
    protected void initialize() {
        this.components = new ArrayList<DataTypeComponentDB>();
        try {
            Field[] ids;
            for (Field id : ids = this.componentAdapter.getComponentIdsInComposite(this.key)) {
                DBRecord rec = this.componentAdapter.getRecord(id.getLongValue());
                this.components.add(new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec));
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        Collections.sort(this.components, CompositeInternal.ComponentComparator.INSTANCE);
        this.unionLength = this.record.getIntValue(4);
        this.unionAlignment = this.record.getIntValue(5);
        this.computedAlignment = -1;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        if (this.isNotYetDefined()) {
            return "<Empty-Union>";
        }
        return "";
    }

    @Override
    public DataTypeComponent add(DataType dataType, int length, String componentName, String comment) throws IllegalArgumentException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.getComputedAlignment(true);
            DataTypeComponent dtc = this.doAdd(dataType, length, componentName, comment, true);
            if (!this.repack(false, true)) {
                this.dataMgr.dataTypeChanged(this, false);
            }
            DataTypeComponent dataTypeComponent = dtc;
            return dataTypeComponent;
        }
        catch (DataTypeDependencyException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        finally {
            this.lock.release();
        }
    }

    private int getBitFieldAllocation(BitFieldDataType bitfieldDt) {
        BitFieldPacking bitFieldPacking = this.getDataOrganization().getBitFieldPacking();
        if (bitFieldPacking.useMSConvention()) {
            return bitfieldDt.getBaseTypeSize();
        }
        if (bitfieldDt.getBitSize() == 0) {
            return 0;
        }
        int length = bitfieldDt.getBaseTypeSize();
        int packValue = this.getStoredPackingValue();
        if (packValue > 0 && length > packValue) {
            length = DataOrganizationImpl.getLeastCommonMultiple(bitfieldDt.getStorageSize(), packValue);
        }
        return length;
    }

    private DataTypeComponent doAdd(DataType dataType, int length, String name, String comment, boolean validateAlignAndNotify) throws DataTypeDependencyException {
        dataType = this.validateDataType(dataType);
        dataType = this.adjustBitField(dataType);
        if (validateAlignAndNotify) {
            dataType = this.resolve(dataType);
            this.checkAncestry(dataType);
        }
        length = this.getPreferredComponentLength(dataType, length);
        DataTypeComponentDB dtc = this.createComponent(this.dataMgr.getResolvedID(dataType), length, this.components.size(), 0, name, comment);
        dataType.addParent(this);
        this.components.add(dtc);
        return dtc;
    }

    private DataTypeComponentDB createComponent(long dtID, int length, int ordinal, int offset, String name, String comment) {
        try {
            DBRecord rec = this.componentAdapter.createRecord(dtID, this.key, length, ordinal, offset, name, comment);
            return new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
            return null;
        }
    }

    private void removeComponent(long compKey) {
        try {
            this.componentAdapter.removeRecord(compKey);
            this.dataMgr.getSettingsAdapter().removeAllSettingsRecords(compKey);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    @Override
    public DataTypeComponent insert(int ordinal, DataType dataType, int length, String name, String comment) throws IllegalArgumentException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            dataType = this.validateDataType(dataType);
            dataType = this.adjustBitField(dataType);
            dataType = this.resolve(dataType);
            this.checkAncestry(dataType);
            this.getComputedAlignment(true);
            length = this.getPreferredComponentLength(dataType, length);
            DataTypeComponentDB dtc = this.createComponent(this.dataMgr.getResolvedID(dataType), length, ordinal, 0, name, comment);
            dataType.addParent(this);
            this.shiftOrdinals(ordinal, 1);
            this.components.add(ordinal, dtc);
            if (!this.repack(false, true)) {
                this.dataMgr.dataTypeChanged(this, false);
            }
            DataTypeComponentDB dataTypeComponentDB = dtc;
            return dataTypeComponentDB;
        }
        catch (DataTypeDependencyException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataTypeComponent addBitField(DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException {
        return this.insertBitField(this.components.size(), baseDataType, bitSize, componentName, comment);
    }

    @Override
    public DataTypeComponent insertBitField(int ordinal, DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException, IndexOutOfBoundsException {
        if (ordinal < 0 || ordinal > this.components.size()) {
            throw new IndexOutOfBoundsException(ordinal);
        }
        BitFieldDBDataType bitFieldDt = new BitFieldDBDataType(baseDataType, bitSize, 0);
        return this.insert(ordinal, bitFieldDt, bitFieldDt.getStorageSize(), componentName, comment);
    }

    @Override
    public void delete(int ordinal) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.getComputedAlignment(true);
            DataTypeComponentDB dtc = this.components.remove(ordinal);
            dtc.getDataType().removeParent(this);
            this.removeComponent(dtc.getKey());
            this.shiftOrdinals(ordinal, -1);
            if (!this.repack(false, true)) {
                this.dataMgr.dataTypeChanged(this, false);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Set<Integer> ordinals) {
        if (ordinals.isEmpty()) {
            return;
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.isPackingEnabled()) {
                this.getComputedAlignment(true);
            }
            ArrayList<DataTypeComponentDB> newComponents = new ArrayList<DataTypeComponentDB>();
            int newLength = 0;
            int ordinalAdjustment = 0;
            for (DataTypeComponentDB dtc : this.components) {
                int ordinal = dtc.getOrdinal();
                if (ordinals.contains(ordinal)) {
                    --ordinalAdjustment;
                    continue;
                }
                if (ordinalAdjustment != 0) {
                    dtc.setOrdinal(dtc.getOrdinal() + ordinalAdjustment, true);
                }
                newComponents.add(dtc);
                newLength = Math.max(newLength, dtc.getLength());
            }
            this.components = newComponents;
            if (this.isPackingEnabled()) {
                if (!this.repack(false, true)) {
                    this.dataMgr.dataTypeChanged(this, false);
                }
            } else {
                this.unionLength = newLength;
                this.notifySizeChanged(false);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceWith(DataType dataType) {
        if (!(dataType instanceof UnionInternal)) {
            throw new IllegalArgumentException();
        }
        this.lock.acquire();
        boolean isResolveCacheOwner = this.dataMgr.activateResolveCache();
        try {
            this.checkDeleted();
            this.doReplaceWith((UnionInternal)dataType, true);
        }
        catch (DataTypeDependencyException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            if (isResolveCacheOwner) {
                this.dataMgr.flushResolveQueue(true);
            }
            this.lock.release();
        }
    }

    void doReplaceWith(UnionInternal union, boolean notify) throws DataTypeDependencyException, IOException {
        DataTypeComponent[] otherComponents = union.getComponents();
        DataType[] resolvedDts = new DataType[otherComponents.length];
        for (int i = 0; i < otherComponents.length; ++i) {
            resolvedDts[i] = this.doCheckedResolve(otherComponents[i].getDataType());
            this.checkAncestry(resolvedDts[i]);
        }
        for (DataTypeComponentDB dataTypeComponentDB : this.components) {
            dataTypeComponentDB.getDataType().removeParent(this);
            this.removeComponent(dataTypeComponentDB.getKey());
        }
        this.components.clear();
        this.unionAlignment = -1;
        this.computedAlignment = -1;
        this.doSetPackingAndAlignment(union);
        for (int i = 0; i < otherComponents.length; ++i) {
            DataTypeComponent dataTypeComponent = otherComponents[i];
            this.doAdd(resolvedDts[i], dataTypeComponent.getLength(), dataTypeComponent.getFieldName(), dataTypeComponent.getComment(), false);
        }
        this.repack(false, false);
        if (notify) {
            this.notifySizeChanged(false);
        }
        if (this.pointerPostResolveRequired) {
            this.dataMgr.queuePostResolve(this, union);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPartOf(DataType dataType) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.equals(dataType)) {
                boolean bl = true;
                return bl;
            }
            for (DataTypeComponent dataTypeComponent : this.components) {
                DataType subDt = dataTypeComponent.getDataType();
                if (subDt instanceof Composite) {
                    if (!((Composite)subDt).isPartOf(dataType)) continue;
                    boolean bl = true;
                    return bl;
                }
                if (!subDt.equals(dataType)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getNumComponents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            int n = this.components.size();
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getNumDefinedComponents() {
        return this.getNumComponents();
    }

    @Override
    public DataTypeComponent getComponent(int ordinal) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (ordinal < 0 || ordinal >= this.components.size()) {
                DataTypeComponent dataTypeComponent = null;
                return dataTypeComponent;
            }
            DataTypeComponent dataTypeComponent = this.components.get(ordinal);
            return dataTypeComponent;
        }
        finally {
            this.lock.release();
        }
    }

    public DataTypeComponentDB[] getComponents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            DataTypeComponentDB[] dataTypeComponentDBArray = this.components.toArray(new DataTypeComponentDB[this.components.size()]);
            return dataTypeComponentDBArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataTypeComponentDB[] getDefinedComponents() {
        return this.getComponents();
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        UnionDataType union = new UnionDataType(this.getCategoryPath(), this.getName(), dtm);
        union.setDescription(this.getDescription());
        union.replaceWith(this);
        return union;
    }

    @Override
    public Union clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        UnionDataType union = new UnionDataType(this.getCategoryPath(), this.getName(), this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
        union.setDescription(this.getDescription());
        union.replaceWith(this);
        return union;
    }

    @Override
    public boolean isZeroLength() {
        return this.unionLength == 0;
    }

    @Override
    public int getLength() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.unionLength == 0) {
                int n = 1;
                return n;
            }
            int n = this.unionLength;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return true;
    }

    @Override
    protected void fixupComponents() {
        boolean changed = false;
        for (DataTypeComponentDB dtc : this.components) {
            int length;
            DataType dt = dtc.getDataType();
            if (dt instanceof Dynamic) continue;
            if (dt instanceof BitFieldDataType) {
                dt = this.adjustBitField(dt);
            }
            if ((length = DataTypeComponent.usesZeroLengthComponent(dt) ? 0 : dt.getLength()) < 0 || length == dtc.getLength()) continue;
            dtc.setLength(length, true);
            changed = true;
        }
        if (changed && !this.repack(false, false)) {
            this.dataMgr.dataTypeChanged(this, false);
        }
    }

    @Override
    public void dataTypeAlignmentChanged(DataType dt) {
        if (!this.isPackingEnabled()) {
            return;
        }
        if (dt instanceof BitFieldDataType) {
            return;
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.repack(true, true);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeSizeChanged(DataType dt) {
        if (dt instanceof BitFieldDataType) {
            return;
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            boolean changed = false;
            for (DataTypeComponentDB dtc : this.components) {
                int length;
                if (dtc.getDataType() != dt || (length = DataTypeComponent.usesZeroLengthComponent(dt) ? 0 : dt.getLength()) < 0 || length == dtc.getLength()) continue;
                dtc.setLength(length, true);
                changed = true;
            }
            if (changed && !this.repack(true, true)) {
                this.dataMgr.dataTypeChanged(this, true);
            }
        }
        finally {
            this.lock.release();
        }
    }

    private DataType adjustBitField(DataType dataType) {
        if (!(dataType instanceof BitFieldDataType)) {
            return dataType;
        }
        BitFieldDataType bitfieldDt = (BitFieldDataType)dataType;
        DataType baseDataType = bitfieldDt.getBaseDataType();
        baseDataType = this.resolve(baseDataType);
        int bitSize = bitfieldDt.getDeclaredBitSize();
        int effectiveBitSize = BitFieldDataType.getEffectiveBitSize(bitSize, baseDataType.getLength());
        boolean bigEndian = this.getDataOrganization().isBigEndian();
        int storageBitOffset = 0;
        if (bigEndian) {
            if (bitSize == 0) {
                storageBitOffset = 7;
            } else {
                int storageSize = BitFieldDataType.getMinimumStorageSize(effectiveBitSize);
                storageBitOffset = 8 * storageSize - effectiveBitSize;
            }
        }
        if (effectiveBitSize != bitfieldDt.getBitSize() || storageBitOffset != bitfieldDt.getBitOffset()) {
            try {
                bitfieldDt = new BitFieldDBDataType(baseDataType, effectiveBitSize, storageBitOffset);
            }
            catch (InvalidDataTypeException invalidDataTypeException) {
                // empty catch block
            }
        }
        return bitfieldDt;
    }

    @Override
    protected int getComputedAlignment(boolean updateRecord) {
        if (this.unionAlignment > 0) {
            return this.unionAlignment;
        }
        if (this.computedAlignment <= 0) {
            this.computedAlignment = this.isPackingEnabled() ? CompositeAlignmentHelper.getAlignment(this.getDataOrganization(), this) : this.getNonPackedAlignment();
        }
        if (updateRecord) {
            this.record.setIntValue(5, this.computedAlignment);
            try {
                this.compositeAdapter.updateRecord(this.record, false);
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
            this.unionAlignment = this.computedAlignment;
            this.computedAlignment = -1;
            return this.unionAlignment;
        }
        return this.computedAlignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean repack(boolean isAutoChange, boolean notify) {
        this.lock.acquire();
        try {
            boolean changed;
            this.checkDeleted();
            int oldLength = this.unionLength;
            boolean storeAlignment = this.unionAlignment <= 0;
            int oldAlignment = this.getComputedAlignment(false);
            this.unionLength = 0;
            for (DataTypeComponent dataTypeComponent : this.components) {
                int length = dataTypeComponent.getLength();
                if (this.isPackingEnabled() && dataTypeComponent.isBitFieldComponent()) {
                    length = this.getBitFieldAllocation((BitFieldDataType)dataTypeComponent.getDataType());
                }
                this.unionLength = Math.max(length, this.unionLength);
            }
            this.computedAlignment = -1;
            this.unionAlignment = -1;
            this.unionAlignment = this.getComputedAlignment(false);
            if (this.isPackingEnabled()) {
                this.unionLength = DataOrganizationImpl.getAlignedOffset(this.unionAlignment, this.unionLength);
            }
            boolean bl = changed = oldLength != this.unionLength || oldAlignment != this.unionAlignment;
            if (changed || storeAlignment) {
                this.record.setIntValue(4, this.unionLength);
                this.record.setIntValue(5, this.unionAlignment);
                try {
                    this.compositeAdapter.updateRecord(this.record, changed && !isAutoChange);
                }
                catch (IOException iOException) {
                    this.dataMgr.dbError(iOException);
                }
            }
            if (changed & notify) {
                if (oldLength != this.unionLength) {
                    this.notifySizeChanged(isAutoChange);
                } else if (oldAlignment != this.unionAlignment) {
                    this.notifyAlignmentChanged(isAutoChange);
                } else {
                    this.dataMgr.dataTypeChanged(this, isAutoChange);
                }
            }
            boolean bl2 = changed;
            return bl2;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeDeleted(DataType dt) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            boolean changed = false;
            for (int i = this.components.size() - 1; i >= 0; --i) {
                DataTypeComponentDB dtc = this.components.get(i);
                boolean removeBitFieldComponent = false;
                if (dtc.isBitFieldComponent()) {
                    BitFieldDataType bitfieldDt = (BitFieldDataType)dtc.getDataType();
                    boolean bl = removeBitFieldComponent = bitfieldDt.getBaseDataType() == dt;
                }
                if (!removeBitFieldComponent && dtc.getDataType() != dt) continue;
                dt.removeParent(this);
                this.components.remove(i);
                this.removeComponent(dtc.getKey());
                this.shiftOrdinals(i, -1);
                changed = true;
            }
            if (changed && !this.repack(false, true)) {
                this.dataMgr.dataTypeChanged(this, false);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEquivalent(DataType dataType) {
        if (dataType == this) {
            return true;
        }
        if (!(dataType instanceof UnionInternal)) {
            return false;
        }
        this.validate(this.lock);
        if (this.resolving) {
            if (dataType.getUniversalID().equals((Object)this.getUniversalID())) {
                return true;
            }
            return DataTypeUtilities.equalsIgnoreConflict(this.getPathName(), dataType.getPathName());
        }
        Boolean isEquivalent = this.dataMgr.getCachedEquivalence(this, dataType);
        if (isEquivalent != null) {
            return isEquivalent;
        }
        try {
            DataTypeComponent[] otherComps;
            isEquivalent = false;
            UnionInternal union = (UnionInternal)dataType;
            if (this.getStoredPackingValue() != union.getStoredPackingValue() || this.getStoredMinimumAlignment() != union.getStoredMinimumAlignment()) {
                boolean bl = false;
                return bl;
            }
            DataTypeComponentDB[] myComps = this.getComponents();
            if (myComps.length != (otherComps = union.getComponents()).length) {
                boolean bl = false;
                return bl;
            }
            for (int i = 0; i < myComps.length; ++i) {
                if (myComps[i].isEquivalent(otherComps[i])) continue;
                boolean bl = false;
                return bl;
            }
            isEquivalent = true;
        }
        finally {
            this.dataMgr.putCachedEquivalence(this, dataType, isEquivalent);
        }
        return true;
    }

    private void shiftOrdinals(int ordinal, int deltaOrdinal) {
        for (int i = ordinal; i < this.components.size(); ++i) {
            DataTypeComponentDB dtc = this.components.get(i);
            dtc.setOrdinal(dtc.getOrdinal() + deltaOrdinal, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        if (oldDt == this) {
            return;
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            DataType replacementDt = newDt;
            try {
                this.validateDataType(replacementDt);
                if (!(replacementDt instanceof DataTypeDB) || replacementDt.getDataTypeManager() != this.getDataTypeManager()) {
                    replacementDt = this.resolve(replacementDt);
                }
                this.checkAncestry(replacementDt);
            }
            catch (Exception e) {
                replacementDt = DataType.DEFAULT;
            }
            boolean changed = false;
            for (int i = this.components.size() - 1; i >= 0; --i) {
                DataTypeComponentDB dtc = this.components.get(i);
                boolean remove = false;
                if (dtc.isBitFieldComponent()) {
                    try {
                        changed |= this.updateBitFieldDataType(dtc, oldDt, replacementDt);
                    }
                    catch (InvalidDataTypeException e) {
                        Msg.error((Object)this, (Object)("Invalid bitfield replacement type " + newDt.getName() + ", removing bitfield " + dtc.getDataType().getName() + ": " + this.getPathName()));
                        remove = true;
                    }
                } else if (dtc.getDataType() == oldDt) {
                    if (replacementDt == DEFAULT) {
                        Msg.error((Object)this, (Object)("Invalid replacement type " + newDt.getName() + ", removing component " + dtc.getDataType().getName() + ": " + this.getPathName()));
                        remove = true;
                    } else {
                        int len;
                        int n = len = DataTypeComponent.usesZeroLengthComponent(newDt) ? 0 : newDt.getLength();
                        if (len < 0) {
                            len = dtc.getLength();
                        }
                        oldDt.removeParent(this);
                        dtc.setLength(len, false);
                        dtc.setDataType(replacementDt);
                        this.dataMgr.getSettingsAdapter().removeAllSettingsRecords(dtc.getKey());
                        replacementDt.addParent(this);
                        changed = true;
                    }
                }
                if (!remove) continue;
                oldDt.removeParent(this);
                this.components.remove(i);
                this.removeComponent(dtc.getKey());
                this.shiftOrdinals(i, -1);
                changed = true;
            }
            if (changed) {
                this.repack(false, false);
                this.compositeAdapter.updateRecord(this.record, true);
                this.notifySizeChanged(false);
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dependsOn(DataType dt) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.getNumComponents() == 1) {
                DataTypeComponent dtc = this.getComponent(0);
                boolean bl = dtc.getDataType().dependsOn(dt);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String getDefaultLabelPrefix() {
        return "UNION_" + this.getName();
    }
}

