/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBRecord;
import db.Field;
import ghidra.docking.settings.Settings;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.data.BitFieldDBDataType;
import ghidra.program.database.data.ComponentDBAdapter;
import ghidra.program.database.data.CompositeDB;
import ghidra.program.database.data.CompositeDBAdapter;
import ghidra.program.database.data.DataTypeComponentDB;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeProxyComponentDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.AlignedStructureInspector;
import ghidra.program.model.data.AlignedStructurePacker;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.CompositeInternal;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.StructureInternal;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

class StructureDB
extends CompositeDB
implements StructureInternal {
    private int structLength;
    private int structAlignment;
    private int computedAlignment = -1;
    private int numComponents;
    private List<DataTypeComponentDB> components;

    public StructureDB(DataTypeManagerDB dataMgr, DBObjectCache<DataTypeDB> cache, CompositeDBAdapter compositeAdapter, ComponentDBAdapter componentAdapter, DBRecord record) {
        super(dataMgr, cache, compositeAdapter, componentAdapter, record);
    }

    @Override
    protected void initialize() {
        this.components = new ArrayList<DataTypeComponentDB>();
        try {
            Field[] ids;
            DBRecord oldFlexArrayRecord = null;
            for (Field id : ids = this.componentAdapter.getComponentIdsInComposite(this.key)) {
                DBRecord rec = this.componentAdapter.getRecord(id.getLongValue());
                if (rec.getIntValue(6) < 0) {
                    oldFlexArrayRecord = rec;
                    continue;
                }
                DataTypeComponentDB component = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
                this.components.add(component);
            }
            Collections.sort(this.components, CompositeInternal.ComponentComparator.INSTANCE);
            this.structLength = this.record.getIntValue(4);
            this.structAlignment = this.record.getIntValue(5);
            this.computedAlignment = -1;
            int n = this.numComponents = this.isPackingEnabled() ? this.components.size() : this.record.getIntValue(6);
            if (oldFlexArrayRecord != null) {
                this.migrateOldFlexArray(oldFlexArrayRecord);
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    private void migrateOldFlexArray(DBRecord oldFlexArrayRecord) throws IOException {
        DataTypeComponentDB component;
        long id = oldFlexArrayRecord.getLongValue(2);
        DataType dt = this.dataMgr.getDataType(id);
        dt = new ArrayDataType(dt, 0, 1, this.dataMgr);
        boolean repack = false;
        if (this.dataMgr.isUpdatable()) {
            if (!this.dataMgr.isTransactionActive()) {
                throw new AssertException("Structure flex-array component should have been migrated during required upgrade: " + this.getPathName());
            }
            dt = this.dataMgr.resolve(dt, null);
            oldFlexArrayRecord.setIntValue(6, this.numComponents++);
            oldFlexArrayRecord.setIntValue(1, this.structLength);
            oldFlexArrayRecord.setLongValue(2, this.dataMgr.getID(dt));
            this.componentAdapter.updateRecord(oldFlexArrayRecord);
            component = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, oldFlexArrayRecord);
            this.record.setIntValue(6, this.numComponents);
            this.compositeAdapter.updateRecord(this.record, false);
            repack = this.isPackingEnabled();
        } else {
            String fieldName = oldFlexArrayRecord.getString(3);
            String comment = oldFlexArrayRecord.getString(4);
            component = new DataTypeProxyComponentDB(this.dataMgr, this, this.numComponents++, this.structLength, dt, 0, fieldName, comment);
        }
        this.components.add(component);
        if (repack) {
            this.repack(false, false);
        }
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        if (this.isNotYetDefined()) {
            return "<Empty-Structure>";
        }
        return "";
    }

    @Override
    public DataTypeComponent add(DataType dataType, int length, String name, String comment) throws IllegalArgumentException {
        try {
            return this.doAdd(dataType, length, name, comment, true);
        }
        catch (DataTypeDependencyException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataTypeComponent doAdd(DataType dataType, int length, String name, String comment, boolean validatePackAndNotify) throws DataTypeDependencyException, IllegalArgumentException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (validatePackAndNotify) {
                dataType = this.validateDataType(dataType);
                dataType = this.resolve(dataType);
                this.checkAncestry(dataType);
            }
            DataTypeComponentDB dtc = null;
            try {
                if (dataType == DataType.DEFAULT) {
                    dtc = new DataTypeComponentDB(this.dataMgr, this, this.numComponents, this.structLength);
                } else {
                    int componentLength = this.getPreferredComponentLength(dataType, length);
                    DBRecord rec = this.componentAdapter.createRecord(this.dataMgr.getResolvedID(dataType), this.key, componentLength, this.numComponents, this.structLength, name, comment);
                    dtc = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
                    dataType.addParent(this);
                    this.components.add(dtc);
                }
                int structureGrowth = dtc.getLength();
                if (structureGrowth != 0 && !this.isPackingEnabled() && length > 0) {
                    structureGrowth = length;
                }
                ++this.numComponents;
                this.structLength += structureGrowth;
                if (validatePackAndNotify) {
                    if (this.isPackingEnabled()) {
                        this.repack(false, false);
                    }
                    this.record.setIntValue(6, this.numComponents);
                    this.record.setIntValue(4, this.structLength);
                    this.compositeAdapter.updateRecord(this.record, true);
                    this.notifySizeChanged(false);
                }
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
            DataTypeComponentDB dataTypeComponentDB = dtc;
            return dataTypeComponentDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void growStructure(int amount) {
        if (this.isPackingEnabled()) {
            return;
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.doGrowStructure(amount);
            this.repack(false, false);
            this.notifySizeChanged(false);
        }
        finally {
            this.lock.release();
        }
    }

    private void doGrowStructure(int amount) {
        if (this.isPackingEnabled()) {
            throw new AssertException("only valid for non-packed");
        }
        this.record.setIntValue(6, this.numComponents);
        this.structLength += amount;
        this.record.setIntValue(4, this.structLength);
        try {
            this.compositeAdapter.updateRecord(this.record, true);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent insert(int ordinal, DataType dataType, int length, String name, String comment) {
        this.lock.acquire();
        try {
            DataTypeComponentDB existingDtc;
            int idx;
            this.checkDeleted();
            if (ordinal < 0 || ordinal > this.numComponents) {
                throw new IndexOutOfBoundsException(ordinal);
            }
            if (ordinal == this.numComponents) {
                DataTypeComponent dataTypeComponent = this.add(dataType, length, name, comment);
                return dataTypeComponent;
            }
            dataType = this.validateDataType(dataType);
            dataType = this.resolve(dataType);
            this.checkAncestry(dataType);
            if (this.isPackingEnabled()) {
                idx = ordinal;
            } else {
                DataTypeComponentDB previousDtc;
                idx = Collections.binarySearch(this.components, ordinal, CompositeInternal.OrdinalComparator.INSTANCE);
                if (idx > 0 && (existingDtc = this.components.get(idx)).isBitFieldComponent() && (previousDtc = this.components.get(idx - 1)).getEndOffset() == existingDtc.getOffset()) {
                    this.shiftOffsets(idx, 0, 1);
                }
            }
            if (idx < 0) {
                idx = -idx - 1;
            }
            if (dataType == DataType.DEFAULT) {
                this.shiftOffsets(idx, 1, 1);
                this.notifySizeChanged(false);
                existingDtc = this.getComponent(ordinal);
                return existingDtc;
            }
            length = this.getPreferredComponentLength(dataType, length);
            int offset = this.getComponent(ordinal).getOffset();
            DBRecord rec = this.componentAdapter.createRecord(this.dataMgr.getResolvedID(dataType), this.key, length, ordinal, offset, name, comment);
            DataTypeComponentDB dtc = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
            dataType.addParent(this);
            this.shiftOffsets(idx, 1, dtc.getLength());
            this.components.add(idx, dtc);
            this.repack(false, false);
            this.notifySizeChanged(false);
            DataTypeComponentDB dataTypeComponentDB = dtc;
            return dataTypeComponentDB;
        }
        catch (DataTypeDependencyException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    @Override
    public DataTypeComponent addBitField(DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException {
        BitFieldDataType.checkBaseDataType(baseDataType);
        baseDataType = baseDataType.clone(this.getDataTypeManager());
        BitFieldDBDataType bitFieldDt = new BitFieldDBDataType(baseDataType, bitSize, 0);
        return this.add(bitFieldDt, componentName, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent insertBitField(int ordinal, int byteWidth, int bitOffset, DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException, IndexOutOfBoundsException {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (ordinal < 0 || ordinal > this.numComponents) {
                throw new IndexOutOfBoundsException(ordinal);
            }
            if (!this.isPackingEnabled()) {
                int offset = this.structLength;
                if (ordinal < this.numComponents) {
                    offset = this.getComponent(ordinal).getOffset();
                }
                DataTypeComponent dataTypeComponent = this.insertBitFieldAt(offset, byteWidth, bitOffset, baseDataType, bitSize, componentName, comment);
                return dataTypeComponent;
            }
            BitFieldDBDataType bitFieldDt = new BitFieldDBDataType(baseDataType, bitSize, 0);
            DataTypeComponent dataTypeComponent = this.insert(ordinal, bitFieldDt, bitFieldDt.getStorageSize(), componentName, comment);
            return dataTypeComponent;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent insertBitFieldAt(int byteOffset, int byteWidth, int bitOffset, DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException {
        this.lock.acquire();
        try {
            int requiredLength;
            int ordinal;
            this.checkDeleted();
            BitFieldDataType.checkBaseDataType(baseDataType);
            baseDataType = baseDataType.clone(this.dataMgr);
            if (byteOffset < 0 || bitSize < 0) {
                throw new IllegalArgumentException("Negative values not permitted when defining bitfield");
            }
            if (byteWidth <= 0) {
                throw new IllegalArgumentException("Invalid byteWidth");
            }
            int effectiveBitSize = BitFieldDataType.getEffectiveBitSize(bitSize, baseDataType.getLength());
            int minByteWidth = BitFieldDataType.getMinimumStorageSize(effectiveBitSize + bitOffset);
            if (byteWidth < minByteWidth) {
                throw new IllegalArgumentException("Bitfield does not fit within specified constraints");
            }
            boolean bigEndian = this.getDataOrganization().isBigEndian();
            boolean hasConflict = false;
            int additionalShift = 0;
            int startBitOffset = Structure.BitOffsetComparator.getNormalizedBitfieldOffset(byteOffset, byteWidth, effectiveBitSize, bitOffset, bigEndian);
            Comparator<Object> bitOffsetComparator = bigEndian ? Structure.BitOffsetComparator.INSTANCE_BE : Structure.BitOffsetComparator.INSTANCE_LE;
            int startIndex = Collections.binarySearch(this.components, startBitOffset, bitOffsetComparator);
            if (startIndex < 0) {
                startIndex = -startIndex - 1;
            } else {
                hasConflict = true;
                DataTypeComponentDB dtc = this.components.get(startIndex);
                if (bitSize == 0 || dtc.isZeroBitFieldComponent()) {
                    boolean bl = hasConflict = dtc.getOffset() != startBitOffset / 8;
                }
                if (hasConflict) {
                    additionalShift = byteOffset - dtc.getOffset();
                }
            }
            if (startIndex < this.components.size()) {
                DataTypeComponentDB dtc = this.components.get(startIndex);
                ordinal = dtc.getOrdinal();
            } else {
                ordinal = startIndex;
            }
            if (this.isPackingEnabled()) {
                this.insertBitField(ordinal, 0, 0, baseDataType, effectiveBitSize, componentName, comment);
            }
            int endIndex = startIndex;
            if (startIndex < this.components.size()) {
                int endBitOffset = startBitOffset;
                if (effectiveBitSize != 0) {
                    endBitOffset += effectiveBitSize - 1;
                }
                if ((endIndex = Collections.binarySearch(this.components, endBitOffset, bitOffsetComparator)) < 0) {
                    endIndex = -endIndex - 1;
                } else if (effectiveBitSize != 0) {
                    hasConflict = true;
                }
            }
            if (startIndex != endIndex) {
                hasConflict = true;
            }
            if (hasConflict) {
                this.shiftOffsets(startIndex, 1, byteWidth + additionalShift);
            }
            if ((requiredLength = byteOffset + byteWidth) > this.structLength) {
                this.structLength = requiredLength;
            }
            int storageBitOffset = bitOffset % 8;
            int revisedOffset = bigEndian ? byteOffset + byteWidth - (effectiveBitSize + bitOffset + 7) / 8 : byteOffset + bitOffset / 8;
            BitFieldDBDataType bitfieldDt = new BitFieldDBDataType(baseDataType, bitSize, storageBitOffset);
            DBRecord rec = this.componentAdapter.createRecord(this.dataMgr.getResolvedID(bitfieldDt), this.key, bitfieldDt.getStorageSize(), ordinal, revisedOffset, componentName, comment);
            DataTypeComponentDB dtc = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
            bitfieldDt.addParent(this);
            this.components.add(startIndex, dtc);
            this.adjustNonPackedComponents(true);
            this.notifySizeChanged(false);
            DataTypeComponentDB dataTypeComponentDB = dtc;
            return dataTypeComponentDB;
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    @Override
    public void delete(int ordinal) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (ordinal < 0 || ordinal >= this.numComponents) {
                throw new IndexOutOfBoundsException(ordinal);
            }
            int idx = this.isPackingEnabled() ? ordinal : Collections.binarySearch(this.components, ordinal, CompositeInternal.OrdinalComparator.INSTANCE);
            if (idx >= 0) {
                this.doDeleteWithComponentShift(idx, false);
            } else {
                idx = -idx - 1;
                this.shiftOffsets(idx, -1, -1);
            }
            this.repack(false, false);
            this.notifySizeChanged(false);
        }
        finally {
            this.lock.release();
        }
    }

    private DataTypeComponentDB doDelete(int index) throws IOException {
        DataTypeComponentDB dtc = this.components.remove(index);
        dtc.getDataType().removeParent(this);
        long compKey = dtc.getKey();
        this.componentAdapter.removeRecord(compKey);
        this.dataMgr.getSettingsAdapter().removeAllSettingsRecords(compKey);
        return dtc;
    }

    private void doDeleteWithComponentShift(int index, boolean disableOffsetShift) {
        DataTypeComponentDB dtc = null;
        try {
            dtc = this.doDelete(index);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        if (this.isPackingEnabled()) {
            return;
        }
        int shiftAmount = disableOffsetShift || dtc.isBitFieldComponent() ? 0 : dtc.getLength();
        this.shiftOffsets(index, -1, -shiftAmount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Set<Integer> ordinals) {
        this.lock.acquire();
        try {
            SortedSet<Integer> removedFillerSet;
            this.checkDeleted();
            if (ordinals.isEmpty()) {
                return;
            }
            boolean bitFieldRemoved = false;
            TreeSet<Integer> treeSet = null;
            if (!this.isPackingEnabled()) {
                treeSet = new TreeSet<Integer>(ordinals);
            }
            ArrayList<DataTypeComponentDB> newComponents = new ArrayList<DataTypeComponentDB>();
            int ordinalAdjustment = 0;
            int offsetAdjustment = 0;
            int lastDefinedOrdinal = -1;
            for (DataTypeComponentDB dtc : this.components) {
                SortedSet<Integer> removedFillerSet2;
                int ordinal = dtc.getOrdinal();
                if (treeSet != null && lastDefinedOrdinal < ordinal - 1 && !(removedFillerSet2 = treeSet.subSet(lastDefinedOrdinal + 1, ordinal)).isEmpty()) {
                    int undefinedRemoveCount = removedFillerSet2.size();
                    ordinalAdjustment -= undefinedRemoveCount;
                    offsetAdjustment -= undefinedRemoveCount;
                }
                if (ordinals.contains(ordinal)) {
                    if (dtc.isBitFieldComponent()) {
                        bitFieldRemoved = true;
                    } else {
                        offsetAdjustment -= dtc.getLength();
                    }
                    --ordinalAdjustment;
                    lastDefinedOrdinal = ordinal;
                    continue;
                }
                if (ordinalAdjustment != 0) {
                    this.shiftOffset(dtc, ordinalAdjustment, offsetAdjustment);
                }
                newComponents.add(dtc);
                lastDefinedOrdinal = ordinal;
            }
            if (treeSet != null && !(removedFillerSet = treeSet.subSet(lastDefinedOrdinal + 1, this.numComponents)).isEmpty()) {
                int undefinedRemoveCount = removedFillerSet.size();
                ordinalAdjustment -= undefinedRemoveCount;
                offsetAdjustment -= undefinedRemoveCount;
            }
            this.components = newComponents;
            this.updateComposite(this.numComponents + ordinalAdjustment, -1, -1, true);
            if (this.isPackingEnabled()) {
                if (!this.repack(false, true)) {
                    this.dataMgr.dataTypeChanged(this, false);
                }
            } else {
                this.updateComposite(-1, this.structLength + offsetAdjustment, -1, true);
                if (bitFieldRemoved) {
                    this.repack(false, false);
                }
                this.notifySizeChanged(false);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPartOf(DataType dataType) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.equals(dataType)) {
                boolean bl = true;
                return bl;
            }
            for (DataTypeComponentDB dtc : this.components) {
                DataType subDt = dtc.getDataType();
                if (subDt instanceof Composite) {
                    if (!((Composite)subDt).isPartOf(dataType)) continue;
                    boolean bl = true;
                    return bl;
                }
                if (!subDt.equals(dataType)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getNumComponents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            int n = this.numComponents;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getNumDefinedComponents() {
        this.lock.acquire();
        try {
            int n = this.components.size();
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponentDB getComponent(int ordinal) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (ordinal < 0 || ordinal >= this.numComponents) {
                throw new IndexOutOfBoundsException(ordinal);
            }
            if (this.isPackingEnabled()) {
                DataTypeComponentDB dataTypeComponentDB = this.components.get(ordinal);
                return dataTypeComponentDB;
            }
            int idx = Collections.binarySearch(this.components, ordinal, CompositeInternal.OrdinalComparator.INSTANCE);
            if (idx >= 0) {
                DataTypeComponentDB dataTypeComponentDB = this.components.get(idx);
                return dataTypeComponentDB;
            }
            int offset = 0;
            if ((idx = -idx - 1) == 0) {
                offset = ordinal;
            } else {
                DataTypeComponent dtc = this.components.get(idx - 1);
                offset = dtc.getEndOffset() + ordinal - dtc.getOrdinal();
                if (dtc.getLength() == 0) {
                    --offset;
                }
            }
            DataTypeComponentDB dataTypeComponentDB = new DataTypeComponentDB(this.dataMgr, this, ordinal, offset);
            return dataTypeComponentDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataTypeComponent[] getComponents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            DataTypeComponent[] comps = new DataTypeComponent[this.numComponents];
            for (int i = 0; i < comps.length; ++i) {
                comps[i] = this.getComponent(i);
            }
            DataTypeComponent[] dataTypeComponentArray = comps;
            return dataTypeComponentArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        StructureDataType struct = new StructureDataType(this.getCategoryPath(), this.getName(), this.getLength(), dtm);
        struct.setDescription(this.getDescription());
        struct.replaceWith(this);
        return struct;
    }

    @Override
    public Structure clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        StructureDataType struct = new StructureDataType(this.getCategoryPath(), this.getName(), this.structLength, this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
        struct.setDescription(this.getDescription());
        struct.replaceWith(this);
        return struct;
    }

    @Override
    protected int getComputedAlignment(boolean updateRecord) {
        if (this.structAlignment > 0) {
            return this.structAlignment;
        }
        if (this.computedAlignment <= 0) {
            if (this.isPackingEnabled()) {
                AlignedStructurePacker.StructurePackResult packResult = AlignedStructureInspector.packComponents(this);
                this.computedAlignment = packResult.alignment;
            } else {
                this.computedAlignment = this.getNonPackedAlignment();
            }
        }
        if (updateRecord) {
            this.record.setIntValue(5, this.computedAlignment);
            try {
                this.compositeAdapter.updateRecord(this.record, false);
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
            this.structAlignment = this.computedAlignment;
            this.computedAlignment = -1;
            return this.structAlignment;
        }
        return this.computedAlignment;
    }

    @Override
    public boolean isZeroLength() {
        return this.structLength == 0;
    }

    @Override
    public int getLength() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.structLength == 0) {
                int n = 1;
                return n;
            }
            int n = this.structLength;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean hasLanguageDependantLength() {
        return this.isPackingEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearComponent(int ordinal) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.isPackingEnabled()) {
                this.delete(ordinal);
                return;
            }
            if (ordinal < 0 || ordinal >= this.numComponents) {
                throw new IndexOutOfBoundsException(ordinal);
            }
            int idx = Collections.binarySearch(this.components, ordinal, CompositeInternal.OrdinalComparator.INSTANCE);
            if (idx >= 0) {
                DataTypeComponentDB dtc = this.doDelete(idx);
                int len = dtc.getLength();
                if (len > 1) {
                    this.shiftOffsets(idx, len - 1, 0);
                } else {
                    this.compositeAdapter.updateRecord(this.record, true);
                }
                this.repack(false, false);
                this.dataMgr.dataTypeChanged(this, false);
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    private int backupToFirstComponentContainingOffset(int index, int offset) {
        DataTypeComponentDB previous;
        if (index == 0) {
            return 0;
        }
        while (index != 0 && (previous = this.components.get(index - 1)).containsOffset(offset)) {
            --index;
        }
        return index;
    }

    private int indexOfFirstNonZeroLenComponentContainingOffset(int index, int offset) {
        DataTypeComponentDB next = this.components.get(index);
        for (index = this.backupToFirstComponentContainingOffset(index, offset); next.getLength() == 0 && index < this.components.size() - 1 && (next = this.components.get(index + 1)).containsOffset(offset); ++index) {
        }
        return index;
    }

    private int advanceToLastComponentContainingOffset(int index, int offset) {
        DataTypeComponentDB next;
        while (index < this.components.size() - 1 && (next = this.components.get(index + 1)).containsOffset(offset)) {
            ++index;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAtOffset(int offset) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (offset < 0) {
                throw new IllegalArgumentException("Offset cannot be negative.");
            }
            if (offset > this.structLength) {
                return;
            }
            int index = Collections.binarySearch(this.components, offset, CompositeInternal.OffsetComparator.INSTANCE);
            if (index < 0) {
                if (offset == this.structLength) {
                    return;
                }
                this.shiftOffsets(-index - 1, -1, -1);
            } else {
                index = this.advanceToLastComponentContainingOffset(index, offset);
                DataTypeComponentDB dtc = this.components.get(index);
                while (dtc.containsOffset(offset)) {
                    this.doDeleteWithComponentShift(index, false);
                    if (--index < 0) break;
                    dtc = this.components.get(index);
                }
            }
            this.repack(false, false);
            this.notifySizeChanged(false);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAtOffset(int offset) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (offset < 0) {
                throw new IllegalArgumentException("Offset cannot be negative.");
            }
            if (offset > this.structLength) {
                return;
            }
            int index = Collections.binarySearch(this.components, offset, CompositeInternal.OffsetComparator.INSTANCE);
            if (index < 0) {
                return;
            }
            index = this.advanceToLastComponentContainingOffset(index, offset);
            DataTypeComponentDB dtc = this.components.get(index);
            while (dtc.containsOffset(offset)) {
                this.doDeleteWithComponentShift(index, true);
                if (--index < 0) break;
                dtc = this.components.get(index);
            }
            this.repack(false, false);
            this.notifySizeChanged(false);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent getDefinedComponentAtOrAfterOffset(int offset) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (offset > this.structLength || offset < 0) {
                DataTypeComponent dataTypeComponent = null;
                return dataTypeComponent;
            }
            int index = Collections.binarySearch(this.components, offset, CompositeInternal.OffsetComparator.INSTANCE);
            if (index >= 0) {
                DataTypeComponent dtc = this.components.get(index);
                index = this.backupToFirstComponentContainingOffset(index, offset);
                DataTypeComponent dataTypeComponent = dtc = (DataTypeComponent)this.components.get(index);
                return dataTypeComponent;
            }
            if ((index = -index - 1) < this.components.size()) {
                DataTypeComponent dataTypeComponent = this.components.get(index);
                return dataTypeComponent;
            }
            DataTypeComponent dataTypeComponent = null;
            return dataTypeComponent;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent getComponentContaining(int offset) {
        this.lock.acquire();
        try {
            DataTypeComponentDB dataTypeComponentDB;
            this.checkIsValid();
            if (offset > this.structLength || offset < 0) {
                DataTypeComponent dataTypeComponent = null;
                return dataTypeComponent;
            }
            int index = Collections.binarySearch(this.components, offset, CompositeInternal.OffsetComparator.INSTANCE);
            if (index >= 0) {
                DataTypeComponent dtc = this.components.get(index);
                dtc = this.components.get(index = this.indexOfFirstNonZeroLenComponentContainingOffset(index, offset));
                if (dtc.getLength() != 0) {
                    DataTypeComponent dataTypeComponent = dtc;
                    return dataTypeComponent;
                }
                index = -index - 1;
            }
            if (offset != this.structLength && !this.isPackingEnabled()) {
                dataTypeComponentDB = this.generateUndefinedComponent(offset, index);
                return dataTypeComponentDB;
            }
            dataTypeComponentDB = null;
            return dataTypeComponentDB;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DataTypeComponent> getComponentsContaining(int offset) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            ArrayList<DataTypeComponent> list = new ArrayList<DataTypeComponent>();
            if (offset > this.structLength || offset < 0) {
                ArrayList<DataTypeComponent> arrayList = list;
                return arrayList;
            }
            int index = Collections.binarySearch(this.components, offset, CompositeInternal.OffsetComparator.INSTANCE);
            boolean hasSizedComponent = false;
            if (index >= 0) {
                DataTypeComponentDB dtc = this.components.get(index);
                index = this.backupToFirstComponentContainingOffset(index, offset);
                while (index < this.components.size() && (dtc = this.components.get(index)).containsOffset(offset)) {
                    ++index;
                    hasSizedComponent |= dtc.getLength() != 0;
                    list.add(dtc);
                }
                index = -index - 1;
            }
            if (!hasSizedComponent && offset != this.structLength && !this.isPackingEnabled()) {
                list.add(this.generateUndefinedComponent(offset, index));
            }
            ArrayList<DataTypeComponent> arrayList = list;
            return arrayList;
        }
        finally {
            this.lock.release();
        }
    }

    private DataTypeComponentDB generateUndefinedComponent(int offset, int missingComponentIndex) {
        if (missingComponentIndex >= 0) {
            throw new AssertException();
        }
        missingComponentIndex = -missingComponentIndex - 1;
        int ordinal = offset;
        if (missingComponentIndex > 0) {
            DataTypeComponent dtc = this.components.get(missingComponentIndex - 1);
            ordinal = dtc.getOrdinal() + offset - dtc.getEndOffset();
            if (dtc.getLength() == 0) {
                ++ordinal;
            }
        }
        return new DataTypeComponentDB(this.dataMgr, this, ordinal, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent getDataTypeAt(int offset) {
        this.lock.acquire();
        try {
            DataType dt;
            DataTypeComponent dtc = this.getComponentContaining(offset);
            if (dtc != null && (dt = dtc.getDataType()) instanceof Structure) {
                DataTypeComponent dataTypeComponent = ((Structure)dt).getDataTypeAt(offset - dtc.getOffset());
                return dataTypeComponent;
            }
            DataTypeComponent dataTypeComponent = dtc;
            return dataTypeComponent;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataTypeComponentDB[] getDefinedComponents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            DataTypeComponentDB[] dataTypeComponentDBArray = this.components.toArray(new DataTypeComponentDB[this.components.size()]);
            return dataTypeComponentDBArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public final DataTypeComponent insertAtOffset(int offset, DataType dataType, int length) throws IllegalArgumentException {
        return this.insertAtOffset(offset, dataType, length, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent insertAtOffset(int offset, DataType dataType, int length, String name, String comment) throws IllegalArgumentException {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        if (dataType instanceof BitFieldDataType) {
            BitFieldDataType bfDt = (BitFieldDataType)dataType;
            if (length <= 0) {
                length = dataType.getLength();
            }
            try {
                return this.insertBitFieldAt(offset, length, bfDt.getBitOffset(), bfDt.getBaseDataType(), bfDt.getDeclaredBitSize(), name, comment);
            }
            catch (InvalidDataTypeException e) {
                throw new AssertException((Throwable)((Object)e));
            }
        }
        this.lock.acquire();
        try {
            DataTypeComponentDB dtc;
            this.checkDeleted();
            dataType = this.validateDataType(dataType);
            dataType = this.resolve(dataType);
            this.checkAncestry(dataType);
            if (offset > this.structLength && !this.isPackingEnabled()) {
                this.numComponents += offset - this.structLength;
                this.structLength = offset;
            }
            int index = Collections.binarySearch(this.components, offset, CompositeInternal.OffsetComparator.INSTANCE);
            int additionalShift = 0;
            if (index >= 0) {
                index = this.backupToFirstComponentContainingOffset(index, offset);
                DataTypeComponentDB dtc2 = this.components.get(index);
                additionalShift = offset - dtc2.getOffset();
            } else {
                index = -index - 1;
            }
            int ordinal = offset;
            if (index > 0) {
                dtc = this.components.get(index - 1);
                ordinal = dtc.getOrdinal() + offset - dtc.getEndOffset();
            }
            if (dataType == DataType.DEFAULT) {
                this.shiftOffsets(index, 1 + additionalShift, 1 + additionalShift);
                this.repack(false, false);
                this.notifySizeChanged(false);
                dtc = new DataTypeComponentDB(this.dataMgr, this, ordinal, offset);
                return dtc;
            }
            length = this.getPreferredComponentLength(dataType, length);
            DBRecord rec = this.componentAdapter.createRecord(this.dataMgr.getResolvedID(dataType), this.key, length, ordinal, offset, name, comment);
            dataType.addParent(this);
            DataTypeComponentDB dtc3 = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
            this.shiftOffsets(index, 1 + additionalShift, length + additionalShift);
            this.components.add(index, dtc3);
            this.repack(false, false);
            this.notifySizeChanged(false);
            DataTypeComponentDB dataTypeComponentDB = dtc3;
            return dataTypeComponentDB;
        }
        catch (DataTypeDependencyException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    private DataTypeComponent doComponentReplacement(LinkedList<DataTypeComponentDB> replacedComponents, int offset, DataType dataType, int length, String componentName, String comment) throws IOException {
        DataTypeComponentDB oldComponent = replacedComponents.get(0);
        DataType oldDt = oldComponent.getDataType();
        if (!(replacedComponents.size() != 1 || oldDt == DEFAULT || dataType == DEFAULT || length != oldComponent.getLength() || offset != oldComponent.getOffset() || this.isPackingEnabled() && dataType.getAlignment() != oldDt.getAlignment())) {
            oldComponent.update(componentName, dataType, comment);
            this.setLastChangeTime(System.currentTimeMillis());
            this.dataMgr.dataTypeChanged(this, false);
            return oldComponent;
        }
        DataTypeComponent replaceComponent = this.replaceComponents(replacedComponents, dataType, offset, length, componentName, comment);
        this.repack(false, false);
        this.record.setIntValue(4, this.structLength);
        this.compositeAdapter.updateRecord(this.record, true);
        this.notifySizeChanged(false);
        return replaceComponent;
    }

    @Override
    public final DataTypeComponent replace(int ordinal, DataType dataType, int length) throws IllegalArgumentException {
        return this.replace(ordinal, dataType, length, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent replace(int ordinal, DataType dataType, int length, String componentName, String comment) {
        this.lock.acquire();
        try {
            int offset;
            this.checkDeleted();
            if (ordinal < 0 || ordinal >= this.numComponents) {
                throw new IndexOutOfBoundsException(ordinal);
            }
            dataType = this.validateDataType(dataType);
            dataType = this.resolve(dataType);
            this.checkAncestry(dataType);
            length = this.getPreferredComponentLength(dataType, length);
            LinkedList<DataTypeComponentDB> replacedComponents = new LinkedList<DataTypeComponentDB>();
            int index = ordinal;
            if (!this.isPackingEnabled()) {
                index = Collections.binarySearch(this.components, ordinal, CompositeInternal.OrdinalComparator.INSTANCE);
            }
            if (index >= 0) {
                origDtc = this.components.get(index);
                offset = origDtc.getOffset();
                if (this.isPackingEnabled() || length == 0) {
                    replacedComponents.add(origDtc);
                } else {
                    if (origDtc.getLength() == 0) {
                        throw new IllegalArgumentException("Zero-length component may only be replaced with another zero-length component");
                    }
                    if (origDtc.isBitFieldComponent()) {
                        int i;
                        int minOffset = origDtc.getOffset();
                        int maxOffset = origDtc.getEndOffset();
                        replacedComponents.add(origDtc);
                        for (i = index - 1; i >= 0 && (origDtc = this.components.get(i)).getLength() != 0 && origDtc.containsOffset(minOffset); --i) {
                            replacedComponents.add(0, origDtc);
                        }
                        for (i = index + 1; i < this.components.size() && (origDtc = this.components.get(i)).getLength() != 0 && origDtc.containsOffset(maxOffset); ++i) {
                            replacedComponents.add(origDtc);
                        }
                    } else {
                        replacedComponents.add(origDtc);
                    }
                }
            } else {
                index = -index - 1;
                offset = ordinal;
                if (index > 0) {
                    DataTypeComponent dtc = this.components.get(index - 1);
                    offset = dtc.getEndOffset() + ordinal - dtc.getOrdinal();
                    if (dtc.getLength() == 0) {
                        --offset;
                    }
                }
                origDtc = new DataTypeComponentDB(this.dataMgr, this, ordinal, offset);
                if (dataType == DataType.DEFAULT) {
                    DataTypeComponentDB dataTypeComponentDB = origDtc;
                    return dataTypeComponentDB;
                }
                replacedComponents.add(origDtc);
            }
            DataTypeComponent replaceComponent = this.doComponentReplacement(replacedComponents, offset, dataType, length, componentName, comment);
            DataTypeComponent dataTypeComponent = replaceComponent != null ? replaceComponent : this.getComponent(ordinal);
            return dataTypeComponent;
        }
        catch (DataTypeDependencyException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
            DataTypeComponent dataTypeComponent = null;
            return dataTypeComponent;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent replaceAtOffset(int offset, DataType dataType, int length, String componentName, String comment) throws IllegalArgumentException {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        this.lock.acquire();
        try {
            DataTypeComponent dataTypeComponent;
            this.checkDeleted();
            if (offset >= this.structLength) {
                throw new IllegalArgumentException("Offset " + offset + " is beyond end of structure (" + this.structLength + ").");
            }
            dataType = this.validateDataType(dataType);
            dataType = this.resolve(dataType);
            this.checkAncestry(dataType);
            LinkedList<DataTypeComponentDB> replacedComponents = new LinkedList<DataTypeComponentDB>();
            DataTypeComponentDB origDtc = null;
            int index = Collections.binarySearch(this.components, offset, CompositeInternal.OffsetComparator.INSTANCE);
            if (index >= 0) {
                origDtc = this.components.get(index = this.advanceToLastComponentContainingOffset(index, offset));
                if (origDtc.getLength() == 0) {
                    if (this.isPackingEnabled()) {
                        DataTypeComponent dataTypeComponent2 = this.insert(index + 1, dataType, length, componentName, comment);
                        return dataTypeComponent2;
                    }
                    replacedComponents.add(new DataTypeComponentDB(this.dataMgr, this, origDtc.getOrdinal() + 1, offset));
                } else if (origDtc.isBitFieldComponent()) {
                    replacedComponents.add(origDtc);
                    for (int i = index - 1; i >= 0 && (origDtc = this.components.get(i)).getLength() != 0 && origDtc.containsOffset(offset); --i) {
                        replacedComponents.add(0, origDtc);
                    }
                } else {
                    replacedComponents.add(origDtc);
                }
            } else {
                index = -index - 1;
                if (this.isPackingEnabled()) {
                    DataTypeComponent i = this.insert(index, dataType, length, componentName, comment);
                    return i;
                }
                int ordinal = offset;
                if (index > 0) {
                    DataTypeComponent dtc = this.components.get(index - 1);
                    ordinal = dtc.getOrdinal() + offset - dtc.getEndOffset();
                }
                origDtc = new DataTypeComponentDB(this.dataMgr, this, ordinal, offset);
                if (dataType == DataType.DEFAULT) {
                    dataTypeComponent = origDtc;
                    return dataTypeComponent;
                }
                replacedComponents.add(origDtc);
            }
            length = this.getPreferredComponentLength(dataType, length);
            DataTypeComponent replaceComponent = this.doComponentReplacement(replacedComponents, offset, dataType, length, componentName, comment);
            dataTypeComponent = replaceComponent != null ? replaceComponent : this.getComponentContaining(offset);
            return dataTypeComponent;
        }
        catch (DataTypeDependencyException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
            DataTypeComponent dataTypeComponent = null;
            return dataTypeComponent;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceWith(DataType dataType) {
        if (!(dataType instanceof StructureInternal)) {
            throw new IllegalArgumentException();
        }
        this.lock.acquire();
        boolean isResolveCacheOwner = this.dataMgr.activateResolveCache();
        try {
            this.checkDeleted();
            this.doReplaceWith((StructureInternal)dataType, true);
        }
        catch (DataTypeDependencyException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            if (isResolveCacheOwner) {
                this.dataMgr.flushResolveQueue(true);
            }
            this.lock.release();
        }
    }

    void doReplaceWith(StructureInternal struct, boolean notify) throws DataTypeDependencyException, IOException {
        int oldAlignment = this.getAlignment();
        int oldLength = this.structLength;
        DataTypeComponent[] otherComponents = struct.getDefinedComponents();
        DataType[] resolvedDts = new DataType[otherComponents.length];
        for (int i = 0; i < otherComponents.length; ++i) {
            resolvedDts[i] = this.doCheckedResolve(otherComponents[i].getDataType());
        }
        for (DataTypeComponentDB dtc : this.components) {
            dtc.getDataType().removeParent(this);
            long compKey = dtc.getKey();
            this.componentAdapter.removeRecord(compKey);
            this.dataMgr.getSettingsAdapter().removeAllSettingsRecords(compKey);
        }
        this.components.clear();
        this.numComponents = 0;
        this.structLength = 0;
        this.structAlignment = -1;
        this.computedAlignment = -1;
        this.doSetPackingAndAlignment(struct);
        if (struct.getDataTypeManager() == this.dataMgr) {
            this.doCopy(struct, otherComponents, resolvedDts);
        } else {
            if (struct.isPackingEnabled()) {
                this.doReplaceWithPacked(struct, resolvedDts);
            } else {
                this.doReplaceWithNonPacked(struct, resolvedDts);
            }
            this.repack(false, false);
        }
        this.record.setIntValue(6, this.numComponents);
        this.record.setIntValue(4, this.structLength);
        this.record.setIntValue(5, this.structAlignment);
        this.compositeAdapter.updateRecord(this.record, true);
        if (notify) {
            if (this.structLength != oldLength) {
                this.notifySizeChanged(false);
            } else if (this.structAlignment != oldAlignment) {
                this.notifyAlignmentChanged(false);
            } else {
                this.dataMgr.dataTypeChanged(this, false);
            }
        }
        if (this.pointerPostResolveRequired) {
            this.dataMgr.queuePostResolve(this, struct);
        }
    }

    private void doReplaceWithPacked(Structure struct, DataType[] resolvedDts) {
        DataTypeComponent[] otherComponents = struct.getDefinedComponents();
        for (int i = 0; i < otherComponents.length; ++i) {
            DataTypeComponent dtc = otherComponents[i];
            DataType dt = dtc.getDataType();
            int length = dt instanceof Dynamic ? dtc.getLength() : -1;
            try {
                this.doAdd(resolvedDts[i], length, dtc.getFieldName(), dtc.getComment(), false);
                continue;
            }
            catch (DataTypeDependencyException e) {
                throw new AssertException((Throwable)e);
            }
        }
    }

    private void doReplaceWithNonPacked(Structure struct, DataType[] resolvedDts) throws IOException {
        if (struct.isNotYetDefined()) {
            return;
        }
        this.numComponents = this.structLength = struct.isZeroLength() ? 0 : struct.getLength();
        DataTypeComponent[] otherComponents = struct.getDefinedComponents();
        for (int i = 0; i < otherComponents.length; ++i) {
            int length;
            DataTypeComponent dtc = otherComponents[i];
            DataType dt = resolvedDts[i];
            int n = length = DataTypeComponent.usesZeroLengthComponent(dt) ? 0 : dt.getLength();
            if (length < 0 || dtc.isBitFieldComponent()) {
                length = dtc.getLength();
            } else {
                int nextIndex = i + 1;
                int maxOffset = nextIndex < otherComponents.length ? otherComponents[nextIndex].getOffset() : this.structLength;
                if (length > 0) {
                    length = Math.min(length, maxOffset - dtc.getOffset());
                }
            }
            DBRecord rec = this.componentAdapter.createRecord(this.dataMgr.getResolvedID(dt), this.key, length, dtc.getOrdinal(), dtc.getOffset(), dtc.getFieldName(), dtc.getComment());
            dt.addParent(this);
            DataTypeComponentDB newDtc = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
            this.components.add(newDtc);
        }
    }

    private void doCopy(Structure struct, DataTypeComponent[] definedComponents, DataType[] resolvedDts) throws IOException {
        this.structLength = struct.isZeroLength() ? 0 : struct.getLength();
        this.numComponents = struct.getNumComponents();
        this.structAlignment = struct.getAlignment();
        DataTypeComponent[] otherComponents = struct.getDefinedComponents();
        for (int i = 0; i < otherComponents.length; ++i) {
            DataTypeComponent dtc = otherComponents[i];
            DataType dt = resolvedDts[i];
            DBRecord rec = this.componentAdapter.createRecord(this.dataMgr.getResolvedID(dt), this.key, dtc.getLength(), dtc.getOrdinal(), dtc.getOffset(), dtc.getFieldName(), dtc.getComment());
            dt.addParent(this);
            DataTypeComponentDB newDtc = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
            this.components.add(newDtc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeDeleted(DataType dt) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            boolean changed = false;
            int n = this.components.size();
            for (int i = n - 1; i >= 0; --i) {
                DataTypeComponentDB dtc = this.components.get(i);
                boolean removeBitFieldComponent = false;
                if (dtc.isBitFieldComponent()) {
                    BitFieldDataType bitfieldDt = (BitFieldDataType)dtc.getDataType();
                    boolean bl = removeBitFieldComponent = bitfieldDt.getBaseDataType() == dt;
                }
                if (!removeBitFieldComponent && dtc.getDataType() != dt) continue;
                this.doDelete(i);
                this.shiftOffsets(i, dtc.getLength() - 1, 0);
                --this.numComponents;
                changed = true;
            }
            if (changed && !this.repack(false, true)) {
                this.dataMgr.dataTypeChanged(this, false);
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeSizeChanged(DataType dt) {
        if (dt instanceof BitFieldDataType) {
            return;
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.isPackingEnabled()) {
                if (!this.repack(true, true)) {
                    this.dataMgr.dataTypeChanged(this, true);
                }
                return;
            }
            int oldLength = this.structLength;
            boolean changed = false;
            boolean warn = false;
            int n = this.components.size();
            for (int i = 0; i < n; ++i) {
                int consumed;
                int length;
                DataTypeComponentDB dtc = this.components.get(i);
                if (dtc.getDataType() != dt) continue;
                int dtcLen = dtc.getLength();
                int n2 = length = DataTypeComponent.usesZeroLengthComponent(dt) ? 0 : dt.getLength();
                if (length < 0) {
                    length = dtcLen;
                }
                if (length < dtcLen) {
                    dtc.setLength(length, true);
                    this.shiftOffsets(i + 1, dtcLen - length, 0);
                    changed = true;
                } else if (length > dtcLen && (consumed = this.consumeBytesAfter(i, length - dtcLen)) > 0) {
                    this.shiftOffsets(i + 1, -consumed, 0);
                    changed = true;
                }
                if (dtc.getLength() == length) continue;
                warn = true;
            }
            if (warn) {
                Msg.warn((Object)this, (Object)("Failed to resize one or more structure components: " + this.getPathName()));
            }
            if (changed) {
                this.repack(false, false);
                if (oldLength != this.structLength) {
                    this.notifySizeChanged(false);
                } else {
                    this.dataMgr.dataTypeChanged(this, false);
                }
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    protected void fixupComponents() throws IOException {
        boolean isPacked = this.isPackingEnabled();
        boolean didChange = false;
        boolean warn = false;
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            int consumed;
            int dtcLen;
            int length;
            DataTypeComponentDB dtc = this.components.get(i);
            DataType dt = dtc.getDataType();
            if (dt instanceof Dynamic || dt instanceof BitFieldDataType) continue;
            int n2 = length = DataTypeComponent.usesZeroLengthComponent(dt) ? 0 : dt.getLength();
            if (length < 0 || (dtcLen = dtc.getLength()) == length) continue;
            if (isPacked) {
                dtc.setLength(length, true);
                didChange = true;
            } else if (length < dtcLen) {
                dtc.setLength(length, true);
                this.shiftOffsets(i + 1, dtcLen - length, 0);
                didChange = true;
            } else if (length > dtcLen && (consumed = this.consumeBytesAfter(i, length - dtcLen)) > 0) {
                this.shiftOffsets(i + 1, -consumed, 0);
                didChange = true;
            }
            if (dtc.getLength() == length) continue;
            warn = true;
        }
        if (didChange) {
            this.repack(false, false);
            this.compositeAdapter.updateRecord(this.record, true);
            this.dataMgr.dataTypeChanged(this, false);
        }
        if (warn) {
            Msg.warn((Object)this, (Object)("Failed to resize one or more structure components: " + this.getPathName()));
        }
    }

    @Override
    public void dataTypeAlignmentChanged(DataType dt) {
        this.lock.acquire();
        try {
            if (this.isPackingEnabled()) {
                this.checkDeleted();
                this.repack(true, true);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEquivalent(DataType dataType) {
        if (dataType == this) {
            return true;
        }
        if (!(dataType instanceof StructureInternal)) {
            return false;
        }
        this.validate(this.lock);
        if (this.resolving) {
            if (dataType.getUniversalID().equals((Object)this.getUniversalID())) {
                return true;
            }
            return DataTypeUtilities.equalsIgnoreConflict(this.getPathName(), dataType.getPathName());
        }
        Boolean isEquivalent = this.dataMgr.getCachedEquivalence(this, dataType);
        if (isEquivalent != null) {
            return isEquivalent;
        }
        try {
            int otherNumComps;
            isEquivalent = false;
            StructureInternal struct = (StructureInternal)dataType;
            int otherLength = struct.isZeroLength() ? 0 : struct.getLength();
            int packing = this.getStoredPackingValue();
            if (packing != struct.getStoredPackingValue() || this.getStoredMinimumAlignment() != struct.getStoredMinimumAlignment() || packing == -1 && this.structLength != otherLength) {
                boolean bl = false;
                return bl;
            }
            int myNumComps = this.components.size();
            if (myNumComps != (otherNumComps = struct.getNumDefinedComponents())) {
                boolean bl = false;
                return bl;
            }
            DataTypeComponent[] otherDefinedComponents = struct.getDefinedComponents();
            if (otherDefinedComponents.length != myNumComps) {
                boolean bl = false;
                return bl;
            }
            for (int i = 0; i < myNumComps; ++i) {
                DataTypeComponent otherDtc;
                DataTypeComponent myDtc = this.components.get(i);
                if (myDtc.isEquivalent(otherDtc = otherDefinedComponents[i])) continue;
                boolean bl = false;
                return bl;
            }
            isEquivalent = true;
        }
        finally {
            this.dataMgr.putCachedEquivalence(this, dataType, isEquivalent);
        }
        return true;
    }

    private int consumeBytesAfter(int definedComponentIndex, int numBytes) {
        int available;
        DataTypeComponentDB thisDtc = this.components.get(definedComponentIndex);
        int thisLen = thisDtc.getLength();
        int nextOffset = thisDtc.getOffset() + thisLen;
        if (definedComponentIndex == this.components.size() - 1) {
            available = this.structLength - nextOffset;
            if (numBytes > available) {
                this.doGrowStructure(numBytes - available);
                available = numBytes;
            }
        } else {
            DataTypeComponent nextDtc = this.components.get(definedComponentIndex + 1);
            available = nextDtc.getOffset() - nextOffset;
        }
        if (numBytes <= available) {
            thisDtc.setLength(thisLen + numBytes, true);
            return numBytes;
        }
        thisDtc.setLength(thisLen + available, true);
        return available;
    }

    private int getLastDefinedComponentOrdinal() {
        if (this.components.size() == 0) {
            return 0;
        }
        DataTypeComponentDB dataTypeComponentDB = this.components.get(this.components.size() - 1);
        return dataTypeComponentDB.getOrdinal();
    }

    private void shiftOffsets(int definedComponentIndex, int deltaOrdinal, int deltaOffset) {
        if (deltaOffset == 0 && deltaOrdinal == 0) {
            return;
        }
        for (int i = definedComponentIndex; i < this.components.size(); ++i) {
            DataTypeComponentDB dtc = this.components.get(i);
            this.shiftOffset(dtc, deltaOrdinal, deltaOffset);
        }
        this.structLength += deltaOffset;
        if (!this.isPackingEnabled()) {
            this.numComponents += deltaOrdinal;
        }
        this.record.setIntValue(6, this.numComponents);
        this.record.setIntValue(4, this.structLength);
        try {
            this.compositeAdapter.updateRecord(this.record, true);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    protected void shiftOffset(DataTypeComponentDB dtc, int deltaOrdinal, int deltaOffset) {
        dtc.setOffset(dtc.getOffset() + deltaOffset, false);
        dtc.setOrdinal(dtc.getOrdinal() + deltaOrdinal, false);
        dtc.updateRecord(false);
    }

    private void checkUndefinedSpaceAvailabilityAfter(int lastOrdinalReplacedOrUpdated, int bytesNeeded, DataType newDataType, int offset) throws IllegalArgumentException {
        if (bytesNeeded <= 0) {
            return;
        }
        int bytesAvailable = this.getNumUndefinedBytes(lastOrdinalReplacedOrUpdated + 1);
        if (bytesAvailable < bytesNeeded) {
            if (lastOrdinalReplacedOrUpdated == this.getLastDefinedComponentOrdinal()) {
                this.growStructure(bytesNeeded - bytesAvailable);
            } else {
                throw new IllegalArgumentException("Not enough undefined bytes to fit " + newDataType.getPathName() + " in structure " + this.getPathName() + " at offset 0x" + Integer.toHexString(offset) + ". It needs " + (bytesNeeded - bytesAvailable) + " more byte(s) to be able to fit.");
            }
        }
    }

    private DataTypeComponent replaceComponents(LinkedList<DataTypeComponentDB> origComponents, DataType resolvedDataType, int newOffset, int length, String name, String comment) throws IOException, IllegalArgumentException {
        int index;
        boolean clearOnly = false;
        if (resolvedDataType == DataType.DEFAULT) {
            clearOnly = true;
            length = 0;
        }
        DataTypeComponentDB origFirstDtc = origComponents.getFirst();
        DataTypeComponentDB origLastDtc = origComponents.getLast();
        int origFirstOrdinal = origFirstDtc.getOrdinal();
        int origLastOrdinal = origLastDtc.getOrdinal();
        int minReplacedOffset = origFirstDtc.getOffset();
        int maxReplacedOffset = origLastDtc.getEndOffset();
        if (newOffset < minReplacedOffset || newOffset > maxReplacedOffset) {
            throw new AssertException("newOffset not contained within origComponents");
        }
        if (origComponents.size() > 1) {
            int checkOrdinal = origFirstOrdinal;
            for (DataTypeComponentDB origDtc : origComponents) {
                if (origDtc.isUndefined()) {
                    throw new AssertException("undefined component within multi-component sequence");
                }
                if (origDtc.getOrdinal() == checkOrdinal++) continue;
                throw new AssertException("non-sequential components specified");
            }
        }
        int leadingUnusedBytes = newOffset - minReplacedOffset;
        int newOrdinal = origFirstOrdinal;
        if (!this.isPackingEnabled()) {
            newOrdinal += leadingUnusedBytes;
        }
        int origLength = 0;
        if (origLastDtc.getLength() != 0) {
            origLength = maxReplacedOffset - minReplacedOffset + 1;
        }
        if (!clearOnly && !this.isPackingEnabled()) {
            int bytesNeeded = length - origLength + leadingUnusedBytes;
            this.checkUndefinedSpaceAvailabilityAfter(origLastOrdinal, bytesNeeded, resolvedDataType, newOffset);
        }
        if ((index = this.isPackingEnabled() ? newOrdinal : Collections.binarySearch(this.components, origFirstOrdinal, CompositeInternal.OrdinalComparator.INSTANCE)) < 0) {
            index = -index - 1;
        } else {
            for (DataTypeComponentDB origDtc : origComponents) {
                DataTypeComponentDB dtc = this.doDelete(index);
                if (dtc == origDtc) continue;
                throw new AssertException("component replacement mismatch");
            }
        }
        DataTypeComponentDB newDtc = null;
        if (!clearOnly) {
            DBRecord rec = this.componentAdapter.createRecord(this.dataMgr.getResolvedID(resolvedDataType), this.key, length, newOrdinal, newOffset, name, comment);
            resolvedDataType.addParent(this);
            newDtc = new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
            this.components.add(index, newDtc);
        }
        if (!this.isPackingEnabled()) {
            int deltaOrdinal = -origComponents.size() + origLength - length;
            this.shiftOffsets(index + 1, deltaOrdinal, 0);
        }
        return newDtc;
    }

    private int getNumUndefinedBytes(int ordinal) {
        if (this.isPackingEnabled()) {
            return 0;
        }
        if (ordinal >= this.numComponents) {
            return 0;
        }
        int idx = Collections.binarySearch(this.components, ordinal, CompositeInternal.OrdinalComparator.INSTANCE);
        DataTypeComponentDB dtc = null;
        if (idx < 0) {
            if ((idx = -idx - 1) >= this.components.size()) {
                return this.numComponents - ordinal;
            }
            dtc = this.components.get(idx);
            return dtc.getOrdinal() - ordinal;
        }
        return 0;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        if (oldDt == this) {
            return;
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            DataType replacementDt = newDt;
            try {
                this.validateDataType(replacementDt);
                replacementDt = this.resolve(replacementDt);
                this.checkAncestry(replacementDt);
            }
            catch (Exception e) {
                replacementDt = DataType.DEFAULT;
            }
            boolean changed = false;
            for (int i = this.components.size() - 1; i >= 0; --i) {
                DataTypeComponentDB comp = this.components.get(i);
                int nextIndex = i + 1;
                boolean remove = false;
                if (comp.isBitFieldComponent()) {
                    try {
                        changed |= this.updateBitFieldDataType(comp, oldDt, replacementDt);
                    }
                    catch (InvalidDataTypeException e) {
                        Msg.error((Object)this, (Object)("Invalid bitfield replacement type " + newDt.getName() + ", removing bitfield " + comp.getDataType().getName() + ": " + this.getPathName()));
                        remove = true;
                    }
                } else if (comp.getDataType() == oldDt) {
                    if (replacementDt == DEFAULT && this.isPackingEnabled()) {
                        Msg.error((Object)this, (Object)("Invalid replacement type " + newDt.getName() + ", removing component " + comp.getDataType().getName() + ": " + this.getPathName()));
                        remove = true;
                    } else {
                        this.setComponentDataType(comp, replacementDt, nextIndex);
                        changed = true;
                    }
                }
                if (!remove) continue;
                this.doDelete(i);
                this.shiftOffsets(i, comp.getLength() - 1, 0);
                changed = true;
            }
            if (changed) {
                this.repack(false, false);
                this.compositeAdapter.updateRecord(this.record, true);
                this.notifySizeChanged(false);
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    private void setComponentDataType(DataTypeComponentDB comp, DataType newDt, int nextIndex) throws IOException {
        int len;
        int oldLen = comp.getLength();
        int n = len = DataTypeComponent.usesZeroLengthComponent(newDt) ? 0 : newDt.getLength();
        if (len < 0) {
            len = oldLen;
        }
        comp.getDataType().removeParent(this);
        if (this.isPackingEnabled()) {
            comp.setLength(len, false);
        }
        comp.setDataType(newDt);
        this.dataMgr.getSettingsAdapter().removeAllSettingsRecords(comp.getKey());
        newDt.addParent(this);
        if (this.isPackingEnabled()) {
            return;
        }
        if (len < oldLen) {
            comp.setLength(len, true);
            this.shiftOffsets(nextIndex, oldLen - len, 0);
        } else if (len > oldLen) {
            int bytesNeeded = len - oldLen;
            int bytesAvailable = this.getNumUndefinedBytes(comp.getOrdinal() + 1);
            if (bytesNeeded <= bytesAvailable) {
                comp.setLength(len, true);
                this.shiftOffsets(nextIndex, -bytesNeeded, 0);
            } else if (comp.getOrdinal() == this.getLastDefinedComponentOrdinal()) {
                this.doGrowStructure(bytesNeeded - bytesAvailable);
                comp.setLength(len, true);
                this.shiftOffsets(nextIndex, -bytesNeeded, 0);
            } else {
                comp.setLength(oldLen + bytesAvailable, true);
                this.shiftOffsets(nextIndex, -bytesAvailable, 0);
            }
        }
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAll() {
        this.lock.acquire();
        try {
            this.checkDeleted();
            for (DataTypeComponentDB dtc : this.components) {
                dtc.getDataType().removeParent(this);
                try {
                    long compKey = dtc.getKey();
                    this.componentAdapter.removeRecord(compKey);
                    this.dataMgr.getSettingsAdapter().removeAllSettingsRecords(compKey);
                }
                catch (IOException e) {
                    this.dataMgr.dbError(e);
                }
            }
            this.components.clear();
            this.structLength = 0;
            this.numComponents = 0;
            this.record.setIntValue(4, 0);
            this.record.setIntValue(6, 0);
            this.compositeAdapter.updateRecord(this.record, true);
            this.notifySizeChanged(false);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean repack(boolean isAutoChange, boolean notify) {
        this.lock.acquire();
        try {
            boolean changed;
            this.checkDeleted();
            int oldLength = this.structLength;
            int oldAlignment = this.getComputedAlignment(true);
            this.computedAlignment = -1;
            if (!this.isPackingEnabled()) {
                changed = this.adjustNonPackedComponents(!isAutoChange);
            } else {
                AlignedStructurePacker.StructurePackResult packResult = AlignedStructurePacker.packComponents(this, this.components);
                changed = packResult.componentsChanged;
                changed |= this.updateComposite(this.components.size(), packResult.structureLength, packResult.alignment, !isAutoChange);
            }
            if (changed && notify) {
                if (oldLength != this.structLength) {
                    this.notifySizeChanged(isAutoChange);
                } else if (oldAlignment != this.structAlignment) {
                    this.notifyAlignmentChanged(isAutoChange);
                }
                this.dataMgr.dataTypeChanged(this, isAutoChange);
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    private boolean adjustNonPackedComponents(boolean setLastChangeTime) {
        boolean changed = false;
        int componentCount = 0;
        int currentOffset = 0;
        for (DataTypeComponentDB dataTypeComponent : this.components) {
            int componentLength = dataTypeComponent.getLength();
            int componentOffset = dataTypeComponent.getOffset();
            int numUndefinedsBefore = componentOffset - currentOffset;
            if (numUndefinedsBefore > 0) {
                componentCount += numUndefinedsBefore;
            }
            currentOffset = componentOffset + componentLength;
            if (dataTypeComponent.getOrdinal() != componentCount) {
                dataTypeComponent.setOrdinal(componentCount, true);
                changed = true;
            }
            ++componentCount;
        }
        int numUndefinedsAfter = this.structLength - currentOffset;
        return changed |= this.updateComposite(componentCount += numUndefinedsAfter, this.structLength, this.getNonPackedAlignment(), setLastChangeTime);
    }

    private boolean updateComposite(int currentNumComponents, int currentLength, int currentAlignment, boolean setLastChangeTime) {
        boolean compositeChanged = false;
        if (currentNumComponents >= 0 && this.numComponents != currentNumComponents) {
            this.numComponents = currentNumComponents;
            this.record.setIntValue(6, this.numComponents);
            setLastChangeTime = true;
            compositeChanged = true;
        }
        if (currentLength >= 0 && this.structLength != currentLength) {
            this.structLength = currentLength;
            this.record.setIntValue(4, this.structLength);
            compositeChanged = true;
        }
        if (currentAlignment >= 0 && this.structAlignment != currentAlignment) {
            this.structAlignment = currentAlignment;
            this.record.setIntValue(5, this.structAlignment);
            compositeChanged = true;
        }
        if (compositeChanged) {
            try {
                this.compositeAdapter.updateRecord(this.record, setLastChangeTime);
                return true;
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
        }
        return false;
    }
}

