/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.Schema;
import db.Table;
import ghidra.program.database.data.ParentChildAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

class ParentChildDBAdapterV0
extends ParentChildAdapter {
    private static final int VERSION = 0;
    private static final int PARENT_COL = 0;
    private static final int CHILD_COL = 1;
    static final Schema V0_SCHEMA = new Schema(0, "KEY", new Field[]{LongField.INSTANCE, LongField.INSTANCE}, new String[]{"Parent ID", "Child ID"});
    private Table table;
    private boolean needsInitializing = false;

    ParentChildDBAdapterV0(DBHandle handle, boolean create) throws VersionException, IOException {
        if (create) {
            this.table = handle.createTable("DT_PARENT_CHILD", V0_SCHEMA, new int[]{0, 1});
        } else {
            this.table = handle.getTable("DT_PARENT_CHILD");
            if (this.table == null) {
                throw new VersionException(true);
            }
            if (this.table.getSchema().getVersion() != 0) {
                throw new VersionException("Expected version 0 for table DT_PARENT_CHILD but got " + this.table.getSchema().getVersion());
            }
        }
    }

    @Override
    public void createRecord(long parentID, long childID) throws IOException {
        long key = this.table.getKey();
        DBRecord record = V0_SCHEMA.createRecord(key);
        record.setLongValue(0, parentID);
        record.setLongValue(1, childID);
        this.table.putRecord(record);
    }

    @Override
    void removeRecord(long parentID, long childID) throws IOException {
        Field[] ids;
        for (Field id : ids = this.table.findRecords((Field)new LongField(childID), 1)) {
            DBRecord rec = this.table.getRecord(id);
            if (rec.getLongValue(0) != parentID) continue;
            this.table.deleteRecord(id);
            return;
        }
    }

    @Override
    Set<Long> getParentIds(long childID) throws IOException {
        Field[] ids = this.table.findRecords((Field)new LongField(childID), 1);
        HashSet<Long> parentIds = new HashSet<Long>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            DBRecord rec = this.table.getRecord(ids[i]);
            parentIds.add(rec.getLongValue(0));
        }
        return parentIds;
    }

    public void setNeedsInitializing() {
        this.needsInitializing = true;
    }

    @Override
    boolean needsInitializing() {
        return this.needsInitializing;
    }

    @Override
    void removeAllRecordsForParent(long parentID) throws IOException {
        Field[] ids;
        for (Field id : ids = this.table.findRecords((Field)new LongField(parentID), 0)) {
            this.table.deleteRecord(id);
        }
    }

    @Override
    void removeAllRecordsForChild(long childID) throws IOException {
        Field[] ids;
        for (Field id : ids = this.table.findRecords((Field)new LongField(childID), 1)) {
            this.table.deleteRecord(id);
        }
    }
}

