/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.pattern;

import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import ghidra.app.plugin.processors.sleigh.pattern.OrPattern;
import ghidra.app.plugin.processors.sleigh.pattern.Pattern;
import ghidra.app.plugin.processors.sleigh.pattern.PatternBlock;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.StringUtilities;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class ContextPattern
extends DisjointPattern {
    private PatternBlock maskvalue;

    @Override
    public PatternBlock getBlock(boolean context) {
        return context ? this.maskvalue : null;
    }

    public ContextPattern() {
        this.maskvalue = null;
    }

    public ContextPattern(PatternBlock mv) {
        this.maskvalue = mv;
    }

    public PatternBlock getBlock() {
        return this.maskvalue;
    }

    @Override
    public Pattern simplifyClone() {
        return new ContextPattern((PatternBlock)this.maskvalue.clone());
    }

    @Override
    public void shiftInstruction(int sa) {
    }

    @Override
    public Pattern doOr(Pattern b, int sa) {
        if (!(b instanceof ContextPattern)) {
            return b.doOr(this, -sa);
        }
        return new OrPattern((DisjointPattern)this.simplifyClone(), (DisjointPattern)b.simplifyClone());
    }

    @Override
    public Pattern doAnd(Pattern b, int sa) {
        if (!(b instanceof ContextPattern)) {
            return b.doAnd(this, -sa);
        }
        PatternBlock resblock = this.maskvalue.andBlock(((ContextPattern)b).maskvalue);
        return new ContextPattern(resblock);
    }

    @Override
    public boolean isMatch(ParserWalker walker, SleighDebugLogger debug) throws MemoryAccessException {
        boolean match = this.maskvalue.isContextMatch(walker);
        this.debugPatternMatch(debug, walker, match);
        return match;
    }

    private void debugPatternMatch(SleighDebugLogger debug, ParserWalker walker, boolean match) {
        if (debug == null) {
            return;
        }
        debug.append("context pattern: ");
        if (this.alwaysTrue()) {
            debug.append("always-Matched\n");
        } else if (this.alwaysFalse()) {
            debug.append("always-Failed\n");
        } else {
            debug.addContextPattern(this.maskvalue);
            if (debug.isVerboseEnabled()) {
                debug.append("mask=");
                debug.append(this.maskvalue.maskvec, -1, 0);
                debug.append("\n");
                int startbit = this.maskvalue.offset * 8;
                int endbit = startbit + 31 + 32 * (this.maskvalue.maskvec.length - 1);
                String leader = "context(" + startbit + ".." + endbit + ")=";
                debug.append(StringUtilities.pad((String)leader, (char)' ', (int)22));
                for (int i = 0; i < this.maskvalue.maskvec.length; ++i) {
                    if (i != 0) {
                        debug.append(".");
                    }
                    debug.append(walker.getParserContext().getContextBytes(this.maskvalue.offset + i * 4, 4), -1, 0);
                }
                debug.append("\n");
                debug.append("          match-value=");
                debug.append(this.maskvalue.valvec, -1, 0);
                debug.append(" " + (match ? "Matched" : "Failed") + "\n");
                debug.dumpContextPattern(this.maskvalue.maskvec, this.maskvalue.valvec, this.maskvalue.offset, walker.getParserContext());
            }
        }
    }

    @Override
    public boolean alwaysTrue() {
        return this.maskvalue.alwaysTrue();
    }

    @Override
    public boolean alwaysFalse() {
        return this.maskvalue.alwaysFalse();
    }

    @Override
    public boolean alwaysInstructionTrue() {
        return true;
    }

    @Override
    public void restoreXml(XmlPullParser parser) {
        XmlElement el = parser.start(new String[]{"context_pat"});
        this.maskvalue = new PatternBlock(true);
        this.maskvalue.restoreXml(parser);
        parser.end(el);
    }

    public String toString() {
        if (this.alwaysTrue()) {
            return "always";
        }
        if (this.alwaysFalse()) {
            return "never";
        }
        return "ctx:" + this.maskvalue;
    }
}

