/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler;

import ghidra.app.plugin.assembler.Assembler;
import ghidra.app.plugin.assembler.AssemblySemanticException;
import ghidra.app.plugin.assembler.AssemblySyntaxException;
import ghidra.program.model.address.Address;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class AssemblyBuffer {
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final Assembler asm;
    private final Address entry;

    public AssemblyBuffer(Assembler asm, Address entry) {
        this.asm = asm;
        this.entry = entry;
    }

    public Address getNext() {
        return this.entry.add(this.baos.size());
    }

    public byte[] assemble(String line) throws AssemblySyntaxException, AssemblySemanticException, IOException {
        return this.emit(this.asm.assembleLine(this.getNext(), line));
    }

    public byte[] emit(byte[] bytes) throws IOException {
        this.baos.write(bytes);
        return bytes;
    }

    public byte[] getBytes() {
        return this.baos.toByteArray();
    }
}

