/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.DecompilerProvider;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesService;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;

public class FindReferencesToHighSymbolAction
extends AbstractDecompilerAction {
    private static final String MENU_ITEM_TEXT = "Find References to";
    public static final String NAME = "Find References to Symbol";

    public FindReferencesToHighSymbolAction() {
        super(NAME);
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionFindReferences"));
        this.setPopupMenuData(new MenuData(new String[]{"References", MENU_ITEM_TEXT}));
    }

    private void updateMenuName(String newName) {
        String menuName = "Find References to " + newName;
        MenuData data = this.getPopupMenuData().cloneData();
        data.setMenuPath(new String[]{"References", menuName});
        this.setPopupMenuData(data);
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = this.getFunction(context);
        if (function != null && !(function instanceof UndefinedFunction)) {
            this.updateMenuName(function.getName());
            return true;
        }
        ClangToken token = context.getTokenAtCursor();
        if (token == null) {
            return false;
        }
        HighSymbol highSymbol = FindReferencesToHighSymbolAction.findHighSymbolFromToken(token, context.getHighFunction());
        if (highSymbol == null || highSymbol.getStorage().isBadStorage() || !highSymbol.isGlobal()) {
            return false;
        }
        this.updateMenuName(highSymbol.getName());
        return true;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        LocationReferencesService service = (LocationReferencesService)context.getTool().getService(LocationReferencesService.class);
        if (service == null) {
            Msg.showError((Object)((Object)this), null, (String)"Missing Plugin", (Object)("The " + LocationReferencesService.class.getSimpleName() + " is not installed.\nPlease add the plugin implementing this service."));
            return;
        }
        LabelFieldLocation location = null;
        Function function = this.getFunction(context);
        if (function != null && !(function instanceof UndefinedFunction)) {
            location = new LabelFieldLocation(function.getSymbol());
        } else {
            HighSymbol highSymbol = FindReferencesToHighSymbolAction.findHighSymbolFromToken(context.getTokenAtCursor(), context.getHighFunction());
            location = new LabelFieldLocation(context.getProgram(), highSymbol.getStorage().getMinAddress(), highSymbol.getName());
        }
        DecompilerProvider provider = context.getComponentProvider();
        service.showReferencesToLocation((ProgramLocation)location, (Navigatable)provider);
    }
}

