/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.workflow;

import ghidra.app.plugin.core.debug.service.workflow.AbstractMultiToolTraceListener;
import ghidra.app.plugin.core.debug.service.workflow.DebuggerWorkflowServicePlugin;
import ghidra.app.plugin.core.debug.service.workflow.MultiToolTraceListenerManager;
import ghidra.app.services.DebuggerBot;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.ProgramManager;
import ghidra.async.AsyncDebouncer;
import ghidra.async.AsyncTimer;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractMapDebuggerBot
implements DebuggerBot {
    private DebuggerWorkflowServicePlugin plugin;
    private final MultiToolTraceListenerManager<ForChangesTraceListener> listeners = new MultiToolTraceListenerManager<ForChangesTraceListener>(x$0 -> new ForChangesTraceListener((Trace)x$0));
    private final Set<Trace> traceQueue = new HashSet<Trace>();
    private final AsyncDebouncer<Void> debouncer = new AsyncDebouncer(AsyncTimer.DEFAULT_TIMER, 500L);

    public AbstractMapDebuggerBot() {
        this.debouncer.addListener(this::queueSettled);
    }

    protected abstract Collection<TraceChangeType<?, ?>> getChangeTypes();

    @Override
    public void enable(DebuggerWorkflowServicePlugin wp) {
        this.plugin = wp;
        this.listeners.enable(wp);
        for (PluginTool t : this.plugin.getProxyingPluginTools()) {
            DebuggerTraceManagerService traceManager = (DebuggerTraceManagerService)t.getService(DebuggerTraceManagerService.class);
            if (traceManager == null) continue;
            this.queueTraces(traceManager.getOpenTraces());
        }
    }

    @Override
    public void disable() {
        this.plugin = null;
        this.listeners.disable();
    }

    @Override
    public boolean isEnabled() {
        return this.plugin != null;
    }

    @Override
    public void traceOpened(PluginTool tool, Trace trace) {
        this.listeners.traceOpened(tool, trace);
        this.queueTrace(trace);
    }

    @Override
    public void traceClosed(PluginTool tool, Trace trace) {
        this.listeners.traceClosed(tool, trace);
    }

    @Override
    public void programOpened(PluginTool t, Program program) {
        DebuggerTraceManagerService traceManager = (DebuggerTraceManagerService)t.getService(DebuggerTraceManagerService.class);
        if (traceManager == null) {
            return;
        }
        this.queueTraces(traceManager.getOpenTraces());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueTrace(Trace trace) {
        Set<Trace> set = this.traceQueue;
        synchronized (set) {
            this.traceQueue.add(trace);
        }
        this.debouncer.contact(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueTraces(Collection<Trace> traces) {
        Set<Trace> set = this.traceQueue;
        synchronized (set) {
            this.traceQueue.addAll(traces);
        }
        this.debouncer.contact(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueSettled(Void __) {
        Set<Trace> traces;
        Set<Trace> set = this.traceQueue;
        synchronized (set) {
            traces = Set.copyOf(this.traceQueue);
            this.traceQueue.clear();
        }
        HashMap<Trace, Pair> toAnalyze = new HashMap<Trace, Pair>();
        for (Trace trace : traces) {
            for (PluginTool tool : this.plugin.getProxyingPluginTools()) {
                ProgramManager programManager;
                DebuggerTraceManagerService traceManager = (DebuggerTraceManagerService)tool.getService(DebuggerTraceManagerService.class);
                if (traceManager == null || (programManager = (ProgramManager)tool.getService(ProgramManager.class)) == null || !traceManager.getOpenTraces().contains(trace)) continue;
                Pair programs = toAnalyze.computeIfAbsent(trace, t -> Pair.of((Object)tool, new HashSet()));
                ((Set)programs.getRight()).addAll(List.of(programManager.getAllOpenPrograms()));
            }
        }
        for (Map.Entry entry : toAnalyze.entrySet()) {
            PluginTool tool = (PluginTool)((Pair)entry.getValue()).getLeft();
            Trace trace = (Trace)entry.getKey();
            Set programs = (Set)((Pair)entry.getValue()).getRight();
            this.analyzeTrace(tool, trace, programs);
        }
    }

    private void analyzeTrace(final PluginTool tool, final Trace trace, final Set<Program> programs) {
        BackgroundCommand cmd = new BackgroundCommand(this.getDescription(), true, true, false){

            public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
                try {
                    AbstractMapDebuggerBot.this.doAnalysis(tool, trace, programs, monitor);
                    return true;
                }
                catch (CancelledException e) {
                    return false;
                }
            }
        };
        tool.executeBackgroundCommand(cmd, (UndoableDomainObject)trace);
    }

    protected abstract void doAnalysis(PluginTool var1, Trace var2, Set<Program> var3, TaskMonitor var4) throws CancelledException;

    protected class ForChangesTraceListener
    extends AbstractMultiToolTraceListener {
        public ForChangesTraceListener(Trace trace) {
            super(trace);
            for (TraceChangeType<?, ?> type : AbstractMapDebuggerBot.this.getChangeTypes()) {
                this.listenFor(type, this::changed);
            }
        }

        private void changed() {
            AbstractMapDebuggerBot.this.queueTrace(this.trace);
        }
    }
}

