/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import ghidra.app.plugin.core.debug.mapping.DebuggerMemoryMapper;
import ghidra.app.plugin.core.debug.mapping.DebuggerRegisterMapper;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerTargetTraceMapper;
import ghidra.app.plugin.core.debug.service.model.DefaultBreakpointRecorder;
import ghidra.app.plugin.core.debug.service.model.DefaultStackRecorder;
import ghidra.app.plugin.core.debug.service.model.DefaultTraceRecorder;
import ghidra.app.plugin.core.debug.service.model.TraceObjectManager;
import ghidra.app.plugin.core.debug.service.model.interfaces.AbstractRecorderMemory;
import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedBreakpointRecorder;
import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedStackRecorder;
import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedThreadRecorder;
import ghidra.app.services.TraceRecorderListener;
import ghidra.async.AsyncUtils;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetMemoryRegion;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetRegister;
import ghidra.dbg.target.TargetRegisterBank;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.Trace;
import ghidra.trace.model.listing.TraceCodeManager;
import ghidra.trace.model.listing.TraceCodeSpace;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.listing.TraceDefinedDataView;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import ghidra.util.TimedMsg;
import ghidra.util.exception.DuplicateNameException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class DefaultThreadRecorder
implements ManagedThreadRecorder {
    private final TargetThread targetThread;
    private final TraceThread traceThread;
    protected final AbstractRecorderMemory threadMemory;
    protected TargetBreakpointSpecContainer threadBreakpointContainer;
    protected Map<Integer, TargetRegisterBank> regs = new HashMap<Integer, TargetRegisterBank>();
    protected Collection<TargetRegister> extraRegs;
    protected TargetExecutionStateful.TargetExecutionState state = TargetExecutionStateful.TargetExecutionState.ALIVE;
    private final DefaultTraceRecorder recorder;
    private final Trace trace;
    private final TraceObjectManager objectManager;
    private final TraceMemoryManager memoryManager;
    private DebuggerRegisterMapper regMapper;
    private final DefaultDebuggerTargetTraceMapper mapper;
    private final DefaultStackRecorder stackRecorder;
    private final DefaultBreakpointRecorder breakpointRecorder;

    protected static int getFrameLevel(TargetStackFrame frame) {
        return Integer.decode(frame.getIndex());
    }

    public DefaultThreadRecorder(DefaultTraceRecorder recorder, DefaultDebuggerTargetTraceMapper mapper, TargetThread targetThread, TraceThread traceThread) {
        this.recorder = recorder;
        this.mapper = mapper;
        this.trace = recorder.getTrace();
        this.objectManager = recorder.objectManager;
        this.targetThread = targetThread;
        this.traceThread = traceThread;
        this.memoryManager = this.trace.getMemoryManager();
        this.threadMemory = recorder.getProcessMemory();
        if (targetThread instanceof TargetExecutionStateful) {
            TargetExecutionStateful stateful = (TargetExecutionStateful)targetThread;
            this.state = stateful.getExecutionState();
        }
        this.stackRecorder = new DefaultStackRecorder(traceThread, recorder);
        this.breakpointRecorder = new DefaultBreakpointRecorder(recorder);
    }

    protected synchronized CompletableFuture<Void> initRegMapper(TargetRegisterContainer registers) {
        return this.objectManager.getRegMappers().get((Object)registers).thenAccept(rm -> {
            DefaultThreadRecorder defaultThreadRecorder = this;
            synchronized (defaultThreadRecorder) {
                this.regMapper = rm;
                Language language = this.trace.getBaseLanguage();
                this.extraRegs = new LinkedHashSet<TargetRegister>();
                for (String rn : this.mapper.getExtraRegNames()) {
                    Register traceReg = language.getRegister(rn);
                    if (traceReg == null) {
                        Msg.error((Object)this, (Object)("Mapper's extra register '" + rn + "' is not in the language!"));
                        continue;
                    }
                    TargetRegister targetReg = this.regMapper.traceToTarget(traceReg);
                    if (targetReg == null) {
                        Msg.error((Object)this, (Object)("Mapper's extra register '" + traceReg + "' is not mappable!"));
                        continue;
                    }
                    this.extraRegs.add(targetReg);
                }
            }
        }).exceptionally(ex -> {
            Msg.error((Object)this, (Object)"Could not intialize register mapper", (Throwable)ex);
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> doFetchAndInitRegMapper(TargetRegisterBank bank) {
        TargetRegisterContainer descs = bank.getDescriptions();
        if (descs == null) {
            Msg.error((Object)this, (Object)"Cannot create mapper, yet: Descriptions is null.");
            return AsyncUtils.NIL;
        }
        return ((CompletableFuture)this.initRegMapper(descs).thenAccept(__ -> ((TraceRecorderListener)this.recorder.getListeners().fire).registerBankMapped(this.recorder))).exceptionally(ex -> {
            Msg.error((Object)this, (Object)"Could not intialize register mapper", (Throwable)ex);
            return null;
        });
    }

    public CompletableFuture<Map<Register, RegisterValue>> captureThreadRegisters(TraceThread thread, int frameLevel, Set<Register> registers) {
        if (this.regMapper == null) {
            throw new IllegalStateException("Have not found register descriptions for " + thread);
        }
        if (!this.regMapper.getRegistersOnTarget().containsAll(registers)) {
            throw new IllegalArgumentException("All given registers must be recognized by the target");
        }
        if (registers.isEmpty()) {
            return CompletableFuture.completedFuture(Map.of());
        }
        List tRegs = registers.stream().map(this.regMapper::traceToTarget).collect(Collectors.toList());
        TargetRegisterBank bank = this.getTargetRegisterBank(thread, frameLevel);
        if (bank == null) {
            throw new IllegalArgumentException("Given thread and frame level does not have a live register bank");
        }
        return bank.readRegisters(tRegs).thenApply(this.regMapper::targetToTrace);
    }

    public TargetRegisterBank getTargetRegisterBank(TraceThread thread, int frameLevel) {
        return this.regs.get(frameLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void regMapperAmended(DebuggerRegisterMapper rm, TargetRegister reg, boolean removed) {
        String name = reg.getIndex();
        DefaultThreadRecorder defaultThreadRecorder = this;
        synchronized (defaultThreadRecorder) {
            if (this.regMapper != rm) {
                return;
            }
            if (this.mapper.getExtraRegNames().contains(name)) {
                if (removed) {
                    this.extraRegs.remove(reg);
                } else {
                    this.extraRegs.add(reg);
                }
            }
        }
    }

    @Override
    public void offerRegisters(TargetRegisterBank bank) {
        int frameLevel;
        TargetRegisterBank old;
        if (this.regMapper == null) {
            this.doFetchAndInitRegMapper(bank);
        }
        if (null != (old = this.regs.put(frameLevel = this.stackRecorder.getSuccessorFrameLevel((TargetObject)bank), bank))) {
            Msg.warn((Object)this, (Object)"Unexpected register bank replacement");
        }
    }

    @Override
    public void removeRegisters(TargetRegisterBank bank) {
        int frameLevel = this.stackRecorder.getSuccessorFrameLevel((TargetObject)bank);
        TargetRegisterBank old = this.regs.remove(frameLevel);
        if (bank != old) {
            Msg.warn((Object)this, (Object)"Unexpected register bank upon removal");
        }
    }

    @Override
    public void offerThreadRegion(TargetMemoryRegion region) {
        TargetMemory mem = region.getMemory();
        this.threadMemory.addRegion(region, mem);
    }

    @Override
    public void stateChanged(TargetExecutionStateful.TargetExecutionState newState) {
        this.state = newState;
    }

    public void threadDestroyed() {
        String path = this.getTargetThread().getJoinedPath(".");
        long snap = this.recorder.getSnap();
        this.recorder.parTx.execute("Thread " + path + " destroyed", () -> {
            try {
                this.getTraceThread().setDestructionSnap(snap);
            }
            catch (DuplicateNameException e) {
                throw new AssertionError((Object)e);
            }
        }, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordRegisterValues(TargetRegisterBank bank, Map<String, byte[]> updates) {
        DefaultTraceRecorder defaultTraceRecorder = this.recorder;
        synchronized (defaultTraceRecorder) {
            if (this.regMapper == null) {
                this.doFetchAndInitRegMapper(bank);
            }
        }
        int frameLevel = this.stackRecorder.getSuccessorFrameLevel((TargetObject)bank);
        long snap = this.recorder.getSnap();
        String path = bank.getJoinedPath(".");
        TimedMsg.debug((Object)this, (String)("Reg values changed: " + updates.keySet()));
        this.recorder.parTx.execute("Registers " + path + " changed", () -> {
            TraceCodeManager codeManager = this.trace.getCodeManager();
            TraceCodeSpace codeRegisterSpace = codeManager.getCodeRegisterSpace(this.traceThread, false);
            TraceDefinedDataView definedData = codeRegisterSpace == null ? null : codeRegisterSpace.definedData();
            TraceMemorySpace regSpace = this.memoryManager.getMemoryRegisterSpace(this.traceThread, frameLevel, true);
            for (Map.Entry ent : updates.entrySet()) {
                TraceData td;
                RegisterValue rv = this.regMapper.targetToTrace((String)ent.getKey(), (byte[])ent.getValue());
                if (rv == null) continue;
                regSpace.setValue(snap, rv);
                Register register = rv.getRegister();
                if (definedData == null || (td = (TraceData)definedData.getForRegister(snap, register)) == null || !(td.getDataType() instanceof Pointer)) continue;
                Address addr = this.registerValueToTargetAddress(rv, (byte[])ent.getValue());
                this.readAlignedConditionally((String)ent.getKey(), addr);
            }
        }, this.getTargetThread().getJoinedPath("."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordRegisterValue(TargetRegister targetRegister, byte[] value) {
        TargetRegisterBank bank = (TargetRegisterBank)targetRegister.getParent();
        DefaultTraceRecorder defaultTraceRecorder = this.recorder;
        synchronized (defaultTraceRecorder) {
            if (this.regMapper == null) {
                this.doFetchAndInitRegMapper(bank);
            }
        }
        int frameLevel = this.stackRecorder.getSuccessorFrameLevel((TargetObject)bank);
        long snap = this.recorder.getSnap();
        String path = targetRegister.getJoinedPath(".");
        this.recorder.parTx.execute("Register " + path + " changed", () -> {
            TraceData td;
            RegisterValue rv;
            TraceCodeManager codeManager = this.trace.getCodeManager();
            TraceCodeSpace codeRegisterSpace = codeManager.getCodeRegisterSpace(this.traceThread, false);
            TraceDefinedDataView definedData = codeRegisterSpace == null ? null : codeRegisterSpace.definedData();
            TraceMemorySpace regSpace = this.memoryManager.getMemoryRegisterSpace(this.traceThread, frameLevel, true);
            String key = targetRegister.getName();
            if (PathUtils.isIndex((String)key)) {
                key = key.substring(1, key.length() - 1);
            }
            if ((rv = this.regMapper.targetToTrace(key, value)) == null) {
                return;
            }
            regSpace.setValue(snap, rv);
            Register register = rv.getRegister();
            if (definedData != null && (td = (TraceData)definedData.getForRegister(snap, register)) != null && td.getDataType() instanceof Pointer) {
                Address addr = this.registerValueToTargetAddress(rv, value);
                this.readAlignedConditionally(key, addr);
            }
        }, this.getTargetThread().getJoinedPath("."));
    }

    @Override
    public void invalidateRegisterValues(TargetRegisterBank bank) {
        int frameLevel = this.stackRecorder.getSuccessorFrameLevel((TargetObject)bank);
        long snap = this.recorder.getSnap();
        String path = bank.getJoinedPath(".");
        this.recorder.parTx.execute("Registers invalidated: " + path, () -> {
            TraceMemorySpace regSpace = this.memoryManager.getMemoryRegisterSpace(this.traceThread, frameLevel, false);
            if (regSpace == null) {
                return;
            }
            AddressSpace as = regSpace.getAddressSpace();
            regSpace.setState(snap, as.getMinAddress(), as.getMaxAddress(), TraceMemoryState.UNKNOWN);
        }, path);
    }

    public CompletableFuture<Void> writeThreadRegisters(int frameLevel, Map<Register, RegisterValue> values) {
        if (!this.regMapper.getRegistersOnTarget().containsAll(values.keySet())) {
            throw new IllegalArgumentException("All given registers must be recognized by the target");
        }
        if (values.isEmpty()) {
            return AsyncUtils.NIL;
        }
        Map<String, byte[]> tVals = values.entrySet().stream().map(ent -> {
            if (ent.getKey() != ((RegisterValue)ent.getValue()).getRegister()) {
                throw new IllegalArgumentException("register name mismatch in value");
            }
            return this.regMapper.traceToTarget((RegisterValue)ent.getValue());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        TargetRegisterBank bank = this.getTargetRegisterBank(this.traceThread, frameLevel);
        if (bank == null) {
            throw new IllegalArgumentException("Given thread and frame level does not have a live register bank");
        }
        return bank.writeRegistersNamed(tVals).thenApply(__ -> null);
    }

    Address registerValueToTargetAddress(RegisterValue rv, byte[] value) {
        Address traceAddress = this.trace.getBaseLanguage().getDefaultSpace().getAddress(rv.getUnsignedValue().longValue());
        return this.objectManager.getMemoryMapper().traceToTarget(traceAddress);
    }

    protected CompletableFuture<?> readAlignedConditionally(String name, Address targetAddress) {
        if (targetAddress == null) {
            return AsyncUtils.NIL;
        }
        Address traceAddress = this.objectManager.getMemoryMapper().targetToTrace(targetAddress);
        if (traceAddress == null) {
            return AsyncUtils.NIL;
        }
        if (!this.checkReadCondition(traceAddress)) {
            return AsyncUtils.NIL;
        }
        AddressRange targetRange = this.threadMemory.alignAndLimitToFloor(targetAddress, 1);
        if (targetRange == null) {
            return AsyncUtils.NIL;
        }
        TimedMsg.debug((Object)this, (String)("  Reading memory at " + name + " (" + targetAddress + " -> " + targetRange + ")"));
        return this.threadMemory.readMemory(targetRange.getMinAddress(), (int)targetRange.getLength()).exceptionally(ex -> {
            Msg.error((Object)this, (Object)("Could not read memory at " + name), (Throwable)ex);
            return null;
        });
    }

    protected boolean checkReadCondition(Address traceAddress) {
        TraceMemoryRegion region = this.memoryManager.getRegionContaining(this.recorder.getSnap(), traceAddress);
        if (region == null) {
            return false;
        }
        if (region.isWrite()) {
            return true;
        }
        Map.Entry ent = this.memoryManager.getMostRecentStateEntry(this.recorder.getSnap(), traceAddress);
        if (ent == null) {
            return true;
        }
        return ent.getValue() != TraceMemoryState.KNOWN;
    }

    @Override
    public TargetThread getTargetThread() {
        return this.targetThread;
    }

    @Override
    public TraceThread getTraceThread() {
        return this.traceThread;
    }

    @Override
    public long getSnap() {
        return this.recorder.getSnap();
    }

    @Override
    public Trace getTrace() {
        return this.recorder.getTrace();
    }

    @Override
    public DebuggerMemoryMapper getMemoryMapper() {
        return this.recorder.objectManager.getMemoryMapper();
    }

    @Override
    public ManagedStackRecorder getStackRecorder() {
        return this.stackRecorder;
    }

    @Override
    public ManagedBreakpointRecorder getBreakpointRecorder() {
        return this.breakpointRecorder;
    }

    @Override
    public synchronized boolean objectRemoved(TargetObject invalid) {
        if (this.checkThreadRemoved(invalid)) {
            return true;
        }
        if (this.stackRecorder.checkStackFrameRemoved(invalid)) {
            return false;
        }
        if (this.threadMemory.removeRegion(invalid)) {
            return false;
        }
        Msg.trace((Object)this, (Object)("Ignored removed object: " + invalid));
        return false;
    }

    protected boolean checkThreadRemoved(TargetObject invalid) {
        if (this.getTargetThread() == invalid) {
            this.threadDestroyed();
            return true;
        }
        return false;
    }

    public DebuggerRegisterMapper getRegisterMapper() {
        return this.regMapper;
    }
}

