/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.stack;

import docking.ActionContext;
import docking.WindowPosition;
import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.stack.DebuggerStackActionContext;
import ghidra.app.plugin.core.debug.gui.stack.DebuggerStackPlugin;
import ghidra.app.plugin.core.debug.gui.stack.StackFrameRow;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerModelService;
import ghidra.app.services.DebuggerStaticMappingChangeListener;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.TraceRecorder;
import ghidra.dbg.DebugModelConventions;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeType;
import ghidra.trace.util.TraceRegisterUtils;
import ghidra.util.Swing;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import utilities.util.SuppressableCallback;

public class DebuggerStackProvider
extends ComponentProviderAdapter {
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    private Trace currentTrace;
    private TraceStack currentStack;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private DebuggerModelService modelService;
    DebuggerStaticMappingService mappingService;
    @AutoServiceConsumed
    private DebuggerListingService listingService;
    @AutoServiceConsumed
    private MarkerService markerService;
    private final AutoService.Wiring autoServiceWiring;
    private ForStackListener forStackListener = new ForStackListener();
    private ForFunctionsListener forFunctionsListener = new ForFunctionsListener();
    private final SuppressableCallback<Void> cbFrameSelected = new SuppressableCallback();
    protected final StackTableModel stackTableModel;
    protected GhidraTable stackTable;
    protected GhidraTableFilterPanel<StackFrameRow> stackFilterPanel;
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private DebuggerStackActionContext myActionContext;

    protected static boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getTrace(), b.getTrace())) {
            return false;
        }
        if (!Objects.equals(a.getThread(), b.getThread())) {
            return false;
        }
        if (!Objects.equals(a.getTime(), b.getTime())) {
            return false;
        }
        return Objects.equals(a.getFrame(), b.getFrame());
    }

    public DebuggerStackProvider(DebuggerStackPlugin plugin) {
        super(plugin.getTool(), "Stack", plugin.getName());
        this.stackTableModel = new StackTableModel(this.tool);
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.setTitle("Stack");
        this.setIcon(DebuggerResources.ICON_PROVIDER_STACK);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_STACK);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.setDefaultWindowPosition(WindowPosition.LEFT);
        this.createActions();
        this.setVisible(true);
        this.contextChanged();
    }

    protected void buildMainPanel() {
        this.stackTable = new GhidraTable((TableModel)((Object)this.stackTableModel));
        this.mainPanel.add(new JScrollPane((Component)this.stackTable));
        this.stackFilterPanel = new GhidraTableFilterPanel((JTable)this.stackTable, (RowObjectTableModel)this.stackTableModel);
        this.mainPanel.add((Component)this.stackFilterPanel, "South");
        this.stackTable.getSelectionModel().addListSelectionListener(evt -> {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            this.contextChanged();
            this.activateSelectedFrame();
        });
        this.stackTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2 || e.getButton() != 1) {
                    return;
                }
                if (DebuggerStackProvider.this.listingService == null) {
                    return;
                }
                if (DebuggerStackProvider.this.myActionContext == null) {
                    return;
                }
                Address pc = DebuggerStackProvider.this.myActionContext.getFrame().getProgramCounter();
                if (pc == null) {
                    return;
                }
                DebuggerStackProvider.this.listingService.goTo(pc, true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int selectedRow = DebuggerStackProvider.this.stackTable.getSelectedRow();
                StackFrameRow row = (StackFrameRow)DebuggerStackProvider.this.stackTableModel.getRowObject(selectedRow);
                DebuggerStackProvider.this.rowActivated(row);
            }
        });
        TableColumnModel columnModel = this.stackTable.getColumnModel();
        TableColumn levelCol = columnModel.getColumn(StackTableColumns.LEVEL.ordinal());
        levelCol.setPreferredWidth(25);
        TableColumn baseCol = columnModel.getColumn(StackTableColumns.PC.ordinal());
        baseCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
    }

    public void contextChanged() {
        StackFrameRow row = (StackFrameRow)this.stackFilterPanel.getSelectedItem();
        this.myActionContext = row == null ? null : new DebuggerStackActionContext(this, row, (Component)this.stackTable);
        super.contextChanged();
    }

    protected void activateSelectedFrame() {
        if (this.myActionContext == null) {
            return;
        }
        if (this.traceManager == null) {
            return;
        }
        this.cbFrameSelected.invoke(() -> this.traceManager.activateFrame(this.myActionContext.getFrame().getFrameLevel()));
    }

    private void rowActivated(StackFrameRow row) {
        if (row == null) {
            return;
        }
        TraceStackFrame frame = row.frame;
        if (frame == null) {
            return;
        }
        TraceThread thread = frame.getStack().getThread();
        Trace trace = thread.getTrace();
        TraceRecorder recorder = this.modelService.getRecorder(trace);
        if (recorder == null) {
            return;
        }
        TargetStackFrame targetFrame = recorder.getTargetStackFrame(thread, frame.getLevel());
        if (targetFrame == null || !targetFrame.isValid()) {
            return;
        }
        DebugModelConventions.requestActivation((TargetObject)targetFrame);
    }

    protected void createActions() {
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.myActionContext == null) {
            return super.getActionContext(event);
        }
        return this.myActionContext;
    }

    protected void updateStack() {
        LinkedHashSet toAdd = new LinkedHashSet(this.currentStack.getFrames(this.current.getSnap()));
        Iterator it = this.stackTableModel.getModelData().iterator();
        while (it.hasNext()) {
            StackFrameRow row = (StackFrameRow)it.next();
            if (!toAdd.remove(row.frame)) {
                it.remove();
                continue;
            }
            row.update();
        }
        for (TraceStackFrame frame : toAdd) {
            this.stackTableModel.add(new StackFrameRow(this, frame));
        }
        this.stackTableModel.fireTableDataChanged();
        this.selectCurrentFrame();
    }

    protected void doSetCurrentStack(TraceStack stack) {
        if (stack == null) {
            this.currentStack = null;
            this.stackTableModel.clear();
            this.contextChanged();
            return;
        }
        if (this.currentStack == stack && stack.hasFixedFrames()) {
            this.stackTableModel.fireTableDataChanged();
            return;
        }
        this.currentStack = stack;
        this.stackTableModel.clear();
        for (TraceStackFrame frame : this.currentStack.getFrames(this.current.getSnap())) {
            this.stackTableModel.add(new StackFrameRow(this, frame));
        }
    }

    protected void doSetSyntheticStack() {
        this.stackTableModel.clear();
        this.currentStack = null;
        Trace curTrace = this.current.getTrace();
        TraceMemorySpace regs = curTrace.getMemoryManager().getMemoryRegisterSpace(this.current.getThread(), false);
        if (regs == null) {
            this.contextChanged();
            return;
        }
        Register pc = curTrace.getBaseLanguage().getProgramCounter();
        if (pc == null) {
            this.contextChanged();
            return;
        }
        RegisterValue value = regs.getViewValue(this.current.getViewSnap(), pc);
        if (value == null) {
            this.contextChanged();
            return;
        }
        Address address = curTrace.getBaseLanguage().getDefaultSpace().getAddress(value.getUnsignedValue().longValue(), true);
        this.stackTableModel.add(new StackFrameRow.Synthetic(this, address));
    }

    protected void loadStack() {
        TraceThread curThread = this.current.getThread();
        if (curThread == null) {
            this.doSetCurrentStack(null);
            return;
        }
        TraceStack stack = this.current.getTrace().getStackManager().getLatestStack(curThread, this.current.getViewSnap());
        if (stack == null) {
            this.doSetSyntheticStack();
        } else {
            this.doSetCurrentStack(stack);
        }
        this.selectCurrentFrame();
    }

    protected String computeSubTitle() {
        TraceThread curThread = this.current.getThread();
        return curThread == null ? "" : curThread.getName();
    }

    protected void updateSubTitle() {
        this.setSubTitle(this.computeSubTitle());
    }

    private void removeOldListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.removeListener((DomainObjectListener)this.forStackListener);
    }

    private void addNewListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.addListener((DomainObjectListener)this.forStackListener);
    }

    private void doSetTrace(Trace trace) {
        if (this.currentTrace == trace) {
            return;
        }
        this.removeOldListeners();
        this.currentTrace = trace;
        this.addNewListeners();
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        if (DebuggerStackProvider.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        this.current = coordinates;
        this.doSetTrace(this.current.getTrace());
        this.loadStack();
        this.updateSubTitle();
    }

    protected void selectCurrentFrame() {
        try (SuppressableCallback.Suppression supp = this.cbFrameSelected.suppress(null);){
            StackFrameRow row = (StackFrameRow)this.stackTableModel.findFirst(r -> r.getFrameLevel() == this.current.getFrame());
            if (row == null) {
                this.stackTable.clearSelection();
            } else {
                this.stackFilterPanel.setSelectedItem((Object)row);
            }
        }
    }

    @AutoServiceConsumed
    public void setModelService(DebuggerModelService modelService) {
        this.modelService = modelService;
    }

    @AutoServiceConsumed
    private void setMappingService(DebuggerStaticMappingService mappingService) {
        if (this.mappingService != null) {
            this.mappingService.removeChangeListener(this.forFunctionsListener);
        }
        this.mappingService = mappingService;
        if (this.mappingService != null) {
            this.mappingService.addChangeListener(this.forFunctionsListener);
        }
    }

    class ForStackListener
    extends TraceDomainObjectListener {
        public ForStackListener() {
            this.listenFor((TraceChangeType)Trace.TraceStackChangeType.ADDED, this::stackAdded);
            this.listenFor((TraceChangeType)Trace.TraceStackChangeType.CHANGED, this::stackChanged);
            this.listenFor((TraceChangeType)Trace.TraceStackChangeType.DELETED, this::stackDeleted);
            this.listenFor((TraceChangeType)Trace.TraceMemoryBytesChangeType.CHANGED, this::bytesChanged);
        }

        private void stackAdded(TraceStack stack) {
            if (stack.getSnap() != DebuggerStackProvider.this.current.getViewSnap()) {
                return;
            }
            TraceThread curThread = DebuggerStackProvider.this.current.getThread();
            if (curThread != stack.getThread()) {
                return;
            }
            DebuggerStackProvider.this.loadStack();
        }

        private void stackChanged(TraceStack stack) {
            if (DebuggerStackProvider.this.currentStack != stack) {
                return;
            }
            DebuggerStackProvider.this.updateStack();
        }

        private void stackDeleted(TraceStack stack) {
            if (DebuggerStackProvider.this.currentStack != stack) {
                return;
            }
            DebuggerStackProvider.this.loadStack();
        }

        private void bytesChanged(TraceAddressSpace space, TraceAddressSnapRange range) {
            TraceThread curThread = DebuggerStackProvider.this.current.getThread();
            if (space.getThread() != curThread || space.getFrameLevel() != 0) {
                return;
            }
            if (!DebuggerStackProvider.this.current.getView().getViewport().containsAnyUpper(range.getLifespan())) {
                return;
            }
            List stackData = DebuggerStackProvider.this.stackTableModel.getModelData();
            if (stackData.isEmpty() || !(stackData.get(0) instanceof StackFrameRow.Synthetic)) {
                return;
            }
            StackFrameRow.Synthetic frameRow = (StackFrameRow.Synthetic)stackData.get(0);
            Trace trace = DebuggerStackProvider.this.current.getTrace();
            Register pc = trace.getBaseLanguage().getProgramCounter();
            if (!TraceRegisterUtils.rangeForRegister((Register)pc).intersects(range.getRange())) {
                return;
            }
            TraceMemorySpace regs = trace.getMemoryManager().getMemoryRegisterSpace(curThread, false);
            RegisterValue value = regs.getViewValue(DebuggerStackProvider.this.current.getViewSnap(), pc);
            Address address = trace.getBaseLanguage().getDefaultSpace().getAddress(value.getUnsignedValue().longValue());
            frameRow.updateProgramCounter(address);
            DebuggerStackProvider.this.stackTableModel.fireTableDataChanged();
        }
    }

    class ForFunctionsListener
    implements DebuggerStaticMappingChangeListener {
        ForFunctionsListener() {
        }

        @Override
        public void mappingsChanged(Set<Trace> affectedTraces, Set<Program> affectedPrograms) {
            Trace curTrace = DebuggerStackProvider.this.current.getTrace();
            if (curTrace == null || !affectedTraces.contains(curTrace)) {
                return;
            }
            Swing.runIfSwingOrRunLater(() -> DebuggerStackProvider.this.stackTableModel.fireTableDataChanged());
        }
    }

    protected static class StackTableModel
    extends DefaultEnumeratedColumnTableModel<StackTableColumns, StackFrameRow> {
        public StackTableModel(PluginTool tool) {
            super(tool, "Stack", StackTableColumns.class);
        }

        public List<StackTableColumns> defaultSortOrder() {
            return List.of(StackTableColumns.LEVEL);
        }
    }

    protected static enum StackTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<StackTableColumns, StackFrameRow>
    {
        LEVEL("Level", Integer.class, StackFrameRow::getFrameLevel),
        PC("PC", Address.class, StackFrameRow::getProgramCounter),
        FUNCTION("Function", ghidra.program.model.listing.Function.class, StackFrameRow::getFunction),
        COMMENT("Comment", String.class, StackFrameRow::getComment, StackFrameRow::setComment, StackFrameRow::isCommentable);

        private final String header;
        private final Function<StackFrameRow, ?> getter;
        private final BiConsumer<StackFrameRow, Object> setter;
        private final Predicate<StackFrameRow> editable;
        private final Class<?> cls;

        private <T> StackTableColumns(String header, Class<T> cls, Function<StackFrameRow, T> getter, BiConsumer<StackFrameRow, T> setter, Predicate<StackFrameRow> editable) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
            this.editable = editable;
        }

        private <T> StackTableColumns(String header, Class<T> cls, Function<StackFrameRow, T> getter) {
            this(header, cls, getter, null, null);
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(StackFrameRow row) {
            return this.getter.apply(row);
        }

        public void setValueOf(StackFrameRow row, Object value) {
            this.setter.accept(row, value);
        }

        public String getHeader() {
            return this.header;
        }

        public boolean isEditable(StackFrameRow row) {
            return this.setter != null && this.editable.test(row);
        }
    }
}

