/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.action.LocationTracker;
import ghidra.app.plugin.core.debug.gui.action.LocationTrackingSpecFactory;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.util.TraceAddressSpace;
import javax.swing.Icon;

public interface LocationTrackingSpec {
    public static boolean changeIsCurrent(TraceAddressSpace space, TraceAddressSnapRange range, DebuggerCoordinates current) {
        TraceMemorySpace memSpace;
        if (space == null) {
            return false;
        }
        if (!(space.getAddressSpace().isMemorySpace() || (memSpace = current.getTrace().getMemoryManager().getMemoryRegisterSpace(current.getThread(), current.getFrame(), false)) != null && memSpace.getAddressSpace() == space.getAddressSpace())) {
            return false;
        }
        return range.getLifespan().contains((Comparable)Long.valueOf(current.getSnap()));
    }

    public String getConfigName();

    public String getMenuName();

    public Icon getMenuIcon();

    public String computeTitle(DebuggerCoordinates var1);

    public LocationTracker getTracker();

    public static class TrackingSpecConfigFieldCodec
    implements AutoConfigState.ConfigFieldCodec<LocationTrackingSpec> {
        public LocationTrackingSpec read(SaveState state, String name, LocationTrackingSpec current) {
            String specName = state.getString(name, null);
            return LocationTrackingSpecFactory.fromConfigName(specName);
        }

        public void write(SaveState state, String name, LocationTrackingSpec value) {
            state.putString(name, value.getConfigName());
        }
    }
}

