/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug;

import com.google.common.collect.Range;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.TraceRecorder;
import ghidra.dbg.target.TargetObject;
import ghidra.framework.data.ProjectFileManager;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.stack.TraceObjectStackFrame;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.Msg;
import ghidra.util.NotOwnerException;
import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jdom.Element;

public class DebuggerCoordinates {
    public static final DebuggerCoordinates NOWHERE = new DebuggerCoordinates(null, null, null, null, null, null, null, null);
    private static final String KEY_TRACE_PROJ_LOC = "TraceProjLoc";
    private static final String KEY_TRACE_PROJ_NAME = "TraceProjName";
    private static final String KEY_TRACE_PATH = "TracePath";
    private static final String KEY_TRACE_VERSION = "TraceVersion";
    private static final String KEY_THREAD_KEY = "ThreadKey";
    private static final String KEY_TIME = "Time";
    private static final String KEY_FRAME = "Frame";
    private static final String KEY_OBJ_PATH = "ObjectPath";
    private final Trace trace;
    private final TracePlatform platform;
    private final TraceRecorder recorder;
    private final TraceThread thread;
    private final TraceProgramView view;
    private final TraceSchedule time;
    private final Integer frame;
    private final TraceObject object;
    private final int hash;
    private Long viewSnap;
    private TraceObject registerContainer;

    public static boolean equalsIgnoreRecorderAndView(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.trace, b.trace)) {
            return false;
        }
        if (!Objects.equals(a.platform, b.platform)) {
            return false;
        }
        if (!Objects.equals(a.thread, b.thread)) {
            return false;
        }
        if (!Objects.equals(a.getTime(), b.getTime())) {
            return false;
        }
        if (!Objects.equals(a.getFrame(), b.getFrame())) {
            return false;
        }
        return Objects.equals(a.getObject(), b.getObject());
    }

    DebuggerCoordinates(Trace trace, TracePlatform platform, TraceRecorder recorder, TraceThread thread, TraceProgramView view, TraceSchedule time, Integer frame, TraceObject object) {
        this.trace = trace;
        this.platform = platform;
        this.recorder = recorder;
        this.thread = thread;
        this.view = view;
        this.time = time;
        this.frame = frame;
        this.object = object;
        this.hash = Objects.hash(trace, recorder, thread, view, time, frame, object);
    }

    public String toString() {
        return String.format("Coords(trace=%s,recorder=%s,thread=%s,view=%s,time=%s,frame=%d,object=%s)", this.trace, this.recorder, this.thread, this.view, this.time, this.frame, this.object);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DebuggerCoordinates)) {
            return false;
        }
        DebuggerCoordinates that = (DebuggerCoordinates)obj;
        if (!Objects.equals(this.trace, that.trace)) {
            return false;
        }
        if (!Objects.equals(this.recorder, that.recorder)) {
            return false;
        }
        if (!Objects.equals(this.thread, that.thread)) {
            return false;
        }
        if (!Objects.equals(this.view, that.view)) {
            return false;
        }
        if (!Objects.equals(this.time, that.time)) {
            return false;
        }
        if (!Objects.equals(this.frame, that.frame)) {
            return false;
        }
        return Objects.equals(this.object, that.object);
    }

    public int hashCode() {
        return this.hash;
    }

    private static TracePlatform resolvePlatform(Trace trace) {
        return trace.getPlatformManager().getHostPlatform();
    }

    private static TraceThread resolveThread(Trace trace, TraceSchedule time) {
        long snap = time.getSnap();
        return trace.getThreadManager().getLiveThreads(snap).stream().findFirst().orElse(null);
    }

    private static TraceThread resolveThread(Trace trace) {
        return DebuggerCoordinates.resolveThread(trace, TraceSchedule.ZERO);
    }

    private static TraceObject resolveObject(Trace trace) {
        return trace.getObjectManager().getRootObject();
    }

    private static TraceProgramView resolveView(Trace trace, TraceSchedule time) {
        return trace.getProgramView();
    }

    private static TraceProgramView resolveView(Trace trace) {
        return DebuggerCoordinates.resolveView(trace, TraceSchedule.ZERO);
    }

    public DebuggerCoordinates trace(Trace newTrace) {
        if (newTrace == null) {
            return NOWHERE;
        }
        if (this.trace == newTrace) {
            return this;
        }
        if (this.trace == null) {
            TracePlatform newPlatform = DebuggerCoordinates.resolvePlatform(newTrace);
            TraceThread newThread = DebuggerCoordinates.resolveThread(newTrace);
            TraceProgramView newView = DebuggerCoordinates.resolveView(newTrace);
            TraceSchedule newTime = null;
            Integer newFrame = DebuggerCoordinates.resolveFrame(newThread, newTime);
            TraceObject newObject = DebuggerCoordinates.resolveObject(newTrace);
            return new DebuggerCoordinates(newTrace, newPlatform, null, newThread, newView, newTime, newFrame, newObject);
        }
        throw new IllegalArgumentException("Cannot change trace");
    }

    private static TraceThread resolveThread(TraceRecorder recorder, TraceSchedule time) {
        if (recorder.getSnap() != time.getSnap() || !recorder.isSupportsFocus()) {
            return DebuggerCoordinates.resolveThread(recorder.getTrace(), time);
        }
        return DebuggerCoordinates.resolveThread(recorder, recorder.getFocus());
    }

    private static TraceThread resolveThread(Trace trace, TraceRecorder recorder, TraceSchedule time) {
        if (recorder == null) {
            return DebuggerCoordinates.resolveThread(trace, time);
        }
        return DebuggerCoordinates.resolveThread(recorder, time);
    }

    private static Integer resolveFrame(TraceThread thread, TraceSchedule time) {
        return null;
    }

    private static Integer resolveFrame(TraceRecorder recorder, TraceThread thread, TraceSchedule time) {
        if (recorder == null || recorder.getSnap() != time.getSnap() || !recorder.isSupportsFocus()) {
            return DebuggerCoordinates.resolveFrame(thread, time);
        }
        return DebuggerCoordinates.resolveFrame(recorder, recorder.getFocus());
    }

    private static TraceObject resolveObject(Trace trace, TargetObject object) {
        if (object == null) {
            return null;
        }
        return trace.getObjectManager().getObjectByCanonicalPath(TraceObjectKeyPath.of((List)object.getPath()));
    }

    private static TraceObject resolveObject(TraceRecorder recorder, TraceSchedule time) {
        if (recorder.getSnap() != time.getSnap() || !recorder.isSupportsFocus()) {
            return DebuggerCoordinates.resolveObject(recorder.getTrace());
        }
        return DebuggerCoordinates.resolveObject(recorder.getTrace(), recorder.getFocus());
    }

    public DebuggerCoordinates platform(TracePlatform newPlatform) {
        if (this.platform == newPlatform) {
            return this;
        }
        if (newPlatform == null) {
            if (this.trace == null) {
                return NOWHERE;
            }
            return new DebuggerCoordinates(this.trace, DebuggerCoordinates.resolvePlatform(this.trace), this.recorder, this.thread, this.view, this.time, this.frame, this.object);
        }
        if (this.trace == null) {
            Trace newTrace = newPlatform.getTrace();
            TraceThread newThread = DebuggerCoordinates.resolveThread(newTrace);
            TraceProgramView newView = DebuggerCoordinates.resolveView(newTrace);
            TraceSchedule newTime = null;
            Integer newFrame = DebuggerCoordinates.resolveFrame(newThread, newTime);
            TraceObject newObject = DebuggerCoordinates.resolveObject(newTrace);
            return new DebuggerCoordinates(newTrace, newPlatform, null, newThread, newView, newTime, newFrame, newObject);
        }
        if (this.trace != newPlatform.getTrace()) {
            throw new IllegalArgumentException("Cannot change trace");
        }
        return new DebuggerCoordinates(this.trace, newPlatform, this.recorder, this.thread, this.view, this.time, this.frame, this.object);
    }

    public DebuggerCoordinates recorder(TraceRecorder newRecorder) {
        if (this.recorder == newRecorder) {
            return this;
        }
        if (newRecorder == null) {
            return new DebuggerCoordinates(this.trace, this.platform, newRecorder, this.thread, this.view, this.time, this.frame, this.object);
        }
        if (newRecorder != null && this.trace != null && newRecorder.getTrace() != this.trace) {
            throw new IllegalArgumentException("Cannot change trace");
        }
        Trace newTrace = this.trace != null ? this.trace : newRecorder.getTrace();
        TracePlatform newPlatform = this.platform != null ? this.platform : DebuggerCoordinates.resolvePlatform(newTrace);
        TraceSchedule newTime = this.time != null ? this.time : TraceSchedule.snap((long)newRecorder.getSnap());
        TraceThread newThread = this.thread != null ? this.thread : DebuggerCoordinates.resolveThread(newRecorder, newTime);
        TraceProgramView newView = this.view != null ? this.view : DebuggerCoordinates.resolveView(newTrace, newTime);
        Integer newFrame = this.frame != null ? this.frame : DebuggerCoordinates.resolveFrame(newRecorder, newThread, newTime);
        TraceObject newObject = this.object != null ? this.object : DebuggerCoordinates.resolveObject(newRecorder, newTime);
        return new DebuggerCoordinates(newTrace, newPlatform, newRecorder, newThread, newView, newTime, newFrame, newObject);
    }

    public DebuggerCoordinates reFindThread() {
        if (this.trace == null || this.thread == null) {
            return this;
        }
        return this.thread(this.trace.getThreadManager().getThread(this.thread.getKey()));
    }

    private static TraceObject resolveObject(TraceThread thread, Integer frameLevel, TraceSchedule time) {
        if (thread instanceof TraceObjectThread) {
            TraceObjectThread tot = (TraceObjectThread)thread;
            TraceObject objThread = tot.getObject();
            if (frameLevel == null) {
                return objThread;
            }
            TraceStack stack = thread.getTrace().getStackManager().getStack(thread, time.getSnap(), false);
            if (stack == null) {
                return objThread;
            }
            TraceStackFrame frame = stack.getFrame(frameLevel.intValue(), false);
            if (frame == null) {
                return objThread;
            }
            return ((TraceObjectStackFrame)frame).getObject();
        }
        return null;
    }

    private static boolean isAncestor(TraceObject ancestor, TraceObject successor, TraceSchedule time) {
        return successor.getCanonicalParents(Range.singleton((Comparable)Long.valueOf(time.getSnap()))).anyMatch(p -> p == ancestor);
    }

    public DebuggerCoordinates thread(TraceThread newThread) {
        if (this.thread == newThread) {
            return this;
        }
        if (newThread != null && this.trace != null && this.trace != newThread.getTrace()) {
            throw new IllegalArgumentException("Cannot change trace");
        }
        if (newThread == null) {
            newThread = DebuggerCoordinates.resolveThread(this.trace, this.recorder, this.getTime());
        }
        Trace newTrace = this.trace != null ? this.trace : newThread.getTrace();
        TracePlatform newPlatform = this.platform != null ? this.platform : DebuggerCoordinates.resolvePlatform(newTrace);
        TraceSchedule newTime = this.time != null ? this.time : DebuggerCoordinates.resolveTime(this.view);
        TraceProgramView newView = this.view != null ? this.view : DebuggerCoordinates.resolveView(newTrace, newTime);
        Integer newFrame = DebuggerCoordinates.resolveFrame(this.recorder, newThread, newTime);
        TraceObject ancestor = DebuggerCoordinates.resolveObject(newThread, newFrame, newTime);
        TraceObject newObject = this.object != null && DebuggerCoordinates.isAncestor(ancestor, this.object, newTime) ? this.object : ancestor;
        return new DebuggerCoordinates(newTrace, newPlatform, this.recorder, newThread, newView, newTime, newFrame, newObject);
    }

    public DebuggerCoordinates snap(long snap) {
        return this.time(TraceSchedule.snap((long)snap));
    }

    public DebuggerCoordinates time(TraceSchedule newTime) {
        if (this.trace == null) {
            return NOWHERE;
        }
        long snap = newTime.getSnap();
        TraceThread newThread = this.thread != null && this.thread.getLifespan().contains((Comparable)Long.valueOf(snap)) ? this.thread : DebuggerCoordinates.resolveThread(this.trace, this.recorder, newTime);
        Integer newFrame = DebuggerCoordinates.resolveFrame(newThread, newTime);
        TraceObject ancestor = DebuggerCoordinates.resolveObject(newThread, newFrame, newTime);
        TraceObject newObject = this.object != null && DebuggerCoordinates.isAncestor(ancestor, this.object, newTime) ? this.object : ancestor;
        return new DebuggerCoordinates(this.trace, this.platform, this.recorder, newThread, this.view, newTime, newFrame, newObject);
    }

    public DebuggerCoordinates frame(int newFrame) {
        if (this.trace == null) {
            return NOWHERE;
        }
        if (Objects.equals(this.frame, newFrame)) {
            return this;
        }
        TraceObject ancestor = DebuggerCoordinates.resolveObject(this.thread, newFrame, this.getTime());
        TraceObject newObject = this.object != null && DebuggerCoordinates.isAncestor(ancestor, this.object, this.getTime()) ? this.object : ancestor;
        return new DebuggerCoordinates(this.trace, this.platform, this.recorder, this.thread, this.view, this.time, newFrame, newObject);
    }

    public DebuggerCoordinates frame(Integer newFrame) {
        if (newFrame == null) {
            return this;
        }
        return this.frame((int)newFrame);
    }

    private DebuggerCoordinates replaceView(TraceProgramView newView) {
        return new DebuggerCoordinates(this.trace, this.platform, this.recorder, this.thread, newView, this.time, this.frame, this.object);
    }

    private static TraceSchedule resolveTime(TraceProgramView view) {
        if (view == null) {
            return null;
        }
        long snap = view.getSnap();
        if (!DBTraceUtils.isScratch((long)snap)) {
            return TraceSchedule.snap((long)snap);
        }
        TraceSnapshot snapshot = view.getTrace().getTimeManager().getSnapshot(snap, false);
        if (snapshot == null) {
            return TraceSchedule.snap((long)snap);
        }
        TraceSchedule schedule = snapshot.getSchedule();
        if (schedule == null) {
            return TraceSchedule.snap((long)snap);
        }
        return schedule;
    }

    public DebuggerCoordinates view(TraceProgramView newView) {
        if (this.view == newView) {
            return this;
        }
        if (this.trace == null) {
            if (newView == null) {
                return NOWHERE;
            }
            return NOWHERE.trace(newView.getTrace()).time(DebuggerCoordinates.resolveTime(newView)).replaceView(newView);
        }
        if (newView.getTrace() != this.trace) {
            throw new IllegalArgumentException("Cannot change trace");
        }
        return this.time(DebuggerCoordinates.resolveTime(newView)).replaceView(newView);
    }

    private static TraceThread resolveThread(TraceObject object) {
        return object.queryCanonicalAncestorsInterface(TraceObjectThread.class).findFirst().orElse(null);
    }

    private static Integer resolveFrame(TraceObject object) {
        TraceObjectStackFrame frame = object.queryCanonicalAncestorsInterface(TraceObjectStackFrame.class).findFirst().orElse(null);
        return frame == null ? null : Integer.valueOf(frame.getLevel());
    }

    public DebuggerCoordinates object(TraceObject newObject) {
        Trace newTrace;
        if (this.trace == null) {
            if (newObject == null) {
                return NOWHERE;
            }
            newTrace = newObject.getTrace();
        } else {
            if (newObject == null) {
                return new DebuggerCoordinates(this.trace, this.platform, this.recorder, this.thread, this.view, this.time, this.frame, newObject);
            }
            if (newObject.getTrace() != this.trace) {
                throw new IllegalArgumentException("Cannot change trace");
            }
            newTrace = this.trace;
        }
        TracePlatform newPlatform = this.platform != null ? this.platform : DebuggerCoordinates.resolvePlatform(newTrace);
        TraceThread newThread = DebuggerCoordinates.resolveThread(newObject);
        Integer newFrame = DebuggerCoordinates.resolveFrame(newObject);
        return new DebuggerCoordinates(newTrace, newPlatform, this.recorder, newThread, this.view, this.time, newFrame, newObject);
    }

    protected static TraceThread resolveThread(TraceRecorder recorder, TargetObject targetObject) {
        return recorder.getTraceThreadForSuccessor(targetObject);
    }

    protected static Integer resolveFrame(TraceRecorder recorder, TargetObject targetObject) {
        TraceStackFrame frame = recorder.getTraceStackFrameForSuccessor(targetObject);
        return frame == null ? null : Integer.valueOf(frame.getLevel());
    }

    protected DebuggerCoordinates object(TraceObject traceObject, TargetObject targetObject) {
        if (traceObject != null) {
            return this.object(traceObject);
        }
        if (this.recorder == null) {
            throw new IllegalArgumentException("No recorder");
        }
        TraceThread newThread = DebuggerCoordinates.resolveThread(this.recorder, targetObject);
        Integer newFrame = DebuggerCoordinates.resolveFrame(this.recorder, targetObject);
        return new DebuggerCoordinates(this.trace, this.platform, this.recorder, newThread == null ? this.thread : newThread, this.view, this.time, newFrame == null ? this.frame : newFrame, null);
    }

    public DebuggerCoordinates object(TargetObject newObject) {
        return this.object(DebuggerCoordinates.resolveObject(this.trace, newObject), newObject);
    }

    public Trace getTrace() {
        return this.trace;
    }

    public TracePlatform getPlatform() {
        return this.platform;
    }

    public TraceRecorder getRecorder() {
        return this.recorder;
    }

    public TraceThread getThread() {
        return this.thread;
    }

    public TraceProgramView getView() {
        return this.view;
    }

    public long getSnap() {
        return this.getTime().getSnap();
    }

    public TraceSchedule getTime() {
        return this.time == null ? TraceSchedule.ZERO : this.time;
    }

    public int getFrame() {
        return this.frame == null ? 0 : this.frame;
    }

    public TraceObject getObject() {
        return this.object;
    }

    public TraceObject getRegisterContainer() {
        if (this.registerContainer != null) {
            return this.registerContainer;
        }
        this.registerContainer = this.object.queryRegisterContainer(this.getFrame());
        return this.registerContainer;
    }

    public synchronized long getViewSnap() {
        if (this.viewSnap != null) {
            return this.viewSnap;
        }
        TraceSchedule defaultedTime = this.getTime();
        if (defaultedTime.isSnapOnly()) {
            this.viewSnap = defaultedTime.getSnap();
            return this.viewSnap;
        }
        Collection snapshots = this.trace.getTimeManager().getSnapshotsWithSchedule(defaultedTime);
        if (snapshots.isEmpty()) {
            Msg.warn((Object)this, (Object)"Seems the emulation service did not create the requested snapshot, yet");
            return defaultedTime.getSnap();
        }
        this.viewSnap = ((TraceSnapshot)snapshots.iterator().next()).getKey();
        return this.viewSnap;
    }

    public void writeDataState(PluginTool tool, SaveState saveState, String key) {
        if (this == NOWHERE) {
            return;
        }
        SaveState coordState = new SaveState();
        if (this.trace != null) {
            DomainFile df = this.trace.getDomainFile();
            if (df.getParent() == null) {
                return;
            }
            ProjectLocator projLoc = df.getProjectLocator();
            if (projLoc != null && !projLoc.isTransient()) {
                coordState.putString(KEY_TRACE_PROJ_LOC, projLoc.getLocation());
                coordState.putString(KEY_TRACE_PROJ_NAME, projLoc.getName());
                coordState.putString(KEY_TRACE_PATH, df.getPathname());
                if (!df.isLatestVersion()) {
                    coordState.putInt(KEY_TRACE_VERSION, df.getVersion());
                }
            }
        }
        if (this.thread != null) {
            coordState.putLong(KEY_THREAD_KEY, this.thread.getKey());
        }
        if (this.time != null) {
            coordState.putString(KEY_TIME, this.time.toString());
        }
        if (this.frame != null) {
            coordState.putInt(KEY_FRAME, this.frame.intValue());
        }
        saveState.putXmlElement(key, coordState.saveToXml());
    }

    protected static DomainFile getDomainFile(PluginTool tool, SaveState coordState) {
        DomainFile df;
        String pathname = coordState.getString(KEY_TRACE_PATH, null);
        String location = coordState.getString(KEY_TRACE_PROJ_LOC, null);
        String projName = coordState.getString(KEY_TRACE_PROJ_NAME, null);
        if (location == null || projName == null) {
            return null;
        }
        ProjectLocator projLoc = new ProjectLocator(location, projName);
        ProjectData projData = tool.getProject().getProjectData(projLoc);
        if (projData == null) {
            try {
                projData = new ProjectFileManager(projLoc, false, false);
            }
            catch (NotOwnerException e) {
                Msg.showError(DebuggerCoordinates.class, (Component)tool.getToolFrame(), (String)"Trace Open Failed", (Object)("Not project owner: " + projLoc + "(" + pathname + ")"));
                return null;
            }
            catch (IOException e) {
                Msg.showError(DebuggerCoordinates.class, (Component)tool.getToolFrame(), (String)"Trace Open Failed", (Object)("Project error: " + e.getMessage()));
                return null;
            }
        }
        if ((df = projData.getFile(pathname)) == null || !"Trace".equals(df.getContentType())) {
            String message = "Can't open trace - \"" + pathname + "\"";
            int version = coordState.getInt(KEY_TRACE_VERSION, -1);
            if (version != -1) {
                message = message + " version " + version;
            }
            String title = df == null ? "Trace Not Found" : "Wrong File Type";
            Msg.showError(DebuggerCoordinates.class, (Component)tool.getToolFrame(), (String)title, (Object)message);
            return null;
        }
        return df;
    }

    public static DebuggerCoordinates readDataState(PluginTool tool, SaveState saveState, String key) {
        TraceSchedule time;
        if (!saveState.hasValue(key)) {
            return NOWHERE;
        }
        DebuggerTraceManagerService traceManager = (DebuggerTraceManagerService)tool.getService(DebuggerTraceManagerService.class);
        Trace trace = null;
        Element coordElement = saveState.getXmlElement(key);
        SaveState coordState = new SaveState(coordElement);
        if (traceManager != null) {
            DomainFile df = DebuggerCoordinates.getDomainFile(tool, coordState);
            int version = coordState.getInt(KEY_TRACE_VERSION, -1);
            if (df != null) {
                trace = traceManager.openTrace(df, version);
            }
        }
        TraceThread thread = null;
        if (trace != null && coordState.hasValue(KEY_THREAD_KEY)) {
            long threadKey = coordState.getLong(KEY_THREAD_KEY, 0L);
            thread = trace.getThreadManager().getThread(threadKey);
        }
        String timeSpec = coordState.getString(KEY_TIME, null);
        try {
            time = TraceSchedule.parse((String)timeSpec);
        }
        catch (Exception e) {
            Msg.error(DebuggerCoordinates.class, (Object)("Could not restore invalid time specification: " + timeSpec));
            time = TraceSchedule.ZERO;
        }
        Integer frame = null;
        if (coordState.hasValue(KEY_FRAME)) {
            frame = coordState.getInt(KEY_FRAME, 0);
        }
        TraceObject object = null;
        if (trace != null && coordState.hasValue(KEY_OBJ_PATH)) {
            String pathString = coordState.getString(KEY_OBJ_PATH, "");
            try {
                TraceObjectKeyPath path = TraceObjectKeyPath.parse((String)pathString);
                object = trace.getObjectManager().getObjectByCanonicalPath(path);
            }
            catch (Exception e) {
                Msg.error(DebuggerCoordinates.class, (Object)("Could not restore object: " + pathString), (Throwable)e);
                object = trace.getObjectManager().getRootObject();
            }
        }
        DebuggerCoordinates coords = NOWHERE.trace(trace).thread(thread).time(time).frame(frame).object(object);
        return coords;
    }

    public boolean isAlive() {
        return this.recorder != null;
    }

    public boolean isPresent() {
        TraceSchedule defaultedTime = this.getTime();
        return this.recorder.getSnap() == defaultedTime.getSnap() && defaultedTime.isSnapOnly();
    }

    public boolean isReadsPresent() {
        return this.recorder.getSnap() == this.getTime().getSnap();
    }

    public boolean isAliveAndPresent() {
        return this.isAlive() && this.isPresent();
    }

    public boolean isDeadOrPresent() {
        return !this.isAlive() || this.isPresent();
    }

    public boolean isAliveAndReadsPresent() {
        return this.isAlive() && this.isReadsPresent();
    }
}

