/*
 * Decompiled with CFR 0.152.
 */
package docking.help;

import docking.framework.ApplicationInformationDisplayFactory;
import docking.help.HelpViewSearcher;
import docking.help.ToggleNavigationAid;
import docking.util.AnimationPainter;
import docking.util.AnimationUtils;
import ghidra.framework.preferences.Preferences;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.bean.GGlassPane;
import help.CustomTOCView;
import help.GHelpBroker;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.List;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.help.NavigatorView;
import javax.help.WindowPresentation;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;

public class DockingHelpBroker
extends GHelpBroker {
    private static final List<Image> ICONS = ApplicationInformationDisplayFactory.getWindowIcons();
    private static final int MAX_CALLOUT_RETRIES = 3;
    private PropertyChangeListener pageLoadListener = new PageLoadingListener();
    private HelpModelListener helpModelListener = new HelpIDChangedListener();
    private Animator lastAnimator;
    private URL loadingURL;

    public DockingHelpBroker(HelpSet hs) {
        super(hs);
    }

    protected List<Image> getApplicationIcons() {
        return ICONS;
    }

    protected HelpModel getCustomHelpModel() {
        WindowPresentation windowPresentation = this.getWindowPresentation();
        HelpSet helpSet = windowPresentation.getHelpSet();
        NavigatorView tocView = helpSet.getNavigatorView("TOC");
        if (!(tocView instanceof CustomTOCView)) {
            Msg.debug((Object)((Object)this), (Object)"The help system is not using the CustomTOCView class!");
            return null;
        }
        CustomTOCView customTOCView = (CustomTOCView)tocView;
        return customTOCView.getHelpModel();
    }

    protected void installHelpSearcher(JHelp jHelp, HelpModel helpModel) {
        helpModel.addHelpModelListener(this.helpModelListener);
        new HelpViewSearcher(jHelp, helpModel);
    }

    protected void showNavigationAid(URL url) {
        this.prepareToCallout(url);
    }

    protected void installActions(JHelp help) {
        Component[] components;
        JToolBar toolbar = null;
        for (Component c : components = help.getComponents()) {
            if (!(c instanceof JToolBar)) continue;
            toolbar = (JToolBar)c;
            break;
        }
        if (toolbar == null) {
            return;
        }
        toolbar.addSeparator();
        ToggleNavigationAid action = new ToggleNavigationAid();
        toolbar.add(new JButton(action));
    }

    protected void reloadHelpPage(URL url) {
        super.reloadHelpPage(url);
    }

    private JScrollPane getScrollPane(JEditorPane editorPane) {
        for (Container parent = editorPane.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JScrollPane)) continue;
            return (JScrollPane)parent;
        }
        return null;
    }

    private void showNavigationAid() {
        String showAidString = Preferences.getProperty((String)"SHOW.HELP.NAVIGATION.AID");
        if (showAidString == null) {
            return;
        }
        boolean showAid = Boolean.parseBoolean(showAidString);
        if (!showAid) {
            return;
        }
        this.calloutReferenceLater();
    }

    private void calloutReferenceLater() {
        Swing.runLater(() -> this.calloutReference(this.loadingURL));
    }

    private void calloutReference(URL url) {
        String ref = url.getRef();
        if (ref == null) {
            return;
        }
        Rectangle area = this.getReferenceArea(ref);
        if (area == null) {
            return;
        }
        this.doCalloutReference(area, 0);
    }

    private Rectangle getReferenceArea(String ref) {
        HTMLDocument document = (HTMLDocument)this.htmlEditorPane.getDocument();
        HTMLDocument.Iterator iter = document.getIterator(HTML.Tag.A);
        while (iter.isValid()) {
            AttributeSet attributes = iter.getAttributes();
            String name = (String)attributes.getAttribute(HTML.Attribute.NAME);
            if (name != null && name.equals(ref)) {
                try {
                    int start = iter.getStartOffset();
                    Rectangle2D startArea = this.htmlEditorPane.modelToView2D(start);
                    return startArea.getBounds();
                }
                catch (BadLocationException ble) {
                    Msg.trace((Object)((Object)this), (Object)"Unexpected exception searching for help reference", (Throwable)ble);
                }
            }
            iter.next();
        }
        return null;
    }

    private void doCalloutReference(Rectangle area, int callCount) {
        if (callCount > 3) {
            return;
        }
        WindowPresentation windowPresentation = this.getWindowPresentation();
        Window helpWindow = windowPresentation.getHelpWindow();
        Container contentPane = null;
        contentPane = helpWindow instanceof JDialog ? ((JDialog)helpWindow).getContentPane() : ((JFrame)helpWindow).getContentPane();
        JScrollPane scrollPane = this.getScrollPane(this.htmlEditorPane);
        JViewport viewport = scrollPane.getViewport();
        Point viewPosition = viewport.getViewPosition();
        int numberOfCalls = callCount + 1;
        if (viewPosition.x == 0 && viewPosition.y == 0) {
            Swing.runLater(() -> this.doCalloutReference(area, numberOfCalls));
            return;
        }
        area.y -= viewPosition.y;
        Rectangle relativeArea = SwingUtilities.convertRectangle(scrollPane, area, contentPane);
        StarShape star = new StarShape(relativeArea.getLocation());
        Animator animator = AnimationUtils.createPaintingAnimator(helpWindow, new LocationHintPainter(star));
        if (animator == null) {
            return;
        }
        this.lastAnimator = animator;
        this.lastAnimator.addTarget((TimingTarget)new TimingTargetAdapter(){

            public void end() {
                DockingHelpBroker.this.lastAnimator = null;
            }
        });
    }

    private void prepareToCallout(URL url) {
        if (this.lastAnimator != null) {
            this.lastAnimator.stop();
        }
        this.loadingURL = url;
        if (this.isCurrentPage(this.loadingURL)) {
            this.showNavigationAid();
            return;
        }
        this.htmlEditorPane.removePropertyChangeListener("page", this.pageLoadListener);
        this.htmlEditorPane.addPropertyChangeListener("page", this.pageLoadListener);
    }

    private boolean isCurrentPage(URL newURL) {
        if (newURL == null) {
            return false;
        }
        String newFile = newURL.getFile();
        URL currentURL = this.htmlEditorPane.getPage();
        if (currentURL == null) {
            return false;
        }
        String currentFile = currentURL.getFile();
        return newFile.equals(currentFile);
    }

    private class PageLoadingListener
    implements PropertyChangeListener {
        private PageLoadingListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DockingHelpBroker.this.showNavigationAid();
            DockingHelpBroker.this.htmlEditorPane.removePropertyChangeListener("page", DockingHelpBroker.this.pageLoadListener);
        }
    }

    private class HelpIDChangedListener
    implements HelpModelListener {
        private HelpIDChangedListener() {
        }

        public void idChanged(HelpModelEvent e) {
            DockingHelpBroker.this.prepareToCallout(e.getURL());
        }
    }

    private class StarShape
    extends Path2D.Float {
        StarShape(Point location) {
            this(5, location, 1.0, 0.3);
        }

        StarShape(int points, Point location, double outerRadius, double innerRadius) {
            int width;
            double angle = Math.PI / (double)points;
            GeneralPath path = new GeneralPath();
            int scale = 20;
            double lr = Math.max(outerRadius, innerRadius);
            int height = width = (int)((double)scale * (2.0 * lr));
            double cx = location.x + width / 2;
            double cy = location.y + height / 2;
            Point2D.Double center = new Point2D.Double(cx, cy);
            double r = outerRadius;
            double x = center.x + Math.cos(0.0 * angle) * r;
            double y = center.y + Math.sin(0.0 * angle) * r;
            path.moveTo(x, y);
            for (int i = 1; i < 2 * points; ++i) {
                r = i % 2 == 0 ? outerRadius : innerRadius;
                x = center.x + Math.cos((double)i * angle) * r;
                y = center.y + Math.sin((double)i * angle) * r;
                path.lineTo(x, y);
            }
            path.closePath();
            double scx = (double)scale * cx;
            double scy = (double)scale * cy;
            double offsetx = width / 4;
            double offsety = height / 4;
            double sox = scx - offsetx;
            double soy = scy - offsety;
            double dx = sox - (double)location.x;
            double dy = soy - (double)location.y;
            AffineTransform xform = AffineTransform.getTranslateInstance(-dx, -dy);
            xform.scale(scale, scale);
            Shape shape = xform.createTransformedShape(path);
            super.append(shape, true);
        }
    }

    private class LocationHintPainter
    implements AnimationPainter {
        private Color color = new Color(100, 100, 255, 100);
        private Shape paintShape;

        LocationHintPainter(Shape paintShape) {
            this.paintShape = paintShape;
        }

        @Override
        public void paint(GGlassPane glassPane, Graphics graphics, double percentComplete) {
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            Composite originalComposite = g2d.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(AlphaComposite.SrcOver.getRule(), (float)(1.0 - percentComplete));
            g2d.setComposite(alphaComposite);
            double transition = 1.0 - percentComplete;
            Color originalColor = g2d.getColor();
            AffineTransform originalTransform = g2d.getTransform();
            double scale = 4.0 * transition;
            int degrees = (int)(480.0 * transition);
            double rad = Math.toRadians(transition * (double)degrees);
            Rectangle b = this.paintShape.getBounds();
            double cx = b.getCenterX();
            double cy = b.getCenterY();
            double scx = cx * scale;
            double scy = cy * scale;
            double dcx = scx - cx;
            double dcy = scy - cy;
            AffineTransform scaler = new AffineTransform();
            scaler.translate(-dcx, -dcy);
            scaler.scale(scale, scale);
            Shape scaled = scaler.createTransformedShape(this.paintShape);
            AffineTransform rotater = new AffineTransform();
            rotater.rotate(rad, cx, cy);
            Shape finalShape = rotater.createTransformedShape(scaled);
            g2d.setColor(this.color);
            g2d.fill(finalShape);
            g2d.setColor(originalColor);
            g2d.setTransform(originalTransform);
            g2d.setComposite(originalComposite);
        }
    }
}

