/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.AbstractErrDialog;
import docking.DockingWindowManager;
import docking.ErrLogDialog;
import docking.ErrLogExpandableDialog;
import docking.widgets.OkDialog;
import ghidra.util.ConsoleErrorDisplay;
import ghidra.util.ErrorDisplay;
import ghidra.util.ErrorLogger;
import ghidra.util.HTMLUtilities;
import ghidra.util.MessageType;
import ghidra.util.StringUtilities;
import ghidra.util.Swing;
import ghidra.util.exception.MultipleCauses;
import ghidra.util.html.HtmlLineSplitter;
import java.awt.Component;
import java.awt.Window;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public class DockingErrorDisplay
implements ErrorDisplay {
    private static AbstractErrDialog activeDialog;
    ConsoleErrorDisplay consoleDisplay = new ConsoleErrorDisplay();

    public void displayInfoMessage(ErrorLogger errorLogger, Object originator, Component parent, String title, Object message) {
        this.displayMessage(MessageType.INFO, errorLogger, originator, parent, title, message, null);
    }

    public void displayErrorMessage(ErrorLogger errorLogger, Object originator, Component parent, String title, Object message, Throwable throwable) {
        this.displayMessage(MessageType.ERROR, errorLogger, originator, parent, title, message, throwable);
    }

    public void displayWarningMessage(ErrorLogger errorLogger, Object originator, Component parent, String title, Object message, Throwable throwable) {
        this.displayMessage(MessageType.WARNING, errorLogger, originator, parent, title, message, throwable);
    }

    private static String wrap(String text) {
        StringBuilder buffy = new StringBuilder();
        int limit = 120;
        List lines = HtmlLineSplitter.split((String)text, (int)limit, (boolean)true);
        String newline = "\n";
        for (String line : lines) {
            if (buffy.length() != 0) {
                buffy.append(newline);
            }
            if (StringUtils.isBlank((CharSequence)line)) continue;
            String wrapped = line;
            if (line.length() > limit) {
                wrapped = WordUtils.wrap((String)line, (int)limit, null, (boolean)true);
            }
            buffy.append(wrapped);
        }
        return buffy.toString();
    }

    private void displayMessage(MessageType messageType, ErrorLogger errorLogger, Object originator, Component parent, String title, Object message, Throwable throwable) {
        Swing.runIfSwingOrRunLater(() -> this.doDisplayMessage(messageType, errorLogger, originator, parent, title, message, throwable));
    }

    private void doDisplayMessage(MessageType messageType, ErrorLogger errorLogger, Object originator, Component parent, String title, Object message, Throwable throwable) {
        String messageString;
        int dialogType = -1;
        String string = messageString = message != null ? message.toString() : null;
        if (messageString != null) {
            int maxChars = 1000;
            String safeMessage = StringUtilities.trimMiddle((String)messageString, (int)maxChars);
            messageString = DockingErrorDisplay.wrap(safeMessage);
        }
        String unformattedMessage = HTMLUtilities.fromHTML((String)messageString);
        switch (messageType) {
            case INFO: {
                dialogType = 1;
                this.consoleDisplay.displayInfoMessage(errorLogger, originator, parent, title, (Object)unformattedMessage);
                break;
            }
            case WARNING: 
            case ALERT: {
                dialogType = 2;
                this.consoleDisplay.displayWarningMessage(errorLogger, originator, parent, title, (Object)unformattedMessage, throwable);
                break;
            }
            case ERROR: {
                this.consoleDisplay.displayErrorMessage(errorLogger, originator, parent, title, (Object)unformattedMessage, throwable);
                dialogType = 0;
            }
        }
        this.showDialog(title, throwable, dialogType, messageString, this.getWindow(parent));
    }

    private Component getWindow(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return component;
    }

    private void showDialog(String title, Throwable throwable, int dialogType, String messageString, Component parent) {
        if (dialogType == 0) {
            this.showDialogOnSwing(title, throwable, dialogType, messageString, parent);
        } else {
            DockingWindowManager.showDialog(parent, new OkDialog(title, messageString, dialogType));
        }
    }

    private void showDialogOnSwing(String title, Throwable throwable, int dialogType, String messageString, Component parent) {
        if (activeDialog != null) {
            activeDialog.addException(messageString, throwable);
            return;
        }
        activeDialog = this.createErrorDialog(title, throwable, messageString);
        activeDialog.setClosedCallback(() -> {
            activeDialog.setClosedCallback(null);
            activeDialog = null;
        });
        DockingWindowManager.showDialog(parent, activeDialog);
    }

    private AbstractErrDialog createErrorDialog(String title, Throwable throwable, String messageString) {
        if (this.containsMultipleCauses(throwable)) {
            return new ErrLogExpandableDialog(title, messageString, throwable);
        }
        return ErrLogDialog.createExceptionDialog(title, messageString, throwable);
    }

    private boolean containsMultipleCauses(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof MultipleCauses) {
            return true;
        }
        return this.containsMultipleCauses(throwable.getCause());
    }
}

